<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
    Soumission des formulaires
    @package individu
*/



/*------------------------------------------------------------------------*/
// Inscription
/*------------------------------------------------------------------------*/
if(isset($subinscrit)){
	global $_POST;
//	print_rr($_POST);
	$suppression_photo = (bool)$_POST['del_photo'];
//	echo "coucou $suppression_photo<br>";
	$message="";
	// test validit login et mot de passe
	if(!is_alphanum($log) ){//|| !is_alphanum($_POST['pass'])){
		$message="Le login ne peut contenir que des characteres alphanumeriques";
	}

	// test si login utitlise dans individu
	if($old_log!=$log){
		if(check_plateforme_login_utilise($log)){
			$message=ERROR_108	;
		}
	
		// test si login utilise dans inscription
		if(check_plateforme_login_inscription_utilise($log)){
			$message=ERROR_108	;
		}
	}
	//echo "mesg=$message<br>";
	// Traitement du message d'erreur
	if(!empty($message)){
		AstairsTemplate::setPageMessage($message,MSG_ERROR);
	}else{
		// Prparation des donnes
		$nom=strtoupper($nom);
		$prenom=strtolower($prenom);
		$prenom=ucwords($prenom);

		
		//repertoire de destination des photos
		$chemin_photo=$astairs_directories['PRIVATE_REGISTERED_DIR'];					
		pg_query('begin');
		
		//-----------------------------------------------------------
		//					UPLOAD PHOTO
		//----------------------------------------------------------- 
		if(count($_FILES)>0){
			
			$err=false;
			$type_message=MSG_ERROR;
			$userfile_name=$_FILES['photo']['name'];
			$userfile_size=$_FILES['photo']['size'];
			$userfile=$_FILES['photo']['tmp_name'];
			$userfile_name=get_fichier_disk_name($userfile_name);	
			if(!empty($userfile_name)){

				//vrif de la taille du fichier fourni par le stagiaire
				if($userfile_size>(((int)MAX_PHOTO_SIZE)*1024)){
					$err=true;
					$message=WARN_80;
					$type_message=MSG_WARNING;
				}
				
				//verif des dimmensions de l'image
				list($width, $height, $type, $attr) = getimagesize($userfile);
				if($width>MAX_PHOTO_WIDTH || $height>MAX_PHOTO_HEIGHT){
					$err=true;
					$message='L\'image doit avoir des dimensions maximales de '.MAX_PHOTO_WIDTH.'px * '.MAX_PHOTO_HEIGHT.'px';
					$type_message=MSG_WARNING;
				}
				if(!$err){
					$id_photo=set_fichier_photo($userfile_name);
				}
			}
		}
		
		
		if($mode_formulaire==1 || $mode_formulaire==3){
			$token=md5(uniqid(rand()));
			// Mot de passe
			$chaine = "abBDEFcdefghijkmnPQRSTUVWXYpqrst23456789"; 
		 	srand((double)microtime()*1000000);  
		 	$genpass="";
		 	for($i=0; $i<8; $i++){ //mot de passe de 8 caracteres 
		 	    $genpass .= $chaine[rand()%strlen($chaine)];  
		 	}   
			$individu=set_inscription(string2Sql($token),string2Sql($log),string2Sql($genpass),string2Sql($nom),string2Sql($prenom),string2Sql($adr),string2Sql($code),string2Sql($ville),string2Sql($mail),string2Sql($telfixe),string2Sql($telport),int2Sql($langue),int2Sql($org),'NULL','NULL','NULL',int2Sql($id_photo));
			
			//upload
			$chemin_photo=$chemin_photo.$individu.'/';
			if(!is_dir($chemin_photo)){//si le repertoire de l'individu n'existe pas au sein du repertoire, on le cre
				mkdir($chemin_photo,0777);
			}
			if(!empty($id_photo))$msg_upload=uploadFichier($userfile, $userfile_name, $userfile_size, $userfile_name, $chemin_photo);
		    //erreur upload
		    if (!empty($msg_upload)){
				$message=$msg_upload;
				$err=true;
				pg_query('rollback');
		    }else{
		    	pg_query('commit');
		    }
		    //message
			if($err){
				PageComponent::setPageMessage($message,$type_message);
			}
		}
		else{

			//recup ancienne photo
			$old_photo=pg_fetch_result(get_inscription($individu),0,14);
	
			//suppression photo 
			if($suppression_photo ){
				$keep_old_photo=false;
			}else{
				//pas de changemement de photo
				if(empty($id_photo)){
					$id_photo=$old_photo; //on ne change pas la photo 
					$keep_old_photo=true;
				}
				//changemement de photo
				else{
					$keep_old_photo=false;
				}
			}
			
			//maj
			$res=maj_inscription($individu,string2Sql($log),string2Sql($_POST['pass']),string2Sql($nom),string2Sql($prenom),string2Sql($adr),string2Sql($code),string2Sql($ville),string2Sql($mail),string2Sql($telfixe),string2Sql($telport),int2Sql($langue),int2Sql($org),int2Sql($id_photo));
			
			//upload
			$chemin_photo=$chemin_photo.$individu.'/';
			if(!empty($id_photo)&&!empty($userfile_name)){
				if(!is_dir($chemin_photo)){//si le repertoire de l'individu n'existe pas au sein du repertoire, on le cre
					mkdir($chemin_photo,0777);
				}
				$msg_upload=uploadFichier($userfile, $userfile_name, $userfile_size, $userfile_name, $chemin_photo);
			}	
			if(!$keep_old_photo){	
				//suppression ancienne photo
				if($old_photo){
					$old_photo_name=pg_fetch_result(get_fichier($old_photo),0,1);
					$del_db=del_fichier_db($old_photo);
					if($del_db)$del_fichier_disque=del_fichier($chemin_photo.$old_photo_name);
					else $err=true;	
					
					if(!$del_fichier_disque){
						$message="Erreur, l'ancienne photo n'a pu etre supprime";
						$err=true;
					}
				}
			}
		    //erreur upload
		    if (!empty($msg_upload)){
				$message=$msg_upload;
				$err=true;
				pg_query('rollback');
		    }else{
		    	pg_query('commit');
		    }
		    //message
			if($err){
				PageComponent::setPageMessage($message,$type_message);
			}else{
				if($res)
					PageComponent::setPageMessage("Vos modifications ont bien ete prises en compte",MSG_CONFIRM);
				else 
					PageComponent::setPageMessage("Erreur modifications utilisateur",MSG_ERROR);
			}
		}
		
//		if(isset($lien_header) && !empty($lien_header)){
//			header("location:$lien_source?$lien_header");
//			include("$dbpath/pied_page.php");
//			exit();
//		}
//		else{
//			header("location:inscription.php?action_inscription=lister_inscription");
//			include("$dbpath/pied_page.php");
//			exit();
//		}
	}
//	else{
//		$blocage_affichage=1;
//		// Affichage du message
//		$styleCSS="../style/".MY_STYLE."/ressourcesHumaines.css";
//		include('../entete.php3');
//		print("
//		<table class=\"tableau_message\">
//		<tr>
//		<td>$message</td>
//		</tr>
//		</table>
//		<br><a class=\"retour\" href=\"javascript:history.go(-1)\">$MSG_37</a>
//		");
//		die;
//		
//	}	
}
?>