<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Affichage d'une AstairsPage de Back-office spcifique  langue editor
 */ 
class LangueEditorPage extends AstairsPageBo{
	
	/**
	 * Constructeur.
	 * Appel du constructeur pre (AstairsPageBO) avec les valeurs ncssaires  l'affichage du lien retour  null.
	 * @param string $astairs_titre Titre  afficher 
	 * @param string $astairs_retour_libelle Libell du lien retour  afficher
	 * @param string $astairs_retour_url URL du lien retour  afficher 
	 * @param string $astairs_retour_title Message sur le title du retour ( un retour par exemple)
	 * @param object PageBuilder $pageBuilder L'objet permettant de crer une page
	 * @param Array $templates Les templates  utiliser pour la cration de la page
	 * @param Array $style_files Les feuilles de style
	 * @param Array $javascript_files Les fichiers javascript
	 * @param string $javascript_internal_code Le code javascript interne
	 */
	function LangueEditorPage($astairs_titre, $astairs_retour_libelle,$astairs_retour_url,$astairs_retour_title,$pageBuilder,$templates,$style_files,$javascript_files,$javascript_internal_code,$obj_table_model,$page_titre=""){
		parent::AstairsPageBO($pageBuilder,$templates,$style_files,$javascript_files,$javascript_internal_code,$astairs_titre, $astairs_retour_libelle,$astairs_retour_url,$astairs_retour_title,$page_titre);
		global $root;
		global $submit_editor;
		global $num_page;
		global $_POST;
	
	
		if(is_object($obj_table_model)){
			$multilingual_filter_box=$obj_table_model->getDataFilter();	
		}
		
		if(!is_object($multilingual_filter_box)){
			//echo"pas d'objet";
			$req='select * from contraintes.af_get_langues() as  (id int4,libelle varchar, code varchar, locale varchar)';
			$value=null;
			$disabled="";
			$valeur=null;
			$filters[]=new DataFilterSelect(MSG_2501,'langue',$value,$disabled,$req,$valeur);
		
			
			// selection du type de message
			// la requete
			$req='select * from contraintes.af_get_langue_types() as  (id integer,libelle varchar,code varchar)';
			$value=null;
			$disabled=false;
			$valeur=null;
			$filters[]=new DataFilterSelect(MSG_2502,'type_message',$value,$disabled,$req,$valeur);
			
			// saisie du message
			$filters[]=new DataFilterInput(MSG_2577,'message',20,null,$disabled);
			
			// max messages par page
			// la requete
			$req='select * from contraintes.af_gen_get_int_values(10,100) as (id integer,val integer)';
			$value=null;
			$disabled=false;
			$valeur=null;
			$filters[]=new DataFilterSelect(MSG_1085,'max_par_page',$value,$disabled,$req,$valeur);
			
			// L'objet LanguageSelectionBox

			$req="select * from contraintes.af_get_langues() as  (id int4,libelle varchar, code varchar, locale varchar)";
			$obj_langue_checkbox=new LanguageSelectionBox('formcheckbox',$req,'','');
			//print_rr($obj_langue_checkbox);
			
			//$fonction_page='get_langue_libelles(##tab_coches##,##type##,##num_champ##,##classement##,##limit##,##offset##,##message##)';
			
			// Ecriture Dynamique de la fonction "fonction_page"
			$fonction_page='get_langue_message_type_langues_libelles(';
			$tab_param_supplementaire=array("##num_champ##","##classement##","##offset##");
			$nb_param_supplementaire=sizeof($tab_param_supplementaire);
			// affecte autant d'arguments qu'il y a de filters
			$nb_filters=sizeof($filters);
			for($f=0;$f<$nb_filters;$f++){
				//$num_filter=$f+1;
				if($f==$nb_filters -1)
					$fonction_page .="##$f##";
				else
					$fonction_page .="##$f##,";
					
			}
			// Ajoute les paramtres supplmentaires s'il y en a
			for($e=0;$e<$nb_param_supplementaire;$e++){
				$fonction_page .=",$tab_param_supplementaire[$e]";	
			}
			// ferme la parenthse
			$fonction_page .=")";
			//echo "la fonction_page=$fonction_page<br>";
			//$fonction_page='get_langue_message_type_langues_libelles(##tab_coches##,##type##,##message##,##limit##,##num_champ##,##classement##,##offset##)';
			
//modifi par RC			
//			$req='select * from contraintes.af_get_langue_messages_type(##langues##,##type##,##message##) as (id int4,libelle text,type int4,langue int4,variable text)';
			$req='select * from contraintes.af_get_langue_messages_type(##0##,##1##,##2##) as (id int4,libelle text,type int4,langue int4,variable text)';
			
			$disabled=false;
			$multilingual_filter_box=new MultilingualFilterBox($obj_langue_checkbox,'Selection des messages  afficher','form_langue_editor','','submit_editor',$req,$fonction_page,$filters,FORM_6,$disabled);
			$obj_table_model->setDataFilter($multilingual_filter_box);
		}
		
		
		$component=new guiMultilingualFilterBox($multilingual_filter_box,$root."lib_graphique/tables/tableModel/templates/tpl",array('multilingual_filter_box' => 'gui_multilingual_filter_box.tpl'));
		$this->setComponent('multilingual_filter_box', $component,true);
		
		
		//$table_model_gui_line_struct=new TableModelGuiLineStruct(array('1'=>TABLE_MODEL_LINE_INPUT,'2'=>TABLE_MODEL_LINE_INPUT),TABLE_MODEL_LINE_LABEL);
		
		$table_model_gui_line_struct=new TableModelGuiLineStruct(array('0'=>TABLE_MODEL_LINE_ID,'1'=>TABLE_MODEL_LINE_INPUT),TABLE_MODEL_LINE_LABEL);
		// test affichage sans id
		//$table_model_gui_line_struct=new TableModelGuiLineStruct(array('0'=>TABLE_MODEL_LINE_INPUT),TABLE_MODEL_LINE_LABEL);
		
		// ajoute en parametre $table_model_gui_line_struct (je suggre en 2eme)
		$component=new guiTableModel($obj_table_model,$table_model_gui_line_struct,$root."lib_graphique/tables/tableModel/templates/tpl",array('table_model' => 'gui_table_model.tpl'));
		$this->setComponent('table_model', $component,true);
	
		
		// Ajout lien "generer le fichier"
		// recup l'objet dataFilter
 	 	$obj_data_filter=$obj_table_model->getDataFilter();
 	 	$langue_courante=$obj_data_filter->getLangueCourante();
		// test si langue courante
	
//		if($langue_courante){
//			$component=new guiLangueEditorPageLienGenererFichier($obj_table_model,$langue_courante,$root."lib_graphique/tables/tableModel/templates/tpl",array('langue_editor_page_lien_generer_fichier' => 'gui_langue_editor_page_lien_generer_fichier.tpl'));
//			$this->setComponent('langue_editor_page_lien_generer_fichier',$component,true);
//		}
	}
}
?>
