<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Enregistrement du module courrant en session.
 * Ce script doit etre inclu afin de disposer d'un objet module 'obj_module',
 * contenant les informations du module courant, en tant que variable globale stockée en session.
 * 
 * Plus précisément, ce script :
 *  -Efface l'éventuel module accueil (accueil_bo) s'il existe
 *  -Lit et charge le module à partir de l'url (sz_obj_module)
 *  -Provoque une erreur si le module n'a pas été chargé
 *  -Si le module à été convenablement chargé: 
 * 		* charge ses pages et ses sous modules
 * 		* charge les droits du module
 * 		* vérifie ces droits par rapport à ceux de l'utilisateur authentifié
 * 
 */
// $NIVEAU_DEBUG=1;

$keep_module=false;
//	print_rr($obj_module);
//	extract($_GET);
	if(exportedObject($_GET['sz_obj_module'])&&!empty($_GET['sz_obj_module'])){
		messageDebug("Lecture du Module a partir de l'URL");
		$new_obj_module=importObject($_GET['sz_obj_module']);
	}else{
		if(!is_object($obj_module)||$load_accueil){
//			echo"\$load_accueil=$load_accueil";
			messageDebug("Chargement du module accueil");
			$new_obj_module=ModuleBuilder::loadModule($chemin_bo,'accueil');
			$new_obj_module->setId(ModuleBuilder::getModuleId($new_obj_module));
			$new_mod_id=$new_obj_module->getId();
			if(empty($new_mod_id)){
				die("Erreur, module 'accueil' non dploy.");
			}
		}else{
			messageDebug("Conserve le module en session".$obj_module->getCode());
			$keep_module=true;
		}
	}
if(!$keep_module){
	//Si l'objet Module n'est pas en session, il doit etre passe par l'URL
	if($sess->is_registered("obj_module")){
	//	if(is_object($obj_module)&&$obj_module->getCode()=='accueil_bo'){
		messageDebug("Efface le module");
		$sess->unregister("obj_module");
	}
	
	//	print_rr($obj_module);
		messageDebug("Affecte le nouveau module");
		$obj_module=&$new_obj_module;
		
	if(!$sess->is_registered("obj_module")){
		messageDebug("Enregistre le nouveau module");
		$sess->register("obj_module");
	}
	//}else{
	//	messageDebug("Lecture du Module a partir de la session");
	//}
}

//Si toujours pas d'objet Module, cad qu'il n'est pas fourni par l'URL ou pas dans la session: ERREUR. 
if(!is_object($obj_module)){
	die("Erreur module_menu.php: Absence de Module");
}else{
	
}
//print_rr($obj_module);
//on charge les �l�ments du module
$obj_module->loadPages();
$obj_module->loadSubModules();
//chargement des droits du module              
module_open($obj_module);
module_check($obj_module);
?>