<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Affichage d'un ModuleMenu. 
 * Il s'agit ici d'afficher un menu pour un Module.
 * Un Module est compos de Pages organises en SousMenu.
 * Ces ModuleSubMenu sont dfinis par un type afin qu'ils contiennent les Pages d'un meme type.
 * 
 * @param var {PAGE_TITLE}
 * @param var {PAGE_DESCRIPTION}
 * @param var {PAGE_KEYWORD}
 * @param var {PAGE_SUBJECT}
 * @param var {PAGE_AUTHOR}
 * @param var {PAGE_FAVICO}
 * @param var {LIBELLE}
 * @param block_target {$block_target}
 */
class guiBoModuleMenu extends PageComponent{
	
	/**
	 * Constructeur.
	 * @param string $block_target Nom du bloc dans lequel on affiche ce PageComponent
	 * @param object Module $module Le module dont dont veut afficher les fonctionnalits
	 * @param object ModuleMenuStruct $moduleMenuStruct La structure permettant d'organiser le ModuleMenu
	 * @param object PageBuilder $pageBuilder L'objet permettant de crer une page
	 * @param Array $templates Les templates  utiliser pour la cration de la page
	 * @param Array $style_files Les feuilles de style
	 * @param Array $javascript_files Les fichiers javascript
	 * @param string $javascript_internal_code Le code javascript interne
	 */
	function guiBoModuleMenu($block_target,$module,$moduleMenuStruct,$module_root,$templates){

		global $MSG_37;

		parent::PageComponent($module_root,$templates);
		//on charge les pages
		$module->loadPages();
//		print_rr($module);
		$val ['LIBELLE'] = $module->getLibelle();
		$val ['MODULE_MENU_CODE'] =strtolower('_'.$module->getType());
		parent::set_var($val);
//		print_rr($module);
		//rcupration des types apparaissant dans la dfinition des Pages du module.
		$module_menus=$moduleMenuStruct->getModuleMenus();
		parent::set_block($block_target,'block','bloc_sub_menus');
		foreach($module_menus as $k => $module_menu){
			
			//on affiche le sous menu que si celui-ci contient des pages
			if(count($module->getPagesByType($module_menu->getCode()))>0){	
				$component=new guiBoModuleMenuPages('block_line',$module_menu,$module, $module_root,array('block_line' => 'gui_bo_module_menu_pages.tpl'));
				$this->setComponent('block_line', $component,true,'block','bloc_sub_menus');
			}
		}
	}
}
?>
