<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Affichage d'un ModuleMenu. 
 * Il s'agit ici d'afficher un menu pour un Module.
 * Un Module est compos� de Pages organis�es en SousMenu.
 * Ces ModuleSubMenu sont d�finis par un type afin qu'ils contiennent les Pages d'un meme type.
 * 
 * @param var {PAGE_TITLE}
 * @param var {PAGE_DESCRIPTION}
 * @param var {PAGE_KEYWORD}
 * @param var {PAGE_SUBJECT}
 * @param var {PAGE_AUTHOR}
 * @param var {PAGE_FAVICO}
 * @param var {LIBELLE}
 * @param block_target {$block_target}
 */
class guiBoModuleMenuPage extends AstairsPageBO{
	
	/**
	 * Constructeur.
	 * @param string $block_target Nom du bloc dans lequel on affiche ce PageComponent
	 * @param object Module $module Le module dont dont veut afficher les fonctionnalit�s
	 * @param object PageBuilder $pageBuilder L'objet permettant de cr�er une page
	 * @param Array $templates Les templates � utiliser pour la cr�ation de la page
	 * @param Array $style_files Les feuilles de style
	 * @param Array $javascript_files Les fichiers javascript
	 * @param string $javascript_internal_code Le code javascript interne
	 */
	function guiBoModuleMenuPage($block_target,$module,$pageBuilder,$templates,$style_files,$javascript_files,$javascript_internal_code){


		parent::AstairsPageBO($pageBuilder,$templates,$style_files,$javascript_files,$javascript_internal_code,"Administration Astairs", MENU_1,"../accueil/accueil.php",MENU_2562,$module->getLibelle(),MSG_37,"../accueil/accueil.php");
		
		$val ['PAGE_TITLE'] = $module->getLibelle();
		$val ['PAGE_DESCRIPTION']= 'description courte de la page';
		$val ['PAGE_KEYWORD']= 'liste des mots cles';
		$val ['PAGE_SUBJECT']= 'sujet de la page';
		$val ['PAGE_AUTHOR']= 'auteur de la page';
		$val ['PAGE_FAVICO']= ''; 
		
		$val ['MODULE_MENU_CODE'] = strtolower('_'.$module->getType());
		parent::set_var($val);
	}
}
?>
