<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Affichage d'un menu(ModuleMenu) pour un Module affichant certaines de ses pages.
 * Les pages affich�es d�pendent de leur type, qui doit correspondre au code du ModuleMenu.
 * S'il n'y a pas de pages pour ce ModuleMenu, il n'est pas affich�.
 * @param var {LIBELLE}
 * @param block_target {$block_target}
 */
class guiBoModuleMenuPages extends PageComponent{
	
	
	/**
	 * Constructeur.
	 * @param string $block_target Nom du bloc dans lequel on affiche ce PageComponent
	 * @param object ModuleMenu $module_menu Objet permettant de d�finir quelles pages du Module sont � afficher dans ce ModuleMenu
	 * @param object Module $module Le Module dont on souhaite afficher certaines pages
	 * @param string $module_root Chemin racine des fichiers de templates (TPL)
	 * @param string $templates Les fichiers de Templates
	 */
	function guiBoModuleMenuPages($block_target,$module_menu,$module,$module_root=null,$templates=null){
		global $chemin_bo,$perm;
//		global $auth;
//			print_rr($auth);
		parent::PageComponent($module_root,$templates);
		//on charge les pages
		$module->loadPages();
		//on filtre les pages en fonction du type pour n'obtenir que celles qui correspondent � ce menu.
		$pages=$module->getPagesByType($module_menu->getCode());

		//on affiche le menu que si celui-ci contient des pages
		if(count($pages)>0){
			parent::set_var('LIBELLE', $module_menu->getLibelle()); //ok pour menu de module
//			echo $module->getLibelle();
			//d�claration du bloc que l'on va remplir avec 2 boucles
			parent::set_block($block_target,'block','bloc_pages');
			//affichage des pages du Module qui correspondent � ce ModuleMenu		
			foreach($pages as $k => $page){
				if($module->have_perm($module_menu->getCode())){
					$component=new guiBoModulePage($page,$module,"$chemin_bo/module_menu/templates/tpl",array('block_line' => 'gui_bo_module_page.tpl'));
					$this->setComponent('block_line', $component,true,'block','bloc_pages');
				}
			}
			
		}		
	}
}
?>