<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/
                     
/**
Fichier de fonctions pour l'affichage des rsultats de recherche du moteur de recherche

C'est dans ce fichier que sont gnrs tous les affichages du moteur de recherche.
On utilise pour cela des fonctions qui gnrent du code dynamiquement (les mmes fonctions
pour des objets diffrents) pusique les menus se ressemblent tous plus au moins.
Ce fichier de fonctions contient les fonctions qui sont appeles lorsqu'on veut afficher des rsultats de
recherche.
@package moteur de recherche
@author CHABOISSIER Jonathan
@since 02/06/2004

*/
include("$root/lib/lib_front_office.php");
include("./fonctions_aff_type.inc");

/**
* @var string : largeur de tous les tableaux menu affichs
*/
$largeur="70%" ;

/**
* @var string[] Tableau utilis pour des expressions multilingues (faire global $search)
*/
// $search = array ($MSG_1268, $MSG_1269, $MSG_1270, $MSG_1271, $MSG_1272, $MSG_1273b, $MSG_1277, $MSG_1279, $MSG_1296, $MSG_1297, $MSG_1298);
//> 0 ses stagiaires, 1 ses formateurs, 2 ses parcours, 3 ses calendriers, 4 ses groupes, 5 Informations personnelles, 6 Recherche Simple, 7 ~ en profondeur,
// 8 par saisie, 9 par date, 10 par filire

/**
* @var string[] Tableau utilis pour des expressions multilingues (faire global $select) pour les SELECT des formulaires
*/
$select = array ($MSG_1302, $MSG_2386, $MSG_53, $MSG_2396);

/**
* Fonction qui affiche les informations d'un objet
*
* Cette procdure affiche les informations d'un objets comme le nom, le prnom dans le cas d'un formateur ou d'un stagiaire
* @param object : objet dont il faut afficher les informations
*/
function affSesInfos($objet)
{
        global $largeur, $serverfront, $MSG_1273,$MSG_1594,$MSG_1595,$MSG_2617 ;
        global $coul1,$coul2;
		
        print("
        <table border=\"0\" width=\"70%\">
        <tr class=\"$coul1\" height=\"30\" valign=\"middle\">
                <td colspan=\"2\"><b>$MSG_1273 </b></td>
        </tr>") ;
		
       switch(get_class($objet)){
       	
		       	  //appel de fonction affiche_formation
		       	 case "formation":
		       	 
				       	  $libelle_parcours=pg_fetch_result(get_parcours($objet->getParcours()),0,1);
				       	  $libelle_classes=pg_fetch_result($objet->getClasses(),0,1);
				       	  $id_classes=pg_fetch_result($objet->getClasses(),0,0);
				       	  $id_formateur=pg_fetch_result($objet->getFormateur(),0,0);
				       	  $libelle_formateur=pg_fetch_result($objet->getFormateur(),0,1);
				       	  $libelle_langue=pg_fetch_result(get_langue($objet->getLangue()),0,1);
				       	  eval("\$libelle_langue=\"$libelle_langue\";");
				       	  $lien=affiche_formation($objet->getId(), $objet->getDebut(), $objet->getFin(), $libelle_formateur, $id_formateur, $libelle_classes, $id_classes,  $libelle_parcours, $objet->getParcours(),  $libelle_langue, $coul1, $coul2);
				       	  
		       	  break;
		       	 	
		       	 //appel de la fonction affiche_filiere	
		       	 case "filiere":
		       	 
				       	 $obj_mere= $objet->getPere();
				       	 if($obj_mere){
				       	 	$libelle_mere= $obj_mere->getLibelle();
				       	 	$id_mere = $obj_mere->getId();
				       	 }
				       	 $lien=affiche_filiere( $objet->getId(), $objet->getLibelle(), $id_mere, $libelle_mere, $coul1,$coul2);
				       	 
		       	 break;
		       	  
		       	  //appel de la fonction affiche_parcours  
		       	 case "parcours":
		       	 
		       	 		$lien=affiche_parcours($objet->getFiliere(), $objet->getLibelle(),$objet->getId(), $coul1,$coul2);
		       	 
		       	 break;
		       	 
		       	 //appel de la fonction affiche_formateur
		       	 case "formateur":
		       	 
				       	 $obj_organisme = $objet->org;
				       	 $libelle_organisme = $obj_organisme->getLibelle();
				       	 $id_organisme = $obj_organisme->getId( );
				       	 $libelle_langue=pg_fetch_result(get_langue($objet->getLangue()),0,1);
				       	 eval("\$libelle_langue=$libelle_langue;");
				       	 $lien=affiche_formateur( $objet->getId(),  $id_organisme,$libelle_organisme, $objet->getNom(), $objet->getPrenom(), $objet->getLogin(), $objet->getPassword(), $objet->getAdresse(), $objet->getCode(), $objet->getVille(), $objet->getEmail(), $objet->getTelephonefixe(), $objet->getTelephoneport(), $libelle_langue, $objet->getPhoto(), $coul1, $coul2);
				       	
		       	 break;
		       	 	
		       	  //appel de la fonction affiche_stagiaire	
		       	 case "stagiaire":
		       	 	//print_rr($objet);
				       	 $obj_organisme = $objet->org;
				       	 $libelle_organisme = $obj_organisme->getLibelle();
				       	 $id_organisme = $obj_organisme->getId( );
				       	 $libelle_langue=pg_fetch_result(get_langue($objet->getLangue()),0,1);
				       	 eval("\$libelle_langue=$libelle_langue;");
				       	 $lien= affiche_stagiaire($objet->getId(), $id_organisme, $libelle_organisme, $objet->getNom(), $objet->getPrenom(), $objet->getLogin(), $objet->getPassword(), $objet->getAdresse(), $objet->getCode(), $objet->getVille(), $objet->getEmail(), $objet->getTelephonefixe(),  $objet->getTelephoneport(), $libelle_langue, $objet->getPhoto(), $coul1, $coul2);
				       	 
		       	 break;
		       	 	
		       	 //appel de la fonction affiche_classe       	 	
		       	 case"classe":
		       	 
				       	 $obj_pere=$objet->getPere();
				       	 if($obj_pere){
					       	  	$libelle_pere=$obj_pere->getLibelle();	
					       	  	$id_pere=$obj_pere->getId();
				       	 }
				       	  $lien=affiche_classe( $objet->getId(), $objet->getLibelle(), $id_pere,  $libelle_pere, $objet->getPlacemin(), $objet->getPlacemax(), $coul1, $coul2);
				       	
		       	 break;
		       	 	
       }
       
       print("
       		<tr class=\"$coul1\" align=\"center\">
                <td colspan=\"2\"><a class=\"action\" href=\"$lien \" value=\"cliquer\">$MSG_2617 <!--Editer ses informations--></a></td>
            </tr>
       		</table>");
}


/**
* Fonction qui affiche la liste des formations
* @param object : objet dont il faut trouver les formations
*/
function affSesFormations($objet)
{
        global $largeur,$coul1,$coul2 ;

        global $MSG_635, $MSG_7, $MSG_2390, $MSG_1031 ;

        // Voir si il existe un moyen d'appeler la fonction qu'une fois et d'avoir de parcourir le resultat dans les deux sens

        // On rcupre dans un tableau associatif les informations de l'objet
        $sesFormations=$objet->getFormations("ASC","libelle") ;
        $sesFormations_DESC=$objet->getFormations("DESC","libelle") ;

        // Rsultat pour classement par date
        $sesFormations_dates=$objet->getFormations("ASC","date_debut") ;
        $sesFormations_dates_DESC=$objet->getFormations("DESC","date_debut") ;
        if(pg_num_rows($sesFormations))
        {
                include("fonctions_javascript.inc");

                // Fonction javascript pour afficher le bon tableau
                ?>
                <script>

                function inverse(val)
                {
                        cal1 = MM_findObj("nom") ;
                        cal2 = MM_findObj("nom_DESC") ;

                        cal3 = MM_findObj("dates") ;
                        cal4 = MM_findObj("dates_DESC") ;

                        // Par nom
                        if(val==1)
                        {
                                // On cache les cadres de classement par dates
                                cal3.style.display='none' ;
                                cal4.style.display='none' ;
                                document.fleche_dates.style.display='none' ;
                                document.fleche_nom.style.display='block' ;

                                // Les cachs deviennent visibles
                                if(cal1.style.display=="none")
                                {
                                        cal1.style.display='block' ;
                                        cal2.style.display='none' ;
                                        document.fleche_nom.src="../images/fleche0.gif" ;
                                }
                                else
                                {
                                        cal1.style.display='none' ;
                                        cal2.style.display='block' ;
                                        document.fleche_nom.src="../images/fleche1.gif" ;
                                }
                        }
                        // Par dates
                        else
                        {
                                // On cache les cadres de classement par nom
                                cal1.style.display='none' ;
                                cal2.style.display='none' ;
                                document.fleche_nom.style.display='none' ;
                                document.fleche_dates.style.display='block' ;

                                // Les cachs deviennent visibles
                                if(cal3.style.display=="none")
                                {
                                        cal3.style.display='block' ;
                                        cal4.style.display='none' ;
                                        document.fleche_dates.src="../images/fleche0.gif" ;
                                }
                                else
                                {
                                        cal3.style.display='none' ;
                                        cal4.style.display='block' ;
                                        document.fleche_dates.src="../images/fleche1.gif" ;
                                }
                        }
                }

                </script>

                <?php
                // Haut du tableau
                print("

                <table width=\"$largeur\">
                <tr class=\"$coul1\" height=\"30\" valign=\"middle\">
                        <td colspan=\"2\"><b>".pg_num_rows($sesFormations)." $MSG_635</b></td>
                </tr>
                <tr class=\"$coul2\">
                        <td width=\"60%\">
                                <a onClick=\"inverse(1)\"><b>$MSG_7</b>&nbsp;&nbsp;
                                <img src=\"../images/fleche0.gif\" name=\"fleche_nom\" style=\"display:block;\"></a>
                        </td>
                        <td width=\"40%\">
                                <a onClick=\"inverse(2)\"><b>$MSG_2390</b>&nbsp;&nbsp;
                                <img src=\"../images/fleche0.gif\" name=\"fleche_dates\" style=\"display:none;\"></a>
                        </td>
                </tr>
                </table>
                <div id=\"nom\" style=\"display:block;\">
                <table width=\"$largeur\">");

                // Parcours du tableau sesInfos pour rcuprer les infos voulues dans sesInfos
                while($row=pg_fetch_array($sesFormations)){
                	//print_rr($row);
                        // On change le format des dates pour l'affichage
                        $date1=substr($row[3],8,2)."-".substr($row[3],5,2)."-".substr($row[3],0,4) ;
                        $date2=substr($row[4],8,2)."-".substr($row[4],5,2)."-".substr($row[4],0,4) ;
                        print("
                        <tr class=\"$coul2\">
                                <td width=\"60%\" align=\"left\">&nbsp;&nbsp;
                                        <a class=\"action\" href=\"index.php?domaine=p&id=".$row[0]."&type=c&res_info=1\">".get_gui_libelle($row[1])."</a>
                                </td>
                                <td width=\"40%\">
                                        $date1 / $date2
                                </td>
                        </tr>");
                }
                print("</table>
                </div>

                <div id=\"nom_DESC\" style=\"display:none;\">
                <table width=\"$largeur\">");

                // Deuxime parcours dans le sens inverse
                while($row=pg_fetch_array($sesFormations_DESC))
                {
                        $date1=substr($row[3],8,2)."-".substr($row[3],5,2)."-".substr($row[3],0,4) ;
                        $date2=substr($row[4],8,2)."-".substr($row[4],5,2)."-".substr($row[4],0,4) ;
					
                        print "
                        <tr class=\"$coul2\">
                                <td width=\"60%\" align=\"left\">&nbsp;&nbsp;
                                        <a class=\"action\" href=\"index.php?domaine=p&id=".$row[0]."&type=c&res_info=1\">".get_gui_libelle($row[1])."</a>
                                </td>
                                <td width=\"40%\">
                                        $date1 / $date2
                                </td>
                        </tr>";
                }
                print("</table></div>

                <div id=\"dates\" style=\"display:none;\">
                <table width=\"$largeur\">");

                // Troisime parcours : classement par dates
                while($row=pg_fetch_array($sesFormations_dates))
                {
                        $date1=substr($row[3],8,2)."-".substr($row[3],5,2)."-".substr($row[3],0,4) ;
                        $date2=substr($row[4],8,2)."-".substr($row[4],5,2)."-".substr($row[4],0,4) ;

                        print "
                        <tr class=\"$coul2\">
                                <td width=\"60%\" align=\"left\">&nbsp;&nbsp;
                                        <a class=\"action\" href=\"index.php?domaine=p&id=".$row[0]."&type=c&res_info=1\">".$row[1]."</a>
                                </td>
                                <td width=\"40%\">
                                        $date1 / $date2
                                </td>
                        </tr>";
                }
                print("</table></div>

                <div id=\"dates_DESC\" style=\"display:none;\">
                <table width=\"$largeur\">");

                // Quatrime parcours : classement par dates dans le sens inverse
                while($row=pg_fetch_array($sesFormations_dates_DESC))
                {
                        $date1=substr($row[3],8,2)."-".substr($row[3],5,2)."-".substr($row[3],0,4) ;
                        $date2=substr($row[4],8,2)."-".substr($row[4],5,2)."-".substr($row[4],0,4) ;

                        print "
                        <tr class=\"$coul2\">
                                <td width=\"60%\" align=\"left\">&nbsp;&nbsp;
                                        <a class=\"action\" href=\"index.php?domaine=p&id=".$row[0]."&type=c&res_info=1\">".$row[1]."</a>
                                </td>
                                <td width=\"40%\">
                                        $date1 / $date2
                                </td>
                        </tr>";
                }
                print("</table></div>");

        }
        // Aucune formation  afficher
        else
        {
                print("
                <table width=\"$largeur\">
                <tr class=\"$coul2\" height=\"30\" valign=\"middle\">
                        <td><i>$MSG_1031</i></td>
                </tr>
                </table>");
        }
}


/**
* Fonction qui affiche la liste des individus lis  l'objet
* @param object : objet dont il faut trouver les individus
* @param char : Catgorie de l'individu s ou f (prendre en compte un paramtre tous les individus ?)
* @param string : Si == "res_strict"  alors rsultats exclusifs : soit que des 'f' soit que des 'u'
*/
function affSesIndividus($objet,$categorie='s', $type_recherche=0)
{
        global $largeur,$coul1,$coul2 ;

        global $MSG_2419, $MSG_2271, $MSG_7, $MSG_8, $MSG_16;
        global $ERROR_77, $ERROR_78;



        // Une recherche stricte ou non
        if($type_recherche==1)
                $strict='true';
        else
                $strict='false';

        // On appele les mthodes des objets selon la catgorie souhaite
        // Les formateurs
        if($categorie=='f')
        {
                $sesIndivs=$objet->getFormateurs("ASC", $strict) ;
                $sesIndivs_DESC=$objet->getFormateurs("DESC", $strict) ;
        }
        // Les stagiaires
        else
        {
                $sesIndivs=$objet->getStagiaires("ASC", $strict) ;
                $sesIndivs_DESC=$objet->getStagiaires("DESC", $strict) ;
        }

        if(pg_num_rows($sesIndivs))
        {
                include("fonctions_javascript.inc");

                // Fonction javascript pour afficher le bon tableau
                print("

                <script>
                function inverse_$categorie()
                {
                        cal1 = MM_findObj(\"".$categorie."_nom\") ;
                        cal2 = MM_findObj(\"".$categorie."_nom_DESC\") ;

                        document.".$categorie."_fleche_nom.style.display='block' ;

                        // Les cachs deviennent visibles
                        if(cal1.style.display==\"none\")
                        {
                                cal1.style.display='block' ;
                                cal2.style.display='none' ;
                                document.".$categorie."_fleche_nom.src=\"../images/fleche0.gif\" ;
                        }
                        else
                        {
                                cal1.style.display='none' ;
                                cal2.style.display='block' ;
                                document.".$categorie."_fleche_nom.src=\"../images/fleche1.gif\" ;
                        }
                }

                </script>
                ");

                // Haut du tableau
                print("
                <table border=\"0\" width=\"$largeur\">
                <tr class=\"$coul1\" height=\"30\" valign=\"middle\">
                        <td colspan=\"2\"><b>
                                ".pg_num_rows($sesIndivs)." ");

                                if($categorie=='f')
                                        echo $MSG_2271 ;
                                else
                                        echo $MSG_2419 ;

                                if($strict)
                                        print(" (recherche stricte)");
                        print("</b>
                        </td>
                </tr>
                <tr height=\"30\" class=\"$coul2\">
                        <td width=\"60%\">
                                <a onClick=\"inverse_".$categorie."()\"><b>$MSG_7 $MSG_8</b><!--Nom prnom-->&nbsp;
                                <img src=\"../images/fleche0.gif\" name=\"".$categorie."_fleche_nom\" style=\"display:block;\"></a>
                        </td>
                        <td width=\"40%\">
                                <b>$MSG_16</b> <!--Catgorie-->
                        </td>
                </tr>
                </table>
                <div id=\"".$categorie."_nom\" style=\"display:block;\">
                <table border=\"0\" width=\"$largeur\">");

                // Premier parcours dans le sens ASC
                while($row=pg_fetch_array($sesIndivs)){
                	//print_rr($row);
                	// recup les types de l'individu
                	$liste_type=get_individu_liste_type($row[0]);
                
                        print("
                        <tr class=\"$coul2\">
                                <td width=\"60%\" align=\"left\">&nbsp;&nbsp;
                                        <a class=\"action\" href=\"index.php?domaine=h&id=".$row[0]."&type=".$categorie."&res_info=1\">".$row[1]." ".$row[2]."</a>
                                </td>
                                <td width=\"40%\">
                                        ".$row["categorie"]."$liste_type
                                </td>
                        </tr>");
                }
                print("</table>
                </div>

                <div id=\"".$categorie."_nom_DESC\" style=\"display:none;\">
                <table border=\"0\" width=\"$largeur\">");

                // Deuxime parcours dans le sens inverse
                while($row=pg_fetch_array($sesIndivs_DESC))
                {
                		$liste_type=get_individu_liste_type($row[0]);
                        $date1=substr($row[1],8,2)."-".substr($row[1],5,2)."-".substr($row[1],0,4) ;
                        $date2=substr($row[2],8,2)."-".substr($row[2],5,2)."-".substr($row[2],0,4) ;
                        print "
                        <tr class=\"$coul2\">
                                <td width=\"60%\" align=\"left\">&nbsp;&nbsp;
                                        <a class=\"action\" href=\"index.php?domaine=h&id=".$row[0]."&type=".$categorie."&res_info=1\">".$row[1]." ".$row[2]."</a>
                                </td>
                                <td width=\"40%\">
                                        ".$row["categorie"]."$liste_type
                                </td>
                        </tr>";
                }
                print("</table></div>");
        }
        // Aucun stagiaire  afficher
        else
        {
                print("
                <table border=\"0\" width=\"$largeur\">
                <tr height=\"30\" class=\"$coul2\" valign=\"middle\">
                        <td>
                                <i>$ERROR_77 - $ERROR_78</i> <!--Aucun stagiaire - Aucun formateur-->
                        </td>
                </tr>
                </table>");
        }

}


/**
* Fonction qui affiche la liste des groupe
* @param object : objet dont il faut trouver les groupe
*/
function affSesGroupes($objet){
    global $largeur,$coul1,$coul2 ;
    global $MSG_682,$MSG_1238, $MSG_16, $MSG_7;
    global $ERROR_79;
    
    // on recupre ds un tableau associatif les informatons de l'objet
    $sesGroupes=$objet->getGroupes();
    $sesGroupes_DESC=$objet->getGroupes("DESC");
    if(pg_num_rows($sesGroupes)){
        if(pg_num_rows($sesGroupes)>1)
            $gp=$MSG_1238;
        else
            $gp=$MSG_682;
        include("fonctions_javascript.inc");
        // Fonction javascript pour afficher le bon tableau
        print("
        <script>
        function inversegp(){
        	
            cal1 = MM_findObj(\"nomgp\") ;
            cal2 = MM_findObj(\"nomgp_DESC\") ;
            	
            document.fleche_nomgp.style.display='block' ;
           
           	 // Les cachs deviennent visibles
            if(cal1.style.display==\"none\")
            {
	                cal1.style.display='block' ;
	                cal2.style.display='none' ;
	                document.fleche_nomgp.src=\"../images/fleche0.gif\" ;
            }
            else
            {
	                cal1.style.display='none' ;
	                cal2.style.display='block' ;
	                document.fleche_nomgp.src=\"../images/fleche1.gif\" ;
            }
        }
        </script>
        ");
         // Haut du tableau
         print("
         <table width=\"$largeur\">
         <tr height=\"30\" class=\"$coul1\" valign=\"middle\">
         <td colspan=\"2\"><b>".pg_num_rows($sesGroupes)." $gp</b>
         ");
         print("
         </td>
         </tr>
         <tr class=\"$coul2\">
         <td width=\"60%\">
         <table border=0 cellpadding=0 cellspacing=0 align=center>
         <tr>
         <td><b>$MSG_7</b></td>
         <td><a onClick=\"inversegp()\"><img src=\"../images/fleche0.gif\" name=\"fleche_nomgp\"><!--Nom--></a></td>
         </tr>
         </table>
         </td>
         <!--
         <td width=\"40%\"><b>
         $MSG_16 </b><!--Catgorie-->
         </td>
         
         </tr>
         </table>
         <div id=\"nomgp\" style=\"display:block;\">
         <table width=\"$largeur\">");
         // Premier parcours dans le sens ASC
         while($row=pg_fetch_array($sesGroupes)){
            print("
            <tr class=\"$coul2\">
            <td width=\"60%\">
            <a class=\"action\" href=\"index.php?domaine=h&id=".$row[0]."&res_info=1&type=g\">".$row[1]." </a>
            </td>
            <!--<td width=\"40%\">".$row["categorie"]."</td>-->
            </tr>
            ");
         }
         print("</table>
         </div>
         <div id=\"nomgp_DESC\" style=\"display:none;\">
         <table width=\"$largeur\">");
         // Deuxime parcours dans le sens inverse
         while($row=pg_fetch_array($sesGroupes_DESC)){
         
                        $date1=substr($row[3],8,2)."-".substr($row[3],5,2)."-".substr($row[3],0,4) ;
                        $date2=substr($row[4],8,2)."-".substr($row[4],5,2)."-".substr($row[4],0,4) ;
                        print "
                        <tr class=\"$coul2\">
                                <td width=\"60%\">
                                        <a class=\"action\" href=\"index.php?domaine=h&id=".$row[0]."&res_info=1&type=g\">".$row[1]." </a>
                                </td>
                                <!--
                                <td width=\"40%\">
                                        ".$row["categorie"]."
                                </td>
                                -->
                        </tr>";
                }
                print("</table></div>");
    }
    else {
                print("
                <table width=\"$largeur\">
                <tr class=\"$coul2\" height=\"30\" valign=\"middle\">
                        <td colspan=\"2\">
                                <i>$ERROR_79</i> <!--Aucun Groupe-->
                        </td>
                </tr>
                </table>");
        }

}


/**
* Fonction qui affiche la liste des tapes d'un parcours
* @param object : objet dont il faut trouver les etapes
*/
function affSesEtapes($objet){
    global $largeur,$coul1,$coul2 ;
    global $MSG_1687, $MSG_1415, $MSG_933, $MSG_606;
    global $MSG_1267, $MSG_516, $MSG_922, $MSG_926, $MSG_927, $MSG_928, $MSG_288, $MSG_282, $MSG_776, $MSG_1274, $MSG_1689;
    global $MSG_1473, $MSG_547, $MSG_2421, $MSG_2227, $MSG_1741, $MSG_727, $MSG_1372, $MSG_2226, $MSG_1483, $MSG_2226, $MSG_1483, $MSG_2228, $MSG_2228 , $MSG_2233; 

    // on recupere le tableau associatif sesEtapes du parcours
    $res=$objet->getEtapes() ;
    //calcul du nombre d'lments
    $nbEtapes=pg_num_rows($res);

    // affichage en tete du tableau
    print("
    <table width=\"$largeur\">
    <tr class=\"$coul1\" height=\"30\" valign=\"middle\">
    <td colspan=\"2\"><b>$nbEtapes $MSG_1687</b> <!--Etapes--></td>
    </tr>
    <tr class=\"$coul2\">
    <td width=\"30%\"><b>$MSG_1415</b> <!--Etapes--></td>
    <td width=\"70%\"><b>$MSG_933 ($MSG_606)</b> <!--Type d'tape (Libell)--></td>
    </tr>
    </table>
    ");
    // affichage des resultats
    print("
    <table width=\"$largeur\">
    ");
    for($i=0;$i<$nbEtapes;$i++){
        $row = pg_fetch_row($res,$i);
        $j=$i+1;
        //On recupere tout les Objets correspondant aux types
        $obj_etape = EtapeFactory::createEtape($row[0],$row[4]);
        print("
        <tr class=\"$coul2\">
        <td width=\"30%\">$j</td>
        <td>
        ");
        $libelle = $obj_etape->getLibelle();
        //On effectue un "eval" pour interpreter les champs contenu dans les variables $MSGXXX 
        $var = '$le_libelle_que_je_veux='.$row[10].';';
        eval($var);
        //On retire les tirs ce trouvants devant certain type d'tape
        $pos=strpos($le_libelle_que_je_veux," -");
        if($pos == 2){
        	$le_libelle_que_je_veux=substr($le_libelle_que_je_veux,5);
        }
        print("$le_libelle_que_je_veux (".get_gui_libelle($libelle).")");

        
        print("
        </td>
        </tr>
        ");
    }
    print("
    </table>
    ");
}


// DEBUT TEST D'AFFICHAGE "SES PARCOURS"
/**
* Fonction qui affiche la liste des parcours
* @param object : objet dont il faut trouver les parcours
/* NOTE : Une formation ne possde qu'un SEUL parcours qui est principal !
*/
function affSesParcours($objet){
          global $largeur,$coul1,$coul2 ;
          global $MSG_235, $MSG_1688, $MSG_1026;

           $sesParcours=$objet->getParcours();
           $nbParcours=pg_num_rows($sesParcours);

          // affichage en tete du tableau
          print("
         <table width=\"$largeur\">
            <tr class=\"$coul1\" height=\"30\" valign=\"middle\">
                <td colspan=\"2\"><b>$nbParcours $MSG_235</b> <!--Parcours--></td>
            </tr>
            <tr class=\"$coul2\">
                <td width=\"40%\"><b>$MSG_1688</b> <!--N Parcours--></td>
                <td width=\"60%\"><b>$MSG_1026</b> <!--Nom Parcours--></td>
            </tr>
         </table>
         ");
         // affichage des resultats
         print("
         <table width=\"$largeur\">
        ");
        while($ligne=pg_fetch_row($sesParcours)){
        	
        print("
                        <tr class=\"$coul2\">
                                <td width=\"40%\">$ligne[0]</td>
                                <td width=\"60%\">".get_gui_libelle($ligne[1])."</td>
                        </tr>
        ");
        }
        print("
        </table>
        ");
}

?>