<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/


 /**
Fichier de fonctions  pour l'affichage des rubriques "infos"  ce trouvant dans le moteur de recherche.

C'est dans ce fichier que sont gnrs les affichages "infos" de chaques rubriques prsentes dans le moteur
de recherche.
@package moteur de recherche
@author OUAKNINE Grgory
@since 12/06/2007
  */
  
//--------------------------------------------------------------------------------------------------------------------------RESSOURCES PEDAGOGIQUES---------------------------------------------------------------------------------------------------------------
/**
 * Fonction qui est appell pour afficher les informations d'une FORMATION
 * 
 * @param integer $id_formation Identifiant en base de donne de la Formation.
 * @param string $debut_formation chaine de caractere contenant la date de debut de la Formation(formatSQL).
 * @param string $fin_formation chaine de caractere contenant la date de fin de la Formation(formatSQL).
 * @param string $nom_formateur chaine de caractere contenant le nom du formateur de la Formation.
 * @param integer $id_formateur identifiant en base de donne du formateur.
 * @param string $nom_groupe chaine de caractere contenant le nom de la Classe de la Formation.
 * @param integer $id_classe identifiant base de donne de la Classe de la Formation.
 * @param string $nom_parcours chaine de caractere contenant le nom du Parcous de la Fromation.
 * @param integer $id_nomparcours identifiant base de donne du Parcours.
 * @param integer $langue_fodispo numero de la langue par defaut.
 * @param string $coul1 chaine de caractere contenant la couleur "ressourcesPedagogiques2".
 * @param string $coul2 chaine de caractere contenant la couleur "ressourcesPedagogiques3".
 * @return string retourne une chaine de caractere contenant l'url d'edition de la formation.
 */
function affiche_formation($id_formation, $debut_formation, $fin_formation, $nom_formateur, $id_formateur,  $nom_groupe, $id_classe, $nom_parcours, $id_nomparcours,  $langue_fodispo, $coul1, $coul2){
	global $s_langue,$MSG_1594, $MSG_1595,$MSG_192,$MSG_186,$MSG_183,$MSG_642,$MSG_1026,$MSG_968 ;
	$langue=$s_langue;
	if($langue==1){
    	$tab=explode("-",$debut_formation);
        $datedeb=formater_date($tab,"french","Y");
        $tab=explode("-",$fin_formation);
         $datefin=formater_date($tab,"french","Y");
            }
	print(" 
			<tr class=\"$coul2\" align=\"left\">
            	<td>&nbsp;$MSG_192 <!--Debut de la formation-->:</td>
                <td>".$datedeb."</td>
            </tr>
            <tr class=\"$coul2\" align=\"left\">
                <td>&nbsp;$MSG_186 <!--Fin de la formation-->:</td>
                <td>".$datefin."</td>
            </tr>
            <tr class=\"$coul2\" align=\"left\">
                <td>&nbsp;$MSG_183 <!--Nom du Formateur-->:</td>
                <td><a class=\"action\" href=\"index.php?domaine=h&id=".$id_formateur."&type=f&res_info=1\">".$nom_formateur."</a></td>
            </tr>
			<tr class=\"$coul2\" align=\"left\">
        		<td>&nbsp;$MSG_642 <!--Nom du groupe-->:</td>
                <td><a class=\"action\" href=\"index.php?domaine=h&id=".$id_classe."&type=g&res_lienClasse=1\">".$nom_groupe."</a></td>
            </tr>
            <tr class=\"$coul2\" align=\"left\">
        		<td>&nbsp;$MSG_1026 <!--Nom du parcours-->:</td>
                <td><a class=\"action\" href=\"index.php?domaine=p&id=".$id_nomparcours."&type=p&res_lienFormation=1\">".get_gui_libelle($nom_parcours)."</a></td>
            </tr>
            <tr class=\"$coul2\" align=\"left\">
        		<td>&nbsp;$MSG_968 <!--Langues disponibles pour le Front office-->:</td>
                <td>$langue_fodispo</td>
            </tr>
            		
           
    ");
    return "moteur_edition_formation.php?action_evenement=detail&num_cal=".$id_formation."";
}


/**
 * Fonction qui est appell pour afficher les informations d'une FILIERE
 * 
 * @param integer $id_filiere identifiant base de donne de la Filiere.
 * @param string $nom_filiere chaine de caractere contenant le nom de la filiere.
 * @param integer $id_filiereMere identifiant base de donne de la Filliere Mere.
 * @param string $nom_filiereMere chaine de caractere contenant le nom de la Filiere Mere.
 * @param string $coul1 chaine de caractere contenant la couleur "ressourcesPedagogiques2".
 * @param string $coul2 chaine de caractere contenant la couleur "ressourcesPedagogiques3".
 * @return string chaine de caractere contenant l'url de redirection vers la page d'edition de la Filiere.
 */
function affiche_filiere($id_filiere,  $nom_filiere, $id_filiereMere, $nom_filliereMere, $coul1,$coul2){
	global $MSG_2612,$MSG_2034;	
	print(" 
			<tr class=\"$coul2\" align=\"left\">
            	<td>&nbsp;$MSG_2612 <!--Nom de la filiere-->:</td>
                <td>".get_gui_libelle($nom_filiere,false)."</td>
            </tr>
            <tr class=\"$coul2\" align=\"left\">
                <td>&nbsp;$MSG_2034 <!--Nom de la filiere mere-->:</td>
                <td><a class=\"action\" href=\"index.php?domaine=p&id=".$id_filiereMere."&type=l&res_lienFiliere=1\">".get_gui_libelle($nom_filliereMere,false)."</a></td>
            </tr>

    ");	
	return "./moteur_edition_filiere.php?gestcours=".$id_filiere."&niv= ";
}


/**
 * Fonction qui est appell pour afficher les informations d'un PARCOURS
 * 
 * @param integer $id_filiere identifiant base de donnes de la Filiere.
 * @param string $nom_parcours retourne une chaine de caractere contenant le nom du Parcours.
 * @param integer $numero_parcours identifiant base de donnes du Parcours.
 * @param string $coul1 chaine de caractere contenant la couleur "ressourcesPedagogiques2".
 * @param string $coul2 chaine de caractere contenant la couleur "ressourcesPedagogiques3".
 * @return string chaine de caractere contenant l'url de redirection vers la page d'edition du Parcours.
 */
function affiche_parcours($id_filiere, $nom_parcours, $numero_parcours, $coul1, $coul2){
	global $MSG_1026,$MSG_1688;
	print(" 
			<tr class=\"$coul2\" align=\"left\">
            	<td>&nbsp;$MSG_1026 <!--Nom du parcours-->:</td>
                <td>".get_gui_libelle($nom_parcours,false)."</td>
            </tr>
            <tr class=\"$coul2\" align=\"left\">
                <td>&nbsp;$MSG_1688 <!--Numero de parcours-->:</td>
                <td>".$numero_parcours."</td>
            </tr>   
	");
	  return "./moteur_edition_parcours.php?action_parcours=detail&num_parcours=".$numero_parcours."&gestcours=".$id_filiere."&niv= ";
}

//--------------------------------------------------------------------------------------------------------------------FIN DE RESSOURCES PEDAGOGIQUES	--------------------------------------------------------------------------------------------------------------


//-----------------------------------------------------------------------------------------------------------------------------RESSOURCES HUMAINES------------------------------------------------------------------------------------------------------------------------
/**
 * Fonction qui est appell pour afficher les informations d'un FORMATEUR
 * 
 * @param integer $id_formateur identifiant base de donne du Formateur.
 * @param integer $id_organisme identifiant base de donne de l'Organisme.
 * @param string $nom_organisme chaine de caractere contenant le nom de l'Organisme.
 * @param string $nom chaine de caractere contenant le nom du Formateur.
 * @param string $prenom chaine de caractere contenant le prenom du Formateur.
 * @param string $login chaine de caractere contenant le login du Formateur.
 * @param string $mot_de_passe chaine de caractere contenant le mot de passe du Formateur.
 * @param string $adresse chaine de caractere contenant l'adresse du Formateur.
 * @param string $code_postal chaine de caractere contenant le code postal du Formateur.
 * @param string $ville chaine de caractere contenant la ville du Formateur.
 * @param string $e_mail chaine de caractere contenant le mail du Formateur..
 * @param string $tel_fixe chaine de caractere contenant le numero de telephone fixe du Formateur.
 * @param string $tel_port chaine de caractere contenant le le numero de telephone portable du Formateur.
 * @param integer $langue_parle numero de la langue du Formateur.
 * @param integer $photo_formateur le numero de la photo du Formateur.
 * @param string $coul1 chaine de caractere contenant la couleur "ressourcesHumaines2".
 * @param string $coul2 chaine de caractere contenant la couleur "ressourcesHumaines3".
 * @return string chaine de caractere contenant l'url de redirection vers la page d'edition du Formateur.
 */
function affiche_formateur($id_formateur, $id_organisme, $nom_organisme, $nom, $prenom, $login, $mot_de_passe, $adresse, $code_postal, $ville,$e_mail, $tel_fixe, $tel_port, $langue_parle, $photo_formateur, $coul1, $coul2){
	global $MSG_1594, $MSG_1595,$astairs_directories;
	global $MSG_5, $MSG_6, $MSG_7, $MSG_8, $MSG_9, $MSG_10, $MSG_11, $MSG_12, $MSG_13, $MSG_14, $MSG_15, $MSG_16, $FORM_6, $MSG_82, $MSG_1030 ;
	print(" 
			<tr class=\"$coul2\" align=\"left\">
                <td>&nbsp;$MSG_82:</td>
                <td><a class=\"action\" href=\"index.php?domaine=h&id=".$id_organisme."&type=o&res_organisme=1\">".$nom_organisme."</a></td>
            </tr>
			<tr class=\"$coul2\" align=\"left\">
                <td>&nbsp;$MSG_7:</td>
                <td>".$nom."</td>
            </tr>
			<tr class=\"$coul2\" align=\"left\">
        		<td>&nbsp;$MSG_8:</td>
                <td>".$prenom."</td>
            </tr>
			<tr class=\"$coul2\" align=\"left\">
            	<td>&nbsp;$MSG_5:</td>
                <td>".$login."</td>
            </tr>
            <tr class=\"$coul2\" align=\"left\">
                <td>&nbsp;$MSG_6:</td>
                <td>".$mot_de_passe."</td>
            </tr>
            <tr class=\"$coul2\" align=\"left\">
        		<td>&nbsp;$MSG_9:</td>
                <td>".$adresse."</td>
            </tr>
            <tr class=\"$coul2\" align=\"left\">
        		<td>&nbsp;$MSG_10:</td>
                <td>".$code_postal."</td>
            </tr>
			  <tr class=\"$coul2\" align=\"left\">
        		<td>&nbsp;$MSG_11:</td>
                <td>".$ville."</td>
            </tr>
            <tr class=\"$coul2\" align=\"left\">
        		<td>&nbsp;$MSG_12:</td>
                <td>".$e_mail."</td>
            </tr> 
			<tr class=\"$coul2\" align=\"left\">
            	<td>&nbsp;$MSG_13:</td>
                <td>".$tel_fixe."</td>
            </tr>
            <tr class=\"$coul2\" align=\"left\">
                <td>&nbsp;$MSG_14:</td>
                <td>".$tel_port."</td>
            </tr>
            <tr class=\"$coul2\" align=\"left\">
                <td>&nbsp;$MSG_1030:</td>
                <td>".$langue_parle."</td>
            </tr>");
            //photo
			if(!empty($photo_formateur)){
				$nom_photo=pg_fetch_result(get_fichier($photo_formateur),0,1);
				$photo_url=$astairs_directories['PRIVATE_USER_DATA_URL'].$id_formateur.'/'.$nom_photo;	
			}else{
				$photo_url =DEFAULT_PHOTO_PATH;
			}
			$photo_alt=MSG_15.$login;
            print("
            <tr class=\"$coul2\" align=\"left\">
                <td>&nbsp;$MSG_15:</td>
                <td><img src=\"$photo_url\" width=\"100px\" height=\"100px\" alt=\"$photo_alt\" title=\"$photo_alt\"/></td>
            </tr>
           
	");
	return "./moteur_edition_formateur.php?action_individu=ajout_modification_individu&t=2&organisme=".$id_organisme."&idv=".$id_formateur."";
}


/**
 * Fonction qui est appell pour afficher les informations d'un STAGIAIRE
 * 
 * @param integer $id_formateur identifiant base de donne du Stagiaire.
 * @param integer $id_organisme identifiant base de donne de l'Organisme.
 * @param string $nom_organisme chaine de caractere contenant le nom de l'Organisme.
 * @param string $nom chaine de caractere contenant le nom du Stagiaire.
 * @param string $prenom chaine de caractere contenant le prenom du Stagiaire.
 * @param string $login chaine de caractere contenant le login du Stagiaire.
 * @param string $mot_de_passe chaine de caractere contenant le mot de passe du Stagiaire.
 * @param string $adresse chaine de caractere contenant l'adresse du Stagiaire.
 * @param string $code_postal chaine de caractere contenant le code postal du Stagiaire.
 * @param string $ville chaine de caractere contenant la ville du Stagiaire.
 * @param string $e_mail chaine de caractere contenant le mail du Stagiaire..
 * @param string $tel_fixe chaine de caractere contenant le numero de telephone fixe du Stagiaire.
 * @param string $tel_port chaine de caractere contenant le le numero de telephone portable du Stagiaire.
 * @param integer $langue_parle numero de la langue du Stagiaire.
 * @param integer $photo_formateur le numero de la photo du Stagiaire.
 * @param string $coul1 chaine de caractere contenant la couleur "ressourcesHumaines2".
 * @param string $coul2 chaine de caractere contenant la couleur "ressourcesHumaines3".
 * @return string chaine de caractere contenant l'url de redirection vers la page d'edition du Stagiaire.
 **/
function affiche_stagiaire($id_stagiaire, $id_organisme, $nom_organisme, $nom, $prenom, $login, $mot_de_passe, $adresse, $code_postal, $ville,$e_mail, $tele_fixe, $tele_port, $langue_parle, $photo_formateur, $coul1, $coul2){	
	global $MSG_1594, $MSG_1595,$astairs_directories;
	global $MSG_5, $MSG_6, $MSG_7, $MSG_8, $MSG_9, $MSG_10, $MSG_11, $MSG_12, $MSG_13, $MSG_14, $MSG_15, $MSG_16, $FORM_6, $MSG_82, $MSG_1030 ;
	print("
			<tr class=\"$coul2\" align=\"left\">
                <td>&nbsp;$MSG_82:</td>
                <td><a class=\"action\" href=\"index.php?domaine=h&id=".$id_organisme."&type=o&res_organisme=1\">".$nom_organisme."</a></td>
            </tr>
			<tr class=\"$coul2\" align=\"left\">
                <td>&nbsp;$MSG_7:</td>
                <td>".$nom."</td>
            </tr>
			<tr class=\"$coul2\" align=\"left\">
        		<td>&nbsp;$MSG_8:</td>
                <td>".$prenom."</td>
            </tr>
			<tr class=\"$coul2\" align=\"left\">
            	<td>&nbsp;$MSG_5:</td>
                <td>".$login."</td>
            </tr>
            <tr class=\"$coul2\" align=\"left\">
                <td>&nbsp;$MSG_6:</td>
                <td>".$mot_de_passe."</td>
            </tr>
            <tr class=\"$coul2\" align=\"left\">
        		<td>&nbsp;$MSG_9:</td>
                <td>".$adresse."</td>
            </tr>
            <tr class=\"$coul2\" align=\"left\">
        		<td>&nbsp;$MSG_10:</td>
                <td>".$code_postal."</td>
            </tr>
			  <tr class=\"$coul2\" align=\"left\">
        		<td>&nbsp;$MSG_11:</td>
                <td>".$ville."</td>
            </tr>
            <tr class=\"$coul2\" align=\"left\">
        		<td>&nbsp;$MSG_12:</td>
                <td>".$e_mail."</td>
            </tr> 
			<tr class=\"$coul2\" align=\"left\">
            	<td>&nbsp;$MSG_13:</td>
                <td>".$tele_fixe."</td>
            </tr>
            <tr class=\"$coul2\" align=\"left\">
                <td>&nbsp;$MSG_14:</td>
                <td>".$tele_port."</td>
            </tr>
         	<tr class=\"$coul2\" align=\"left\">
                <td>&nbsp;$MSG_1030:</td>
                <td>".$langue_parle."</td>
            </tr>");
            //photo
			if(!empty($photo_formateur)){
				$nom_photo=pg_fetch_result(get_fichier($photo_formateur),0,1);
				$photo_url=$astairs_directories['PRIVATE_USER_DATA_URL'].$id_stagiaire.'/'.$nom_photo;	
			}else{
				$photo_url =DEFAULT_PHOTO_PATH;
			}
			$photo_alt=MSG_15.$login;
            print("
            <tr class=\"$coul2\" align=\"left\">
                <td>&nbsp;$MSG_15:</td>
                <td><img src=\"$photo_url\" width=\"100px\" height=\"100px\" alt=\"$photo_alt\" title=\"$photo_alt\"/></td>
            </tr>
	");
	return "./moteur_edition_stagiaire.php?action_individu=ajout_modification_individu&t=1&organisme=".$id_organisme."&idv=".$id_stagiaire."";
}	


/**
 * Fonction qui est appell pour afficher les informations d'une CLASSE
 * 
 * @param integer $id_classe identifiant base de donne de la Classe.
 * @param string $nom_classe chaine de caractere contenant le nom de la Classe.
 * @param integer $id_pereclasse identifiant base de donne du pere de la Classe.
 * @param string $nom_pereclasse chaine de caractere contnenant le nom du pere de la Classe.
 * @param integer $place_min nombre de place Minimum de la Classe.
 * @param integer $place_max nombre de place Maximum de la Classe.
 * @param string $coul1 chaine de caractere contenant la couleur "ressourcesHumaines2".
 * @param string $coul2 chaine de caractere contenant la couleur "ressourcesHumaines3".
 * @return string chaine de caractere contenant l'url de redirection vers la page d'edition de la Classe.
 */
function affiche_classe($id_classe,  $nom_classe, $id_pereclasse, $nom_pereclasse, $place_min, $place_max, $coul1, $coul2){
	global $MSG_184, $MSG_190, $MSG_1168, $MSG_2507;
	print(" 
			<tr class=\"$coul2\" align=\"left\">
            	<td>&nbsp;$MSG_184:</td>
                <td>".$nom_classe."</td>
            </tr>
            <tr class=\"$coul2\" align=\"left\">
                <td>&nbsp;$MSG_190:</td>
                <td><a class=\"action\" href=\"index.php?domaine=h&id=".$id_pereclasse."&type=g&res_lienClasse=1\">".$nom_pereclasse."</a></td>
            </tr>
            <tr class=\"$coul2\" align=\"left\">
                <td>&nbsp;$MSG_1168:</td>
                <td>".$place_min."</td>
            </tr>
            <tr class=\"$coul2\" align=\"left\">
                <td>&nbsp;$MSG_2507:</td>
                <td>".$place_max."</td>
            </tr>
	");
	return"moteur_edition_classe.php?gestgp=".$id_classe."&niv=&lstGrp=1";
}
           
//-------------------------------------------------------------------------------------------------------------------------------FIN DE RESSOURCES HUMAINES---------------------------------------------------------------------------------------------------------           



?>