<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**                                
Fichier de fonctions pour l'affichage du moteur de recherche

C'est dans ce fichier que sont gnrs tous les affichages du moteur de recherche.
On utilise pour cela des fonctions qui gnrent du code dynamiquement (les mmes fonctions
pour des objets diffrents) pusique les menus se ressemblent tous plus au moins.
@package moteur de recherche
@author CHABOISSIER Jonathan
@since 25/05/2004
*/


/**
* @var string : largeur de tous les tableaux menu affichs
*/
$largeur="70%" ;


/**
* @var string[] Tableau utilis pour des expressions multilingues (faire global $search)
*/
$search = array ($MSG_1268, $MSG_1269, $MSG_1270, $MSG_2409, $MSG_1272, $MSG_743, $MSG_1277, $MSG_1279, $MSG_1296, $MSG_1297, $MSG_1298,$MSG_1682);
//> 0 ses stagiaires, 1 ses formateurs, 2 ses parcours, 3 ses formations, 4 ses groupes, 5 infos, 6 Recherche Simple, 7 ~ en profondeur,
// 8 par saisie, 9 par date, 10 par filire, 11 ses tapes


/**
* @var string[] Tableau utilis pour des expressions multilingues (faire global $select) pour les SELECT des formulaires
*/
$select = array ($MSG_1302, $MSG_2386, $MSG_53, $MSG_2396,$MSG_810,$MSG_1681);


/**
* Fonction qui affiche le menu du choix de domaine de recherche
*
* Cette procdure affiche le menu du haut de la page de recherche. On peut dfinir le domaine,  savoir
* "ressources humaines" ou "ressources pdagogiques".
* @param char : determine le domaine de recherche.
* 'h' > ressources humaines & 'p' > ressources pdagogiques
*/
function affMenuHaut($domaine)
{		
        global $MSG_17,$MSG_2324,$MSG_71,$MSG_682, $MSG_810;
        global $MSG_1519,$MSG_727,$MSG_635;
        global $MSG_748,$MSG_749,$MSG_747,$MSG_1290;
        global $largeur ;
global $root;
        $tableauLiens = array() ;

        // Domaine de recherche : ressources humaines
        if($domaine=='h')
        {
                // Titre des domaines (lien ou non)
                $titreGauche="$MSG_748";//Ressources humaines";
                $titreDroite="<a class=\"action\" href=\"index.php?domaine=p\" class=\"domaine\">$MSG_749 <!--Ressources pdagogiques--></a>";
                // Couleur des domaines (gris ou non)
                //$coulBas=$coulGauche = "#CCCCFF" ;
                $coulBas=$coulGauche = "ressourcesHumaines1";
                $coulDroite = "ressourcesAdministratives1";
                //$coulDroite = "#DDDDDD" ;
                // Couleur des coins arrondis
                $coulGaucheImg="bleu";
                $coulDroiteImg="gris";

                // Les liens du sous-menu diffrent selon la recherche (niveau ressources humaine ou ressources pdagogique)
                $tableauLiens[0]["nom"] = "$MSG_17";//Formateur" ;
                $tableauLiens[0]["lien"] = "index.php?domaine=h&recherche=f" ;
                $tableauLiens[1]["nom"] = "$MSG_2324";//Apprenant" ;
                $tableauLiens[1]["lien"] = "index.php?domaine=h&recherche=s" ;
                $tableauLiens[2]["nom"] = "$MSG_71";//Organisme" ;
                $tableauLiens[2]["lien"] = "index.php?domaine=h&recherche=o" ;
                $tableauLiens[3]["nom"] = "$MSG_682";//Groupe" ;
                $tableauLiens[3]["lien"] = "index.php?domaine=h&recherche=g" ;
        }
        // Domaine de recherche : ressources pdagogiques
        else
        {
                // Titre des domaines (lien ou non)
                $titreGauche="<a class=\"action\" href=\"index.php?domaine=h\" class=\"domaine\">$MSG_748 <!--Ressources humaines--></a>";
                $titreDroite="$MSG_749";//Ressources pdagogiques";
                // Couleur des domaines (gris ou non)
                //$coulGauche = "#DDDDDD" ;
                //$coulBas=$coulDroite = "#FFCC00" ;
                $coulGauche="ressourcesAdministratives1";
                $coulBas=$coulDroite="ressourcesPedagogiques1";
                $coulGaucheImg="gris";
                $coulDroiteImg="oran";

                // Les liens du sous-menu diffrent selon la recherche (niveau ressources humaine ou ressources pdagogique)
                $tableauLiens[0]["nom"] = "$MSG_1290";//Calendrier/Formation" ;
                $tableauLiens[0]["lien"] = "index.php?domaine=p&recherche=c" ;
                $tableauLiens[1]["nom"] = "$MSG_1519";//Filire" ;
                $tableauLiens[1]["lien"] = "index.php?domaine=p&recherche=l" ;
                $tableauLiens[2]["nom"] = "$MSG_727";//Parcours" ;
                $tableauLiens[2]["lien"] = "index.php?domaine=p&recherche=p" ;
        }
        //<img src=\"../images/coin_".$coulGaucheImg."_g.gif\" alt=\"coin_gris_g.jpg\">
        print("
        <table width=\"$largeur\" cellpadding=\"0\" cellspacing=\"0\">
        <tr>
            <td width=\"15\" height=\"35\" background=\"../images/coin_".$coulGaucheImg."_g.gif\"></td>
            <td width=\"42%\" height=\"35\" class=\"$coulGauche\"><font style=\"font-size:14px\"><b>$titreGauche</b></font></td>
            <td width=\"15\" height=\"35\" background=\"../images/coin_".$coulGaucheImg."_d.gif\"></td>
            <td align=\"center\" height=\"35\">&nbsp;</td>
            <td width=\"15\" height=\"35\" background=\"../images/coin_".$coulDroiteImg."_g.gif\"></td>
            <td width=\"42%\" height=\"35\" class=\"$coulDroite\"><font style=\"font-size:14px\"><b>$titreDroite</b></font></td>
            <td width=\"15\" height=\"35\" background=\"../images/coin_".$coulDroiteImg."_d.gif\"></td>
        </tr>
        <tr>
            <td colspan=\"7\" class=\"$coulBas\" height=\"30\" align=\"center\">
        <table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"95%\">
        <tr>
        ");

        // Parcours et affichage des sous-menu
        for($i=0;$i<count($tableauLiens);$i++)
        {
                print("<td align=\"center\" width=\"".(round(100/count($tableauLiens)))."%\"><a class=\"action\" href=\"".$tableauLiens[$i]["lien"]."\">".$tableauLiens[$i]["nom"]."</a></td>") ;
        }

        print("
        </tr>
        </table>
        </td>
        </tr>
        </table>
        ");
}


/**
* Fonction qui affiche le menu de recherche d'un objet dont le type est pass en paramtre
*
* Cette procdure affiche le menu de recherche d'un objet (individu, organisme, etc.)
* @param char : determine le type d'objet :
* 'f' > formateur, 's' > stagiaire, 'o' > organisme, 'g' > groupe (classe), 'l' > filire, 'c' > calendrier (formation), 'p' > parcours
*/
function affMenuRecherche($type)
{
        global $largeur, $domaine ;
global $root,$s_langue;
        global $search, $select ;
        global $MSG_71,$MSG_682,$MSG_1277,$MSG_635,$MSG_727,$MSG_1519,$MSG_1686,$MSG_2165;
        global $MSG_17, $MSG_741, $MSG_1293, $MSG_1302, $MSG_2386, $MSG_2324, $MSG_537, $MSG_535, $MSG_1658, $MSG_1031, $MSG_1658 ;
        global $MSG_1690,$MSG_1691,$MSG_1692,$MSG_1693,$MSG_1694,$MSG_1695,$MSG_2409,$MSG_2414,$MSG_1696, $MSG_2264;
        global $WARN_74, $WARN_74,  $WARN_76,  $WARN_77, $WARN_78, $WARN_115, $WARN_116, $WARN_117, $WARN_118,   $ERROR_38 ;
        global $MSG_1303, $MSG_249, $MSG_810,$MSG_1290,$MSG_2410;
        
        // echo "Menu recherche type = $type $largeur<br>";
        $tabCheckBox=array();

        // -- - -- - -- - -- - -- - -- - -- - -- - -- - -- - -- - -- - -- - -- - -- - -- -
        // INITIALISATION DES VARIABLES
        // -- - -- - -- - -- - -- - -- - -- - -- - -- - -- - -- - -- - -- - -- - -- - -- -

        // Remarque :
        // la requte doit retourner en 0 l'identifiant en base de donnes et en 1 un nom ou un libell
        // Traitement selon le type d'objet  rechercher
        switch($type)
        {
                // Recherche d'un formateur
                case 'f' :

                        // Requete sur base de donnes
                        $result = get_plateforme_individus(1,'asc','false');
                        // Titre du select : "selectionnez un formateur"
                        $titre_page= $MSG_17 ;
                        $titre_select=$select[0] ;
                        $msg_warn1=$WARN_77 ;
                        $msg_warn2=$WARN_74 ;

                        // Checkbox de recherche disponibles
                        $tabCheckBox["res_info"]=$search[5];
                        $tabCheckBox["res_groupe"]=$search[4];
                        $tabCheckBox["res_calendrier"]=$search[3];

                        // Type de selection
                        $selection="dynamique" ;
                        $couleur_fond="ressourcesHumaines2" ;
                        break ;

                // Recherche d'un stagiaire
                case 's' :
                        // Requete sur base de donnes
                        $result = get_plateforme_individus(2,'asc','false');
                        // Titre du select : "selectionnez un stagiaire"
                        $titre_page= $MSG_2324 ;
                        $titre_select=$select[1] ;
                        $msg_warn1=$WARN_78;
                        $msg_warn2=$WARN_74;

                        // Checkbox de recherche disponibles
                        $tabCheckBox["res_info"]=$search[5];
                        $tabCheckBox["res_groupe"]=$search[4];
                        $tabCheckBox["res_calendrier"]=$search[3];

                        // Type de selection
                        $selection="dynamique" ;
                        $couleur_fond="ressourcesHumaines2" ;
                        break;

                // Recherche d'un organisme
                case 'o' :
                        // Requete sur base de donnes
                        $result = get_plateforme_organismes() ;
                        // Titre du select : "selectionnez un organisme"
                        $titre_page= "$MSG_71";//titre Organisme" ;
                        $titre_select=$select[2] ;
                        $msg_warn1="$WARN_117";
                        $msg_warn2="$WARN_74";

                        // Checkbox de recherche disponibles
                        $tabCheckBox["res_stagiaire"]=$search[0];
                        $tabCheckBox["res_formateur"]=$search[1];
                        //$tabCheckBox["res_groupe"]=$search[4];

                        // Deux radios sont utiliss : recherche normale ou recherche stricte (ou les formateurs et/ou stagiaires
                        $tabRadio["res_normal"] = "$MSG_1277";//Recherche simple" ;
                        $tabRadio["res_strict"] = "$MSG_2165" ;

                        // Type de selection
                        $selection="dynamique" ;
                        $couleur_fond="ressourcesHumaines2" ;
                        break;

                // Recherche d'un groupe
                case 'g' :

                        // Pas de requete ici
                        $titre_select="classe"; // < utilis dans une fonction, ne pas traduire !
                        $titre_page= "$MSG_682";//titre groupe" ;
                        $msg_warn1="$WARN_116";
                        $msg_warn2="$WARN_74";

                        // Checkbox de recherche disponibles
                        $tabCheckBox["res_info"]=$search[5];
                        $tabCheckBox["res_formateur"]=$search[1];
                        $tabCheckBox["res_stagiaire"]=$search[0];
                        $tabCheckBox["res_calendrier"]=$search[3];

                        // Deux radios sont utiliss : recherche simple ou recherche en profondeur
                        $tabRadio["res_simple"] = $search[6] ;
                        $tabRadio["res_profondeur"] = $search[7] ;

                        // Type de selection
                        $selection="classique" ;
                        $couleur_fond="ressourcesHumaines2" ;
                         $coul2="ressourcesHumaines2" ;
                        break;

                // Recherche d'une fillire
                case 'l' :
                        $titre_select="filiere" ;  // < utilis dans une fonction, ne pas traduire !
                        $titre_page= "$MSG_1519";//titre filiere" ;
                        $msg_warn1="$WARN_115";
                        $msg_warn2="$WARN_74";

                        // Checkbox de recherche disponibles
                        $tabCheckBox["res_info"]=$search[5];
                        $tabCheckBox["res_parcours"]=$search[2] ;
                        $tabCheckBox["res_calendrier"]=$search[3] ;

                        // Type de selection
                        $selection="classique" ;
                        $couleur_fond="ressourcesPedagogiques2" ;
						$coul2 = "ressourcesPedagogiques2" ;
                        break;

                // Recherche d'une formation
                case 'c' :
                        // On conserve les variables du formulaire prcdent
                        global $recherche_par, $annee1, $mois1, $jour1, $annee2, $mois2, $jour2, $dates_strict, $dates_fin, $dates_debut ;

                        // La requete sur la base dpend de la fourchette de dates et du type de recherche (stricte, etc.)
                        if($recherche_par=="date"){
                        	$date1=$annee1."-".$mois1."-".$jour1 ;
                        	$date2=$annee2."-".$mois2."-".$jour2 ;
                        	//echo "strict=$dates_strict et dates_debut=$dates_debut et dates_fin=$dates_fin <br>";
//-----------------------------------------------A VERIFIER------------------------------------------------------------------								
//                                $date1=$annee1."-".$mois1."-".$jour1 ;
//                                $date2=$annee2."-".$mois2."-".$jour2 ;
//
//
//                                $sql="SELECT *
//                                FROM calendrier, dates d1, dates d2
//                                WHERE datedeb=d1.num_date and datefin=d2.num_date " ;
//
//                                if($dates_strict)
//                                        $sql .= "AND ( ( d1.jour >= '$date1' AND d2.jour <= '$date2' ) " ;
//
//                                if($dates_debut)
//                                {
//                                        if($dates_strict)
//                                                $sql .= "OR ( d1.jour >= '$date1' AND d1.jour <= '$date2' ) " ;
//                                        else
//                                                $sql .= "AND ( ( d1.jour >= '$date1' AND d1.jour <= '$date2' ) " ;
//                                }
//
//                                if($dates_fin)
//                                {
//                                        if($dates_strict || $dates_debut)
//                                                $sql .= "OR ( d2.jour >= '$date1' AND d2.jour <= '$date2' ) " ;
//                                        else
//                                                $sql .= "AND ( ( d2.jour >= '$date1' AND d2.jour <= '$date2' ) " ;
//                                }
//                                $sql .= " ) ORDER BY lower(nom_cal)" ;

                                // On selectionne dans la BD les calendriers correspondant  la fourchette et aux options
                                /*
                                if($dates_strict)
                                	$result = get_plateforme_formations_dates($date1,$date2,1) ;
                                else
                                	if($dates_debut)
                                		$result=get_plateforme_formations_dates($date1,$date2,2);
                                	else
                                		if($dates_fin)
                                			$result=get_plateforme_formations_dates($date1,$date2,3);
                                		else
                                			$result=get_plateforme_formations();
                                */
                                if($dates_strict)
                                	$comprise=true;
                                else
                                	$comprise=false;
                                if($dates_debut)
                                	$commencant=true;
                                else
                                	$commencant=false;
                                if($dates_fin)
                                	$finissant=true;
                                else
                                	$finissant=false;
                                $result=get_plateforme_formations_dates($date1,$date2,$comprise,$commencant,$finissant);
                                			
                                		
                                		
                                
                        }
                        // On garde toutes les formations la premire fois
                        else
                                $result = get_plateforme_formations() ;

                        // echo "nb=".pg_num_rows($result)."<br>";

                        $titre_select=$select[3] ;
                        $titre_page= "$MSG_1290";//titre formation" ;
                        $msg_warn1="$WARN_118";
                        $msg_warn2="$WARN_74";

                        // Checkbox de recherche disponibles
                        $tabCheckBox["res_info"]=$search[5];
                        $tabCheckBox["res_stagiaire"]=$search[0];

                        $tabCheckBox2["dates_strict"] = "$MSG_1691 $MSG_1694";// Comprise dans l'intervalle" ;
                        $tabCheckBox2["dates_debut"] = "$MSG_1692 $MSG_1694";//Commenant dans l'intervalle" ;
                        $tabCheckBox2["dates_fin"] = "$MSG_1693 $MSG_1694";//Finissant dans l'intervalle" ;

                        // Type de selection
                        $selection="dynamique" ;
                        $couleur_fond="ressourcesPedagogiques2" ;
                        break;
                        
				//Recherche d'un Parcours
                case 'p' :
                         $result=get_plateforme_parcours();
                         $titre_page= "$MSG_727";//titre parcours";
                         $msg_warn1="$WARN_76";
                         
                         $titre_select=$MSG_810 ;
                        // echo"titre=$titre_select";
                         // Checkbox de recherche disponibles
                         $tabCheckBox["res_info"]=$search[5];
                         $tabCheckBox["res_calendrier"]=$search[3] ;
                         $tabCheckBox["res_etapes"]=$search[11];
                          // Type de selection
                        $selection="dynamique" ;
                        $couleur_fond="ressourcesPedagogiques2" ;
                        break;

                default :
                        die( "Menu Recherche Problme  : paramtre type non pris en compte > $type");
                        break;

        } // fin switch($type);

        // -- - -- - -- - -- - -- - -- - -- - -- - -- - -- - -- - -- - -- - -- - -- - -- -
        // AFFICHAGE
        // -- - -- - -- - -- - -- - -- - -- - -- - -- - -- - -- - -- - -- - -- - -- - -- -

        // Toutes les fonctions javascript  utilises pour ce menu de recherche sont dans le fichier fonctions_javascript.inc
        include ('fonctions_javascript.inc') ;
	
        // Titre de la recherche et dclaration du formulaire
        print("
        <table width=\"$largeur\" cellspacing=\"1\" cellpadding=\"10\">
        <form name=\"search\" method=\"post\" action=\"index.php\">
        <input type=\"hidden\" name=\"type\" value=\"$type\">
        <input type=\"hidden\" name=\"domaine\" value=\"$domaine\">
        <tr class=\"$couleur_fond\">
        <td align=\"center\" colspan=\"5\"><font style=\"font-size:14px\"><b>$titre_page </b></font></td>
        </tr>
        ");
        //print_rr($_SESSION);
        $langue=$s_langue;
        if($recherche_par=="date"){
            $nb=pg_num_rows($result);
            if($nb>1)
                $txt_formation=$MSG_2410;
            else
                $txt_formation=$MSG_1290;
            if($langue==1){
                $tab=explode("-",$date1);
                $date1=formater_date($tab,"french","Y");
                $tab=explode("-",$date2);
                $date2=formater_date($tab,"french","Y");
            }
            print("
            <tr class=\"$couleur_fond\">
            <td align=\"left\" colspan=\"5\">
            $MSG_1690<br>
            <b>$MSG_537</b> : $date1 <br>
            <b>$MSG_535</b> : $date2<br>(
            ");
            if($dates_strict)
                print("
                $MSG_1691&nbsp;
                ");
            if($dates_debut)
                print("
                $MSG_1692&nbsp;
                ");
            if($dates_fin)
                print("
                $MSG_1693
                ");

            print("
            $MSG_1694 )<br>
            <b> $MSG_2414 : $nb</b> $txt_formation 
            </td>
            </tr>
            ");
        }
        
        print("
        <tr class=\"$couleur_fond\">
        <td align=\"left\" colspan=\"3\" width=\"40%\" class=\"menu_recherche\">");

        // Il peut y avoir  afficher des radios. Il faut regarder dans le tableau $tabRadio

        // En cas de recherche d'une formation (=calendrier), il y a deux menus de recherche : par nom ou par date
        if($type=='c')
        {
                print("
                <div align=\"center\">
                        <input type=\"radio\" name=\"recherche_par\" value=\"saisie\" checked onClick=\"modif_menu() ;\">$search[8]&nbsp;
                        <input type=\"radio\" name=\"recherche_par\" value=\"date\" onClick=\"modif_menu() ;\">$search[9]
                </div>
                <br>

                <div id=\"par_dates\" style=\"display:none\">") ;

                // Il faut chercher la date de dbut de la premire formation et la date de fin de la dernire formation
                $resPremier= get_plateforme_formations_dates_bornes();
 
                // Anne minimale
                $anneeMin = substr(pg_result($resPremier,0,0),0,4) ;
               
                // Anne maximale
                $anneeMax = substr(pg_result($resPremier,0,1),0,4) ;
               

                // Appels  la fonction qui gnre les trois select pour choisir une date
                $tab_sel_date1= affSelectDate(1,$anneeMin, $anneeMax) ;
                $tab_sel_date2= affSelectDate(2,$anneeMin, $anneeMax) ;
				
                // Selection d'une fourchette de dates
                print("
                <table width=\"100%\" border=\"0\" cellpadding=\"5\" cellspacing=\"0\" align=\"center\">
                <tr><td colspan=\"4\" align=\"center\">$MSG_1696 :</td></tr>
                <tr>
                        <td nowrap>$MSG_537 :</td>
                        <td>".$tab_sel_date1["sel_jour"]."</td><td>".$tab_sel_date1["sel_mois"]."</td><td>".$tab_sel_date1["sel_annee"]."</td>
                </tr>
                <tr>
                        <td nowrap>$MSG_535 :</td>
                        <td>".$tab_sel_date2["sel_jour"]."</td><td>".$tab_sel_date2["sel_mois"]."</td><td>".$tab_sel_date2["sel_annee"]."</td>

                </tr></table>
                </div>
                <div id=\"par_saisie\">");
        }

        // PARTIE SELECTION
        // Il existe deux types de selection

        // La premire affiche un select dynamique accompagn d'un champ de saisie
        if($selection=="dynamique")
        {
                $nbObjet = pg_num_rows($result);

                //echo "nbObjet = $nbObjet<br>";

                // Il y a un organisme  toujours mettre : Multi-org
                if($type=='o')
                        $nbValTab = $nbObjet+1 ;
                else
                        $nbValTab = $nbObjet ;

                if($nbObjet)
                {
                        // Classe Liste javascript
                        include("js_Liste.php");

                        // Cration d'un objet Liste
                        print("<script language=\"javascript\">
                                // tab est le tableau qui contient les valeurs correspondant aux options du select
                                var tab = new Array($nbValTab");

                                print(") ;
                                var ListeF=new CreerListe(\"id\", 5, 300);
                                </script>
                        ");

                        // Javascript - Premire option : "selectionnez un..."
                        print("<script language=\"javascript\">
                        ListeF.Add(\"$titre_select\",\"\") ;\n") ;


                        if($type=='o')
                                print("ListeF.Add(\"Multi-org\",\"0\") ;\n") ;

                        // Parcours des objets et remplissage de la liste
                        for ($i=0 ; $i<$nbObjet ; $i++)
                        {
                        		
                                $rowObjet = pg_fetch_row($result,$i);
                                //print_rr($rowObjet);
                                // C'est ici qu'on comprend pourquoi dans la requte l'identifiant doit tre donn en premire position et le nom en seconde
                                // On ajoute  un liste une valeur, cl(=id BD)
                                // gestion ams
                                if(is_ams_libelle($rowObjet[1])){
                                	$tmp_objet=get_ams_libelles($rowObjet[1]);
                                	$rowObjet[1]=get_ams_libelle($tmp_objet);
                                }
                                print "ListeF.Add(\"$rowObjet[1]\",\"$rowObjet[0]\") ;\n";
                        }

                        print ("</script>
				                        <b>$MSG_2264</b><br>
				                        <input type=\"text\" size=\"33\" name=\"saisie\"><br><br>
				                        <script language=\"javascript\">
				                                ListeF.Afficher();
				                                ListeCheck();

                       				 </script>
                       	");
                }
                else
                        echo "$MSG_1031<br>" ;
        }
        // La seconde affiche un select classique (utilis pour les groupes et les filires)
        else
        {
        		//recup des filires 
        		if($titre_select=="filiere"){
				    $rescours=get_plateforme_filieres_parcours();
				    $nbcours=pg_num_rows($rescours);    
				    $name="id";
				    $onchange="";  
				    print("
								<tr  class=\"$coul2\">
								<td align=\"center\" valign=\"top\"><b>$MSG_1519 :</b><br><br>
					");  
				    include("$root/lib_graphique/selects/selectArborescenceFiliere.php");
        		}
        		elseif($titre_select=="classe")	{
        			//recup des classes
					//$resgp=get_plateforme_classes();
					$resgp=get_classe_peres_fils();
				    $nbgp=pg_num_rows($resgp);
				    $name="id";
				    $onchange="";
				    print("
								<tr  class=\"$coul2\">
								<td align=\"center\" valign=\"top\"><b>$MSG_682 :</b><br><br>
					");   
					
				    include("$root/lib_graphique/selects/selectArborescenceGroupe.php");
        		}
                //affiche_select2("id",$titre_select) ;
   
        }
         print("</select>
                		");


        // On ferme le div, si on l'a ouvert
        if($type=='c')
                print("</div>") ;

        print("
        </td>
        <td width=\"30%\" align=\"left\">");

                // Si le tableau $tabCheckBox2 a des valeurs, on utilise deux calques
                if(count($tabCheckBox2))
                {
                        // Affichage d'autres checkbox (chercher calendriers avec dates)
                        print("<div id=\"par_dates2\" style=\"display:none\">
                        <input type=\"checkbox\" name=\"tout_cocher2\" OnClick=\"cocher2();\">$MSG_1293<br>
                        <table border=0 cellspacing=0 cellpadding=0 align=right><tr><td nowrap>");
                        // Parcours du tableau $tabCheckBox pour afficher les options de recherche disponibles pour cet objet (ex : ses stagiaires, ses groupes...)
                        while($tmp=each($tabCheckBox2))
                        {
                                print("<input type=\"checkbox\" name=\"$tmp[0]\" onClick=\"if(!this.checked) document.search.tout_cocher2.checked=false;\">&nbsp;$tmp[1]<br>");
                        }
                        print("</td></tr></table>") ;

                        print("</div>
                        <div id=\"par_saisie2\">") ;
                }

                // S'il n'y a qu'un seul checkbox de recherche, on n'affiche pas le checkbox "cocher tout"
                if(count($tabCheckBox)==1)
                {
                        print("<input type=\"checkbox\" name=\"".key($tabCheckBox)."\" checked>&nbsp;".current($tabCheckBox)."</input><br>");
                }
                else
                {
                        print("
                        <input type=\"checkbox\" name=\"tout_cocher\" OnClick=\"cocher();\">$MSG_1293</input><br>
                        <table border=0 cellspacing=0 cellpadding=0 align=right><tr><td nowrap align=\"left\">");

                        // Parcours du tableau $tabCheckBox pour afficher les options de recherche disponibles pour cet objet (ex : ses stagiaires, ses groupes...)
                        while($tmp=each($tabCheckBox))
                        {
                                print("<input type=\"checkbox\" name=\"$tmp[0]\" onClick=\"if(!this.checked) document.search.tout_cocher.checked=false;\">&nbsp;$tmp[1]</input><br>");
                        }
                        print("</td></tr></table>") ;
                }

                // Fermeture du div s'il a t ouvert
                if(count($tabCheckBox2))
                        print("</div>");

                print("</td>
                <td align=\"left\" width=\"30%\" nowrap>");

                        // Il peut y avoir diffrents types de recherches (ex : recherche simple/en profondeur...)
                        // Le tableau $tabRadio contient les noms et valeurs et recherches possibles
                        if(count($tabRadio))
                        {
                                $aff_checked="checked" ;
                                while($tmp=each($tabRadio))
                                {
                                        print("<input type=\"radio\" name=\"typerech\" value=\"$tmp[0]\" $aff_checked>$tmp[1]<br>");
                                        $aff_checked="";
                                }
                        }

                        print("
                        <br>
                        <span align=\"center\">
                        <input type=\"button\" name=\"lancer_recherche\" value=\"$MSG_741\" onclick=\"verification()\">
                        </span>
                </td>
        </tr>
        </form>
        </table>");
}


/**
* Fonction qui retourne 3 lments select (jour, mois, annee) pour choisir une date
*
* Cette fonction retourne un tableau de trois chanes contenant le select du jour, le select du mois et le select de l'anne
* Les select portent respectivement le nom : "jour".$num, "mois".$num &"annee".$num
* @param integer : Numro du de l'ensemble select : determine le nom de trois select jour, mois et annee
* @param integer : Annee de la plus petite date (ex : 1999)
* @param integer : Annee de la plus grande date (ex : 2006)
* @return string[] : Tableau associatif de trois chanes. "sel_jour" => select jour, "sel_mois" => select mois & "sel_annee" => select annee
*/
function affSelectDate($num, $anneeMin, $anneeMax)
{
        $tab_sel = array() ;
global $root;
        // Select du jour
        $tab_sel["sel_jour"] = "<select name=\"jour$num\">\n" ;
        for ($j=1 ; $j<32 ; $j++)
        {
                if($j<10)
                        $val='0'.$j ;
                else
                        $val=$j ;

                if($jour1==$j)
                        $tab_sel["sel_jour"] .= "<option value=$val selected>$val</option>\n" ;
                else
                        $tab_sel["sel_jour"] .= "<option value=$val>$val</option>\n" ;
        }
        $tab_sel["sel_jour"] .=  "</select>\n" ;

        // Select du mois
        $tab_sel["sel_mois"] = "<select name=\"mois$num\">\n" ;
        for ($j=1;$j<13;$j++)
        {
                if($j<10)
                        $val='0'.$j ;
                else
                        $val=$j ;

                if($mois1==$j)
                        $tab_sel["sel_mois"] .= "<option value=$val selected>$val</option>\n" ;
                else
                        $tab_sel["sel_mois"] .= "<option value=$val>$val</option>\n" ;
        }
        $tab_sel["sel_mois"] .= "</select>" ;

        // Select de l'anne
        $tab_sel["sel_annee"] = "<select name=\"annee$num\">\n" ;
        for ($j=$anneeMin ; $j <= $anneeMax ; $j++)
        {
                if($j<10)
                        $val='0'.$j ;
                else
                        $val=$j ;

                if($annee1==$j)
                        $tab_sel["sel_annee"] .= "<option value=$val selected>$val</option>\n" ;
                else
                        $tab_sel["sel_annee"] .= "<option value=$val>$val</option>\n" ;
        }
        $tab_sel["sel_annee"] .= "</select>\n" ;

        // On retourne le tableau contenant
        return $tab_sel ;
}


/**
 * Fonction qui retourne l'affichage du tableau d'accueil
 */
 function afficheMenuAccueil(){
 		global $largeur, $domaine ;
        global $MSG_2266,$MSG_2267;
        global $root;
         if($domaine == 'h'){
                        // Titre de la page : "Accueil"
                        $titre_page= $MSG_2266 ;
                       
                        // Type de selection de couleur de fond
                        $couleur_fond="ressourcesHumaines2" ;
         }
         else{
         				// Titre de la page : "Accueil"
         				$titre_page = $MSG_2266 ;
         				
         				// Type de selection de couleur de fond
         				$couleur_fond="ressourcesPedagogiques2" ;
         }
        
	    //-----------------------------------------------------------------
	    //									AFFICHAGE								 |
	    //-----------------------------------------------------------------    
	 	print("
	        <table width=\"$largeur\" cellspacing=\"1\" cellpadding=\"10\">
	        	<tr class=\"$couleur_fond\">
	        		<td align=\"center\" colspan=\"5\"><font style=\"font-size:14px\"><b>$titre_page</b></font></td>
	       	    </tr>
	        	<tr class=\"$couleur_fond\">
	      			<td align=\"center\" colspan=\"5\">$MSG_2267</td>
	      		</tr>
	      	</table>
	    ");
 }
?>