<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
Fichier de base pour le moteur de recheche

Ce fichier appele les fonctions d'affichages dont il a besoin pour faire fonctionner le moteur de recherche.
On utilise des variables passes dans l'url :
$domaine :<dd>
        * h > ressources humaines<br>
        * p > ressources pdagogiques<br>
@package moteur de recherche
@author CHABOISSIER Jonathan
@since 25/05/2004
*
*Modifi par OUAKNINE Grgory
*/


//------------------------------------------------------------------
//          IDENTIFICATION
//------------------------------------------------------------------
//inclusions
$dbpath="../..";  //le dbpath sert  maintenir les inclusions  partir du $chemin_bo
include("$dbpath/en_tete.php"); //contient les traitements communs  l'ensemble du FrameWork Astairs
include("../en_tete_back.php"); //contient les traitements communs  l'ensemble du BackOffice Astairs
//include("./includes.php"); //inclusions des librairies du module


//------------------------------------------------------------------
//          ENTETE
//------------------------------------------------------------------
$titre=MENU_57;
$nompage="recherche_test/index.php";
$styleCSS="../style/".MY_STYLE."/global.css";
include ('../entete.php3') ;

require ($root.'/lib/object/function_err.inc') ;
require ($root.'/lib/obj_formation.php') ;
require ($root.'/lib/obj_formateur.php') ;
require ($root.'/lib/obj_stagiaire.php') ;
require($root.'/lib/lib_parcours.php');
require($root.'/lib/lib_formation.php');
require ($root.'/lib/obj_plateforme.php') ;
//require($root.'/lib/lib_individu.php');
include ('fonctions_affichage.inc') ;
include ('fonctions_aff_resultat.inc') ;
include ('fonctions_recherche.inc') ;
//include($root.'/lib/plateforme/fonctions_plateforme.inc');


//------------------------------------------------------------------
//       				TRAITEMENT ACTION 
//-------------------------------------------------------------------
$largeur="70%";
// Si le domaine n'est pas dfini, on met Ressources humaines par dfaut
if(!isset($domaine))
        $domaine = 'h' ;

affMenuHaut($domaine) ;

//si la rubrique de recherche est non dfini et si $recherche n est pas vide et si $type n'est pas vide, alors on appelle la fonction afficheMenuAccueil()
if(!isset($recherche) && empty($recherche) && empty($type))
		afficheMenuAccueil();


// res formulaireecho "Rsultats formulaire dans l'index :<br>"; while ($tab=each($_POST)) echo "$tab[0] - $tab[1] | "; echo "<br>";

// Une recherche de calendrier par dates a t effectu > on raffiche le menu de recherche avec seulement les calendriers compris dans les dates
if($recherche_par=="date")
{
        // On raffiche le menu de recherche pour la formation, mais cette fois-ci on ne garde que quelques formations
        affMenuRecherche('c') ;
}

// Recherche est une variable qui contient le type de recherche  effectuer (f>formateur, o>organisme, g>groupe...)
if(isset($recherche))
{
        affMenuRecherche($recherche) ;
}

if(isset($id) && isset($type))
{
	 $objet=PlateformeObjectFactory::createObject($type,$id);

       switch($domaine){
            case 'p' : $coul1="ressourcesPedagogiques2";
                            $coul2="ressourcesPedagogiques3";
                            break;
            case 'h' : $coul1="ressourcesHumaines2";
                            $coul2="ressourcesHumaines3";
                            break ;
            default : $coul1="ressourcesAdministratives2";
                            $coul2="ressourcesAdministratives3";
                            break;
        }
		//print_rr($objet);
		// gestion ams sur libelle
		$lib_objet=$objet->getLibelle();
		if(is_ams_libelle($lib_objet)){
			$tmp_lib=get_ams_libelles($lib_objet);
			$lib_objet=get_ams_libelle($tmp_lib);
		}
        print("
        <!--<br><a class=\"retour\" href=\"index.php?domaine=$domaine&recherche=$type\">$MSG_37</a><br>-->
        <table align=\"center\" width=\"$largeur\">
        <tr height=\"30\" valign=\"middle\" class=\"$coul1\"><td><b>".get_plateforme_object_type_libelle($type)." :</b> $lib_objet</td></tr>
        <tr height=\"30\" class=\"$coul2\"><td>&nbsp;</td></tr>
        </table>
        ");

        // Informations d'un utilisateur : $id > identifiant BD, et $type > nature de l'objet
        if(isset($res_info))
        {
                // On passe l'objet et un tableau associatif contenant les attributs de l'objet  afficher
                affSesInfos($objet) ;
        }

        // Les groupes
        if(isset($res_groupe))
        {
                affSesGroupes($objet) ;
        }

        // Les calendrier/formation
        if(isset($res_calendrier))
        {
                affSesFormations($objet) ;
        }

        // parcours
        if(isset($res_parcours))
        {
                affSesParcours($objet) ;
        }


        // etapes d'un parcours
        if(isset($res_etapes))
        {
                affSesEtapes($objet) ;
        }

        // Les formateurs
        if(isset($res_formateur))
        {
                affSesIndividus($objet,'f',$typerech) ;
                // echo "On veut les formateurs<br>";
        }

        // Les stagiaires
        if(isset($res_stagiaire))
        {
                affSesIndividus($objet,'s',$typerech) ;
        }
        
        // Les Organismes
        if(isset($res_organisme)){
        	  affSesIndividus($objet,'f',$typerech) ;
        	  affSesIndividus($objet,'s',$typerech) ;
        }
        
        // Les Classes
        if(isset($res_lienClasse)){
        	 affSesInfos($objet) ;
        	 affSesFormations($objet) ;
        	 affSesIndividus($objet,'f',$typerech) ;
        	 affSesIndividus($objet,'s',$typerech) ;
        }
        
         // Les Formations
        if(isset($res_formation)){
        	 affSesInfos($objet) ;
        	 affSesIndividus($objet,'s',$typerech) ;
        }
        
        // Les liens retour vers Filiere
        if(isset($res_lienFiliere)){
        	affSesInfos($objet) ;
        	affSesFormations($objet) ;
        	affSesParcours($objet) ;
        }
        
        // Les liens retour vers Formation
        if(isset($res_lienFormation)){
        	affSesInfos($objet) ;
        	affSesFormations($objet) ;
        	affSesEtapes($objet) ;
        }
        
       // Les liens retour vers Formateur ou Stagiaire
        if(isset($res_lienFS)){
             affSesInfos($objet) ;
             affSesFormations($objet) ;
        	 affSesGroupes($objet) ;
        }
        
        // Les liens retour vers Parcours
        if(isset($res_lienPacours)){
        	affSesInfos($objet) ;
        	affSesFormations($objet) ;
            affSesEtapes($objet) ;
        }

        print("<br><a class=\"retour\" href=\"index.php?domaine=$domaine&recherche=$type\">$MSG_37</a><br>");
}

include ('../piedpage.php3') ;
include("$dbpath/pied_page.php");
?>