<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
    Configuration d'un parcours en parcours orient.
    Un parcours orient dirige l'utilisateur vers un sous parcours en fonction du score qu'il a obtenu.
    Il doit donc disposer d'tapes donnant lieu  des notations.
    
    @param integer $parcours identifiant du parcours  configurer.

    @package parcours
*/

//---------------------------------------------------------------------
//      INITIALISATION
//---------------------------------------------------------------------
// recup des infos du parcours
$res=get_parcours($parcours);
$row=pg_fetch_row($res,0);

//recup des parcours disponibles
$res_parcours_dispos=get_parcours_etape_parcours_oriente_parcourss_disponibles($parcours);
$nbchoixmax=pg_num_rows($res_parcours_dispos);

//tableau des types evalues
$tabtype=get_etape_types_evalues();

//creation du tableau de types du parcours donnant lieu  des scores.
$res_types_etapes=get_parcours_types_etapes($parcours);
$nb_types_etapes=pg_num_rows($res_types_etapes);
for($i=0;$i<$nb_types_etapes;$i++){
	$row_types_etapes=pg_fetch_row($res_types_etapes, $i);
	//cas particulier pour les types 4_xxxxx, on ne garde que le type 4 de base
	if(substr($row_types_etapes[0],0,1)=="4"){
		if(in_array("4",$tabtype)){
			$stocktype_eval["4"]=$MSG_2225;
		}
	}
	else{
		if(in_array($row_types_etapes[0],$tabtype)){
			$stocktype_eval[$row_types_etapes[0]]=$row_types_etapes[1];
		}
	}
}
$nbeval=sizeof($stocktype_eval);
if($nbeval >=20)
    $nbchoixmax=20;
// ajout said (15/12/06) : Si pas de type donnant lieu  des scores alors pas de choix !
if($nbeval==0) 
	$nbchoixmax=0;

//echo "\$nbeval=$nbeval \$nbchoixmax=$nbchoixmax";
//---------------------------------------------------------------------
//     VALIDATION FORMULAIRE
//---------------------------------------------------------------------
if(isset($submodule)){
    //debug
    /*reset($HTTP_GET_VARS);
    $sz=sizeof($HTTP_GET_VARS);
    echo "DEBUGAGE<br>";
	for($i=0;$i<$sz;$i++){
		$a=each($HTTP_GET_VARS);
		echo "$a[0] - $a[1]<br>";
	}*/
	$libelle=addslashes($libelle);
	//chacuns des parcours
    for($i=0;$i<$nbchoix;$i++){
    	//recup des sous parcours
    	$var="module$i";
    	$ss_parcours=$$var;
    	//echo "sous parcour $i = $ss_parcours<br>";
    	$tab_params[0][]=$ss_parcours;
    	//recup des seuils
    	if($i<$nbchoix-1){
    		$var="seuiltype$i";
    		$seuil_type=$$var;
    		//seuil global
    		if($seuil_type=="seuilglobal"){
	    		$var="seuil$i";
	    		$seuil_global=$$var;
	    		echo "seuil global $i = $seuil_global<br>";
	    		$tab_params[1][]="-1";
	    		$tab_params[2][]=$seuil_global;
    		}else{
    			$j=0;
    			foreach($stocktype_eval as $id_type => $libelle_type){
    				$var="seuil$i"."_$j";
	    			$seuil_type=$$var;
	    			echo "seuil type ($id_type)$i $j = $seuil_type<br>";
	    			$tab_params[1][]=$id_type;
	    			$tab_params[2][]=$seuil_type;
	    			$j++;
    			}
    		}
    	}
    }
    if(empty($etape_parcours_oriente)){
    	//cree l'tape
    	$etape_parcours_oriente=set_parcours_oriente(set_ams_libelle($libelle),$tab_params[0],$tab_params[1],$nbeval,$tab_params[2]);
    	// ajoute l'tape en dernier position du parcours
		$res_insert=set_parcours_etape($parcours, $etape_parcours_oriente, 'NULL', 'TRUE', 'NULL', 'TRUE');
	
    }else{
    	//mise a jour de l'tape
    	maj_parcours_oriente($etape_parcours_oriente,set_ams_libelle($libelle),$tab_params[0],$tab_params[1],$nbeval,$tab_params[2]);
    }
}

//---------------------------------------------------------------------
//      INITIALISATION DES DONNES POUR MODIF
//---------------------------------------------------------------------    
if(!empty($etape_parcours_oriente)){
	//recup de l'eventuelle tape existante
	$res_config=get_etape($etape_parcours_oriente);
	$v_libelle=pg_fetch_result($res_config,0,1);
	 
	//recup de l'eventuelle configuration existante
	$res_config=get_parcours_oriente_configuration($etape_parcours_oriente);
	$nb_lignes_configurations=pg_num_rows($res_config);
	if($nb_lignes_configurations>0){
		for($i=0;$i<$nb_lignes_configurations;$i++){
			$row_configuration=pg_fetch_row($res_config, $i);
			
			//sous parcourss
			if((!is_array($configuration))||(!in_array($row_configuration[1], $configuration))){
				if(!empty($row_configuration[2]))$configuration[$row_configuration[1]][$row_configuration[2]]=$row_configuration[3];
				else $configuration[$row_configuration[1]]=$row_configuration[3];
			}	
		}
	}
	$nbchoix=count($configuration);
	$tab_ss_parcourss=array_keys($configuration);
//	echo "<pre>";
//	print_r($configuration);
//	echo "</pre>";
//	
//	echo "<pre>";
//	print_r($tab_ss_parcourss);
//	echo "</pre>";
}
//---------------------------------------------------------------------
//      AFFICHAGE
//---------------------------------------------------------------------

//cas ou il y a moins de 2 sous parcours disponibles
if($nbchoixmax<2){
	//message d'information
	print("
		<br/>
	    <table class=\"tableau_message\">
			<tr>
				<td>
					<!--$MSG_2253-->".MSG_1250." 
				</td>
			</tr>
		</table>
		<br>");
	
}
//cas ou il y a au moins 2 sous parcours disponibles 
else{
		
	//message d'information
	print("
		<br/>
	    <table class=\"tableau_message\"><tr><td><b>Les resultats obtenus par le stagiaire pour ce parcours seront compares a chacuns des seuils dans l'ordre.<br/> Le parcours parlie qu'il effectuera sera celui correspondant au seuil valide d'indice le plus grand.</b></td></tr></table><br>");
	
	//infos du parcours    
	$libelle_parcours=$row[1];
	$libelle_filiere=get_filiere_libelle_complet($row[2]);
	$niveau_filiere=get_filiere_niveau($row[2]);
	include("$root/lib_graphique/tables/infoParcours.php");
	
	print("
	<br/>
	<table class=\"tableau_espace2\">");
	
	//SAISIE DU NOMBRE DE CHOIX
	print("
	<form name=\"formchoix\">
		<tr class=\"couleur1\">
			<td><b>$MSG_280:</b></td><td colspan=\"2\">
			<!--<input type=\"text\" name=\"libelle\" value=\"$v_libelle\" size=\"40\">-->
			".get_gui_libelle_input('libelle',$v_libelle,false,60,'')."
			</td>
		</tr>
		<tr class=\"couleur1\">
			<td>
				<b>$MSG_1256<br>$MSG_1257 :</b>
			</td>
			<td align=\"center\" colspan=\"2\">
				<select name=\"nbchoix\" onchange=\"validechoix()\">
					<option value=\"\">$MSG_217</option>");
	for($c=2;$c<=$nbchoixmax;$c++){
	    if($c==$nbchoix)
	        print("
					<option value=\"$c\" selected>$c</option>");
	    else
	        print("
					<option value=\"$c\">$c</option>");
	}
	print("
				</select>
			</td>
		</tr>
		<input type=\"hidden\" name=\"parcours\" value=\"$parcours\">
		<input type=\"hidden\" name=\"nbparc\" value=\"$nbparc\">
		<input type=\"hidden\" name=\"maxpoint\" value=\"$maxpoint\">
		<input type=\"hidden\" name=\"gestcours\" value=\"$gestcours\">
		<input type=\"hidden\" name=\"v_libelle\" value=\"$v_libelle\">
		<input type=\"hidden\" name=\"etape_parcours_oriente\" value=\"$etape_parcours_oriente\">
		<input type =\"hidden\" name=\"action_parcours\" value=\"$action_parcours\">
	</form>");
	
	//ligne blanche de sparation
	print ("
		<tr class=\"#ffffff\">
			<td align=\"center\" colspan=\"3\" style=\"height:10%\">
			</td>
		</tr>");
		
	if($nbchoix!=""){
	    print("
	    <form name=\"formparc\" method=\"get\">");
	    
	    // Boucle principale pour les slections
	    for($m=0;$m<$nbchoix;$m++){
	         print("
	         <tr class=\"couleur2\">");
	
			print("
	                <td><b>parcours palie n ".($m+1)."</b>: </td>");
	        print("
			<td colspan=\"2\">
	        <select name=\"module$m\" >
	        <option value=\"NULL\">$MSG_217</option>");
	        
	        for($pa=0;$pa<$nbchoixmax;$pa++){
	            $rowpatach=pg_fetch_row($res_parcours_dispos,$pa);
	            $tmp_parc=get_ams_libelles($rowpatach[1]);
	            $rowpatach[1]=get_ams_libelle($tmp_parc,50);
	            if($rowpatach[0]==$tab_ss_parcourss[$m])
	                print("
	                <option value=\"$rowpatach[0]\" selected>$rowpatach[1]</option>");
	            else
	                print("
	                <option value=\"$rowpatach[0]\" >$rowpatach[1]</option>");
	        }
	        print("
	        </select>");
	
	        print("
	        </td></tr>");
	
	        if($m!=$nbchoix-1){
	            // selection du seuil
	            // seuil par type d'valuation (si plusieurs valuations)
	            if($nbeval>1){
	                print("
	                <tr class=\"couleur1\"><td rowspan=\"2\" style=\"font-size: 8px;\"><b>Seuil n".($m+1)."</b>:<br/>(selection du parcours palie n".($m+2)." si le score du stagiaire est strictement superieur)</td>");
	              	if(is_array($configuration[$tab_ss_parcourss[$m+1]])){
	                    print("
	                <td><input type=\"radio\" name=\"seuiltype$m\" value=\"seuiltype\" checked onChange=\"activeseuil(this,$m);\">");
	                    $disable_global="disabled";
	                    $disable_type="";
	                }else{
						print("
	                        <td><input type=\"radio\" name=\"seuiltype$m\" value=\"seuiltype\"  onChange=\"activeseuil(this,$m);\">");
	                    $disable_global="";
	                    $disable_type="disabled";
	                }
	                print("
	               $MSG_1259 $MOT_2</td>
	                <td align=\"center\">");
	                
	                $ind_type=0;
	               	foreach($stocktype_eval as $id_type => $libelle_type){
	                    // recup du seuil du type
	                    //libelle de type d'tape 
						$var='$etape_type_libelle_original='.$libelle_type.';';
						eval($var);
						//si c'est un type compos, on enleve le '-' qui est au dbut du type
						if(substr_count($id_type[$n][0],'_')>=2){
							$debut_type=strpos($etape_type_libelle_original,'-');
							$etape_type_libelle_original=substr($etape_type_libelle_original,$debut_type+1);
						}
	                    print("
	                    $etape_type_libelle_original:<select name=\"seuil$m"."_$ind_type\" $disable_type>
	                    <option value=\"-1\"> $MSG_1258</option>
	                    ");
	
	                    for($s=1;$s<21;$s++){
	                        if($s==$configuration[$tab_ss_parcourss[$m+1]][$id_type])
	                            print("
	                            <option value=\"$s\" selected>$s</option>
	                            ");
	                        else
	                            print("
	                            <option value=\"$s\">$s</option>
	                            ");
	                    }
	                    print("
	                    </select><br/>
	                    ");
	                     $ind_type++;
	                }
	                print("
	                </td></tr>
	                ");
	            }else{
					//rien, seuil global uniquement
	            }
	
	            print("
	            <tr class=\"couleur1\"><td>
	            ");
	            if($nbeval>1){
	                if(is_array($configuration[$tab_ss_parcourss[$m+1]]))
	                print("
	                <input type=\"radio\" name=\"seuiltype$m\" value=\"seuilglobal\"  onChange=\"activeseuil(this,$m);\">
	                ");
	                else
	                    print("
	                    <input type=\"radio\" name=\"seuiltype$m\" value=\"seuilglobal\" checked  onChange=\"activeseuil(this,$m);\">
	                    ");
	            }else{
	            	print("
	                        <input type=\"hidden\" name=\"seuiltype$m\" value=\"seuilglobal\">");
	            }
	            
	            print("
	            $MSG_1260 </td>
	            <td align=\"center\"><select name=\"seuil$m\" $disable_global>
	            <option value=\"-1\">$MSG_1258</option>
	            ");
	            for($s=1;$s<21;$s++){
	                 if($s==$configuration[$tab_ss_parcourss[$m+1]])
	                    print("
	                    <option value=\"$s\" selected>$s</option>
	                    ");
	                else
	                    print("
	                    <option value=\"$s\">$s</option>
	                    ");
	            }
	            print("
	            </select>");
	
	            print("
	            </td></tr>");
	        }
	    }
	    print("
	    <input type=\"hidden\" name=\"parcours\" value=\"$parcours\">
	    <input type=\"hidden\" name=\"nbparc\" value=\"$nbparc\">
	    <input type=\"hidden\" name=\"niv\" value=\"$niv\">
	    <input type=\"hidden\" name=\"nbchoix\" value=\"$nbchoix\">
	    <input type=\"hidden\" name=\"maxpoint\" value=\"$maxpoint\">
	 	<input type=\"hidden\" name=\"libelle\" value=\"$libelle\">
	    <input type=\"hidden\" name=\"nbeval\" value=\"$nbeval\">
	    <input type=\"hidden\" name=\"gestcours\" value=\"$gestcours\">
	    <input type=\"hidden\" name=\"action_parcours\" value=\"$action_parcours\">
		<input type=\"hidden\" name=\"etape_parcours_oriente\" value=\"$etape_parcours_oriente\">
	    <tr class=\"couleur3\"><td colspan=\"3\">&nbsp;</td></tr>
	    <tr class=\"couleur1\"><td colspan=\"3\" align=\"center\">
	    <input type=\"submit\" name=\"submodule\" value=\"$FORM_6\" onClick=\"return verifConfigOrientation();\">
	    </form>
	    ");
	}
print("
</td></tr></table><br>
");
	
}

if($diagnostique!=""){
print("
<br><table class=\"tableau_message\"><tr><td>$diagnostique</td></tr></table><br><br>
");
}

?>
