<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
    Cration d'un parcours et de ses tapes, ou modification des tapes existantes.
    
    @param integer $num_parcours idendifiant du parcours (pour modification des tapes uniquement)
    @package parcours
*/
//$NIVEAU_DEBUG=1;

//pour compatibilit. Utiliser $filiere pour que l'on puisse supprimer $gestcours un jour..
if(empty($filiere))$filiere=$gestcours;
	
//-------------------------------------------------------------------------------------------------
//                  					SOUMISSION FORMULAIRE
//-------------------------------------------------------------------------------------------------

// ajout d'une etape de parcours
if (isset ($subparcours)||isset ($subfinparcours)) {
	if ($action_parcours == "creation_parcours"||$action_parcours == "insertion_etape") {
		
		//debut transition
		ob_start();
		pg_query("begin");
		
		//creation du parsours
		if ($etape == 0){
				if (!$num_parcours)$num_parcours = set_parcours(set_ams_libelle($nom_parcours), $filiere);
		}

		if (!isset ($finpage))
			$finpage = "FALSE";
		
		if(!empty($etape_titre)){
			$numexo=set_etape_titre(set_ams_libelle($etape_titre));
		}
        /*
		if($numtype==2){
			$numexo=667;
		}
		*/		
//		if($numtype==8){
//			$numexo=668;
//		}	
		
		// enregistre l'tape
		$res_insert=set_parcours_etape($num_parcours, $numexo, $etape_pere, $obligation, 'NULL', $finpage, $numtype, $numtheme);
		
		//cas spcial: le test de positionnement
		//si le test est dynamique, il faut alors ajouter les sries gnres comme tape suivantes
		if($numtype=="4_3"){
			$res_test=get_test($numexo);
			if(pg_fetch_result($res_test,0,2)=='t'){
				$res_positionnements=get_test_positionnements($numexo);
				$nb_postionnements=pg_num_rows($res_positionnements);
				for($i=0;$i<$nb_postionnements;$i++){
					$row=pg_fetch_row($res_positionnements,$i);
					$res_positionnement=get_positionnement($row[1]);
					$row=pg_fetch_row($res_positionnement);
					
					// enregistre la serie gnre comme tape
					$res_insert=set_parcours_etape($num_parcours, $row[4], $etape_pere, $obligation, 'NULL', 'FALSE', $numtype, $numtheme);
					$etape++;
				}
			}
		}	
		
		//on recupere les messages d'erreur
		$message_erreur = ob_get_contents();
		//on vide les messages stockes
		ob_end_clean();
		
		//fin transition
		if(empty($message_erreur)&&$res_insert=='t'){
			pg_query("commit");
			$etape++;			
		}else{
			echo "Operation base annule:($res_insert)[$message_erreur]<br>";
			pg_query("rollback");
			$erreur=true;
		}
	}
	elseif ($action_parcours == "modification") {
		
		//debut transition
		ob_start();
		pg_query("begin");

		if (!isset ($finpage))
			$finpage = "FALSE";

		if(!empty($etape_titre)){
			$numexo=set_etape_titre(set_ams_libelle($etape_titre));
		}
			
		if(empty($numexo)){
			$numexo=$etape_id;
		}
		//mise a jour
		if($etape_id!=$numexo){
			$maj_etape=maj_parcours_etape_etape_pere($num_parcours,$etape_pere, $numexo,  $obligation, 'NULL', $finpage);
		}
		
		//on recupere les messages d'erreur
		$message_erreur = ob_get_contents();
		//on vide les messages stockes
		ob_end_clean();
		
		if(empty($message_erreur)&&$maj_etape=='t'){
			pg_query("commit");
		}else{
			//echo "Operation base annule:($res_insert)[$message_erreur]<br>";
			pg_query("rollback");
		}
	}
	//exit ();
	// fin de parcours
	if (isset ($subfinparcours)) {
		if($action_parcours == "insertion_etape"){
			header("location:$lien_source?action_parcours=detail&num_parcours=$num_parcours&gestcours=$gestcours");
			include("$dbpath/pied_page.php");
			exit ();
		}else{
			header("location:$lien_source?gestcours=$gestcours");
			include("$dbpath/pied_page.php");
			exit ();
		}
	}
}

//-------------------------------------------------------------------------------------------------
//                  						INITIALISATIONS
//-------------------------------------------------------------------------------------------------

//CHOIX FILIERE SI MANQUANT FILIERE
if(empty($filiere)){
	print ("
<table class=\"tableau_normal2\">
<form name=\"formfiliere\" method=\"post\">
	<tr class=\"couleur1\">");
	$res_filieres=get_filieres();
	$nbfilieres=pg_num_rows($res_filieres);
	print ("
		<td  align=\"left\">
			<b>$MSG_2388:</b> 
			<select name=\"filiere\" onChange=\"submit();\">");

	print ("<option value=\"\">$MSG_217</option>");
	for ($i = 0; $i < $nbfilieres; $i++) {
		$rowfiliere = pg_fetch_row($res_filieres, $i);
		$tmp_filiere=get_ams_libelles($rowfiliere[1]);
		$rowfiliere[1]=get_ams_libelle($tmp_filiere);
		print ("<option value=\"$rowfiliere[0]\">$rowfiliere[1]</option>");
	}
	print ("
			</select>
		</td>
	</tr>
</form>
</table>");
exit();
}
	
	
// pour alterner les couleurs
$ligne = 0;

//le path
$path = "../";

//recup des thems
$restheme = get_plateforme_themes();
$nbtheme = pg_num_rows($restheme);

//----------------------
//		CREATION
//----------------------
if(!$num_parcours){
	$nb_etapes=0;
	$etape_pere='NULL';	
}
else{
	$nb_etapes = get_parcours_nb_etapes($num_parcours) ;
	messageDebug("nombre d'etapes=$nb_etapes<br>");
	// recup nom de parcours
	$res = get_parcours($num_parcours);
	$row = pg_fetch_row($res, 0);
	$nom_parcours = stripslashes($row[1]);
	$filiere=$row[2];
}

//----------------------
//		MODIF
//----------------------
//if ((!empty($etape)||$etape==0)&&!empty($etape_pere)&&$action_parcours == "modification") {
if ($action_parcours == "modification") {	
	//cree un tableau avec toutes les tapes
	print ("
	<SCRIPT LANGUAGE=\"JavaScript\">");
	echo get_parcours_etapes_tableau_javascript($num_parcours);
	print ("
	</SCRIPT>");
	
	messageDebug("charge etape $etape_pere ($etape):<br>");
	//on recupere l'etape_pere
	$res_etape_curr = get_parcours_etape_fille($num_parcours, $etape_pere);
	$row_etape_curr = pg_fetch_row($res_etape_curr);
	//print_rr($row_etape_curr);
	if(empty($row_etape_curr[0])){
		die ("Erreur lors du chargement de l'etape $etape_pere<br>");
	}
	messageDebugR("Ligne etape recuperee:",$row_etape_curr);
	
	//affectations des variables pour le script
	$etape_id = $row_etape_curr[0];
	$etape_libelle = $row_etape_curr[2];
	$etape_type = $row_etape_curr[4];
	$etape_titre=$row_etape_curr[3];
	$var='$etape_type_libelle='.$row_etape_curr[10].';';
	eval($var);
	$res_theme=get_etape_themes($etape_id);
	if(pg_num_rows($res_theme)>0)$numtheme =  pg_fetch_result($res_theme, 0, 0);
	
	if($etape_type==9){
		$tmp_etap=get_ams_libelles($row_etape_curr[2]);
		$etape_libelle=get_ams_libelle($tmp_etap);
		$etape_titre=$etape_libelle;
	}
	else unset($etape_titre);
	
	
	messageDebug("$etape_id $etape_libelle $etape_type $numtheme");
}

//----------------------
//		INSERTION
//----------------------
if($action_parcours == "insertion_etape"){
	$nb_etapes++;
}

//-------------------------------------------------------------------------------------------------
//                  FONCTION PHP
//-------------------------------------------------------------------------------------------------
// javascript pour la gnration automatique des menus droulants
function print_javascript($etape) {
	global $chemin_fo, $niv, $num_parcours, $mode, $MSG_113,$NIVEAU_DEBUG,$filiere;
	global $MSG_2551,$MSG_927,$MSG_727,$MSG_926,$MSG_1689,$MSG_2225,$MSG_776,$MSG_922,$MSG_2421,$MSG_928,$MSG_516,$MSG_1473,$MSG_1741,$MSG_547,$MSG_1483,$MSG_1372,$MSG_1863, $MSG_1864,$MSG_2210, $MSG_1627,$MSG_2224,$MSG_1626,$MSG_1866, $MSG_2224,$MSG_2227, $MSG_2226,$MSG_2228;
	$start = calcul_execution();
	print ("<SCRIPT LANGUAGE=\"JavaScript\">");

	//On recupere la liste des theme (en fonction du n etape)
	$restheme = get_plateforme_themes();
	$nbtheme = pg_numrows($restheme);

	// tableaux  javascript
	print ("var tabtype = new Array();\n");
	print ("var tablibtype = new Array();\n");
	// boucle sur les theme
	for ($i = 0; $i < $nbtheme; $i++) {
		print ("tabtype[$i] = new Array();\n");
		print ("tablibtype[$i] = new Array();\n");
		$theme = pg_fetch_result($restheme, $i, 0);

		// pour compatibilit
		$parcours = $num_parcours;

		// RECUPERATION DES ETAPES DISPONIBLES
		// TODO : Pour les etapes de types fichier,ne retourner que les CONNECTEES
		// Donc pour l'instant pour les tapes de type fichier,on testera si le fichier est connect
		// Fonction provisoire : is_etape_connectee($etape)
		
		
		$res_etapes = get_parcours_etapes_disponibles_theme($num_parcours, $theme,$filiere);
		$nb_etapes_dispos = pg_num_rows($res_etapes);
		$cur_type = null;
		$j = 0;
		for ($e = 0; $e < $nb_etapes_dispos; $e++) {

			//recup de l'tape
			$row_etape = pg_fetch_row($res_etapes, $e);
			// test si etape de type fichier et fichier connecte
			if(is_etape_connectee($row_etape[0],$row_etape[2])){
				
			//print_rr($row_etape);
			$tmp_etape=get_ams_libelles($row_etape[1]);
    		$row_etape[1]=get_ams_libelle($tmp_etape,50);
			//pour chaque nouveau type
			if ($cur_type != $row_etape[3]) {
				$cur_type = $row_etape[3];
				$ind = 0;
				$var='$lib_type='.$row_etape[3].';';
				eval($var);
				print ("tabtype[$i][$j] = new Array();\n");
				//print ("tablibtype[$i][$j] = new Array('$row_etape[2]','" . addslashes($lib_type) . "')\n");
				print ("tablibtype[$i][$j] = new Array('$row_etape[2]','" . $lib_type . "')\n");
				$j++;
			}

			print ("tabtype[$i][" . ($j -1) . "][$ind]=new Array(");
			//print ("'$row_etape[0]','" . addslashes($row_etape[1]) . "');\n");
			print ("'$row_etape[0]','" .addslashes($row_etape[1]) . "');\n");
			$ind++;
			}

		}
	}
	print ("</SCRIPT>");
	messageDebug("execut en " . (calcul_execution() - $start) . " microsecondes");

}
messageDebug("affiche pour etape $etape<br>");
print_javascript($etape);

//-------------------------------------------------------------------------------------------------
//									AFFICHAGE
//-------------------------------------------------------------------------------------------------

//MESSAGE ERREUR
if ($message != "")
	print ("
	    <br>
		<table class=\"tableau_message\">
			<tr>
				<td>$message</td>
			</tr>
		</table>
		<br>");

//LIBELLE FILIERE
print ("
<table class=\"tableau_normal2\">
<form name=\"formparc\" method=\"post\" OnSubmit=\"return checkForm();\">
	<tr class=\"couleur1\">");
if(!empty($filiere)){
	$lib_filiere=get_filiere_libelle_ams_complet($filiere);
	print ("
		<td  align=\"left\">
			<!--<b>$MSG_2388:</b> " . get_filiere_libelle_complet($filiere) . " <i>(niveau $niv)</i>-->
			<b>$MSG_2388:</b> $lib_filiere <i>(niveau $niv)</i>
		</td>");
}

//NUMEROS D'ETAPE
//insertion/modification
if($action_parcours == "modification"){
	//test pour les boutons
	if($etape<=0)
		$disabled_inf="disabled=true";
	else 
		$disabled_inf="";		
	if($etape+1>=$nb_etapes)
		$disabled_sup="disabled=true";
	else $disabled_sup="";
		
	print ("
		<td align=\"right\">
			<input type=\"button\" name=\"precedent\" value=\"<<\" onClick=\"change_etape($num_parcours, $filiere, $niv, document.formparc.etape.value,document.formparc.precedent_val.value)\" $disabled_inf/>
			<input type=\"hidden\" name=\"precedent_val\" value=\"".($etape-1)."\">
			&nbsp;&nbsp;<b>$MSG_234 
			<select name=\"etape\" onChange=\"change_etape($num_parcours, $filiere, $niv, $etape,(this.value))\">");
	for($i=0;$i<$nb_etapes;$i++){
		if($i==$etape)$selected="selected";
		else $selected="";
		print("
				<option value=\"$i\" $selected>".($i+1)."</option>");
	}
	print ("			
			</select> / $nb_etapes</b>
			<input type=\"button\" name=\"suivant\" value=\">>\" onClick=\"change_etape($num_parcours, $filiere, $niv, document.formparc.etape.value,document.formparc.suivant_val.value)\" $disabled_sup/>
			<input type=\"hidden\" name=\"suivant_val\" value=\"".($etape+1)."\">
		</td>");
}
//creation
else{
	print ("
			<td>
				&nbsp;&nbsp;<b>$MSG_234 ".($etape+1)." / $nb_etapes</b>
				<input type=\"hidden\" name=\"etape\" value=\"$etape\">
			</td>");
}
print ("
	</tr>
</table><br>");

//INFORMATIONS SUR L'ETAPE (TABLEAU PRINCIPAL)
print ("<table class=\"tableau_normal2\">");

//cration du parcours (premiere entre dans le script)
if (!isset($etape)||empty($num_parcours)) {
	$etape = 0;
	//saisie du nom de parcours
	print ("<tr class=\"couleur1\">
				    	<td><b>$MSG_1026 :</b></td>
				    	<td colspan=2>".get_gui_libelle_input('nom_parcours',$nom_parcours,false, 60,'valide_select_theme();')."</td>
				    </tr>");
}
//<input type=text name=\"nom_parcours\" size=60 value=\"$nom_parcours\" onKeyUp=\"valide_select_theme();\">
//cration des tapes
else {
	// affichage du nom de parcours
	print ("<tr class=\"couleur1\">
				    	<td><b>$MSG_1026 :</b></td>
				    	<td align=center><i>".get_gui_libelle($nom_parcours,false)."</i></td>
				    	<td align=right><a class=\"action\" href=\"#\" onMouseDown=\"showParcours($num_parcours,$filiere);\">$MSG_239</a></td>
				    </tr>");
}

//SELECTION DU THEME 
print ("
		<tr class=\"couleur2\">
			<td><b> $MSG_2206 :</b></td>
			<td colspan=2>");

print ("<select name=\"numtheme\" onChange=\"charger_type()\" >");

if ($numtheme == $rowtheme[0]) {
	$selected = "selected";
}else {
	$selected = "";
}
print ("<option value=\"\" $selected>$MSG_217</option>");
for ($i = 0; $i < $nbtheme; $i++) {
	$rowtheme = pg_fetch_row($restheme, $i);
	$tmp_theme=get_ams_libelles($rowtheme[1]);
        $rowtheme[1]=get_ams_libelle($tmp_theme,50);
	if ($numtheme == $rowtheme[0]) {
		$selected = "selected";
	} else {
		$selected = "";
	}
	print ("<option value=\"$rowtheme[0]\" $selected>$rowtheme[1]</option>");
}
print ("</select>
			</td>
		</tr>");

//SELECTION DU TYPE
print ("
	<tr class=\"couleur1\">
		<td><b>$MSG_933 :</b></td>
		<td colspan=2>
			<select name=\"numtype\" onchange=\"charger_exo()\">
				<option value=\"\">$MSG_217</option>");
//if($action_parcours == "modification" ){
//	print("
//				<option value=\"$etape_type\" selected>$etape_type</option>");
//}				
print("
			</select>
		</td>
	</tr>");

//LIBELLE ETAPE
//echo "etape_titre=$etape_titre<br>";
print ("
		<tr class=\"couleur2\">
			<td><b>$MSG_2207 :</b></td>
			<td colspan=2>".get_gui_libelle_input('etape_titre',$etape_libelle,true,60,'test_bouton();')."
			</td>
		</tr>");

//SELECTION FICHIER EXO
print ("
		<tr class=\"couleur1\">
			<td><b>$MSG_125/$MSG_2061 :</b></td>
			<td colspan=2>
				<select name=\"numexo\" onChange=\"test_bouton();\">");
//if($action_parcours == "modification" ){
//	print("
//				<option value=\"$etape_id\" selected>$etape_libelle</option>");
//}else				
print("
				<option value=\"null\">$MSG_1410</option>");
print("
				</select>
			</td>
		</tr>");

// OBLIGATION
print ("
		<tr class=\"couleur2\">
			<td><b>$MSG_448 :</b></td>
			<td>
				<input type=radio name=\"obligation\" value=\"TRUE\" selected=\"selected\">$MSG_126
			</td>
			<td>
				<input type=radio name=\"obligation\" value=\"FALSE\">$MSG_127
			</td>
		</tr>");

//FIN DE PAGE
// NOTE : En commentaire pour le moment (Said/Rmi le 17/07/08)
/*
print ("
		<tr class=\"couleur1\">
			<td><b>$MSG_236 :</b></td>
			<td colspan=2>
				<input type=checkbox name=\"finpage\" value=\"TRUE\"> ($MSG_237)
			</td>
		</tr>");
*/
echo "<input type=hidden name=\"finpage\" value=\"FALSE\"> ";

//VALIDATION DU FORMULAIRE

//ligne blanche de sparation
print ("
		<tr class=\"#ffffff\">
	       		<td align=\"center\" colspan=\"4\" style=\"height:10%\">
				</td>
		</tr>");

//titre
print ("
		<tr class=\"#eeeeee\">
	       		<th align=\"center\" colspan=\"4\">$MSG_2208</th>
		</tr>");

//BOUTONS DE VALIDATIONS
if($action_parcours == "insertion_etape"){
	print ("
			<tr class=\"couleur3\">
				<td colspan=3 align=center>
					<input type=\"submit\" name=\"subfinparcours\" value=\"Enregistrer\" disabled=\"true\" onClick=\"return verifFormparc();\">
					<input type=\"button\" name=\"annuler\" value=\"Annuler\" disabled=\"false\" onClick=\"javascript:window.location='$lien_source?action_parcours=detail&num_parcours=$num_parcours&gestcours=$gestcours';\">
				</td>
			</tr>");
}else{
	if ($action_parcours == "creation_parcours") {
		$button1 = $FORM_32;
		$button2 = $FORM_35;
	}
	elseif ($action_parcours == "modification" ) {
		$button1 = $FORM_8;
		$button2 = $FORM_35;
	}
	print ("
			<tr class=\"couleur3\">
				<td colspan=3 align=center>
					<input type=\"submit\" name=\"subparcours\" value=\"$button1\" disabled=\"true\" onClick=\"return verifFormparc('');\">
					<input type=\"submit\" name=\"subfinparcours\" value=\"$button2\" disabled=\"true\">
				</td>
			</tr>");
}
//print ("	
//			<tr class=\"couleur1\">
//				<td colspan=3 align=center>
//					<input type=\"submit\" name=\"retour\" value=\"$FORM_33\" onClick=\"return verifFormparc('$lien_source?action_parcours=detail&num_parcours=$num_parcours&gestcours=$gestcours&niv=$niv');\">
//				</td>
//			</tr>");

//VARIABLES A PASSER
print ("
</table>
	<input type=hidden name=\"etape_id\" value=\"$etape_id\">
	<input type=hidden name=\"etape_libelle\" value=\"$etape_libelle\">
	<input type=hidden name=\"etape_pere\" value=\"$etape_pere\">
	<input type=hidden name=\"etape_suivante\" value=\"$etape_suivante\">
	<input type=hidden name=\"etape_type\" value=\"$etape_type\">
	<input type=hidden name=\"etape_theme\" value=\"$etape_theme\">
	<input type=hidden name=\"etape_type_libelle\" value=\"$etape_type_libelle\">	
	<input type=hidden name=\"gestcours\" value=\"$gestcours\">
	<input type=hidden name=\"filiere\" value=\"$filiere\">
	<input type=hidden name=\"niv\" value=\"$niv\">
	<input type=hidden name=\"num_parcours\" value=\"$num_parcours\">
	<input type=hidden name=\"action_parcours\" value=\"$action_parcours\">
</form>
<br>
<br>");
if($action_parcours == "insertion_etape"){
	print("
		<a class=\"retour\" href=\"$lien_source?action_parcours=detail&num_parcours=$num_parcours&gestcours=$gestcours&niv=$niv\">$MSG_37</a>");
}
if($action_parcours == "creation_parcours"){
	print("
		<a class=\"retour\" href=\"$lien_source?gestcours=$gestcours&niv=$niv\">$MSG_37</a>");
}
?>