<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
   Methode permettant d'avoir une couleur par rapport au num de la ligne
*/
function getCoulLigne($numligne){
  if(($numligne % 2)==1)return "#ffcc00";
  else return("#ffe88c");
}

//  /**
//     Methode qui retourne vrai si le navigateur est IE
//  */
//  function isIE($user){
//    return(1);
//    if(strstr($user,"Mozilla/4.0")){
//      return(1);
//    }
//    else{
//      return(0);
//    }
//  }

// fonction qui retoune un seuil sur 20  partir d'une liste de seuil (ex B12:Q13:E11)
function notesur20($liste){
    // sparation des lments de la liste (:)
    $tab=explode(":",$liste);
    // balaye du tableau et calcul
    $sz=sizeof($tab);
    $note=0;
    for($i=0;$i<$sz;$i++){
        $val=substr("$tab[$i]",1);
        $note +=$val;
    }
    $note /=$sz;
    return $note;
}
// fonction qui test la validit des seuils saisis
function test_seuil(&$tabseuil,$seuil){
    if($seuil=="")
        return false;
    // ok si 1er lment
    $sz=sizeof($tabseuil);
    if($sz==0)
        return true;
    // si seuil est une liste alors ramne la note sur 20
    if(strlen($seuil)>2)
        $seuil=notesur20($seuil);
    // recup de l'elment courant
    $val=current($tabseuil);
    // debug
    //echo "val=$val<br>";
    if(strlen($val)>2)
        $val=notesur20($val);
    // debug
    //echo "val=$val et seuil=$seuil<br>";
    if($seuil>$val)
        return true;
    else
        return false;
}

/*---------------------------------------------------------------*/
//          FONCTIONS SUR LES PARCOURS
/*---------------------------------------------------------------*/
// fonction qui test la possibilit d'ajouter une tape  un parcours en formation
// si possible retourne 1
// sinon retourne 0
//function test_ajout_etape($parcours){
//    // test si parcours attach
//    //$sql="select * from gestparcours where attach_parcours=$parcours";
//    //$res=pg_query($sql);
//    $res=get_parcours_parcours_attaches($parcours);
//    if(pg_numrows($res)>0){
//        //echo "coucou<br>";
//        return 0;
//    }
//    // test si parcours dynamique
//    //$sql="select * from config_orientation where num_parcours=$parcours";
//    //$res=pg_query($sql);
//    $res=get_parcours_config_orientation($parcours);
//    if(pg_numrows($res)>0)
//        return 0;
//    return 1;
//
//}






/*---------------------------------------------------------------------------------------------------*/
// fonction qui retourne vrai si il existe du scorm pour un theme donn
function existe_scorm($theme){
    global $chemin_fo;
    // recup du nom de rep pour le thme
    //$sql="select nom_rep from themedir where num_themedir=$theme";
    //$res=pg_query($sql);
    $res=get_theme($theme);
    $row=pg_fetch_row($res,0);
    // lieu de stockage des paquets scorm
    $scormdir=$chemin_fo."/data/exostlc/$row[2]/scorm_zip";
    $nbscorm=0;
    if ($dir = @opendir($scormdir)) {
        while($file = readdir($dir)) {
            if(substr($file,-4)==".zip"){
                $nbscorm++;
                break;
            }
        }
        closedir($dir);
    }

    if($nbscorm==0)
        return false;
    return true;
}



/*---------------------------------------------------------------------------------------------------*/
// fonction de stockage des series aleatoires monotheme disponibles pour le parcours
// remplit les tablaux
function stockage_series_aleatoires_monotheme_disponibles($parcours,$theme,&$tabmonomulti,&$tabmonoqcm,&$tabmonoblanc,&$tabmonosondage,&$tabmonoqrc,&$tabmonosrc,$valexo=0){
    // recup des n de series alatoires monotheme disponibles
    /*
    $sql="select distinct num_serie from serie_aleatoire where theme=$theme and num_serie not in
            (select num_c_q_e_d from gestparcours where g_num_parcours=$parcours and type_etape='C' and num_c_q_e_d<>$valexo) and mode=1";
    $resserie=pg_query($sql);
    */
    $resserie=get_parcours_series_aleatoires_monotheme_disponibles($parcours,$theme,$valexo);
    $nbserie=pg_numrows($resserie);
    //echo "nbserie=$nbserie<r>";
    for($i=0;$i<$nbserie;$i++){
        $rowserie=pg_fetch_row($resserie,$i);
        // recup des nb exo par type
        //$req="select nbexo_par_type from serie_aleatoire where num_serie=$rowserie[0]";
        //$res=pg_query($req);
        $res=get_serie_aleatoire_nbexo_par_type($rowserie[0]);
        $nb=pg_numrows($res);
        $liste="";
        for($j=0;$j<$nb;$j++){
            $row=pg_fetch_row($res,$j);
            $liste .=$row[0];
            if($j<$nb -1)
                $liste .=",";
        }
        //echo "liste=$liste<br>";
        $tab=explode(",",$liste);
        //print_r($tab);
        //echo "<br>";
        $sz=sizeof($tab);
        $tabtype=array();
        $tabtype[]=substr($tab[0],0,1);
        $deja_insere=0;
        for($t=1;$t<$sz;$t++){
            if(!in_array(substr($tab[$t],0,1),$tabtype)){
                $tabmonomulti[]=$rowserie[0];
                $deja_insere=1;
                break ;
            }
        }
        if(!$deja_insere)
        switch($tabtype[0]){
            case 'q' : $tabmonoqcm[]=$rowserie[0];
            break;
            case 'f' : $tabmonoblanc[]=$rowserie[0];
            break;
            case 's' : $tabmonosondage[]=$rowserie[0];
            break;
            case 'm' : $tabmonoqrc[]=$rowserie[0];
            break;
            case 'o' : $tabmonosrc[]=$rowserie[0];
            break;
        }
    }
}

/*---------------------------------------------------------------------------------------------------*/
// fonction de stockage des series aleatoires multitheme disponibles pour le parcours
// remplit les tablaux
function stockage_series_aleatoires_multitheme_disponibles($parcours,&$tabmonomulti,&$tabmonoqcm,&$tabmonoblanc,&$tabmonosondage,&$tabmonoqrc,&$tabmonosrc,$valexo=0){
    // recup des n de series alatoires monotheme disponibles
    /*
    $sql="select distinct num_serie from serie_aleatoire where num_serie not in
            (select num_c_q_e_d from gestparcours where g_num_parcours=$parcours and type_etape='C' and num_c_q_e_d<>$valexo) and mode=2";
    $resserie=pg_query($sql);
    */
    $resserie=get_parcours_series_aleatoires_multitheme_disponibles($parcours,$valexo);
    $nbserie=pg_numrows($resserie);
    //echo "nbserie=$nbserie<r>";
    for($i=0;$i<$nbserie;$i++){
        $rowserie=pg_fetch_row($resserie,$i);
        // recup des nb exo par type
        //$req="select nbexo_par_type from serie_aleatoire where num_serie=$rowserie[0]";
        //$res=pg_query($req);
        $res=get_serie_aleatoire_nbexo_par_type($rowserie[0]);
        $nb=pg_numrows($res);
        $liste="";
        for($j=0;$j<$nb;$j++){
            $row=pg_fetch_row($res,$j);
            $liste .=$row[0];
            if($j<$nb -1)
                $liste .=",";
        }
        //echo "liste=$liste<br>";
        $tab=explode(",",$liste);
        //print_r($tab);
        //echo "<br>";
        $sz=sizeof($tab);
        $tabtype=array();
        $tabtype[]=substr($tab[0],0,1);
        $deja_insere=0;
        for($t=1;$t<$sz;$t++){
            if(!in_array(substr($tab[$t],0,1),$tabtype)){
                $tabmonomulti[]=$rowserie[0];
                $deja_insere=1;
                break ;
            }
        }
        if(!$deja_insere)
        switch($tabtype[0]){
            case 'q' : $tabmonoqcm[]=$rowserie[0];
            break;
            case 'f' : $tabmonoblanc[]=$rowserie[0];
            break;
            case 's' : $tabmonosondage[]=$rowserie[0];
            break;
        }
    }
}

/**
 * Les paramtres etant passs par adresse,la fonction peut les modifier
 */
function modification_suppression($parcours,&$modif,&$supp,&$attache){
    
    // test si le parcours est une tape
    if(is_parcours_etape($parcours)){
        $modif=0;
        $supp=0; //on ne peut ni modifier ni supprimer
        $attache=1;
        return; 
    }
    
    //test si le parcours est un sous parcours de parcours dynamique
    if(is_parcours_parcours_dynamiques_sous_parcours($parcours)){
    	$modif=0; //on ne peut ni modifier ni supprimer
        $supp=0;
        return;
    } 
    // test si le parcours est en formation 
    if(is_parcours_en_formation($parcours)){
        $supp=0; //on ne peut pas supprimer
        return;
    }
}
/*
// fonction qui retourne le temps d'une valuation
// donne reue : $type et $numeval
function tempseval($type,$numeval,$type_chrono=-1){
    global $obj_liste;
    // init
    $duree=0;
    switch($type){
        case 'Q' :
            // recup du chrono questionnaire s'il existe
            $req="select chrono_qstaire from questionnaire where num_qstaire='$numeval' and chrono_qstaire > 0";
            $res=pg_exec($req);
            if(pg_numrows($res)==1){
                // recup de la valeur du chrono
                $row=pg_fetch_row($res,0);
                // debug
                //echo "chrono=$row[0]<br>";
                $req="select temps from chrono where num_chrono='$row[0]'";
                $res=pg_exec($req);
                $row=pg_fetch_row($res,0);
                $type_chrono=1;
                $duree=$row[0];
            }
            else {
                // debug
                //echo "pas de chono qstaire<br>";
                //recup de la somme des chronos par question
                $req="select * from elaborqstn where eq_num_qstaire='$numeval'";
                $res=pg_exec($req);
                $nb=pg_numrows($res);
                for($c=0;$c<$nb;$c++){
                    $row=pg_fetch_row($res,$c);
                    if($row[2]>0){
                        $req="select temps from chrono where num_chrono='$row[2]'";
                        $reschrono=pg_exec($req);
                        $rowchrono=pg_fetch_row($reschrono,0);
                        $duree +=$rowchrono[0];
                    }
                    else
                        $duree +=60; // 60 secondes par defaut
                    $type_chrono=0;
                }

            }
        break;
        case 'B' :
        case 'C' :
            // debug
            //echo "numeval=$numeval et parcours=$parcours<br>";
            // recup de la valeur du chrono si existe
            $req="select chrono from serie_exo where id='$numeval'";
            $res=pg_exec($req);
            $row=pg_fetch_row($res,0);
            // 3 cas possibles >0 =0 et <0
            if($row[0]== -1){
                $duree=0;
                $type_chrono=-1;
            }
            else
                if($row[0]>0){
                    $duree=$row[0];
                    $type_chrono=1;
                }
                else {
                    // recup de la somme des chronos ds asso_exo_serie
                    $req="select sum(chrono) from asso_exo_serie where id_serie='$numeval'";
                    $res=pg_exec($req);
                    $row=pg_fetch_row($res,0);
                    $duree=$row[0];
                    $type_chrono=0;
                }


        break;
        // Le type 'L' (liste)

        case 'L' :
                        $duree=$obj_liste->getChronoTotal();
        break;
        
    }
    return $duree;
}
*/
/*---------------------------------------------------------------------------------------------------*/
// fonction qui retourne la dure d'un parcours
// donne reue : $parcours (n de parcours)
/*------------------------------------------// NOTE : Prendre en compte les parcours attachs !!!! */
// A SUIVRE ....
/*
function dureeparcours($parcours,$duree=0){
    //init
    //$duree=0;
    $tabeval=array();
    $tabeval[]='Q';
    $tabeval[]='B';
    $tabeval[]='D';
    // balayage des tapes du parcours
    //$req="select * from gestparcours where g_num_parcours='$parcours' order by num_etape";
    //$res=pg_exec($req);
    $res=get_parcours_etapes($parcours);
    $nbetape=pg_numrows($res);
    for($e=0;$e<$nbetape;$e++){
        $temps_eval=0;
        $row=pg_fetch_row($res,$e);
        if($row[2]!='I'){
            if($row[7]!=0)
                $duree =dureeparcours($row[7],$duree);
            else {
                if(in_array("$row[2]",$tabeval)){
                    // on regarde si l'evaluation est chronomtre
                    $temps_eval=tempseval($row[2],$row[4]);
                    // debug
                    //echo "temps_eval=$temps_eval<br>";
                    if($temps_eval>0)
                        $duree +=$temps_eval;
                    else
                        $duree +=$row[11];
                }
                else
                    $duree +=$row[11];

            }
        }
    }

    return $duree;

}
*/
/*---------------------------------------------------------------*/

/*---------------------------------------------------------------*/
//          FONCTIONS DIVERSES
/*---------------------------------------------------------------*/
// fonction qui retourne des heures minute et secondes en secondes
// donne reue : $tab ($tab[0] => Heures $tab[1] => Minutes et $tab[2] => Secondes
//function hmstoseconde($tab){
//    $seconde=0;
//    $seconde +=($tab[0]*3600);
//    $seconde +=($tab[1]*60);
//    $seconde +=$tab[2];
//    return $seconde;
//}
/*
// fonction qui retourne un tableau de heure minute et seconde
// donne reue : $nbseconde
function conversion($nbseconde,$tab){
   // nb heure
   $h=floor($nbseconde/3600);
   // les minute
   $m=floor(($nbseconde - ($h*3600)) / 60);
   // les seconde
   $s=$nbseconde - ($h*3600) - ($m*60);
   $tab[]=$h;
   $tab[]=$m;
   $tab[]=$s;
    return $tab;
}
*/
function calcul_hours($temps,$at)
{
  //combien d'heures ?
  $hours = floor($temps / 3600);

  //combien de minutes ?
  $min = floor(($temps - ($hours * 3600)) / 60);
  if ($min < 10)
    $min = "0".$min;

  //combien de secondes
  $sec = $temps - ($hours * 3600) - ($min * 60);
  if ($sec < 10)
    $sec = "0".$sec;

  echo $hours."h".$min."m".$sec."s";
}

/**
 * Affiche un texte sur un nombre spcifi de colonnes 
 * Utile pour affichage dans les celules de tableau, par exemple.
 * @param string: le texte  formater
 * @param integer: le nombre de colonnes
 * @return string: le texte format
 */
function affiche_texte($texte,$nbcol){
	print("La fonction affiche_texte($texte,$nbcol) est dprcie.");
	return affiche_texte_pour_colonne($texte,$nbcol);
//    $tabtexte=array();
//    $taille=strlen($texte);
//    $t=0;
//    while($t<$taille){
//        $tabtexte[]=substr("$texte",$t,$nbcol);
//        $t +=$nbcol;
//    }
//    // affichage par paquet
//    $nb=sizeof($tabtexte);
//    for($p=0;$p<$nb;$p++)
//        print("
//        $tabtexte[$p]<br>
//        ");
}

//// fonction qui test si l'inversion des tapes est possible
//// donne reue : $parcours
//// retourne le n d'tape  partir duquel on pourra inverser sinon - 1
//function inversion_etape($parcours){
//    $inversion_etape=0;
//    // test si le parcours est un parcours attach
//    if(check_parcours_attache($parcours))
//        return -1;
//
//    // test si le parcours possde au moins un parcours attch
//    $res=get_parcours_parcours_attaches($parcours);
//    if(pg_numrows($res)>0)
//        return -1;
//
//    // test si le parcours est un sousparcours de parcours dynamique
//    $res=get_plateforme_parcours_dynamiques_sous_parcours();
//    $nb=pg_numrows($res);
//    for($i=0;$i<$nb;$i++){
//        $row=pg_fetch_row($res,$i);
//        $stock=array();
//        $stock=explode(",",$row[0]);
//        if(in_array("$parcours",$stock))
//            return -1;
//    }
//
//    // test si le parcours possde une tape de type 'L' (liste de test d'auto-positionnement)
//    $res=get_parcours_types_etape($parcours);
//    $nb=pg_numrows($res);
//    for($i=0;$i<$nb;$i++){
//        $row=pg_fetch_row($res,$i);
//        if($row[0]=='L')
//            return -1;
//    }
//
//    // test si le parcours appartient  une formation
//    /*
//    $req="select * from gestionnaire where g_num_parcours=$parcours";
//    $res=pg_query($req);
//    if(pg_numrows($res)>0){
//    */
//    if(check_parcours_formation($parcours)){
//        // recup de l'avancement max
//        /*
//        $sql="select max(avancement) from gestionparcours where gp_num_parcours=$parcours";
//        $res=pg_query($sql);
//        $row=pg_fetch_row($res,0);
//        $inversion_etape=$row[0];
//        */
//        $inversion_etape=pg_fetch_result(get_parcours_avancement_max($parcours),0,0);
//    }
//    return $inversion_etape;
//}

// fonction qui dtermine le type d'une srie aleatoire
function types_serie_aleatoire($serie){
    $tab=array();
    $res=get_serie_aleatoire_nbexo_par_type($serie);
    $nb=pg_numrows($res);
    $liste="";
    for($i=0;$i<$nb;$i++){
        $row=pg_fetch_row($res,$i);
        $liste .=$row[0];
        if($i<$nb -1)
            $liste .=",";
    }
    $tab=explode(",",$liste);
    $sz=sizeof($tab);
    $tabtype=array();
    $tabtype[]=substr($tab[0],0,1);
    for($t=1;$t<$sz -1;$t++){
        if(!in_array(substr($tab[$t],0,1),$tabtype)){
            $tabtype[]=substr($tab[$t],0,1);
            break;
        }
    }
    return $tabtype;
}
?>