<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/
     
/**
   Fichier de fonctions javascript pour le module nom_etape

   @package nom_etape
*/


/**
*   Affiche un message de confirmation
*
*   @param string: le message ? afficher
*   @return boolean : true=OK, false=cancel
*/
print ("
function Question(msg) {
    return confirm (msg);
}
");

/**
*   Positionne un select sur une option � partir de sa valeur
*
*/
print ("
function setSelectedValue(select,value) {
    for(j=0;j<select.options.length;j++){
		if(select.options[j].value==value){
			select.options[j].selected=true;
		}
		else{
			select.options[j].selected=false;
		}
	}
}
");
/**
*	Recharcher le menu a gauche
*/
print ("
function reloadMenu(){
    if(parent.frames[0].location != document.location)parent.frames[0].location.reload();
}
");

/**
    Submit pour inversion etape
    @param integer : le numero d'�tape
*/
print("
function inverseEtape(num){
    document.inversion.submit();
}
");

print ("
function valideformation(){
    document.formmodif.submit();
}
");
print ("
function valideespace(){
    document.formmodif.submit();
}
");
print ("
function validesection(){
    document.formmodif.submit();
}
");

print("
function recherche_rapide(tableau, valeur) {
  var chaine = '|' + tableau.join('|') + '|';
  if (chaine.indexOf('|'+valeur+'|') == -1) return false;
  else return true;
}
");
//----------------------------------------------------
//      PARCOURS ORIENTE
//----------------------------------------------------
print("
function activeseuil(cur_radio, num_seuil){
	nb_seuil=document.formparc.nbeval.value;

	//choix du seuil par type
	if(cur_radio.value=='seuiltype'){
		//modification des seuils par type
		for(i=0;i<nb_seuil;i++){
			var a_mofifier=eval('document.formparc.seuil'+num_seuil+'_'+i);
			a_mofifier.disabled=false;
		}

		//modification du seuil global
		var a_mofifier=eval('document.formparc.seuil'+num_seuil);
		a_mofifier.disabled=true;
	}
	//choix du seuil global
	else{
		//modification des seuils par type
		for(i=0;i<nb_seuil;i++){
			var a_mofifier=eval('document.formparc.seuil'+num_seuil+'_'+i);
			a_mofifier.disabled=true;
		}

		//modification du seuil global
		var a_mofifier=eval('document.formparc.seuil'+num_seuil);
		a_mofifier.disabled=false;
	}
}");

print("
function verifConfigOrientation(){
	//verification du libelle
	document.formparc.libelle.value=document.formchoix.libelle.value;
	if(document.formparc.libelle.value.length==0){
		alert('$ERROR_69');
		return false;
	}
	
	//verification des parcours
	var tab= new Array();
	var nb=document.formchoix.nbchoix.value;
	for(i=0;i<nb;i++){
		var tmp=eval('document.formparc.module'+(i)+'.value');
		if(tmp=='NULL'){
			alert('$WARN_111!');
			return false;
		}else{
			if(recherche_rapide(tab, tmp)){
				alert('$WARN_112!');
				return false;
			}
			tab[tab.length]=tmp;
		}	
	}

	//verification des seuils
	for(i=0;i<nb-1;i++){
		var cnt=0;
		var tmp=eval('document.formparc.seuiltype'+i+'[0].checked');
		//seuil type
		if(tmp==true){
			for(j=0;j<document.formparc.nbeval.value;j++){
				if(eval('document.formparc.seuil'+i+'_'+j+'.value')=='-1'){
					cnt++;
				}	
			}
			if(cnt==document.formparc.nbeval.value){
				alert('$WARN_113!');
				return false;
			}
		}
		//seuil global
		else{
			if(eval('document.formparc.seuil'+i+'.value')=='-1'){
				alert('$WARN_114!');
				return false;
			}
			
		}	
	}
	return true;
}");

print("
function validechoix(){
	document.formchoix.v_libelle.value=document.formchoix.libelle.value;
    document.formchoix.submit();
}
");
//----------------------------------------------------
//      CREATION D'UN PARCOURS/ AJOUT D'ETAPES
//----------------------------------------------------

/**
 * Remplissage et pr�-selection du champ de formulaire de choix de type � la valeur du type courant.
 * Le remplissage des types se fait selon le theme s�l�ctionn�, et la selection selon le type de l'�tape courante.
 * Les types sont pris dans le tableau tablibtype, et si le type de l'�tape courante n'est pas dans le tableau,
 * le type est ajout� au select.
 * Desactive les boutons de validation.
 */
print("
function init_type() {
    var etape_type=document.formparc.etape_type.value;
    var i=document.formparc.numtheme.selectedIndex-1;
   
	// on supprime toutes les options sauf la premiere
    for (var t=document.formparc.numtype.length;t>1;t--) {
        document.formparc.numtype.options[t-1]=null;
    }
    for (var t=document.formparc.numexo.length;t>1;t--) {
        document.formparc.numexo.options[t-1]=null;
    }
	var trouve=false;
    if (i>=0) {
        for (var j=0;j<tablibtype[i].length;j++) {
            document.formparc.numtype.options[j+1] = new Option();
            document.formparc.numtype.options[j+1].value=tablibtype[i][j][0];
            document.formparc.numtype.options[j+1].text=tablibtype[i][j][1];
			if(etape_type==document.formparc.numtype.options[j+1].value){
					document.formparc.numtype.options[j+1].selected=true;
					trouve=true;
			}
        }
		if(trouve!=true){
			document.formparc.numtype.options[tablibtype[i].length] = new Option();
	        document.formparc.numtype.options[tablibtype[i].length].value=document.formparc.etape_type.value;
			document.formparc.numtype.options[tablibtype[i].length].text=document.formparc.etape_type_libelle.value;
			document.formparc.numtype.options[tablibtype[i].length].selected=true;
		}
        document.formparc.numtype.options[0].text = \"$MSG_217\";
		document.formparc.numtype.options[0].value=null;
    }else{
		document.formparc.numtype.options[1]= new Option();
		document.formparc.numtype.options[1].text = document.formparc.etape_type_libelle.value;
		document.formparc.numtype.options[1].value=document.formparc.etape_type.value;
		document.formparc.numtype.options[1].selected=true;
	}

    // bouton valider
    document.formparc.subparcours.disabled=true;
    // bouton fin de parcours
    if(etape_type>1)
        document.formparc.subfinparcours.disabled=false;
    else
         document.formparc.subfinparcours.disabled=true;
}
");

/**
 * Charger les types d'�tapes disponibles apres la selection d'un theme.
 * Le remplissage des types se fait selon le theme s�l�ctionn�.
 * Les types sont pris dans le tableau tablibtype, et si le type de l'�tape courante n'est pas dans le tableau,
 * le type est ajout� au select.
 * Desactive les boutons de validation.
 */
print("
function charger_type() {
    var etape=document.formparc.etape.value;
    var i=document.formparc.numtheme.selectedIndex-1;
    
	// on supprime toutes les options sauf la premiere
    for (var t=document.formparc.numtype.length;t>1;t--) {
        document.formparc.numtype.options[t-1]=null;
    }
    for (var t=document.formparc.numexo.length;t>1;t--) {
        document.formparc.numexo.options[t-1]=null;
    }
    if (i>=0) {
		var trouve=false;
        for (var j=0;j<tablibtype[i].length;j++) {
            document.formparc.numtype.options[j+1] = new Option();
            document.formparc.numtype.options[j+1].value=tablibtype[i][j][0];
            document.formparc.numtype.options[j+1].text=tablibtype[i][j][1];
			if(document.formparc.etape_type.value==tablibtype[i][j][0]){
				trouve=true;
			}
        }
        document.formparc.numtype.options[0].text = \"$MSG_217\";
		document.formparc.numtype.options[0].value=null;

		if(document.formparc.numtheme.value==document.formparc.etape_theme.value && !trouve){
			document.formparc.numtype.options[tablibtype[i].length] = new Option();
	        document.formparc.numtype.options[tablibtype[i].length].value=document.formparc.etape_type.value;
			document.formparc.numtype.options[tablibtype[i].length].text=document.formparc.etape_type_libelle.value;
		}
		if(parseInt(etape)>=2&&document.formparc.etape_type.value=='C'){
			document.formparc.numtype.options[0].selected=true;
		}
		
    }
    // bouton valider
    if(document.formparc.subparcours)document.formparc.subparcours.disabled=true;
    // bouton fin de parcours
    if(etape>1)
        document.formparc.subfinparcours.disabled=false;
    else
         document.formparc.subfinparcours.disabled=true;
}
");

/**
 * Remplissage et pr�-selection du champ de formulaire de choix de l'�tape � la valeur de l'�tape courante.
 * Le remplissage des �tapes se fait selon le theme et le type d'�tape s�l�ctionn�, et la selection selon l'�tape courante.
 * Les �tapes sont prises dans le tableau tabtype, et si l'�tape courante n'est pas dans le tableau (ce qui est toujours le cas normalement),
 * l'�valuation est ajout�e au select.
 * Pr�selection le radio et le checkbox au valeur de l'�tape courante.
 * Active les boutons de validation si les valeurs des champs select le permettent.
 */
print("
function init_exo() {
    var i=document.formparc.numtheme.selectedIndex-1;
    var j=document.formparc.numtype.selectedIndex-1;

	setSelectedValue(document.formparc.numtheme,document.formparc.etape_theme.value);
    // on supprime toutes les options sauf la premiere
    for (var t=document.formparc.numexo.length;t>1;t--) {
        document.formparc.numexo.options[t-1]=null;
    }
    if (j>=0) {

		if(document.formparc.etape_type.value==9){
			document.formparc.numexo.disabled=true;
			document.formparc.numexo.selectedIndex=0;
			
			document.formparc.etape_titre.disabled=false;
			document.formparc.etape_titre.value=document.formparc.etape_libelle.value;
		}else{

			document.formparc.etape_titre.disabled=true;
			document.formparc.etape_titre.value=null;
			document.formparc.numexo.disabled=false;

        	document.formparc.numexo.options[0].text = \"$MSG_217\";
			document.formparc.numexo.options[0].value=null; 

			if(tabtype[i]){
			    for (var k=0;k<tabtype[i][j].length;k++) {
		            document.formparc.numexo.options[k+1] = new Option();
		            document.formparc.numexo.options[k+1].value=tabtype[i][j][k][0];
			    	document.formparc.numexo.options[k+1].text=tabtype[i][j][k][1];
				
			        if(document.formparc.numexo.options[k+1].value==document.formparc.etape_id.value){
			        	document.formparc.numexo.options[k+1].selected=true;
			        }
				}
			}
			if(document.formparc.numexo.options[document.formparc.numexo.options.length-1].value!=''){
				document.formparc.numexo.options[tabtype[i][j].length+1] = new Option();
		        document.formparc.numexo.options[tabtype[i][j].length+1].value=document.formparc.etape_id.value;
				document.formparc.numexo.options[tabtype[i][j].length+1].text=document.formparc.etape_libelle.value;
				document.formparc.numexo.options[tabtype[i][j].length+1].selected=true;
			}else{
				document.formparc.numexo.options[document.formparc.numexo.options.length-1] = new Option();
		        document.formparc.numexo.options[document.formparc.numexo.options.length-1].value=document.formparc.etape_id.value;
				document.formparc.numexo.options[document.formparc.numexo.options.length-1].text=document.formparc.etape_libelle.value;
				document.formparc.numexo.options[document.formparc.numexo.options.length-1].selected=true;
			}
		}
    }
    else {
        document.formparc.numexo.options[0].text = \"choix type\";
    }
	//obligation et finpage
	if(tab_etapes_parcours[document.formparc.etape.value][7]=='t'){
		document.formparc.obligation[1].checked=false;
		document.formparc.obligation[0].checked=true;
	}else{
		document.formparc.obligation[0].checked=false;
		document.formparc.obligation[1].checked=true;
	}
	if(tab_etapes_parcours[document.formparc.etape.value][9]=='t')document.formparc.finpage.checked=true;
	else document.formparc.finpage.checked=false;	

    //recupere le type selectionn�
    var typ=document.formparc.numtype.value;

	//choix exo et libelle etape
	if(typ=='2' || typ=='8' || typ=='9' )//|| typ=='R'
        document.formparc.numexo.disabled=true;
    else
        document.formparc.numexo.disabled=false;

    if(typ!='9'){
        document.formparc.etape_titre.disabled=true;
		document.formparc.etape_titre.value=null;
	}
    else
        document.formparc.etape_titre.disabled=false;

	//etape non modifiable
	if(tab_etapes_parcours[document.formparc.etape.value][12]=='f'){
		document.formparc.numtheme.disabled=true;
		document.formparc.numtype.disabled=true;
		document.formparc.numexo.disabled=true;
 		document.formparc.etape_titre.disabled=true;
	}else{
		document.formparc.numtheme.disabled=false;
		document.formparc.numtype.disabled=false;
		if(typ!='9'){
	        document.formparc.etape_titre.disabled=true;
			document.formparc.etape_titre.value=null;
			document.formparc.numexo.disabled=false;
		}
	    else{
	        document.formparc.etape_titre.disabled=false;
			document.formparc.numexo.disabled=true;
		}
	}
	if(document.formparc.numtheme)
    // gestion bouton valider
    if(document.formparc.numtheme.selectedIndex>0){

            document.formparc.subparcours.disabled=true;
    }
    else
        document.formparc.subparcours.disabled=true;

}");

/**
 * Charger les �tapes disponibles apres la selection d'un type d'�tape.
 * Le remplissage des �tapes se fait selon le theme et le type d'�tape s�l�ctionn�.
 * Les �tapes sont prises dans le tableau tabtype, et si l'�tape courante n'est pas dans le tableau (ce qui est toujours le cas normalement),
 * l'�valuation est ajout�e au select.
 * Pr�selection pour la selection/saisie de l'�tape, du radio et du checkbox aux valeur de l'�tape courante.
 * Active les boutons de validation si les valeurs des champs select le permettent.
 */
print("
function charger_exo() {
//alert('charger');
    var i=document.formparc.numtheme.selectedIndex-1;
    var j=document.formparc.numtype.selectedIndex-1;

    //recupere le type selectionn�
    var typ=document.formparc.numtype.value;

    // on supprime toutes les options sauf la premiere
    for (var t=document.formparc.numexo.length;t>1;t--) {
        document.formparc.numexo.options[t-1]=null;
    }
	document.formparc.numexo.options[0].text = \"$MSG_217\";
	document.formparc.numexo.options[0].value = null;
	
    if (j>=0) {
		var trouve = false;
		if(tabtype[i][j][0][0]!=''){
	        for (var k=0;k<tabtype[i][j].length;k++) {
	            document.formparc.numexo.options[k+1] = new Option();
	            document.formparc.numexo.options[k+1].value=tabtype[i][j][k][0];
				document.formparc.numexo.options[k+1].text=tabtype[i][j][k][1];
				
	        }
		}
		if(typ==document.formparc.etape_type.value){
			document.formparc.numexo.options[document.formparc.numexo.options.length] = new Option();
			document.formparc.numexo.options[document.formparc.numexo.options.length-1].value=document.formparc.etape_id.value;
			document.formparc.numexo.options[document.formparc.numexo.options.length-1].text=document.formparc.etape_libelle.value;
		}
    }

    //recupere le type selectionn�
    var typ=document.formparc.numtype.value;

	//choix exo et libelle etape
	//if(typ=='2' || typ=='8' || typ=='9' )//|| typ=='R'
	if(typ=='9' )//|| typ=='R'
        document.formparc.numexo.disabled=true;
    else
        document.formparc.numexo.disabled=false;

    if(typ!='9'){
        document.formparc.etape_titre.disabled=true;
		document.formparc.etape_titre.value=null;
	}
    else
        document.formparc.etape_titre.disabled=false;

    // gestion bouton valider
    if(document.formparc.numtheme.selectedIndex>0){

		if(document.formparc.subparcours){
	        // note : les type I et S sont l� pour le debug.
	        //if(typ=='2' || typ=='8'  )
			/*
			if(typ=='8'  )
	            document.formparc.subparcours.disabled=false;
	        else
			*/
	            document.formparc.subparcours.disabled=true;
		}
		
		if(document.formparc.subfinparcours){
	        // note : les type I et S sont l� pour le debug.
	        //if(typ=='2' || typ=='8'  )
			/*
			if(typ=='8'  )
	            document.formparc.subfinparcours.disabled=false;
	        else
			*/
	            document.formparc.subfinparcours.disabled=true;
		}

        // les radio et etape titre
        if(typ=='9')
        {
            document.formparc.obligation[1].disabled=false;
            document.formparc.obligation[1].checked=true;
            document.formparc.obligation[0].disabled=true;
        }
        else
        {
            document.formparc.obligation[0].checked=true;
            document.formparc.obligation[0].disabled=false;
        }
    }
    else{
        if(document.formparc.subparcours)document.formparc.subparcours.disabled=true;
		if(document.formparc.subfinparcours)document.formparc.subfinparcours.disabled=true;
	}

}");

/**
 * Fonction pour le bouton valider
 * Fonction appel�e sur la selection d'un exo et par l'ecriture dans le champ etape_titre
 * et active les boutons de validation selon les selections des champs du formulaire.
 */
print("
function test_bouton(){

    var them=document.formparc.numtheme.value;
    var typ=document.formparc.numtype.value;
    var exo=document.formparc.numexo.options[document.formparc.numexo.selectedIndex].value;

    // sur le select exo
    if(document.formparc.subparcours){
		if(exo !='null')
	        document.formparc.subparcours.disabled=false;
	    else
	        document.formparc.subparcours.disabled=true;
	}
 	if(document.formparc.subfinparcours){
		if(exo !='null')
	        document.formparc.subfinparcours.disabled=false;
	    else
	        document.formparc.subfinparcours.disabled=true;		
	}

    // cas de l'etape titre
	if(typ=='9'){
		txt=document.formparc['etape_titre'].value;
		//alert(txt+' '+txt.length);
		if(txt.length>0) {
			if(document.formparc.subparcours)document.formparc.subparcours.disabled=false;
			if(document.formparc.subfinparcours)document.formparc.subfinparcours.disabled=false;
		}
		else {
			if(document.formparc.subparcours)document.formparc.subparcours.disabled=true;
			if(document.formparc.subfinparcours)document.formparc.subfinparcours.disabled=true;
		}
	}

}");

print("
function showParcours(parcours,filiere){
    window.open('showParcours.php?parcours='+parcours+'&filiere='+filiere,'$MSG_239','height=400,width=400,resizable=no,scrollbars=yes');
}");

/**
 * 
 * 
 */
print("
function infosParcours(parcours){
    window.open('infosParcours.php?parcours='+parcours,'$MSG_239','height=400,width=400,resizable=no,scrollbars=yes');
}");

print("
function valide_select_theme(){
    //alert(\"cc\");
    document.formparc.numtheme.disabled=false;
}");

print("
function fill(s) {
    window.alert(\"$WARN_9\" + s + \"'.\");
    return false;
}");

print("
function checkForm() {
    var typ=document.formparc.numtype.value;
    f=document.formparc.etape_titre.value;
    if(f==\"\" && typ=='I')
        return fill(\"etape titre\");
    return true;
}
");

/**
 * Fonction de chargement d'une �tape courante pour l'insertion d'une �tape.
 * D�sactive les boutons de validation.
 */
print("
function insertion_loading(){
	document.formparc.subfinparcours.disabled=true;
	document.formparc.annuler.disabled=false;	
}");

/**
 * Fonction de chargement d'une �tape courante pour la cr�ation.
 * Initialise le type de l'�tape courante, traite le cas de l'�tape titre et active les boutons de validation.
 */
print("
function creation_loading(){
    if(document.formparc.etape_titre.value.length>0){
    	document.formparc.numtheme.disabled=false;
		document.formparc.numtype.selectedIndex=1;
    }
	charger_type();
	if(document.formparc.numtype.selectedIndex==1){
    	document.formparc.numexo.disabled=true;
    }
	test_bouton();
}");

/**
 * Fonction de chargement d'une �tape courante pour la modification.
 * Initialise le type et l'�tape courante, active les elements de formulaire, les boutons de validation et les boutons suivant et pr�c�dent.
 */
print("
function modification_loading(){
	init_type();
	init_exo();

	document.formparc.obligation[0].disabled=false;
	document.formparc.obligation[1].disabled=false;
	test_bouton();

	//boutons suivant et precedent
	document.formparc.precedent_val.value=(parseInt(document.formparc.etape.value)-1);
	if((parseInt(document.formparc.etape.value)-1)>=0)document.formparc.precedent.disabled=false;
	else document.formparc.precedent.disabled=true;
	document.formparc.suivant_val.value=(parseInt(document.formparc.etape.value)+1);
	if((parseInt(document.formparc.etape.value)+1)<tab_etapes_parcours.length)document.formparc.suivant.disabled=false;
	else document.formparc.suivant.disabled=true;
}");

/**
 * Change l'�tape en cours.
 * Affecte les nouvelles valeurs du formulaire,
 * charge la nouvelle �tape, et active/d�sactive les boutons suivant et pr�c�dent.
 * @param integer : identifiant du parcours
 * @param integer : identifiant de la filiere
 * @param integer : niveau de la filiere
 * @param integer : indice de l'�tape en cours
 * @param integer : indice de la nouvelle �tape
 */
print("
function change_etape(parcours, filiere, niveau, num_etape, goto_num_etape){
	
	//definition de l'etape pere
	var etape_pere;
	if(tab_etapes_parcours[goto_num_etape-1]){
		etape_pere=tab_etapes_parcours[goto_num_etape-1][0];
	}else{
		etape_pere='NULL';
	}
	document.formparc.etape_pere.value= etape_pere;

	//autres variables
	document.formparc.etape.selectedIndex= goto_num_etape;
	document.formparc.etape_libelle.value = tab_etapes_parcours[goto_num_etape][2];
	document.formparc.etape_type.value = tab_etapes_parcours[goto_num_etape][4];
	document.formparc.etape_type_libelle.value = tab_etapes_parcours[goto_num_etape][10];
	document.formparc.etape_theme.value=tab_etapes_parcours[goto_num_etape][11];

	setSelectedValue(document.formparc.numtheme,tab_etapes_parcours[goto_num_etape][11]); 
	//chargement
	modification_loading();
//	if(tab_etapes_parcours[goto_num_etape][7]=='t'){
//		document.formparc.obligation[1].checked=false;
//		document.formparc.obligation[0].checked=true;
//	}else{
//		document.formparc.obligation[0].checked=false;
//		document.formparc.obligation[1].checked=true;
//	}
//	if(tab_etapes_parcours[goto_num_etape][9]=='t')document.formparc.finpage.checked=true;
//	else document.formparc.finpage.checked=false;	
	
	//boutons suivant et precedent
	document.formparc.precedent_val.value=(parseInt(goto_num_etape)-1);
	if((parseInt(goto_num_etape)-1)>=0)document.formparc.precedent.disabled=false;
	else document.formparc.precedent.disabled=true;
	document.formparc.suivant_val.value=(parseInt(goto_num_etape)+1);
	if((parseInt(goto_num_etape)+1)<tab_etapes_parcours.length)document.formparc.suivant.disabled=false;
	else document.formparc.suivant.disabled=true;
}");

print("
function verifFormparc( url_redirection) {
	var f=document.formparc;
	var erreurs='';
	if(f.etape==0){
		if(f.nom_parcours.lenght==0){
			erreurs+='Libelle incorrect\\n';
		}
	}
	if(f.numtheme.selectedIndex==0){
		erreurs+='Theme incorrect\\n';
	}
	if(f.numtype.selectedIndex==0){
		erreurs+='Type d\'etape incorrect\\n';
	}
	if(f.numexo.selectedIndex==0&&f.numtype.value!='9'){
	//if(f.numexo.selectedIndex==0&&f.numtype.value!='2'&&f.numtype.value!='8'){
		erreurs+='Etape ou libelle incorrect\\n';
	}
					
	if(erreurs!=''){
		alert(erreurs);
		return false;
	}
	else{
		
		if(url_redirection!=''){
			window.location=url_redirection;
		}
		return true;
	}
}
");

/**
 * Remplissage du formulaire pour le d�placement d'une �tape dans un parcours.
 * Affecte les valeurs de l'�tape de destination (identifiant, type et indice)
 */
print("
function deplaceEtape(sel, form){

	var ind=sel.options[sel.selectedIndex].text;
	var ind2=ind;
	var ind3=0;
	
	// formulaire en plus (langue ams et administation des droits
	if(document.forms[0].name=='ams_langues_form'){
		//alert(document.forms[0].name);
		ind2++;
		ind3++;
	}
	if(document.forms[1].name=='administration_droits'){
		//alert(document.forms[1].name);
		ind2++;
		ind3++;
	}
	if((!isNaN(ind)||ind<0)){
		
		//form.etape_dest.value=document.forms[ind-1].etape_id.value;
		//form.type_dest.value=document.forms[ind-1].etape_type.value;

		form.etape_dest.value=document.forms[ind2-1].etape_id.value;
		form.type_dest.value=document.forms[ind2-1].etape_type.value;
		
		form.indice_dest.value=ind2-ind3;
	}
	else{
		alert('L\'indice de l\'evaluation est incorrect');
		sel.selectedIndex=0;
		form.type_dest.value=null;
		form.etape_dest.value=null;
	}
}")
?>