<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
    Affiche de la liste des parcours.
    
    Si un numero de fili�re est re�u par le script, affiche les parcours de la fili�re
    et propose les actions de d�tail, modification des �tapes, suppression et copie pour chacun d'entre eux si possible, ou
    encore la cr�ation d'un nouveau parcours pour la filiere s�l�ctionn�e.
   	Sans num�ro de filire, affiche la page d'explication de la gestion des parcours et un lien pour lister tous les parcours,
   	toutes filieres confondues.

	@param integer $gestcours: num�ro de la filiere des parcours � afficher (facultatif)
	
    @package parcours
*/
$perm->check('LST');
//-----------------------------------------------------------------------------------------------------------------
//      									UNE FILIERE EST SELECTIONNE
//-----------------------------------------------------------------------------------------------------------------

//--------------------------------------------------------
//          INITIALISATION
//--------------------------------------------------------

//recup des parcours de la filiere
if(!empty($gestcours)){
	//recup du nom complet de la filiere
	$nomcours=get_filiere_libelle_ams_complet($gestcours);
	//echo "nomcours=$nomcours<br>";
	//recup du niveau en fonction de la longueur du nom
	$tabnomcour=explode("/",$nomcours);
	//print_rr($tabnomcour);
	$niv=sizeof($tabnomcour);
	$niv=get_filiere_niveau($gestcours);
	$obj_filiere=new Filiere($gestcours);
	//recup des parcours
	$respar=$obj_filiere->getParcours();
	$nbpar=pg_num_rows($respar);
}
//recup de tous les parcours
else{
	// recup des parcours
	$respar=get_plateforme_parcours();
	$nbpar=pg_num_rows($respar);
}
//--------------------------------------------------------
//          			AFFICHAGE
//--------------------------------------------------------
print("
<table class=\"tableau_message\">
	<tr>
		<td>$MSG_488 : $nbpar</td>
	</tr>
</table>
<br><br>");

if(!empty($gestcours)){
	//libelle de la filiere
	print("
	<table class=\"tableau_normal2\">
	<tr class=\"couleur1\">
		<td><b>$MSG_2388:</b> ".get_gui_libelle($nomcours ,false)."<i>(niveau $niv)</i></td>
	</tr>
	</table><br>");
	$affiche_colonne_filiere=false;
}else{
	$affiche_colonne_filiere=true;
}


//affichage de l'entete du tableau
print("
    <table class=\"tableau_normal2\">
    <tr>");
if($affiche_colonne_filiere){
	print("
	<th>$MSG_2388</th>");
}    
print("
    <th>$MSG_1026</th>
    <th>$MSG_2410</th>
	<th>$MSG_2459</th>
	<th>$MSG_282</th>
    <th colspan=\"2\">$FORM_1</th>
    </tr>
");

//on boucle sur les parcours
for($x=0;$x<$nbpar;$x++){
    $rowpar=pg_fetch_row($respar,$x);
    
	// recup des formations dont le parcours est principal
	$res_ses_formation=get_parcours_formations($rowpar[0]);
	$tab_ses_formations=get_parcours_ses_formations($rowpar[0]);

	//test des actions possible sur le parcours
	$actions=get_parcours_actions($rowpar[0]); 
	
	//le parcours est-il dynamique?
	$dyn=is_parcours_dynamique($rowpar[0]);
	
    //couleurs des lignes
    $classcolor=($x%2==0||$x==0?"couleur1":"couleur2");
	if($dyn)$classcolor="couleur3";
	
    print("
    <tr class=\"$classcolor\">");
    
    //affichage filiere si besoin
    if($affiche_colonne_filiere){
    	//$gestcours=$rowpar[2];
    	//recup du nom complet de la filiere
		$nomcours=get_filiere_libelle_ams_complet($rowpar[2]);
		//recup du niveau en fonction de la longueur du nom
		$tabnomcour=explode("/",$nomcours);
		$niv=sizeof($tabnomcour);
    	print("<td>$nomcours </td>");
    }
    // affichage du nom du parcours
    print("
		<td><b>".get_gui_libelle($rowpar[1],false)."</b></td>");
	
	//affichage des formations qui utilisent ce parcours		
	print("
		<td align=\"center\">");
    $tabform=get_parcours_alls_formations($rowpar[0]);
    $sz=count($tabform);
    //affichage des formations qui utilisent le parcours
    if($sz>0){
        print("<a class=\"action\" href=\"#\" onMouseDown=\"infosParcours($rowpar[0]);\">$MSG_286</a>");
    }
    else{
    	print(MSG_287);
    }
	print("</td>");
	
	//affichage des relations du parcours
	print("<td align=\"center\">");
	if(is_parcours_etape($rowpar[0])){
	 	//print("$MSG_286");
	 	print("<a class=\"action\" href=\"#\" onMouseDown=\"infosParcours($rowpar[0]);\">$MSG_286</a>");
	}else{
    	print(MSG_287);
	}
	print("</td>");
	
	print("<td align=\"center\">");
	if(is_parcours_sous_parcours_parcourss_orientes($rowpar[0])){
	 	//print("$MSG_286");
	 	print("<a class=\"action\" href=\"#\" onMouseDown=\"infosParcours($rowpar[0]);\">$MSG_286</a>");
	}else{
    	print(MSG_287);
	}
	print("</td>");

	//DETAIL ET COPIE
    print("
        <td align=\"center\">");
        if($perm->have_perm('GEST')){
			 print("	<a class=\"action\" href=\"$lien_source?action_parcours=detail&num_parcours=$rowpar[0]&gestcours=$gestcours&niv=$niv\">
		     $FORM_3</a><br>");
        }
        //TODO LA copie de parcours est a impl�menter
        if($perm->have_perm('COPY')){
			print("    <a class=\"action\" href=\"$lien_source?action_parcours=copie&num_parcours=$rowpar[0]&gestcours=$gestcours&niv=$niv\">
		    $FORM_21</a>");
        }
     print("    </td>
    ");

    print("
    <td align=\"center\">
    ");

	//MODIFIER
	if($perm->have_perm('GEST')){
    if($actions==1 || $actions==2){ //modification ok
        print("
        <a class=\"action\" href=\"$lien_source?action_parcours=modification&num_parcours=$rowpar[0]&gestcours=$gestcours&etape=0&etape_pere=NULL&niv=$niv\">
        $MSG_2232</a><br>");
    }
    else
        print("
        &nbsp;<br>");
	}
	 if($perm->have_perm('DEL')){
		//SUPPRIMER
	    if($actions==2) //suppression ok
	        print("
			<a class=\"action\" href=\"$lien_source?action_parcours=suppression&id=$rowpar[0]&gestcours=$gestcours\" OnClick=\"return(Question('$WARN_2'))\">
        	$MSG_687</a>");
        else
            print("
			&nbsp;");
	 }
            
    print("
    	</td>
	</tr>");

}
//si pas de parcours
if($nbpar==0){
	print("
    <tr class=\"couleur2\">
    	<td colspan=\"5\">$MSG_2198.<td>
	</tr>");
}

//--------------------------------------------------------
//          FIN DE BOUCLE SUR LES PARCOURS
//--------------------------------------------------------

//alternance des couleurs pour les lignes
$classcolor=($classcolor=="couleur1"?"couleur2":"couleur1");

//CREATION D'UN NOUVEAU PARCOURS
$colspan=6;
if($affiche_colonne_filiere)$colspan++;
print("
	<tr class=\"$classcolor\">
		<td align=\"center\" colspan=\"$colspan\">
			<!-- nouvelle cr�ation-->
			<form name=\"formcreparcours\">
				<input type=\"hidden\" name=\"niv\" value=\"$niv\">
				<input type=\"hidden\" name=\"gestcours\" value=\"$gestcours\">
				<input type=\"hidden\" name=\"filiere\" value=\"$gestcours\">
			    <input type=\"hidden\" name=\"etape\" value=\"0\">
			    <input type=\"hidden\" name=\"action_parcours\" value=\"creation_parcours\">");
			    if($perm->have_perm('ADD')){
			    	print("<input type=\"submit\" name=\"subcreparcours\" value=\"$MSG_159\">");
			    }
			print("</form>
		</td>
	</tr>
	</table>
   <br>");
print("
<br><a class=\"retour\" href=\"$lien_source?affiche_message_intro=true;\">$MSG_37</a>");   
?>