<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/


/**
    Aperu des tapes d'un parcours
    @param integer $parcours : identifiant du parcours.
    @param integer $filiere : filiere du parcours.
    
    @package parcours
*/

//-------------------------------------------------------------------------------------------------
//                  						INITIALISATIONS
//-------------------------------------------------------------------------------------------------
$dbpath="../..";
//require ($dbpath.'/dbpostgres.php');
//connecteDB();
include("$dbpath/en_tete.php");
include("../en_tete_back.php");

$perm->check('GEST,LST');
require ("$root/lib/lib_parcours.php");

$styleCSS = "../style/" . MY_STYLE . "/ressourcesPedagogiques.css";
$titre = "";
$nompage = "etape_precedente.php";

// nom du parcours
$res = get_parcours($parcours);
$row = pg_fetch_row($res, 0);
$nom_parcours = $row[1];

// recup des etapes du parcours en cours de cration
$resparc = get_parcours_etapes($parcours);
$nb = pg_numrows($resparc);

//-------------------------------------------------------------------------------------------------
//                  						AFFICHAGE
//-------------------------------------------------------------------------------------------------
include ('../entete_fenetre.php');
print ("
<br>
<center>");
print ("
<table class=\"tableau_normal\">
	<tr class=\"couleur1\">
		<td><b>$MSG_2388: </b>" . get_gui_libelle(get_filiere_libelle_complet($filiere)) . "<br><b>$MSG_732: </b> ".get_gui_libelle($nom_parcours)." </td>
	</tr>
</table>");
print ("
<br>
<table class=\"tableau_espace\">
	<tr>
		<th>$MSG_1033</th>
		<th>$MSG_608</th>
		<th>$MSG_125 / $MSG_113 / $MSG_2282</th>
		<th>$MSG_518</th>
		<th>$MSG_517</th>
	</tr>");

for ($i = 0; $i < $nb; $i++) {
	$row = pg_fetch_row($resparc, $i);
	$classcolor = ($i % 2 == 0 || $i == 0 ? "couleur1" : "couleur2");

	print ("
	<tr class=\"$classcolor\">
		<td>" . ($i +1) . "</td>");

	//etape fin de page?
	if ($row[9] == 't') {
		$finpage = $MSG_286;
	} else {
		$finpage = $MSG_287;
	}

	//obligation
	if ($row[7] == 't')
		$obligation = $MSG_286;
	else
		$obligation = $MSG_287;

	$var='$lib_type='.$row[10].';';
	eval($var);
	print ("
		<td>" . $lib_type . "</td>
		<td>".get_gui_libelle($row[2])."</td> 
		<td>$finpage</td>
		<td>$obligation</td> 
	</tr>");
}

print ("
</table>
<br>
<a class=\"action\" href=\"#\" Onclick=\"window.close()\">$MSG_956</a>
</center>");
print ("
</BODY>
</HTML>
");
include("$dbpath/pied_page.php");
?>

		
