<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/
             
/**
    Affiche les parcours de la filire slctionne et leur dure.
    
    @param integer $gestcour : numro de la filire selectionne
    
    @package parcours_etapes_durees
*/
$perm->check('CONF');
//-------------------------------------------------------
//				INITIALISATION
//-------------------------------------------------------
//recup des parcours
$respar=get_filiere_parcourss($gestcours);  
$nbpar=pg_num_rows($respar);

//--------------------------------------------------------
//          AFFICHAGE
//--------------------------------------------------------

//barre titre
print ("
<br/>
<table class=\"tableau_normal2\">
<tr class=\"couleur1\">
	<td><b>$MSG_2388: </b>".get_filiere_libelle_ams_complet($gestcours)."  ( <b>$MSG_59:</b> ".get_filiere_niveau($gestcours).")</td>
</tr>
</table><br>");

//titre colonnes
print("
<table class=\"tableau_espace2\">
<tr>
    <th>$MSG_1026</th>
    <th>$MSG_635</th>
    <th>$MSG_1241</th>
    <th>$FORM_1</th>
</tr>
");

//BOUCLE SUR LES PARCOURS
for($x=0;$x<$nbpar;$x++){
    $rowpar=pg_fetch_row($respar,$x);
    $tmp_parcours=get_ams_libelles($rowpar[1]);
    $rowpar[1]=get_ams_libelle($tmp_parcours,50);
    $classcolor=($x%2==0||$x==0?"couleur1":"couleur2");

    print("<tr class=\"$classcolor\">
        <td><font color=\"#0000ff\">$rowpar[1]</font></td>
        <td>
            ");
    // recup des formation qui utilisent ce parcours
    $en_formation=0;
    $tabform=array();
    $tabform=get_parcours_all_formations($rowpar[0],&$tabform);
    $sz=sizeof($tabform);
    if($sz>0){
        $en_formation=1;
        // recup et affichage des formations
        for($f=0;$f<$sz;$f++){
            print("
            ".$tabform[$f][1]."<br>");
        }
        print("
        </td>
        ");
    }
    else {
        print("
        &nbsp;</td>");
    }
    // dure du parcours
    $duree_parcours=get_parcours_duree_totale($rowpar[0]);
    //echo "dur_parc=$duree_parcours<br>";
    $tab=get_hms($duree_parcours);
    $heure=$tab["heure"];
    $min=$tab["minute"];
    $sec=$tab["seconde"];
    if($min<10)
        $min="0".$min;
    if($sec<10)
        $sec="0".$sec;
    $chaine=$heure."h ".$min."m ".$sec."s";
    print("<td align=\"center\" nowrap>$chaine </td>
    <td>");
    // recup du parametrage du temps (par etape ou par type ou pas du tout)
    if($duree_parcours==0)
         $partype=$paretape="";
    else {
        $type_parametrage=get_parcours_type_duree($rowpar[0]);
        //debug
        //echo "type_parametrage=$type_parametrage<br>";
        switch($type_parametrage){
            case -1 : 
            	$partype=$paretape="";
            break;
            case 0 : 
            	$partype="<b>*</b>";
                $paretape="";
            break;
            case 1: 
            	$paretape="<b>*</b>";
                $partype="";
            break;
       }
    }

    print("
    <a class=\"action\" href=\"parcours_etapes_durees.php?action_parcours=temps_etape&parcours=$rowpar[0]&gestcours=$gestcours&niv=$niv\">
    $MSG_1321</a> $paretape<br>
    <a class=\"action\" href=\"parcours_etapes_durees.php?action_parcours=temps_type&parcours=$rowpar[0]&gestcours=$gestcours&niv=$niv\">
    $MSG_1322</a> $partype
    </td></tr>
    ");

}
//si pas de parcours
if($nbpar==0){
	print("
    <tr class=\"couleur2\">
    	<td colspan=\"3\">$MSG_2198.<td>
	</tr>");
}

print ("
</table>
<br><br>");
?>