<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
    Affichage des chronos individuels d'une tape de parcours.
	Ce script s'affiche dans une popup.
	
    @param integer $parcours identifiant du parcours
    @param integer $gestcour identifiant de la filiere
    @param integer $type type de l'tape
    @param integer $num_exo identifiant de l'tape
    @param integer $duree dure initiale de l'tape
    
    @package parcours_etapes_durees
    
*/
//--------------------------------------------------
// 			INITIALISATION
//--------------------------------------------------
//require ('../dbpostgres.php3');
//$db = connecteDB();
//inclusions
$dbpath="../..";  //le dbpath sert  maintenir les inclusions  partir du $chemin_bo
include("$dbpath/en_tete.php"); //contient les traitements communs  l'ensemble du FrameWork Astairs
include("../en_tete_back.php"); //contient les traitements communs  l'ensemble du BackOffice Astairs

$perm->check('CONF');


require ("$root/lib/lib_parcours.php");

$styleCSS = "../style/" . MY_STYLE . "/ressourcesPedagogiques.css";
$nompage = "modif_chrono_etape.php";
$titre = $MSG_2062;
include ("../entete_fenetre.php");

$v_type=get_etape_type_formate($type,2);
switch($v_type){
	case '4_1':
		//recup du titre de la serie
		$titre_etape = pg_fetch_result(get_serie($num_exo), 0, 1);
		
		//recup des evaluations de l'etape
		$eval_etapes=get_serie_evaluations($num_exo);
		$nbetapes = pg_numrows($eval_etapes);
		$coltype=8;
		$colchrono=6;
		$msg="";
		break;
		
	case '4_3':
		//recup du titre de la serie
		$res_test=get_test($num_exo);
		$titre_etape = pg_fetch_result($res_test, 0, 1);
		
		//recup des evaluations de l'etape
		$eval_etapes=get_test_positionnements_infos($num_exo);
		$nbetapes = pg_numrows($eval_etapes);
		$coltype=2;
		$colchrono=3;
		if(pg_fetch_result($res_test, 0, 3)=='t')$msg="<b>Test continu:</b> les chronos des positionnement sont fusionnes.";
		else $msg="<b>Test non continu:</b> les chronos des positionnement sont distincts.";
		break;
	default:
		die("erreur: type non reconnu<br/>");		
}

//--------------------------------------------------
//              SOUMISSION FORMULAIRE
//--------------------------------------------------
/*if (isset ($subduree)) {
	// debug
//	reset($HTTP_GET_VARS);
//	$sz=sizeof($HTTP_GET_VARS);
//	for($x=0;$x<$sz;$x++){
//	    $a=each($HTTP_GET_VARS);
//	    echo "$a[0] - $a[1]<br>";
//	}
	
	reset($HTTP_GET_VARS);
	while (list ($cle, $val) = each($HTTP_GET_VARS)) {
		//debug
		//echo "cle=$cle et val=$val<br>";
		$tab = array ();
		if (substr("$cle", 0, 1) == 'h') {
			// stockage des heures minutes et seconde
			$tab[] = $val;
			$a = each($HTTP_GET_VARS);
			$tab[] = $a[1];
			$a = each($HTTP_GET_VARS);
			$tab[] = $a[1];
			$duree = hmstoseconde($tab);
			$num_etape = substr("$cle", 1, 2) + 1;
			// debug
			//echo "num_etape=$num_etape<br>";
			// insertion  suivre ....
			switch ($type) {
				case 'Q' : // test si le chrono existe sinon on le cre
					$req = "select num_chrono from chrono where temps='$duree'";
					$res = pg_exec($req);
					if (pg_numrows($res) == 0) {
						// insertion du nouveau chrono
						$req = "insert into chrono(temps) values ('$duree')";
						$ins = pg_exec($req);
						// recup du n de chrono
						$req = "select max(num_chrono) from chrono";
						$res = pg_exec($req);
					}
					$row = pg_fetch_row($res);
					// mise  jour ds la table questionnaire
					$req = "update elaborqstn set eq_num_chrono='$row[0]' where num_ordre='$num_etape'";
					$maj = pg_exec($req);

					print ("
										                                <script language=\"Javascript\">
										                                window.opener.location=\"temps_etapetest.php3?parcours=$parcours&gestcour=$gestcour\";
										                                </script>
										                                ");
					break;
				case 'B' : //$req="update asso_exo_serie set chrono='$duree' where ordre='$num_etape'";
					//$maj=pg_exec($req);
					maj_serie_exo_chrono($num_exo, $duree, $num_etape);
					print ("
										                                <script language=\"Javascript\">
										                                window.opener.location=\"dureeEtape.php?action_parcours=temps_etape&parcours=$parcours&gestcours=$gestcours\";
										                                </script>
										                                ");
					break;
			}

		}

	}

}
*/
//--------------------------------------------------
//              AFFICHAGE 
//--------------------------------------------------
if(!empty($msg)){
print("
<table class=\"tableau_message\">
	<tr>
		<td>$msg</td>
	</tr>
</table><br/>");	
}
//titre de l'tape  modifier
print ("
<center>
<table align=\"center\">
	<tr class=\"couleur1\">
		<td colspan=\"4\"><b>$MSG_590: </b>$titre_etape</td>
	</tr>");

//ligne blanche de sparation
print ("
	<tr class=\"#ffffff\">
		<td align=\"center\" colspan=\"4\" style=\"height:10%\">
		</td>
	</tr>");

// formulaire de saisie
print ("<form name=\"formduree\" action=\"modif_chrono_etape.php\" method=\"get\">
<tr>
		<th>$MSG_2440</th>
        <th>$MSG_263</th>
        <th>$MSG_262</th>
        <th>$MSG_261</th>
</tr>");

//--------------------------------------------------
//          BOUCLE SUR LES ETAPES
//--------------------------------------------------/
for ($i = 0; $i < $nbetapes; $i++) {
	
	//recup evaluation courante
	$row = pg_fetch_row($eval_etapes, $i);
	
	//recup chrono evaluation courante
	$valchrono = $row[$colchrono];
	$tabhms = get_hms($valchrono);
	
	$classcolor = ($i % 2 == 0 || $i == 0 ? "couleur1" : "couleur2");
	
	//affichage de la ligne
	print ("<tr class=\"$classcolor\">
			<td><b>".($i +1)."</b> ".get_texte_pour_colonne($row[1],50)."<br><b><i>(".get_evaluation_type_libelle($row[$coltype]).")</i></b></td>
			");
	
	//affiche la selection de la dure
	$hms_form_name = "formduree";
	$hms_select_heure_name = "h$i";
	$total_heure+=$hms_select_heure_value = $tabhms["heure"];
	$hms_select_minute_name = "m$i";
	$total_minute+=$hms_select_minute_value = $tabhms["minute"];
	$hms_select_seconde_name = "s$i";
	$total_seconde+=$hms_select_seconde_value = $tabhms["seconde"];
	$hms_units = false;
	$hms_columns = true;
	$hms_disable_selects=true;
	include ("$root/lib_graphique/selects/selectHMS.php");

	print ("</tr>");
}
//ligne blanche de sparation
print ("<tr class=\"#ffffff\">
	       		<td align=\"center\" colspan=\"4\" style=\"height:10%\">
				</td>
			</tr>");
			
//totaux des dures
print("<tr>
	<th align=\"center\" colspan=\"4\">
		$MSG_2167 
	</th>
</tr>
<tr class=\"couleur3\">
	<td align=\"center\" colspan=\"4\">
		<b>$total_heure</b> &nbsp; $MSG_263 &nbsp;&nbsp;&nbsp;&nbsp <b>$total_minute</b> &nbsp; $MSG_262 &nbsp;&nbsp;&nbsp;&nbsp <b>$total_seconde</b> &nbsp; $MSG_261 
	</td>
</tr>");

//validation et champs hidden
print ("
<tr class=\"couleur1\">
<td align=\"center\" colspan=\"4\">
<input type=hidden name=\"type\" value=\"$type\">
<input type=hidden name=\"num_exo\" value=\"$num_exo\">
<input type=hidden name=\"parcours\" value=\"$parcours\">
<input type=hidden name=\"gestcours\" value=\"$gestcours\">
<!--<input type=submit name=\"subduree\" value=\"$FORM_6\">-->
<input type=\"button\" name=\"subduree\" value=\"$MSG_956\" Onclick=\"window.close()\">
</td></tr>
</form>
</table>
</td>
</tr>
</table>
");

//fermeture de la fenetre
/*print ("<br><a class=\"retour\" href=\"#\" Onclick=\"window.close()\">$MSG_956</a><br><br>
</center>");
*/
?>