<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/


/**
    Affectation des dures aux tapes d'un parcours

    @param integer $parcours identifiant du parcours
    @param integer $gestcour identifiant de la filiere
    
    @package parcours_etapes_durees
    
*/

$perm->check('CONF');

//--------------------------------------------------------
//          VALIDATION FORMULAIRE
//--------------------------------------------------------

if(isset($subdureeetape)){
    reset($HTTP_GET_VARS);
    //print_rr($_GET);
    $heures=$minutes=$secondes=false;
	$duree=0;
    while(list($cle,$val)=each($HTTP_GET_VARS)){
    	
    	$t_type=explode("-",$cle);
		//print_rr($t_type);
		//type d'tape
		$type=$t_type[1];
    	//$type=get_etape_type_formate($cle,1);
		//identifiant de l'etape
		$etape = $t_type[2];
		
		if (is_etape_type_duree($type)) {
			//heures
			if (substr("$cle", 0, 1) == 'h') {
				$heures = true;
				$duree+=$val*3600;
			}
			//minutes
			if (substr("$cle", 0, 1) == 'm') {
				$minutes = true;
				$duree+=$val*60;
			}
			//secondes
			if (substr("$cle", 0, 1) == 's') {
				$secondes = true;
				$duree+=$val;
			}
			//mise a jour
			if($heures&&$minutes&&$secondes){
				maj_parcours_etape_duree($parcours, $etape, $duree, $type);	
				$heures=$minutes=$secondes=false;
				$duree=0;
			}
		}
    }
 	//affichage de la dure en front office
	if($affiche_fo!='TRUE')$affiche_fo='FALSE';
		maj_parcours_duree($parcours,$affiche_fo); 
}

//--------------------------------------------------------
//          INITIALISATION
//--------------------------------------------------------

// variable qui renseigne si le parcours contient des valuation
$evaluation = 0;
// test si le parcours est modifiable,supprimable ,attach
$modifiable = 1;
$supprimable = 1;
$attache = 0;
// Appel de la fonction modification_suppression
//is_parcours_modifiable($parcours, & $modifiable, & $supprimable, & $attache);

// test si le parcours est utilis en formation
$en_formation = false;
$tabform = array ();
$tabform = get_parcours_all_formations($parcours, $tabform);
//print_rr($tabform);
$sz = sizeof($tabform);
if ($sz > 0)
	$en_formation = true;

//nom du parcours
$resparcour = get_parcours($parcours);
$row_nparc = pg_fetch_row($resparcour, 0);
$nom_parc = $row_nparc[1];

// recup des tapes
$typ_etap = get_parcours_etapes($parcours);
$nb_etap = pg_numrows($typ_etap);

//--------------------------------------------------------
//          			AFFICHAGE 
//--------------------------------------------------------

//libelles du parcours et de la filiere
print ("
<br/>
<table class=\"tableau_espace2\">
<form name=\"formduree\" method=\"get\">
<tr class=\"couleur1\">
	<td colspan=\"5\" ><b>$MSG_2388: </b>" . get_filiere_libelle_ams_complet($gestcours) . "<br><b>$MSG_732: </b> ".get_gui_libelle($nom_parc,false)." </td>
</tr>");

//ligne blanche de sparation
print ("<tr class=\"#ffffff\">
	       		<td align=\"center\" colspan=\"4\" style=\"height:10%\">
				</td>
			</tr>");
			
//Ligne de titres
print ("<tr>
        <th>$MSG_279<br><span style=\"font-weight: normal;\">$MSG_280 </span></th>
		<th width=\"10%\">$MSG_2567</th>
        <th width=\"20%\">$MSG_263</th>
        <th width=\"20%\">$MSG_262</th>
        <th width=\"20%\">$MSG_261</th>
    </tr>");

//--------------------------------------------------------
// 				BOUCLE SUR LES ETAPES
//--------------------------------------------------------
for ($y = 0; $y < $nb_etap; $y++) {

	$classcolor = ($y % 2 == 0 || $y == 0 ? "couleur1" : "couleur2");
	$rclasscolor = ($y % 2 == 0 || $y == 0 ? "couleur2" : "couleur1");
	$ligne++;
	$cpt = $y +1;
	$row_etap = pg_fetch_row($typ_etap, $y);

	//type de l'etape
	$type = $row_etap[4];
	
	//etape fin de page
	$finpage=$row_etap[9];
	
	//identifiant de l'tape
	$etape=$row_etap[0];
	
	//type de l'etape
	$type = $row_etap[4];

	//indice de l'etape
	$etape_indice = $row_etap[5];

	//etape fin de page?
	if ($row_etap[9] == 1)
		$classcolor = "#eeeeee";

	//libelle de type d'tape 
	$etape_type_libelle_original = $row_etap[10];

	//libelle de l'tape
	$etape_libelle = $row_etap[2];

	//libell personnalis de l'tape (allias)
	$etape_alias = $row_etap[1];

	if($finpage=='t'){
		$couleur_ligne="couleur3";
	}else{
		$couleur_ligne=$classcolor;
	}
	print ("
	<tr class=\"$couleur_ligne\">
		<td>");

	//on formate le $type pour les types composs
	if(substr_count($type,'_')>=2){
		$debut_type=strpos($type,'_');
		$type=substr($type,0,$debut_type+2);
	}
	
	$etape_theme = @pg_fetch_result(get_etape_themes($row_etap[0]), 0, 1);
	if (!empty ($etape_alias)) {
		$colonne_titre = $etape_alias;
	} else {
		$colonne_titre = $etape_alias;
	}
	

	//libelle de type d'tape 
	$var='$etape_type_libelle_original='.$row_etap[10].';';
	eval($var);
	//si c'est un type compos, on enleve le '-' qui est au dbut du type
	if(substr_count( $row_etap[4],'_')>=2){
		$debut_type=strpos($etape_type_libelle_original,'-');
		$etape_type_libelle_original=substr($etape_type_libelle_original,$debut_type+1);
	}else{
		$etape_type_libelle_original=$etape_type_libelle_original;
	}
	//AFFICHAGE DE LA LIGNE
	print ("
			$cpt - <b>$etape_type_libelle_original </b>  <br>".get_gui_libelle($colonne_titre,false)." 
		</td>");

	//--------------------------------------------------------
	//      			CHRONOS
	//--------------------------------------------------------
	//SI ON PEU AVOIR UN CHRONO CALCULE OU CONFIGURE
	$is_duree_calculee=false;
	if (is_etape_type_duree($type)) {
		
		//--------------------------------------------------------
		//      			CALCUL DES DUREES
		//--------------------------------------------------------
		//CHRONO CALCULE
		if (is_etape_type_chronometre($type)) {
			
			$duree_etape_tmp = get_etape_chrono_total($etape, $type);
			//echo"$etape, $type \$duree_etape_tmp=$duree_etape_tmp<br>";
			
			//si on a un chrono
			if(!empty($duree_etape_tmp)){
				//si la dure est ngative, le chrono est individuel, global sinon.
				if ($duree_etape_tmp < 0) {
					$duree_etape = (- $duree_etape_tmp);
					$type_chrono = "<i>($MSG_2201)</i>";
				} else {
					$duree_etape = $duree_etape_tmp;
					$type_chrono = "<i>($MSG_2200)</i>";
				}
				$msg = "<b>$MSG_2202</b><br/> $type_chrono";
				$is_duree_calculee=true;
			}else{
				$is_duree_calculee=false;
				$msg = "<b>$MSG_2199</b>";
				$duree_etape = $row_etap[8];
			}
									
		}
		///CHRONO CONFIGURE
		else {
			$msg = "<b>$MSG_2199</b>";
			$duree_etape = $row_etap[8];
		}
		//configuration chrono:
		$duree_etape_conf = $row_etap[8];
		
		//conversions
		$tabhms = get_hms($duree_etape);
		$tabhms_conf = get_hms($duree_etape_conf);
		/*
		echo "duree_etape=$duree_etape<br>";
		echo "<pre>";
		print_r($tabhms);
		print_r($tabhms_conf);
		echo "</pre>";
		*/

		//--------------------------------------------------------
		//      			AFFICHAGE
		//--------------------------------------------------------		
		print ("
			<td align=\"center\">$msg </td>");
		
		//DUREES CALCULES
		if($is_duree_calculee){
			//echo "coucou<br>";
			print("
			<td align=\"center\" colspan=\"5\" class=\"$classcolor\" style=\"margin:0px;padding:0px;\">
				<table style=\"width:100%;\">
					<tr align=\"center\" class=\"$classcolor\">
						<td colspan=\"3\">");
			
			switch($row_etap[4]){
				case'1':
					print("
					<a href=\"javascript:window.location='parcours_etapes_durees.php?action_parcours=temps_etape&parcours=$etape&gestcours=$gestcours&niv=$niv'\">
						<b>".$tabhms["heure"]."&nbsp; $MSG_263 &nbsp;&nbsp;&nbsp;&nbsp;".$tabhms["minute"]."&nbsp; $MSG_262 &nbsp;&nbsp;&nbsp;&nbsp;".$tabhms["seconde"]."&nbsp; $MSG_261</b>
					</a><br>");
					break;
				case'4_3':
					print ("
					<a href=\"javascript:pop_chrono('modif_chrono_etape.php?type=$type&num_exo=$row_etap[0]&duree=$duree_etape&parcours=$parcours&gestcours=$gestcours')\">
						<b>" . $tabhms["heure"] . "&nbsp;$MSG_263&nbsp;&nbsp;" . $tabhms["minute"] . "&nbsp;$MSG_262&nbsp;&nbsp;" . $tabhms["seconde"] . "&nbsp;$MSG_261</b>
					</a><br/>");
					break;
				case '4_1_4':
					print("
						<b>$MSG_2242: </b>
						<br/><i>($MSG_2243)</i>
						<br/><b>".$tabhms["heure"]."&nbsp; $MSG_263 &nbsp;&nbsp;&nbsp;&nbsp;".$tabhms["minute"]."&nbsp; $MSG_262 &nbsp;&nbsp;&nbsp;&nbsp;".$tabhms["seconde"]."&nbsp; $MSG_261</b>
						<br/>");
					break;
				default:
					if($duree_etape_tmp >= 0 ){ 
						print("
						<b>" . $tabhms["heure"] . "&nbsp;$MSG_263&nbsp;&nbsp;" . $tabhms["minute"] . "&nbsp;$MSG_262&nbsp;&nbsp;" . $tabhms["seconde"] . "&nbsp;$MSG_261</b><br/>");
					}else{
						print("
						<a href=\"javascript:pop_chrono('modif_chrono_etape.php?type=$type&num_exo=$row_etap[0]&duree=$duree_etape&parcours=$parcours&gestcours=$gestcours')\">
							<b>" . $tabhms["heure"] . "&nbsp;$MSG_263&nbsp;&nbsp;" . $tabhms["minute"] . "&nbsp;$MSG_262&nbsp;&nbsp;" . $tabhms["seconde"] . "&nbsp;$MSG_261</b>
						</a><br/>");
					}
			}	
			print("
						</td>
					</tr>
					<tr class=\"$rclasscolor\" >");
			//initialisation duree HMS
			$hms_select_heure_value = $tabhms_conf["heure"];
			$hms_select_minute_value = $tabhms_conf["minute"];
			$hms_select_seconde_value = $tabhms_conf["seconde"];
		
			//affiche la selection de la dure
			$hms_select_heure_name = "h-"."$type"."-$etape";
			$hms_select_minute_name ="m-"."$type"."-$etape";
			$hms_select_seconde_name ="s-"."$type"."-$etape";
			$hms_units = true;
			$hms_columns = true;
			include ("$root/lib_graphique/selects/selectHMS.php");		
			print("
					</tr>
				</table>");
			print("
			</td>");
		}
		//DUREES CONFIGUREES
		else{
			//initialisation duree HMS
			$hms_select_heure_value = $tabhms["heure"];
			$hms_select_minute_value = $tabhms["minute"];
			$hms_select_seconde_value = $tabhms["seconde"];
			
			//affiche la selection de la dure
			$hms_select_heure_name = "h-"."$type"."-$etape";
			$hms_select_minute_name ="m-"."$type"."-$etape";
			$hms_select_seconde_name ="s-"."$type"."-$etape";
			$hms_units = true;
			$hms_columns = true;
			include ("$root/lib_graphique/selects/selectHMS.php");		
		}
		print ("</tr>");
		
		//on calcul le total
		if($row_etap[4]!='4_1_4'){
			if(!empty($duree_etape_conf)){
				$total_heure +=$tabhms_conf["heure"];
				$total_minute+=$tabhms_conf["minute"];
				$total_seconde+=$tabhms_conf["seconde"];
			}else{
				$total_heure +=$tabhms["heure"];
				$total_minute+=$tabhms["minute"];
				$total_seconde+=$tabhms["seconde"];
			}
		}
	}
	//PAS DE CHRONO POSSIBLE OU CAS SPECIAUX(ex: parcours orient)
	else{
		if($type==10){
			print ("<td align=\"center\">$msg</td>
					<td align=\"left\" colspan=\"4\" nowrap>");
			$res_ss_parcours=get_parcours_oriente_sous_parcourss($etape);
			while($row=pg_fetch_row($res_ss_parcours)){
				$ss_duree=get_parcours_duree_totale($row[0]);
				$tabhms_ss=get_hms($ss_duree);	
				print("
						<b>$row[1]:</b><blockquote><a href=\"javascript:window.location='parcours_etapes_durees.php?action_parcours=temps_etape&parcours=$row[0]&gestcours=$gestcours&niv=$niv'\">
							<b>" . $tabhms_ss["heure"] . "&nbsp;$MSG_263&nbsp;&nbsp;" . $tabhms_ss["minute"] . "&nbsp;$MSG_262&nbsp;&nbsp;" . $tabhms_ss["seconde"] . "&nbsp;$MSG_261</b>
						</a></blockquote>");
			}							
			print("
					<br><i>($MSG_2244)</i>
					</td>");
		}else{
			print ("
					<td align=\"center\" colspan=\"5\">
						<i>$MSG_2245</i>
					</td>");
		}								
	}
}

//ligne blanche de sparation
print ("<tr class=\"#ffffff\">
	       		<td align=\"center\" colspan=\"4\" style=\"height:10%\">
				</td>
			</tr>");

//totaux des dures
print ("<tr>
	<th align=\"center\" colspan=\"5\">
		$MSG_2205
	</th>
</tr>
<tr class=\"couleur3\">
	<td align=\"center\" colspan=\"5\">
		<b>$total_heure</b> &nbsp; $MSG_263 &nbsp;&nbsp;&nbsp;&nbsp <b>$total_minute</b> &nbsp; $MSG_262 &nbsp;&nbsp;&nbsp;&nbsp <b>$total_seconde</b> &nbsp; $MSG_261 
	</td>
</tr>");

// Affichage de la dure du parcours en front office
if ($row_nparc[3] == 't')$checked='checked';
else $checked='';
print ("
<tr class=\"couleur3\">
    <td colspan=\"5\" align=\"center\">
        $MSG_1323
        <input type=\"checkbox\" name=\"affiche_fo\" value=\"TRUE\" $checked>
    </td>
</tr>");

//validation
print ("
<tr class=\"couleur1\">
    <td colspan=\"5\" align=\"center\">
		<input type=\"hidden\" name=\"action_parcours\" value=\"temps_etape\">
        <input type=\"hidden\" name=\"parcours\" value=\"$parcours\">
        <input type=\"hidden\" name=\"gestcours\" value=\"$gestcours\">
        <input type=\"submit\" name=\"subdureeetape\" value=\"$FORM_6\">
    </td>
</tr>
</form>
</table>
<br>
");
?>