<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
    Affectation des dures aux types d'tapes d'un parcours

    @param integer $parcours identifiant du parcours
    @param integer $gestcour identifiant de la filiere
    
    @package parcours_etapes_durees
    
*/
$perm->check('CONF');
//--------------------------------------------------------
//         SOUMISSION DU FORMULAIRE
//--------------------------------------------------------
if (isset ($subdureetype)) {
	reset($HTTP_GET_VARS);
	$heures=$minutes=$secondes=false;
	$duree=0;
	while (list ($cle, $val) = each($HTTP_GET_VARS)) {

		//type d'tape
		$type = substr("$cle", 1, strlen($cle) -1);
		
		if (is_etape_type_duree($type)) {
			//heures
			if (substr("$cle", 0, 1) == 'h') {
				$heures = true;
				$duree+=$val*3600;
			}
			//minutes
			if (substr("$cle", 0, 1) == 'm') {
				$minutes = true;
				$duree+=$val*60;
			}
			//secondes
			if (substr("$cle", 0, 1) == 's') {
				$secondes = true;
				$duree+=$val;
			}
			//mise a jour
			if($heures&&$minutes&&$secondes){
				$maj=maj_parcours_etapes_duree_type($parcours, $type, $duree);
				$heures=$minutes=$secondes=false;
				$duree=0;
			}
		}
	}
	//affichage de la dure en front office
	if($affiche_fo!='TRUE')$affiche_fo='FALSE';
	maj_parcours_duree($parcours,$affiche_fo);
}
//--------------------------------------------------------
//          INITIALISATION
//--------------------------------------------------------

//nom du parcours
$nomparcour = get_parcours($parcours);
$row_nparc = pg_fetch_row($nomparcour, 0);
$nom_parc = $row_nparc[1];

// recup des diffrents types d'etape 
$restype = get_parcours_types_etapes($parcours);
$cnt_type = pg_numrows($restype);
$tab_type=Array();
$serie_genere_presente=false;
for($i=0;$i<$cnt_type;$i++){
	//recup du type
	$rowtype = pg_fetch_row($restype, $i);
	if($rowtype[0]=='4_1_4'){
		$serie_genere_presente=true;
	}
	else{
		$tab_type[get_etape_type_formate($rowtype[0],3)]+=$rowtype[2];
	}
}
//$cnt=count($tab_type);
//echo "\$cnt=$cnt<br>";
//echo "<pre>";
//print_r($tab_type);
//echo "</pre>";
//--------------------------------------------------------
//             			AFFICHAGE
//--------------------------------------------------------

//libelles du parcours et de la filiere
print ("
<br/>
<table class=\"tableau_espace2\">
<tr class=\"couleur1\">
	<td><b>$MSG_2388: </b>" . get_filiere_libelle_ams_complet($gestcours) . "<br><b>$MSG_732: </b> ".get_gui_libelle($nom_parc)." </td>
</tr>");

//ligne blanche de sparation
print ("<tr class=\"#ffffff\">
	       		<td align=\"center\" colspan=\"4\" style=\"height:10%\">
				</td>
			</tr>");

//Ligne de titres
print ("
<table class=\"tableau_espace2\">
<form name=\"formtype\"  method=\"get\">
    <tr>
       	<th width=\"30%\">$MSG_116</th>
		<th width=\"10%\">$MSG_2202</th>
        <th width=\"20%\">$MSG_263</th>
        <th width=\"20%\">$MSG_262</th>
        <th width=\"20%\">$MSG_261</th>
    </tr>");

//--------------------------------------------------------
//          BOUCLE SUR LES TYPES
//--------------------------------------------------------
$y = 0;
foreach($tab_type as $type => $nb){
	
	$classcolor = ($y % 2 == 0 || $y == 0 ? "couleur1" : "couleur2");
	$rclasscolor = ($y % 2 == 0 || $y == 0 ? "couleur2" : "couleur1");

	// filtre les types spciaux
	if (is_etape_type_duree($type)) {

		$durees_type = get_parcours_etapes_durees_type($parcours, $type);
		//detection config par type
		if(pg_num_rows($durees_type)==1&&pg_fetch_result($durees_type,0,0)>0){
			$config_type=true;
			$val_tabhms_conf = pg_fetch_result($durees_type,0,0);
			$tabhms_conf = get_hms($val_tabhms_conf);	
		}
		else{
			$config_type=false;
			$val_tabhms_conf = get_parcours_etapes_duree_type($parcours, $type);
			$tabhms_conf = get_hms($val_tabhms_conf);	
		}
		
		//message 				
		if(is_etape_type_chronometre($type)){
			$mess="$MSG_2246:<br/>";
			//duree calculee
			$val_tabhms = get_parcours_etapes_chrono_type($parcours, $type);
		}else{
			$mess="$MSG_2240:<br/>";
			//duree temps configur par etape
			$val_tabhms = get_parcours_etapes_duree_type($parcours, $type);
			
		}
		
		//conversion
		if($val_tabhms>=0){
			$tabhms = get_hms($val_tabhms);
		}else{
			$tabhms = get_hms(-$val_tabhms);
		}
		
		//libelle type
		$etape_type_libelle_original=get_etape_type_libelle("".$type);

		//affiche le type et le nombre d'tape pour la ligne
		print ("
	<tr class=\"$classcolor\">
		<td>
			<b>$etape_type_libelle_original:</b>");
		if($type=='4_1'&&$serie_genere_presente)
			print("
			<br/><i>$MSG_2241</i>");	                
		print("
		</td>
		<td align=\"center\">" . $nb . "</td>");
		
		if($config_type){
			$hms_select_heure_value = $tabhms_conf["heure"];
			$hms_select_minute_value = $tabhms_conf["minute"];
			$hms_select_seconde_value = $tabhms_conf["seconde"];
			
			//calcul totaux
			$total_heure += ($tabhms_conf["heure"] *$nb);
			$total_minute += ($tabhms_conf["minute"]*$nb );
			$total_seconde += ($tabhms_conf["seconde"]*$nb );
		}else{
			$hms_select_heure_value = 0;
			$hms_select_minute_value = 0;
			$hms_select_seconde_value = 0;

			//calcul totaux
			$total_heure += ($tabhms["heure"] );
			$total_minute += ($tabhms["minute"] );
			$total_seconde += ($tabhms["seconde"] );
		}	
		
		print("
		<td align=\"center\" colspan=\"3\" class=\"$classcolor\" style=\"margin:0px;padding:0px;\">
			<table style=\"width:100%;\">
				<tr align=\"center\" class=\"$classcolor\">
					<td colspan=\"3\">
						$mess <b>".$tabhms["heure"]."&nbsp; $MSG_263 &nbsp;&nbsp;&nbsp;&nbsp;".$tabhms["minute"]."&nbsp; $MSG_262 &nbsp;&nbsp;&nbsp;&nbsp;".$tabhms["seconde"]." &nbsp; $MSG_261</b>
					</td>
				</tr>
				<tr class=\"$rclasscolor\" >");
			//affiche la selection de la dure pour la ligne
			$hms_select_heure_name = "h$type";
			$hms_select_minute_name = "m$type";
			$hms_select_seconde_name = "s$type";
			$hms_units = false;
			$hms_columns = true;
		include ("$root/lib_graphique/selects/selectHMS.php");
		print("
				</tr>
			</table>");					
		print("
		</td>");
		print ("
	</tr>");
	}
	$y++;
} 

//--------------------------------------------------------
//          TABLEAU FIN DE PAGE
//--------------------------------------------------------
//ligne blanche de sparation
print ("
	<tr class=\"#ffffff\">
		<td align=\"center\" colspan=\"4\" style=\"height:10%\"></td>
	</tr>");

//totaux des dures

// dure du parcours
print ("
	<tr>
		<th align=\"center\" colspan=\"5\">
			$MSG_2205
		</th>
	</tr>
	<tr class=\"couleur3\">
		<td align=\"center\" colspan=\"5\">
			<b>$total_heure</b> &nbsp; $MSG_263 &nbsp;&nbsp;&nbsp;&nbsp <b>$total_minute</b> &nbsp; $MSG_262 &nbsp;&nbsp;&nbsp;&nbsp <b>$total_seconde</b> &nbsp; $MSG_261 
		</td>
	</tr>");

// Affichage de la dure du parcours en front office
print ("
	<tr class=\"couleur3\">
	    <td align=\"center\" colspan=\"5\">$MSG_1323
	    	<input type=\"checkbox\" name=\"affiche_fo\" value=\"TRUE\"");
if ($row_nparc[3] == 't')
	print ("checked");
print (">
    	</td>
	</tr>");

//validation
print ("
	<tr class=\"couleur1\">
	    <td align=\"center\"  colspan=\"5\">
			<input type=\"hidden\" name=\"action_parcours\" value=\"temps_type\">
	        <input type=\"hidden\" name=\"parcours\" value=\"$parcours\">
	        <input type=\"hidden\" name=\"gestcours\" value=\"$gestcours\">
	        <input type=\"submit\" name=\"subdureetype\" value=\"$FORM_6\">
	    </td>
</tr>");

print ("
</form>
</table>
<br/>");
?>