<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
    Gestion des liblls de type d'tapes.
    
    Ce script propose la personnalisation des liblls de type d'tape pour un parcours.
    Il est possible de personnaliser selon 2 mthodes:
    - La mthode standard: Un libell par type pour le parcours
    - La mthode dtaille: Un libell par tape pour le parcours
    
    @package parcours_etapes_types_noms
*/
$perm->check('CONF');
//-------------------------------------------------------------------------
//              INITIALISATION
//-------------------------------------------------------------------------

//recup du nom du cours
$nomcours=get_filiere_libelle_ams_complet($gestcours);

//recup du niveau en fonction de la longueur du nom
$tabnomcour=explode("/",$nomcours);
$nivsup=sizeof($tabnomcour);
$nivsup=get_filiere_niveau($gestcours);
//recup des parcours
$respar=get_filiere_parcourss($gestcours);  
$nbpar=pg_numrows($respar);

//-------------------------------------------------------------------------
//              AFFICHAGE
//-------------------------------------------------------------------------

// Affichage infos
//print("
//<table class=\"tableau_message\">          
//<tr align=\"left\">
//    <td>$MSG_1225<br><br>$MSG_1226</td>
//</tr>
//</table>
//<br>
//");

//libelle de la filiere
print("
<br/>
<table class=\"tableau_normal2\">
<tr class=\"couleur1\">
	<td><b>$MSG_2388:</b> $nomcours <i>(niveau $nivsup)</i></td>
</tr>
</table><br>");

print("<table class=\"tableau_espace2\">
<tr>
    <th>$MSG_1026</th>
    <th colspan=\"2\">$FORM_1</th>
</tr>");
    
for($x=0;$x<$nbpar;$x++){
    $rowpar=pg_fetch_row($respar,$x);
    $niveau=$niv+1;

    $classcolor=($x%2==0||$x==0?"couleur1":"couleur2");

    print("<tr class=\"$classcolor\">
    <td>".get_gui_libelle($rowpar[1],false)."</td>");
    
    //recup du nb d'tape
    $typ_etap=get_parcours_etapes($rowpar[0]);
    $nb_etap = pg_numrows($typ_etap);
    
    // recup du type de paramtrage
    $type_parametrage=get_parcours_type_parametrage($rowpar[0]);
    //echo "typ_para=$type_parametrage<br>";
    switch($type_parametrage){
        case -1 : $standard=$detail="";
        break;
        case 0 : $standard="*";
                          $detail="";
        break;
        case 1: $detail="*";
                         $standard="";
        break;
    }

    print("
    <td align=\"center\">
        <a class=\"action\" href=\"parcours_etapes_types_noms.php?action_parcours=renomme_type&parcours=$rowpar[0]&gestcours=$gestcours\">
        $MSG_1227 $standard</a>
    </td>
    <td align=\"center\">
        <a class=\"action\" href=\"parcours_etapes_types_noms.php?action_parcours=renomme_etape&parcours=$rowpar[0]&gestcours=$gestcours\">
        $MSG_1228 $detail</a>
    </td>
</tr>");
}
if($nbpar==0){
        print"<tr class=\"couleur1\"><td colspan=\"2\"><i>$MSG_2198</i></td><tr>";
        print "</table>";
}

print("</table>");
//court-circuitage de select_cours.php3 ->> Rmi C.: encore utile?
$rang=$niv;
print("
<form>
<input type=\"hidden\" name=\"niv\" value=\"$niv\">
<input type=\"hidden\" name=\"nivmax\" value=\"$nivmax\">
<input type=\"hidden\" name=\"nbchamp\" value=\"$nbchamp\">
<input type=\"hidden\" name=\"numcour\" value=\"$numcour\">
<input type=\"hidden\" name=\"rang\" value=\"$rang\">
<input type=\"hidden\" name=\"gestcours\" value=\"$gestcours\">
</form>
<br>
");
?>