<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
    Script de personnalisation standard des liblls de types d'tapes.
    
    Affiche les types d'tapes d'un parcours et un champ texte pour la saisie du
    libell de type d'tape.
    Ces liblls sont spcifiques  ce parcours, et s'appliques  toutes les tapes.
    
    @param integer $parcours numro du parcours
    @param integer $gestcour numro de la filre
    
    @package parcours_etapes_types_noms
*/
$perm->check('CONF');
//-------------------------------------------------------------------------
//              SOUMISSION FORMULAIRE
//-------------------------------------------------------------------------

// personnalisation standard
if(isset($subnomtype)){
    reset($_GET);
    //print_rr($_GET);
    $sz=sizeof($_GET) -4;
    for($i=0;$i<$sz;$i++){
        $a=each($_GET);
        $t=explode("_",$a[0]);
        $typ=$t[0];
        /*
        if($a[1])
            $a[1]=addslashes($a[1]);
        */
        //maj_parcours_type_etape_personnalise($parcours,$a[0],$a[1]);
        maj_parcours_type_etape_personnalise($parcours,$typ,set_ams_libelle($a[1]));
    }
}

//-------------------------------------------------------------------------
//              INITIALISATION
//-------------------------------------------------------------------------

// recup du nom de parcours
$res = get_parcours($parcours);
$row = pg_fetch_row($res, 0);

// recup des diffrents type d'tape
$restype = get_parcours_types_etapes($parcours);
$cnt = pg_numrows($restype);

//-------------------------------------------------------------------------
//              AFFICHAGE
//-------------------------------------------------------------------------
print ("
<br/>
<table class=\"tableau_normal\">
<tr class=\"couleur1\">
    <td>
        <b>$MSG_2282 :</b> ".get_gui_libelle($row[1],false)."
    </td>
</tr>
</table>
<br>
");

print ("<table class=\"tableau_espace\">
<form name=\"formauto\"  methode=\"get\">
<tr class=\"couleur1\">
	<th>$MSG_933</th>
    <th>$MSG_1230</th>
</tr>
");
for ($e = 0; $e < $cnt; $e++) {

	$rowtype = pg_fetch_row($restype, $e);
	//print_rr($rowtype);
	if($rowtype[0]!=TYPE_ETAPE_TITRE){
	
	$classcolor = ($e % 2 == 0 || $e == 0 ? "couleur1" : "couleur2");

	// recup du nom d'etape s'il existe
	$res = get_parcours_type_etape_personnalise($parcours, $rowtype[0]);
	if (pg_num_rows($res) == 1) {
		$row = pg_fetch_row($res, 0);
		//print_rr($row);
		$nometape = $row[0];
	} else
		$nometape = "";

	//libelle de type d'tape 
	$var='$etape_type_libelle_original='.$rowtype[1].';';
	eval($var);
	//si c'est un type compos, on enleve le '-' qui est au dbut du type
	if(substr_count($rowtype[0],'_')>=2){
		$debut_type=strpos($etape_type_libelle_original,'-');
		$etape_type_libelle_original=substr($etape_type_libelle_original,$debut_type+1);
	}
	
	print ("<tr class=\"$classcolor\">
	            <td>$etape_type_libelle_original</td>
	            <td align=\"center\">
				<!--<input type=\"text\" name=\"$rowtype[0]\" size=\"50\" value=\"$nometape\">-->
				".get_gui_libelle_input($rowtype[0],$nometape,false,50,'')."
				</td>
	        </tr>");
	}
}
$classcolor = ($e % 2 == 0 || $e == 0 ? "couleur1" : "couleur2");
print ("
<tr class=\"$classcolor\">
    <td colspan=\"2\" align=\"center\">
		<input type=\"hidden\" name=\"action_parcours\" value=\"$action_parcours\">
        <input type=\"submit\" name=\"subnomtype\" value=\"$FORM_6\">
        <input type=\"hidden\" name=\"gestcours\" value=\"$gestcours\">
        <input type=\"hidden\" name=\"parcours\" value=\"$parcours\">
    </td>
</tr>
</form>
</table>
<br>
");
?>