<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Ajouter les choix  un positionnement.
 *  @package positionnement
 */
//--------------------------------------------------
// 			INITIALISATION
//--------------------------------------------------
require("../dbpostgres.php3");
connecteDB();
require("$chemin_bo/lib/lib_positionnement.php");

//construit l'objet positionnement
if(empty($obj_positionnement)){
        die ("Objet Positionnement manquant.<br>");
}else{
	$current_positionnement=importObjet($obj_positionnement);
}
if(empty($current_positionnement))
        die ("Objet Positionnement Non Valide.<br>");
//print_rr($current_positionnement);
//--------------------------------------------------
// PASSAGE A LA SUITE
//--------------------------------------------------
if(isset($suite)){
    header("location:addQuestions.php?theme=$theme&obj_positionnement=".exportObjet($current_positionnement)."&dynamique=$dynamique&nb_choix=$nb_choix&nb_questions=$nb_questions&mode=$mode&nb_max_qcms=$nb_max_qcms&nb_max_ftbs=$nb_max_ftbs");
}


//--------------------------------------------------
//                      VALIDATION DU FORMULAIRE
//--------------------------------------------------
//echo "sub_choix=$sub_choix";
if(isset($sub_choix)){

        $probleme = false ;
        $type = $current_positionnement->getType() ;

		// Bloque l'envoi d'affichage
        ob_start() ;
        pg_query("begin") ;
        $i = 1 ;
        
        // Parcours des rponses
        while($i <= $nb_choix && !$probleme)
        {
        	//	echo "$i ici";
        	
                // Rcupration des variables du formulaire
                $var = "lib_choix".$i ;
                $lib_choix = $$var ;
                $var = "media".$i ;
                $media = $$var ;
                $var = "largeur".$i ;
                $largeur = $$var ;
                $var = "hauteur".$i ;
                $hauteur = $$var ;

                $var = "niveau".$i ;
                $niveau = $$var ;
                $var = "bareme".$i ;
                $bareme = $$var ;
				
				//verification du bareme
				if(empty($bareme)){
					echo"Erreur: Tous les baremes doivent etres values.<br>";
					break;
				} 
				
                $var = "nb_exercices_genQCMS".$i ;
                $nb_qcm = $$var ;
                $var = "nb_exercices_chapQCMS".$i ;
                $chap_qcm = $$var ;
                $var = "nb_exercices_genBLANCS".$i ;
                $nb_ftb = $$var ;
                $var = "nb_exercices_chapBLANCS".$i ;
                $chap_ftb = $$var ;

                $var = "modif".$i ;
                $id_choix = $$var ;

            
                // Modification d'une rponse
                if($id_choix){
					$rep =& $current_positionnement->getObjReponses($i);// new Choix($id_choix, $type, $lib_choix, $interpretationHTML, $media) ;
                       
                    $rep->setLibelle($lib_choix); 
                    $rep->setBareme($bareme);  
  					
  					if($dynamique){
  						if(!empty($nb_qcm)){
  							$rep->setConfigEvaluationsType(TYPE_EVALUATION_QCM, $nb_qcm,$chap_qcm);	
  						}
  						else{
  							$rep->delConfigEvaluationsType(TYPE_EVALUATION_QCM);	
  						}
  						
  						if(!empty($nb_ftb)){
  							$rep->setConfigEvaluationsType(TYPE_EVALUATION_FTB, $nb_ftb,$chap_ftb);	
  						}
  						else{
  							$rep->delConfigEvaluationsType(TYPE_EVALUATION_FTB);	
  						}
  					}
  					
  					$rep->updateToDB();
                }
                // Insertion d'une nouvelle rponse
                else{
					$rep = new Choix(0, $type, $lib_choix, $interpretationHTML,$bareme) ;
                    $id_rep = $rep->insertToDB($theme, &$message_erreur) ;
                    if($id_rep){
                    	
                    	//INSERTION MEDIA REPONSE
			            if(!empty($media)){
			                $mon_media = new  MediaQuestionReponseElement($id,$id_rep,$media, $hauteur, $largeur) ;
				            if(!is_object($mon_media)){
				            	$message_erreur.="Insertion du mdia de la rponse : echec<br>(params : $id_rep, ".$rep->getId().", $media, $hauteur, $largeur)<br>";
				                $probleme = true ;
				            }
				            $rep->setMedia($mon_media);
		                }
	                	
	                	
	                	if($dynamique){
	  						if(!empty($nb_qcm)){
	  							$rep->setConfigEvaluationsType(TYPE_EVALUATION_QCM, $nb_qcm,$chap_qcm);	
	  						}
	  						
	  						if(!empty($nb_qcm)){
	  							$rep->setConfigEvaluationsType(TYPE_EVALUATION_FTB, $nb_ftb,$chap_ftb);	
	  						}
  						}
                       	$current_positionnement->setObjReponse($rep);
                    }
                    else{
						echo "Insertion de la rponse = echec<br>param : $id_rep, 0, $bareme, $nbExos, $mon_media<br>" ;
                        $probleme = true ;
                    }
                }
           
	            
                $i++ ;
        }

        $message_erreur = ob_get_contents() ;
        ob_end_clean();
//        print_rr($current_positionnement);
        // On annule toutes les requtes s'il y a eu un problme
        if($probleme || $message_erreur){
                $message_erreur .= "Oprations sur base de donnes annules<br>" ;

                pg_query("rollback") ;
                echo $message_erreur;
                //header("location:addChoix.php?theme=$theme&obj_positionnement=".exportObjet($current_positionnement)."&dynamique=$dynamique&nb_choix=$nb_choix&nb_questions=$nb_questions&theme=$theme&mode=$mode");
                exit();
        }
        else{
                pg_query("commit") ;
                header("location:addChoix.php?theme=$theme&obj_positionnement=".exportObjet($current_positionnement)."&dynamique=$dynamique&nb_choix=$nb_choix&nb_questions=$nb_questions&theme=$theme&mode=$mode");
               	exit();
        }

}
//--------------------------------------------------
// 			RECUPERATION DONNEES
//--------------------------------------------------
//if(empty($mon_positionnement))$current_positionnement=new Positionnement($id);
//else $current_positionnement=&$mon_positionnement;

// nom du positionnement
$nom_positionnement=$current_positionnement->getLibelle();

//les max pour les positionnements dynamique
$max_qcms=pg_num_rows(get_theme_qcms($theme));
$max_blancs=pg_num_rows(get_theme_ftbs($theme));

$num_bareme=$current_positionnement->getBareme();
//$current_positionnement->initChoix();

$current_positionnement_nb_choix=$current_positionnement->getNbConfiguredObjReponses();
$c_span=4; // a remettre a 5 qd les colonnes de niveau seront ajoutes
if(!$dynamique)$c_span--;

//on initialise les nombres max des evaluations a generer
$nb_max_qcms=0;
$nb_max_ftbs=0;


//--------------------------------------------------
// 			AFFICHAGE
//--------------------------------------------------
if($current_positionnement->getType() == get_evaluation_type_old_new("m")) {
	$col = $current_positionnement_nb_choix + 4;
	$type_positionnement = "qcm";
}
if ($current_positionnement->getType() == get_evaluation_type_old_new("o")) {
	$col = 4;
	$type_positionnement = "sondage";
}
$nom_positionnement = $current_positionnement->toString();

if ($mode == 2 && $current_positionnement_nb_choix == 0)
	$titre = "$MSG_1803<br><i><font color=\"blue\">\"$nom_positionnement\"</font></i> de type $type_positionnement";
else {
	$titre = "$MSG_1804<br><i><font color=\"blue\"> \"$nom_positionnement\"</font></i> de type $type_positionnement";
//	$mode = 1;
}
    
//indique qu'il faut executer la fonction
$print_javascript_theme_media=1;
$javascriptFILE="./commun/javascript_test.php";

$styleCSS="../style/".MY_STYLE."/ressourcesPedagogiques.css";
$fonctionONLOAD="initForm2('choix')";
require ('../entete.php3') ;


if(isset($message_erreur)&&($message_erreur!="")){
        print("<table class=\"tableau_message\"><tr><td>$message_erreur</td></tr></table><br>");
}
print("
<br>
<form name=\"choix\" method=\"post\" action=\"addChoix.php\">
<table class=\"tableau_normal\" border=0>");

//LIBELLES COLONNES
print("
        <tr>
            <th><b>$MSG_606</b></th>
            <th><b>$MSG_297</b></th>");

if($dynamique)
{
    print("
            <th>
                  <table>
                        <tr>
                                <th colspan=\"3\"><b>$MSG_1805</b></th>
                        </tr>
                        <tr>
                                <th><b>$MSG_547</b></th>
                                <th><b>|</b></td>
                                <th><b>$MSG_1201</b></th>
                        </tr>
                  </table>
          </th>");
}

print("
        <th><b>$FORM_1</b></th>
    </tr>");


// LIGNES DE CHOIX
for($i=1; $i<=$nb_choix; $i++){
	
    $classcolor=($i%2==0||$i==0?"couleur1":"couleur2");
    
    if($current_positionnement_nb_choix>=$i){
    	
        $current_rep = $current_positionnement->getObjReponses($i) ;
        print_rr($current_rep);
        // Un input type hidden pour modifier et non pas insrer  la soumission du formulaire
        print("<input type=\"hidden\" name=\"modif$i\" value=\"".$current_rep->getId()."\">");
    }
    else {
    	
        $current_rep = new Choix(0,$current_positionnement->getType(),"Reponse n$i") ;
    }
    
    // taille chapeau et exo gen qcm et blanc pour le choix courant
    $config_qcm=$current_rep->getConfigEvaluationsType(TYPE_EVALUATION_QCM);
    $config_ftb=$current_rep->getConfigEvaluationsType(TYPE_EVALUATION_FTB);
    $taille_chapeau_qcm=$config_qcm[1];
    $taille_chapeau_blanc=$config_ftb[1];
    $taille_gen_qcm=$config_qcm[0];
    $taille_gen_blanc=$config_ftb[0];
    
    //on positionne les nombres max des evaluations a generer
    if($nb_max_qcms<$taille_chapeau_qcm)$nb_max_qcms=$taille_chapeau_qcm;
    if($nb_max_qcms<$taille_gen_qcm)$nb_max_qcms=$taille_gen_qcm;
    if($nb_max_ftbs<$taille_chapeau_blanc)$nb_max_ftbs=$taille_chapeau_blanc;
    if($nb_max_ftbs<$taille_gen_blanc)$nb_max_ftbs=$taille_gen_blanc;
    
    //le media du choix
   //$current_rep_media =& $current_positionnement->getObjElementMedia($current_rep->getId());
    $current_rep_media=$current_rep->getMedia();
     if(!empty($current_rep_media)){
     	$c_med_id=$current_rep_media->getId();	
     	$c_med_largeur=$current_rep_media->getLargeur();	
     	$c_med_hauteur=$current_rep_media->getHauteur();	
     }

    if($current_positionnement_nb_choix){
        print("<tr class=\"$classcolor\">");
        for($j=0; $j<$c_span-2; $j++){
            print("<td>&nbsp;</td>");
        }
        print("
            <td colspan=\"2\" align=\"right\"><a class=\"action\" href=\"#\" onClick=\"alert('option en dveloppement');\">$MSG_1806</a></td>
        </tr>
        ");
    }


    print("
    <tr class=\"$classcolor\">
        <td>$MSG_303 $i : <input type=\"text\" name=\"lib_choix$i\" value=\"".htmlentities($current_rep->getLibelle(),ENT_QUOTES,CHARSET)."\"/></td>");
        //MEDIA
        print("
        <td>
            <table>
                <tr>
                    <td colspan=\"2\" nowrap>
                        <select name=\"media$i\" onchange=\"javascript:charger_tailleSWF($i,'choix');\">\n
                           <option value=\"\">$MSG_1456</option>\n
                            ");
                            //$resmedia=pg_query("select num_fic,lower(nom_fic) AS minnom from ficmediaqcm where num_themedir=".$current_positionnement->getTheme()."  order by minnom;");
                            $resmedia=get_theme_medias_evaluations($theme);
                            $nbmedia=pg_numrows($resmedia);
                            for($j=1;$j<=$nbmedia;$j++){
                                $rowmedia=pg_fetch_row($resmedia);
                                print("
                                <option value=\"".$rowmedia[0]."\"
                                ");
                                if(!empty($current_rep_media)&&$current_rep_media->getId()==$rowmedia[0])
                                    echo ' selected';
                                print(">".$rowmedia[1]."</option>\n");
                            }
                            print ("
                       </select>
                </td>
            </tr>
            ");
            //TAILLE .swf
            print("
            <tr>
                <td nowrap>$MSG_1222 : <input type=\"text\" name=\"largeur$i\" size=\"4\" value=\"$c_med_largeur\">&nbsp;&nbsp;</td>
                <td nowrap>$MSG_1223 : <input type=\"text\" name=\"hauteur$i\" size=\"4\" value=\"$c_med_hauteur\"></td>
            </tr>
        </table>
    </td>
    ");
     //SELECTION NB QUESTIONS GENEREES
    if($dynamique){
        print("
        <td>
            <table>
                <tr>
                    ");
                    //choix du nombre de qcms generes
                    print("
                    <td>
                        <select name=\"nb_exercices_genQCMS$i\" onChange=\"javascript:verifNbExoGen(document.choix,$i, this, '$nb_choix', 'QCMS', '$nb_questions', '$max_qcms' );\">
                        ");
                        for($o=0;$o<=$max_qcms;$o++){
                            print(" <option value=\"$o\"");
                            if($taille_gen_qcm==$o)
                                echo ' selected';
                            print(">$o</option>\n");
                        }
                        print("
                        </select>
                      <input  type=\"checkbox\" name=\"dynamiqueQCMS$i\" value=\"1\" onClick=\"SetDynamique(document.choix,$i, 'QCMS', '$nb_choix');\"
                    ");
                    if($taille_chapeau_qcm>0)
                        print(" checked");
                    print("/>
                </td>");
                //choix du nombre de Blancs gnrs
                print("
                <td>
                    <select name=\"nb_exercices_genBLANCS$i\" onChange=\"javascript:verifNbExoGen(document.choix,$i, this, '$nb_choix', 'BLANCS', '$nb_questions', '$max_blancs' );\">
                    ");
                    for($u=0;$u<=$max_blancs;$u++){
                        print(" <option value=\"$u\"");
                        if($taille_gen_blanc==$u)
                            echo ' selected';
                        print(">$u</option>\n");
                    }
                    print("
                    </select>
                    <input type=\"checkbox\" name=\"dynamiqueBLANCS$i\" value=\"1\" onClick=\"SetDynamique(document.choix,$i, 'BLANCS', '$nb_choix')\"
                        ");
                        if($taille_chapeau_blanc>0)
                            print(" checked");
                        print("/>
                    </td>
                </tr>
                <tr>");
                //choix de la taille du chapeau de QCMs

                print("
                    <td><div id=\"div_dynamiqueQCMS$i\">
                        $MSG_1807&nbsp;<!--<font color=\"#ff0000\">$taille_chapeau_qcm</font>&nbsp;-->
                        <select name=\"nb_exercices_chapQCMS$i\" onChange=\"javascript:verifNbExoGen(document.choix,$i, this, '$nb_choix', 'QCMS', '$nb_questions', '$max_qcms' );\">
                        ");

                        for($o=0;$o<=$max_qcms;$o++){
                        	
                        	$selchap="";
                        	if($o==$taille_chapeau_qcm)$selchap="selected";
                            print("<option value=\"$o\" $selchap>$o</option>\n");
                        }
                        print("
                        </select>
                        </div>
                    </td>
                    ");
                    //choix de la taille du chapeau de Blancs
                    print("
                    <td><div id=\"div_dynamiqueBLANCS$i\">
                        $MSG_1807&nbsp;<!--<font color=\"#ff0000\">$taille_chapeau_blanc</font>&nbsp;-->
                        <select name=\"nb_exercices_chapBLANCS$i\" onChange=\"javascript:verifNbExoGen(document.choix,$i, this, '$nb_choix', 'BLANCS', '$nb_questions', '$max_blancs' );\">
                        ");
                        for($o=0;$o<=$max_blancs;$o++){
                            print(" <option value=\"$o\"");
                            if($taille_chapeau_blanc==$o)
                                echo ' selected';
                            print(">$o</option>\n");
                        }
                        print("
                        </select>
                    </td>
                       </tr> ");
                //BAREME
                if(!empty($current_rep))$c_bareme=$current_rep->getBareme();
                
                print("
                <tr>
                    <td colspan=\"2\">
                        <select name=\"bareme$i\">
                        <option value=\"0\" >$MSG_1394</option>
                        ");
                        $result=get_plateforme_baremes();
                        while($row=pg_fetch_array($result)){
                            echo '<option value="'.$row[0].'"';
                            if($c_bareme==$row[0])
                                echo ' selected';
                            echo '>'.$row[1]."</option>\n";
                        }
                        print("
                        </select>
                        </div>
                    </td>
                </tr>");
	print("
        </table>
    </td>
    ");
    }
//    if($current_positionnement->getType()==get_evaluation_type_new_old('q')){
//        print("
//        <td><a class=\"action\" href=\"\" >$FORM_4</a></td>
//        ");
//    }
//    else
     	print("<td>&nbsp;</td>");
    print("</tr>");
}

// Mode modification
if($current_positionnement_nb_choix)
{
    $classcolor=($classcolor=="couleur1"?"couleur2":"couleur1");
    // Un lien qui recharge la page mais avec un champ texte en plus en bas
    print("
    <tr class=\"$classcolor\">
    <td colspan=\"$c_span\" align=\"center\">
    <a class=\"action\" href=\"addChoix.php?id=$id&theme=$theme&dynamique=$dynamique&nb_questions=$nb_questions&nb_choix=".($nb_choix+1)."\">$MSG_496</a></td>
    </tr>
    ");
}
print("
		<tr class=\"$classcolor\">
			<td colspan=\"$c_span\" align=\"center\">
				<input type=\"hidden\" name=\"obj_positionnement\" value=\"".exportObjet($current_positionnement)."\"/>
				<input type=\"hidden\" name=\"theme\" value=\"$theme\"/>
				<input type=\"hidden\" name=\"dynamique\" value=\"$dynamique\"/>
				<input type=\"hidden\" name=\"nb_questions\" value=\"$nb_questions\"/>
				<input type=\"hidden\" name=\"nb_max_qcms\" value=\"$nb_max_qcms\"/>
				<input type=\"hidden\" name=\"nb_max_ftbs\" value=\"$nb_max_ftbs\"/>
				<input type=\"hidden\" name=\"nb_choix\" value=\"$nb_choix\"/>
				<input type=\"hidden\" name=\"mode\" value=\"$mode\"/>");
				
print("
				<input type=\"submit\" name=\"sub_choix\" value=\"$MSG_1808\"/>") ;

// Bouton pour passer  la suite de la cration du positionnement
if($current_positionnement_nb_choix == 0)
    $disa = "disabled" ;
else {
    $disa = "" ;
}
print("
				<input type=\"submit\" name=\"suite\" value=\"$MSG_1809\" $disa />
			</td>
		</tr>");

print("
	</table>
</form>");
require("../piedpage.php3");
?>