<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Action : Ajout / Modification d'un positionnement
 * Donnes reues :
 * - $mode : 2 -> ajout (insertion)
 *                 1 -> edition (modification)
 * - $num_positionnement (si mode 1)
 * 
 * @package positionnement
 */ 

//--------------------------------------------------
// 			INITIALISATION
//--------------------------------------------------
require ("../dbpostgres.php3");
connecteDB();
require ("$chemin_bo/lib/lib_positionnement.php");

//--------------------------------------------------
// 			VALIDATION DU FORMULAIRE
//--------------------------------------------------

if ($posted == 1) {
	// On rcupre les message d'erreur dans une variable
	ob_start();
	pg_query("begin");
	
	// Calcul du chronomtre pour le positionnement
	if ($chrono != null) { //pas de chrono
		if ($chrono == 0) //le temps est saisi pour chacune des questions du positionnement
			$chrono = - ($heure * 3600 + $minute * 60 + $seconde);
		if ($chrono == 1) //le temps est saisi pour la totalit du positionnement
			$chrono = $heure * 3600 + $minute * 60 + $seconde;
	}
	//Calcul du chrono des evaluations gnrs
	if ($chrono_gen != null) { //pas de chrono
		if ($chrono_gen == 0) //le temps est saisi pour chacune des questions gnres pour le positionnement
			$chrono_gen = - ($heure_gen * 3600 + $minute_gen * 60 + $seconde_gen);
		if ($chrono_gen == 1) //le temps est saisi pour la totalit du positionnement
			$chrono_gen = $heure_gen * 3600 + $minute_gen * 60 + $seconde_gen;
	}

	// Rcupration du bareme ou cration SI type=='q'
	if ($type == get_evaluation_type_old_new('m')) {
		
		//si le type est qcm on a des checkbox 
		$radio=false;
		
		// Cration d'un nouveau barme pour l'occasion
		if ($new_bareme) {
			$bareme = set_bareme(addslashes($libel_bar), $rep_bonne, $rep_fausse, $rep_abs, 0);
		} else
			$bareme = $choix_bareme;
	}else{
		//si le type est qcm on a des checkbox 
		$radio=true;
	}

	// Cration mdia
	if(!empty($media0))$new_media = new Media($media0, $hauteur0, $largeur0);

	// Construction de l'objet 
	//si mofif
	if ($mode == 1) {
		$new_positionnement = new Positionnement($num_positionnement, $type, $titre, $chrono, $chrono_gen, $bareme, $radio, $new_media);
	}
	//si creation
	else {
		$new_positionnement = new Positionnement(0, $type, $titre, $chrono, $chrono_gen, $bareme, $radio, $new_media);
	}


	$message_erreur = ob_get_contents();
	ob_end_clean();
	
	print_rr($new_positionnement);
	
	// Soit on passe  la suite
	if (empty ($message_erreur)) {
		pg_query("commit");
		header("location:addChoix.php?theme=$theme&obj_positionnement=".exportObjet($new_positionnement)."&dynamique=$dynamique&nb_choix=$nb_choix&nb_questions=$nb_questions&mode=$mode") ;
		exit();
	}
	// Soit on recharge la page en affichant l'erreur
	else {
		pg_query("rollback");
		echo "ERREUR:".$message_erreur;
	//	header("location:addPositionnement.php?message_erreur=" . urlencode(addslashes($message_erreur)) . "&mode=$mode");
		exit ();
	}

}

//--------------------------------------------------
//              RECUPERATION DONNEES
//--------------------------------------------------
//si il n'y a pas eut d'insertion ou de maj
if (empty ($new_positionnement)) {

	// passage en mode dition
	if (!empty($num_positionnement)) {
		$current_positionnement = new Positionnement($num_positionnement);
//		$current_positionnement->initQuestions();
//		$current_positionnement->initChoix();
		// recup du theme du positionnement
		$numtheme = $current_positionnement->getTheme();

	}
	//passage en mode cration: On construit un objet sans attributs
	else {
		$current_positionnement = new Positionnement();
		//$current_positionnement->initQuestions();
		//$current_positionnement->initChoix();
	}
} else {
	$current_positionnement =& $new_positionnement;
}

//RECUP DU MEDIA
if ($mode == 1) {
	$obj_media = $current_positionnement->getMedia();
	// debug
	if ($obj_media) {
		$num_media = $obj_media->getId();
		$nom_media = $obj_media->toString();
		$hauteur = $obj_media->getLongueur();
		$largeur = $obj_media->getLargeur();
		// debug
		//echo "num_media=$num_media et nom_media=$nom_media numtheme=$numtheme<br>";
	}
}

//RECUP CHRONO POSITIONNEMENT
$cur_positionnement_chrono = $current_positionnement->getChrono();
if ($cur_positionnement_chrono < 0)
	$v_cur_positionnement_chrono = -1 * $cur_positionnement_chrono;
else
	$v_cur_positionnement_chrono = $cur_positionnement_chrono;

$time = get_hms($v_cur_positionnement_chrono);

//RECUP CHRONO GEN
if ($current_positionnement->getChronoSerieGenere() != null) {
	$chrono_gen = $current_positionnement->getChronoSerieGenere();
	// si chrono individuel on remet la valeur du chrono en positif
	if ($chrono_gen < 0)
		$chrono_gen *= -1;
}
$time_gen = get_hms($chrono_gen);


print_rr($current_positionnement);
//--------------------------------------------------
// 			AFFICHAGE
//--------------------------------------------------
if ($mode == 2)
	$titre = $MSG_1795;
else
	$titre = $MSG_1796;
/*echo "<pre>";
print_r($current_positionnement);
echo "</pre>";*/
//indique qu'il faut executer la fonction
$print_javascript_theme_media = 1;
$javascriptFILE = "./commun/javascript_test.php";

$styleCSS = "../style/" . MY_STYLE . "/ressourcesPedagogiques.css";
$fonctionONLOAD = "initForm('editor')";
if (!empty ($message_erreur)) {
	$fonctionONLOAD .= ";alert('" . addslashes($message_erreur) . "')";
	//print("<div style=\"erreur\">$message_erreur</div>");
}
require ('../entete.php3');
//echo "mode=$mode<br>";

print ("
<form name=\"editor\" action=\"addPositionnement.php\" method=\"post\">
<table class=\"tableau_normal\">");

//SELECTION THEME
print ("
	<tr class=\"couleur1\">
	    <td>$MSG_550 :</td>
	    <td>");
$disable = "";
if ($mode == 1)
	$disable = " disabled";
print ("
	        <select name=\"theme\" $disable onChange=\"javascript:charger_medias(0, document.editor);document.editor.dynamique[1].checked=true;\">
	        <option value=\"null\">$MSG_215</option>\n");

$result = get_themes();
while ($row = pg_fetch_array($result)) {
	echo "<option value=\"" . $row[0] . "\"";
	if ($theme == $row[0])
		echo " selected";
	echo ">" . $row[1] . "</option>\n";
}
print ("
            </select>
    	</td>
	</tr>");
	
//LIBELLE
print ("
	<tr class=\"couleur2\">
	    <td>$MSG_590 :</td>
	    <td><input type=\"text\" name=\"titre\" value=\"" . $current_positionnement->toString() . "\"/></td>
	</tr>");
	
//DYNAMIQUE
print ("
	<tr class=\"couleur1\">
	    <td>$MSG_1797 ?</td>
	    <td>");

// em mode dition, on rcupre le type de positionnement (dynamique ou non)
if ($mode == 1)
	$dynamique = $current_positionnement->isDynamique();

print ("<input ");
if (($mode == 1) && $dynamique == 1) {
	print (" checked ");
} else {
	if (($mode == 1) && $dynamique != 1)
		print (" disabled ");
}

print (" type=\"radio\" name=\"dynamique\" value=\"1\" onClick=\"NbQcm_Blanc(document.editor.theme.value);\">$MSG_286<br>
        <input");
if (($mode == 1) && $dynamique == 1) {
	print (" disabled ");
} else {
	if (($mode == 1) && $dynamique != 1)
		print (" checked ");
}

print (" type=\"radio\" name=\"dynamique\" value=\"0\" onClick=\"document.getElementById('chrono_exo_gen').style.display='none';\">$MSG_287
	    </td>
	</tr>");

//MEDIA
print ("
	<tr class=\"couleur2\">
	    <td>$MSG_297 : <!--<font color=\"#ff0000\">$nom_media</font>--></td>
	    <td>
	        <table>
	            <tr>
	                <td>
	                    <select name=\"media0\" onchange=\"javascript:charger_tailleSWF(0,'editor');\">
	                        <option value=\"\">$MSG_1456</option>");
if ($numtheme > 0) {
	//recup des media du theme
	$resmedia = get_theme_medias_evaluations($numtheme);
	$nbmedia = pg_numrows($resmedia);
	for ($m = 0; $m < $nbmedia; $m++) {
		$rowmedia = pg_fetch_row($resmedia, $m);
		if ($rowmedia[0] == $num_media)
			print ("
                            <option value=\"$rowmedia[0]\" selected>$rowmedia[1]</option>");
		else
			print ("
        					<option value=\"$rowmedia[0]\">$rowmedia[1]</option>");
	}
}

print ("
                        </select>
					</td>");

//TAILLE .swf
print ("
	                <td nowrap>
		                $MSG_1222 : <input type=\"text\" name=\"largeur0\" size=\"4\" value=\"$largeur\" onChange=\"VerifTaille('largeur0');\">&nbsp;&nbsp;
		                <br>
		                <br>
		                $MSG_1223 : <input type=\"text\" name=\"hauteur0\" size=\"4\" value=\"$hauteur\" onChange=\"VerifTaille('hauteur0');\">
	                </td>
				</tr>
			</table>
		</td>
	</tr>");

//NB QUESTIONS
print ("
	<tr class=\"couleur1\">
	    <td>$MSG_492 :</td>
	    <td>
	        <select name=\"nb_questions\" >");
if ($current_positionnement->getNbConfiguredObjQuestions() == 0) {
	for ($i = 1; $i <= 100; $i++) {
		print (" 
				<option value=\"$i\">$i</option>");
	}

} else {
	print ("
				<option selected value=\"" . $current_positionnement->getNbConfiguredObjQuestions() . "\">" . $current_positionnement->getNbConfiguredObjQuestions() . "</option>");
}
print ("
        	</select>
	    </td>
	</tr>");

//NB REPONSES
print ("
	<tr class=\"couleur2\">
	    <td>$MSG_497 :</td>
	    <td>
	            <select name=\"nb_choix\" >");
if ($current_positionnement->getNbConfiguredObjReponses() == 0) {
	// nombre de rponse ... max ?
	for ($i = 2; $i <= 8; $i++) {
		print ("
					<option value=\"$i\"");

		if ($current_positionnement->getNbConfiguredObjReponses() == $i)
			echo ' selected';

		print (">$i</option>");
	}
} else {
	print ("
					<option selected value=\"" . $current_positionnement->getNbConfiguredObjReponses() . "\">" . $current_positionnement->getNbConfiguredObjReponses() . "</option>");
}
print ("
            	</select>
		    </td>
		</tr>");

//TYPE POSITIONNEMENT
print ("
<tr class=\"couleur1\">
    <td>$MSG_608 :</td>
    <td><input");

if ($current_positionnement->getType() == get_evaluation_type_old_new('o')) {
	print (" checked ");
} else {
	if ($current_positionnement->getType() == get_evaluation_type_old_new('m'))
		print (" disabled ");
}

print (" type=\"radio\" name=\"type\" value=\"".get_evaluation_type_old_new('o')."\" OnClick=\"javascript:SetBareme();\">$MSG_1798<br>
            <input");

if ($current_positionnement->getType() == get_evaluation_type_old_new('m')) {
	print (" checked ");
} else {
	if ($current_positionnement->getType() == get_evaluation_type_old_new('o'))
		print (" disabled ");
}

print (" type=\"radio\" name=\"type\" value=\"".get_evaluation_type_old_new('m')."\"  OnClick=\"javascript:SetBareme();\">$MSG_1799<br>
    </td>
</tr>");

//CHRONOS
print ("
<tr class=\"couleur2\">
    <td>$MSG_2300 :</td>
    <td>
            <table width=\"100%\">");


//CHRONO POSITIONNEMENT
print("
				<tr>
					<td nowrap><br>
						<b>$MSG_1801 :</b>
			            <br>");

print ("<input type=\"radio\" name=\"chrono\" value=\"null\" ");

if (empty ($cur_positionnement_chrono) || $cur_positionnement_chrono == 'NULL')
	echo "checked ";

print (" OnClick=\"SetChrono()\">$MSG_1386<br>
            <input type=\"radio\" name=\"chrono\" value=\"0\" ");

if ($cur_positionnement_chrono < 0)
	echo "checked ";

print (" OnClick=\"SetChrono()\">$MSG_2169<br>
            <input type=\"radio\" name=\"chrono\" value=\"1\" ");

if ($cur_positionnement_chrono > 0)
	echo "checked ";

print (" OnClick=\"SetChrono()\">$MSG_2168<br>
            <br>");

if (empty ($cur_positionnement_chrono) || $cur_positionnement_chrono == 'NULL')$disabled="disabled";
else $disabled="";  

// chrono positionnement
$hms_form_name=null;
$hms_select_heure_name="heure";
$hms_select_heure_value=$time["heure"];			
$hms_select_minute_name="minute";
$hms_select_minute_value=$time["minute"];
$hms_select_seconde_name="seconde";
$hms_select_seconde_value=$time["seconde"];
$hms_units=true;
$hms_columns=false;
if ($current_positionnement->getChrono() == null)$hms_disable_selects=true;
else $hms_disable_selects=false; 
include("$chemin_bo/lib_graphique/selects/selectHMS.php");
          
print ("
						<br><br>
					</td>
				</tr>");
            
//CHRONO SERIE GENEREE            
print ("          
				<tr>
					<td nowrap>
						<div id=\"chrono_exo_gen\"");

if (($mode == 2) && $dynamique)
	print (" style='display:block'");
if(($mode==1)&&!$current_positionnement->isDynamique())
	print (" style='display:none'>");
print ("><b>$MSG_1800 :</b>

            <br>
            <input type=\"radio\" name=\"chrono_gen\" value=\"null\"");
if ($current_positionnement->getChronoSerieGenere() == null)
	print (" checked ");
print (" onClick=\"setChrono_gen();\">$MSG_1386<br>
            <input type=\"radio\" name=\"chrono_gen\" value=\"0\"");
if ($current_positionnement->getChronoSerieGenere() < 0)
	print (" checked ");
print (" onClick=\"setChrono_gen();\">$MSG_2166<br>
            <input type=\"radio\" name=\"chrono_gen\" value=\"1\"");
if ($current_positionnement->getChronoSerieGenere() > 0)
	print (" checked ");
print (" onClick=\"setChrono_gen();\">$MSG_2167<br>

            <br>");

// chrono gen
$hms_form_name=null;
$hms_select_heure_name="heure_gen";
$hms_select_heure_value=$time_gen["heure"];			
$hms_select_minute_name="minute_gen";
$hms_select_minute_value=$time_gen["minute"];
$hms_select_seconde_name="seconde_gen";
$hms_select_seconde_value=$time_gen["seconde"];
$hms_units=true;
$hms_columns=false;
if ($current_positionnement->getChronoSerieGenere() == null)$hms_disable_selects=true;
else $hms_disable_selects=false; 
include("$chemin_bo/lib_graphique/selects/selectHMS.php");

print ("
        		    	</div>
    	        	</td>
	            </tr>
            </table>
    </td>
</tr>
<tr class=\"couleur1\">
    <td colspan=\"2\">
        <div id=\"option_bareme\">
        <table>
            <tr>
                <td>$MSG_293:</td>
                <td valign=\"top\">$MSG_1394:&nbsp;&nbsp;
                    <select name=\"choix_bareme\">
                    <option value=\"NULL\" >$MSG_1394</option>
                    ");

//$sql = "SELECT * FROM bareme ORDER BY libelle_bareme";
//$result = pg_query($sql);
$result = get_plateforme_baremes();
while ($row = pg_fetch_array($result)) {
	echo '<option value="' . $row[0] . '"';
	if ($current_positionnement->getBareme() == $row[0])
		echo ' selected';
	echo '>' . $row[1] . "</option>\n";
}
print ("
                    </select><br>
                    <table cellspacing=\"0\" cellpadding=\"5\" border=\"0\" align=\"left\" width=100%>
                        <tr>
                            <td><input type=\"checkbox\" name=\"new_bareme\" value=\"1\" OnClick=\"javascript:SetNewBareme();\">$MSG_1395</td>
                        </tr>
                        <tr>
                            <td align=\"center\">
                                <div id=\"div_new\">
                                <table border=\"0\" width=\"100%\">
                                    <tr>
                                        <td width=\"30%\" nowrap>$MSG_1435 :</td>
                                        <td colspan=\"2\" align=\"right\">&nbsp;&nbsp;&nbsp;<input type=\"text\" name=\"libel_bar\" value=\"$libel_bar\"></td>
                                    </tr>
                                    <tr>
                                        <td nowrap>$MSG_1432 :</td>
                                        <td width=\"10%\" align=\"center\"><b>+</b></td>
                                        <td width=\"50%\" align=\"right\"><input type=\"text\" name=\"rep_bonne\" value=\"$rep_bonne\"></td>
                                    </tr>
                                    <tr>
                                        <td nowrap>$MSG_1433 :</td>
                                        <td align=\"center\"><b>-</b></td>
                                        <td align=\"right\"><input type=\"text\" name=\"rep_fausse\" value=\"$rep_fausse\"></td>
                                    </tr>
                                    <tr>
                                        <td nowrap>$MSG_1434 :</td>
                                        <td align=\"center\"><b>-</b></td>
                                        <td align=\"right\"><input type=\"text\" name=\"rep_abs\" value=\"$rep_abs\"></td>
                                    </tr>
                                </table>
                                </div>
                            </td>
                        </tr>
                </table>
            </td>
        </td>
    </tr>
</table>
</div>
</td>
</tr>
<tr class=\"couleur1\">
    <td colspan=\"2\" align=\"center\">
        ");
if ($mode == 1) {
	print ("
		
		                    <input type=\"hidden\" name=\"num_positionnement\" value=\"$num_positionnement\">
		                    <input type=\"hidden\" name=\"dynamique\" value=\"$dynamique\">
		                    ");
}

print ("
        <input type=\"hidden\" name=\"posted\" value=\"1\">
        <input type=\"hidden\" name=\"mode\" value=\"$mode\">
        <input type=\"button\" name=\"valider\" value=\"$MSG_1802\" onClick=\"javascript:VerifForm();\"/><br><br>
    </td>
</tr>
</form>
</table>
<br>
<br>
<a class=\"retour\"href=\"./index.php\">$MSG_37</a>");
require ("../piedpage.php3");
?>