<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Ajouter les questions de positionnement  un positionnement.
 *  @package positionnement
 */
//--------------------------------------------------
// 			INITIALISATION
//--------------------------------------------------
require ("../dbpostgres.php3");
connecteDB();
require ("$chemin_bo/lib/lib_positionnement.php");

//construit l'objet positionnement
if(empty($obj_positionnement)){
        die ("Objet Positionnement manquant.<br>");
}else{
	$current_positionnement=importObjet($obj_positionnement);
}
if(empty($current_positionnement))
        die ("Objet Positionnement Non Valide.<br>");

$type = $current_positionnement->getType();

//test des actions sur le script
if ($action=="supprimer" && !isset ($sub_questions)) {
		//echo "suppression";
		$current_positionnement->retireQuestion($num_question);
		unset($action);
}
//print_rr($current_positionnement);
//--------------------------------------------------
// 			VALIDATION DU FORMULAIRE
//--------------------------------------------------
if (isset ($sub_questions)) {
	
	// Bloque l'envoi d'affichage
	ob_start() ;
	$probleme = false;

	pg_query("begin");
	$i = 1;
	// Parcours des rponses
	while ($i <= $nb_questions ) {
		// Rcupration des variables du formulaire
		$var = "lib_question" . $i;
		$lib_question = $$var;
		$var = "media" . $i;
		$media = $$var;
		$var = "largeur" . $i;
		$largeur = $$var;
		$var = "hauteur" . $i;
		$hauteur = $$var;
		$var = "interpretation" . $i;
		$interpretation = $$var;
		$var = "modif" . $i;
		$modif = $$var;
		//

		if ($type == get_evaluation_type_old_new("q")) {

			for ($j = 1; $j <= $nb_choix; $j++) {
				$var = "vrai_faux-" . $i . "-" . $j;
				$vrai_faux = $$var;

				$tab_vrai_faux[$j-1][0] = $current_positionnement->sesChoix[$j-1]->getId();
				$tab_vrai_faux[$j-1][1] = $vrai_faux;
			}
		}
		// si mode dition
		if ($modif) {
		
			$current_question=&$current_positionnement->getObjQuestions($i);
			$current_question->setLibelle($lib_question);
			$current_question->setInterpretationHTML($interpretation);
			//on fait un update
			$current_question->updateToDB(&$message_erreur);
		}
		// sinon si mode cration
		else {
			if($media){
				$obj_media=new Media($media, $hauteur, $largeur);
			}
			else{
				$obj_media=null;
			}
			$current_question = new Question(0, $lib_question, get_evaluation_type_new_old_r($type), $interpretation, $obj_media);
			$id_current_question=$current_question->insertToDB($theme,&$message_erreur);
			if(!$id_current_question)die("Erreur lors de la creation de la question du positionnement.<br>".$message_erreur);
			$res_set=$current_positionnement->setObjQuestion(&$current_question);
			if(!$res_set)die("Erreur lors de l'affectation de la question au positionnement.");
		}
	
		$i++;
	}
	$message_erreur = ob_get_contents();
	ob_end_clean();
	// On annule toutes les requtes s'il y a eu un problme
	if (!empty($message_erreur)) {
		$message_erreur .= "$ERROR_91<br>";
		pg_query("rollback");
	} else {
		pg_query("commit");

	}
}
//print_rr($current_positionnement);
if (isset ($suite)) {

	//INSERTION OU MODIFICATION DU POSITIONNEMENT
	// Bloque l'envoi d'affichage
	ob_start() ;
	$probleme = false;

	pg_query("begin");
	
	if($mode==2){	//creation du positionnement
		$id_positionnement=$current_positionnement->insertToDB($theme,&$message_erreur);
		if(!$id_positionnement){
			die("Erreur lors de l'enregistrement du positionnement.");
		}
	}else{ //dition du positionnement
		$res_update=$current_positionnement->updateToDB(&$message_erreur);
		if(!$res_update){
			die("Erreur lors de la mise  jour du positionnement.");
		}
	}

	$message_erreur = ob_get_contents();
	ob_end_clean();
	// On annule toutes les requtes s'il y a eu un problme
	if (!empty($message_erreur)) {
		$message_erreur .= "$ERROR_91<br>";
		echo "$message_erreur<br>";
		pg_query("rollback");
	} else {
		pg_query("commit");

	}
	
	//REDIRECTION 
	//si le positionnement est dynamique on continue (choix des Questions geners)
	if ($dynamique) {
		//echo "dynamique";
		header("location:assocEvaluations.php?theme=$theme&obj_positionnement=".exportObjet($current_positionnement)."&dynamique=$dynamique&nb_choix=$nb_choix&nb_questions=$nb_questions");
		exit ();
	}
	//si le positionnement n'est pas dynamique on s'arrete l
	else {

		echo "pas dynamique";
		//header("location:index.php?id=$id&dynamique=$dynamique&nb_choix=$nb_choix&nb_questions=$nb_questions");
		exit ();
	}
}
//}

//--------------------------------------------------
// 			RECUPERATION DONNEES
//--------------------------------------------------
$current_positionnement_nb_questions=$current_positionnement->getNbConfiguredObjQuestions();

if($type == get_evaluation_type_old_new("m")) {
	$col = $current_positionnement_nb_choix + 4;
	$type_positionnement = "qcm";
}
if ($type == get_evaluation_type_old_new("o")) {
	$col = 4;
	$type_positionnement = "sondage";
}
$nom_positionnement = $current_positionnement->getLibelle();

//les nombres max d'evaluations disponibles pour les positionnements dynamique et l'ajout de question
$max_qcms=pg_num_rows(get_theme_qcms($theme));
$max_ftbs=pg_num_rows(get_theme_ftbs($theme));
$nb_max_ftbs_pris=2;
$nb_max_qcms_pris=2;

//--------------------------------------------------
// 			AFFICHAGE
//--------------------------------------------------

if ($mode == 2 && $current_positionnement_nb_questions == 0)
	$titre = "$MSG_1810<br><i><font color=\"blue\">\"$nom_positionnement\"</font></i> de type $type_positionnement";
else {
	$titre = "$MSG_1811<br><i><font color=\"blue\"> \"$nom_positionnement\"</font></i> de type $type_positionnement";
}
$javascriptFILE = "./commun/javascript_test.php";
$styleCSS = "../style/" . MY_STYLE . "/ressourcesPedagogiques.css";
$fonctionONLOAD = "initForm2('questions')";
require ('../entete.php3');
//LES MESSAGES D'ERREUR
if (isset ($message_erreur) && $message_erreur != "")
	print ("<table class=\"tableau_message\"><tr><td>$message_erreur</td></tr></table><br>");

print ("
<br>
<form name=\"questions\" method=\"post\">
<table class=\"tableau_espace\">
");

//LIBELLES COLONNES
print ("
<tr>
    <th>$MSG_1812</th>
    <th>$MSG_1454</th>
    <th>$MSG_297</th>
");

//COLONNES DE QUESTIONS POUR LES VRAI FAUX
if ($type == get_evaluation_type_old_new("m")) {
	
	for ($i = 1; $i <= $current_positionnement_nb_choix; $i++) {

		$current_reponse = & $current_positionnement->getChoix($i -1);

		print ("
	<th>
		" . htmlentities($current_reponse->toString() ,ENT_QUOTES,CHARSET). "
	</th>");

	}
}
print ("
    <th>$FORM_1</th>
  </tr>");

$current_questions =  $current_positionnement->getObjQuestions();

// LIGNES DES QUESTIONS
for ($i = 1; $i <= $nb_questions; $i++) {
	
	//INSERTION QUESTION
	print ("\n<!--------------DEBUT QUESTION $i-------------->\n");	

	$classcolor = ($i % 2 == 0 || $i == 0 ? "couleur1" : "couleur2");
	if ($current_positionnement_nb_questions >= $i) {
		$current_question =  $current_questions[$i-1];
		// un hidden pour modif
		print ("<input type=\"hidden\" name=\"modif$i\" value=\"" . $current_question->getId() . "\">");		
	} else{
		$current_question = new Question(0, "qn$i");
	}

	$libelle_question = htmlentities($current_question->toString(),ENT_QUOTES,CHARSET);
	$num_quest = $current_question->getId();
	$obj_media_qst = $current_question->getMedia();

	if ($obj_media_qst){
		$media_qst = $obj_media_qst->getLibelle();
		$num_media = $obj_media_qst->getId();
		$largeur=$obj_media_qst->getLargeur();
		$hauteur=$obj_media_qst->getHauteur();
	}
	else{
		unset($media_qst);
		unset($num_media);
		unset($largeur);
		unset($hauteur);
	}

	print ("
		<tr class=\"$classcolor\">");

	//LIBELLE REPONSE
	print ("
			<td>$MSG_292 $i :<br><br>
	    		<input type=\"text\" name=\"lib_question$i\" value=\"" . $libelle_question . "\"/>
	    	</td>");
	    
	//INTERPRETATION HTML
	if ($current_question->isInterpretationHTML()) {
		$checkedT = "checked";
		$checkedF = "";
	} else {
		$checkedT = "";
		$checkedF = "checked";
	}

	print ("
		<td>
		    <input type=\"radio\" name=\"interpretation$i\" value=\"1\" $checkedT >$MSG_286</input>
		    <br>
		    <br>
		    <input type=\"radio\" name=\"interpretation$i\" value=\"0\" $checkedF>$MSG_287</input>
	    </td>");
	    
	//MEDIA +TAILLE .swf
	print ("\n<td>
	    <select name=\"media$i\" onChange=\"javascript:charger_tailleSWF($i, 'questions');\">
	    ");
	$resfic = get_theme_medias_evaluations($theme);
	//$resfic=pg_query("select num_fic,lower(nom_fic) AS minnom from ficmediaqcm where num_themedir=".$current_positionnement->getTheme()." order by minnom;");
	$numresfic = pg_numrows($resfic);
	$sel="";
	if(empty($num_media)){
		$sel="selected";	
	}
	if ($numresfic > 0) {
		print "<option value=\"\" $sel>$MSG_247 $selmedia</option>\n";
	} else {
		print "<option value=\"\" $sel>$MSG_1456</option>\n";
	}
	for ($j = 0; $j < $numresfic; $j++) {
		$rowfic = pg_fetch_row($resfic, $j);
		if ($num_media == $rowfic[0])
			print "<OPTION VALUE=\"$rowfic[0]\" selected>$rowfic[1]</OPTION>\n";
		else
			print "<OPTION VALUE=\"$rowfic[0]\">$rowfic[1]</OPTION>\n";
	}
	print ("</select>");
	print ("<br><br>
	    $MSG_1222 : <input type=\"text\" name=\"largeur$i\" size=\"4\" value=\"$largeur\">&nbsp;&nbsp;
	    <br><br>
	    $MSG_1223 : <input type=\"text\" name=\"hauteur$i\" size=\"4\" value=\"$hauteur\">
	    </td>
	    ");
	//VRAI FAUX
	if ($type == get_evaluation_type_old_new("q")) {
		for ($j = 1; $j <= $current_positionnement_nb_choix; $j++) {
			$check = "";
			$image = "iconontraite.gif";
			if ($mode != 2) {
				// recup du champ 'juste' pour le couple question / reponse dans quest_rep
				$obj_reponse = $current_positionnement->getChoix($j -1);
				$num_reponse = $obj_reponse->getId();
				if (!empty($num_quest))$res_j=get_positionnement_question_positionnement_reponse_solution($current_positionnement->getId(), $num_quest, $num_reponse);
				if (!empty($num_quest)&&pg_num_rows($res_j)>0&&pg_fetch_result($res_j, 0, 3)=="t") {
					$check = "checked";
					$image = "icovalid.gif";
				} else {
					$check = "";
					$image = "iconontraite.gif";
				}
			}
			if ($check != "") {
				$checkvrai = "checked";
				$checkfaux = "";
			} else {
				$checkvrai = "";
				$checkfaux = "checked";
			}
			print ("\n<td class=\"ligne1\">
			            <input type=\"radio\" name=\"vrai_faux-$i-$j\" value=\"1\" $checkvrai>$MSG_304</input>
			            <br>
			            <br>
			            <input type=\"radio\" name=\"vrai_faux-$i-$j\" value=\"0\" $checkfaux>$MSG_305</input>
			            <br><br><div align=\"center\"><img src=\"../images/$image\" border=\"0\"></div>
			            </td>
			            ");
		}
	}

	//SUPPRESSION QUESTION 
	print ("\n<td>");
	
	//on peut supprimmer s'il reste au moins une question dans le test	
	if($nb_questions>1)print ("<a class=\"action\" href=\"./addQuestions.php?id=$id&dynamique=$dynamique&nb_choix=$nb_choix&nb_questions=" . ($nb_questions -1) . "&num_question=" . $current_question->getId() . "&action=supprimer&mode=$mode&nb_max_qcms=$nb_max_qcms&nb_max_ftbs=$nb_max_ftbs\" >$FORM_4</a>");
	else print (" <img src=\"../images/lock.gif\" onMouseOver=\"AffBulle('Il faut au moins une question pour le positionnement.')\" onMouseOut=\"HideBulle()\" border=\"0\">");
	    
	print ("</td>");
	print ("</tr>\n<!--------------FIN QUESTION $i-------------->\n");
}

//AJOUT QUESTION
$classcolor = ($classcolor == "couleur2" ? "couleur1" : "couleur2");
print ("
	\n<tr class=\"$classcolor\">
		<td colspan=\"$col\">
		<a class=\"action\" onclick=\"javascript:return ajoutQuestionPositionnement(document.questions,".$nb_questions.", ".$max_ftbs.", ".$max_qcms.");\" href=\"./addQuestions.php?&id=$id&dynamique=$dynamique&nb_choix=$nb_choix&nb_questions=" . ($nb_questions +1) . "&nb_max_qcms=$nb_max_qcms&nb_max_ftbs=$nb_max_ftbs\">$MSG_494</a>
</td>
	</tr>
");

// Bouton pour passer  la suite de la cration du positionnement
if ($current_positionnement_nb_questions == 0) {
	$disa = "disabled";
} else {
	$disa = "";
}
print ("
	<tr align=\"center\">
		<td colspan=\"" . (4 + $current_positionnement_nb_choix) . "\">
			<input type=\"hidden\" name=\"obj_positionnement\" value=\"".exportObjet($current_positionnement)."\"/>
			<input type=\"hidden\" name=\"dynamique\" value=\"$dynamique\"/>
			<input type=\"hidden\" name=\"nb_questions\" value=\"$nb_questions\"/>
			<input type=\"hidden\" name=\"nb_choix\" value=\"$nb_choix\"/>
            <input type=\"hidden\" name=\"mode\" value=\"$mode\"/>
			<input  type=\"submit\" name=\"sub_questions\" value=\"$MSG_1813\"  />
			<input type=\"submit\" name=\"suite\" value=\"$FORM_10\" $disa/>
			<input type=\"hidden\" name=\"nb_max_qcms\" value=\"$nb_max_qcms\"/>
			<input type=\"hidden\" name=\"nb_max_ftbs\" value=\"$nb_max_ftbs\"/>
		</td>
	</tr>");
print ("
</table>
</form>");
require ("../piedpage.php3");
?>