<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Cration d'un Test.
 * Un test est compos d'un ensemble de positionnements.
 * Ceux-ci peuvent etre de types diffrents (QCM, Sondages)
 * Dans le cas d'un Test dynamique, ses Positionnements le seront forcement, et
 * dans le cas contraire, les Positionnements associs peuvent tres dynamiques ou non dynamiques.
 * Un Test peut aussi tre continu, c'est a dire que l'on peut fusionner les chronos des 
 * Positionnements qui le composent. Cel consiste en une somme simple de tous les chronos, qu'ils soient valus ou non.
 * 
 * @package positionnement
 */

//--------------------------------------------------
// 			INITIALISATION
//--------------------------------------------------
require("../dbpostgres.php3");
$db=pg_connect("$server","","","","$nombase") ;
require ("$chemin_bo/lib/lib_positionnement.php");

//--------------------------------------------------
//                      VALIDATION DU FORMULAIRE
//--------------------------------------------------
if(isset($creer_test)){

        ob_start() ;
        $new_test = new Test("", $titre, $dynamique, $continue) ;

        $id_test = $new_test->insertToDB() ;

        $message_erreur = ob_get_contents() ;

        ob_end_clean() ;

        // Soit on passe  la suite
        if(empty($message_erreur)){

                header("location:addPositionnementsTest.php?num_test=$id_test") ;
        }
}

//---------------------------------------------------------
//              RECUPERATION DONNEES
//---------------------------------------------------------

if(isset($num_test))
{
        $current_test=new Test($num_test);
}
else
{
        $current_test=new Test();
}

//--------------------------------------------------
//                        AFFICHAGE
//--------------------------------------------------

$titre=$MSG_1844;
$javascriptFILE="./commun/javascript_test.php";
$styleCSS="../style/".MY_STYLE."/ressourcesPedagogiques.css";

require ('../entete.php3') ;

// Affichage d'un message d'erreur en cas de proplme (ne doit pas arriver : vrifications javascript !!!
if(isset($message_erreur)&&$message_erreur!=""){
        print("<table class=\"tableau_message\"><tr><td>$message_erreur</td></tr></table><br>");
}

print("
<br>
<form name=\"editor_liste\" action=\"addTest.php\" method=\"post\">
<table class=\"tableau_normal\">
        <tr class=\"couleur1\">
                <td>$MSG_590 :</td>
                <td><input type=\"text\" size=\"60\" name=\"titre\" value=\"".$current_test->toString()."\"/></td>
        </tr>
        <tr class=\"couleur2\">
                <td>$MSG_2484 :</td>
                <td><input type=\"checkbox\" name=\"dynamique\" value=\"true\"/></td>
        </tr>
        <tr class=\"couleur2\">
                <td>$MSG_1845 :</td>
                <td><input type=\"checkbox\" name=\"continue\" value=\"true\"/></td>
	</tr>
        <tr class=\"couleur1\">
                <td colspan=\"2\" align=\"center\"><input type=\"submit\" name=\"creer_test\" value=\"$MSG_1846\"/></td>
                <input type=\"hidden\" name=\"evaluation\" value=\"$evaluation\">
        </tr>
</form>
</table>
<br><br><a class=\"retour\" href=\"./index.php\">$MSG_37</a>
");

require("../piedpage.php3");
//define("VERSION", "9.0.0");
?>