<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Afficher les valuations associes aux QuestionsPositionnement et aux Choix
 * d'un positionnement si celui-ci est dynamique.
 * 
 * @package positionnement
 */ 
//--------------------------------------------------
// 			INITIALISATION
//--------------------------------------------------
//define("VERSION", "7.0.0");
require ("../dbpostgres.php3");
connecteDB();
require ("$chemin_bo/lib/lib_positionnement.php");

//construit l'objet positionnement
if(empty($obj_positionnement)){
        die ("Objet Positionnement manquant.<br>");
}else{
	$current_positionnement=importObjet($obj_positionnement);
}
if(empty($current_positionnement))
        die ("Objet Positionnement Non Valide.<br>");

//--------------------------------------------------
// 			VALIDATION DU FORMULAIRE
//--------------------------------------------------
if (isset($sub_questions)) {
	header("location:index.php?id=$id&dynamique=$dynamique&nb_choix=$nb_choix&nb_questions=$nb_questions");
}

//--------------------------------------------------
// 			RECUPERATION DONNEES
//--------------------------------------------------


$qcms = get_theme_qcms($theme);
$max_qcms = pg_num_rows($qcms);
$qcms = pg_super_fetch_array($qcms);

$blancs = get_theme_ftbs($theme);
$max_blancs = pg_num_rows($blancs);
$blancs = pg_super_fetch_array($blancs);
// recup du nb de questions
//$nb_questions=$current_positionnement->getNbExercices();
//initialisation du nombre d'associations connectes
$nb_connected=0;
$nb_to_be_connected=$nb_choix*$nb_questions;

//--------------------------------------------------
// 			AFFICHAGE
//--------------------------------------------------

$titre = $MSG_1814;
$javascriptFILE = "./commun/javascript_test.php";
$styleCSS = "../style/".MY_STYLE."/ressourcesPedagogiques.css";
//$fonctionONLOAD="initForm2('questions')";
require ('../entete.php3');
//echo "nb_rep=$nb_choix et nb_qst=$nb_questions<br>";

print ("
<br><br>
<form name=\"questions\" method=\"post\">
<table class=\"tableau_espace\" >");

//LIBELLES COLONNES
print ("
	<tr>
		<th>
			$MSG_1088
		</th>");

//LIBELLES COLONNES DE CHOIX
$current_choixx= $current_positionnement->getObjReponses();
for ($i = 1; $i <= ($current_positionnement->getNbConfiguredObjReponses()); $i ++) {

	//recuperation des choix pour les libelles	
	$current_choix =  $current_choixx[$i-1];
	$current_nb_qcms = $current_choix -> nbQcms;
	
	print ("
		<th colspan=\"2\">$MSG_303 $i :<br>
			".$current_choix -> toString()."
		</th>");
}

print ("
	</tr>");

// LIGNES DES QUESTIONS
$current_exercices= $current_positionnement->getObjQuestions();
for ($i = 1; $i <= $current_positionnement->getNbConfiguredObjQuestions(); $i ++) {
    //alternance de couleurs

    $current_exercice = $current_exercices[$i -1];
    print ("<tr>\n");
    //LIBELLE QUESTION
    print ("
    <td class=\"couleur1\" rowspan=\"2\" width=\"90\">
    <b>$MSG_292 $i :</b>
    <br>
    <br>
    ".$current_exercice -> toString()."
    </td>
    ");
    //COLONNES DE CHOIX (1ERE LIGNE)
    for ($j = 1; $j <= $current_positionnement -> getNbConfiguredObjReponses(); $j ++) {
        $current_choix = $current_choixx[$i-1];
        $current_nb_qcms = $current_choix -> nbQcms;
        $current_nb_blancs = $current_choix -> nbBlancs;
        $current_chap_qcms = $current_choix -> chapQcms;
        $current_chap_blancs = $current_choix -> chapBlancs;
        $tab_qcms_gen = $current_positionnement -> getEvaluationsAGenerer($current_exercice -> getId(), $current_choix -> getId(),get_evaluation_type_old_new("q"));
        $nb_qcms_gen = count($tab_qcms_gen);
        $tab_blancs_gen = $current_positionnement -> getEvaluationsAGenerer($current_exercice -> getId(), $current_choix -> getId(), get_evaluation_type_old_new("f"));
        $nb_blancs_gen = count($tab_blancs_gen);
        print ("<td class=\"couleur2\">");
        //affichage de l'icone link ou unlik
        if( ($nb_qcms_gen|| $nb_blancs_gen) || ($current_nb_qcms==0 &&$current_nb_blancs==0)) {
            print ("
            <a href=\"#\"  OnClick=\"javascript:edtAssoc($id, ". ($i -1).", ". ($j -1).", ".$current_positionnement -> getNbChoix().",".$current_positionnement -> getNbQuestions().");return(false)\"><img src=\"../images/link.gif\" border=\"0\"  align=\"absmiddle\"></a>
            </td>
            <td class=\"couleur2\">");
            //on incremente le nombre d'associations connectees
            $nb_connected++;
            if($current_nb_qcms>0 &&$current_chap_qcms>0)
                print ("<small><b>$current_nb_qcms</b> $MSG_1816.<br></small>");
            else
                print ("<small><b>$current_nb_qcms</b> $MSG_1817.<br></small>");
            if($current_nb_blancs>0 &&$current_chap_blancs>0)
                print ("<small><b>$current_nb_blancs</b> $MSG_1818.</small>");
            else
                print ("<small><b>$current_nb_blancs</b> $MSG_1819.</small>");
        }
        else {
            print ("<a href=\"#\"  OnClick=\"javascript:edtAssoc($id, ". ($i -1).", ". ($j -1).", ".$current_positionnement -> getNbChoix().",".$current_positionnement -> getNbQuestions().");return(false)\"><img src=\"../images/unlink.gif\" border=\"0\"  align=\"absmiddle\"></a>
            </td>
            <td class=\"couleur2\">&nbsp;");
        }
        print ("</td>");
    }
    print ("</tr>\n\n");
    //COLONNES DE CHOIX (2EME LIGNE)
    print ("<tr>");
    for ($j = 1; $j <= $current_positionnement -> getNbConfiguredObjReponses(); $j ++) {
        $current_choix = $current_choixx[$j-1];
        $current_nb_qcms = $current_choix -> nbQcms;
        $current_nb_blancs = $current_choix -> nbBlancs;
        $current_chap_qcms = $current_choix -> chapQcms;
        $current_chap_blancs = $current_choix -> chapBlancs;
        $tab_qcms_gen = $current_positionnement -> getEvaluationsAGenerer($current_exercice -> getId(), $current_choix -> getId(), "q");
        $nb_qcms_gen = count($tab_qcms_gen);
        $tab_blancs_gen = $current_positionnement -> getEvaluationsAGenerer($current_exercice -> getId(), $current_choix -> getId(), "f");
        $nb_blancs_gen = count($tab_blancs_gen);
        //QCMs
        if ($current_nb_qcms) {
            print ("<td align=\"center\" class=\"couleur2\">");
            if (!$nb_qcms_gen) {
                print ("<small><b>$current_nb_qcms</b> $MSG_1820<br></small>");
                if($current_chap_qcms>0)
                    print("<small>$MSG_1807 <b>$current_chap_qcms</b> $MSG_1821.</small>");
            }
            else {
                if($current_chap_qcms==0)
                    $max_q=$current_nb_qcms;
                else
                    $max_q=$current_chap_qcms;
                print ("<small><u><b>$max_q</b> $MSG_1822</u> :<br></small>");
                for ($q = 0; $q < $max_q; $q ++) {
                    print ("\n<small><b>". ($q +1).") </b>".$tab_qcms_gen[$q] -> id_exercice."- ".substr(htmlspecialchars($tab_qcms_gen[$q] -> libelle), 0, 25)."...<br></small>");
                }
            }
            print ("</td>");
        }
        else {
            print ("<td class=\"couleur2\">&nbsp</td>");
        }
        //BLANCs
        if ($current_nb_blancs) {
            print ("<td class=\"couleur2\" align=\"center\">");
            if (!$nb_blancs_gen) {
                print ("<small><b>$current_nb_blancs</b> $MSG_1823<br></small>");
                if($current_chap_blancs>0)
                    print("<small>$MSG_1807 <b>$current_chap_blancs</b> $MSG_1821</small>");
            }
            else {
                if($current_chap_blancs==0)
                    $max_q=$current_nb_blancs;
                else
                    $max_q=$current_chap_blancs;
                print ("<small><u><b>$max_q</b> $MSG_1824</u> :<br></small>");
                for ($q = 0; $q < $max_q; $q ++) {
                    print ("\n<small><b>". ($q +1).") </b>".$tab_blancs_gen[$q] -> id_exercice."- ".substr(htmlspecialchars($tab_blancs_gen[$q] -> libelle), 0, 25)."...<br></small>");
                }
            }
            print ("</td>");
        }
        else {
            print ("<td class=\"couleur2\">&nbsp</td>");
        }
    }
    print ("</tr>\n\n");
}

print ("
\n<tr align=\"center\">
<td colspan=\"". (5 + $current_positionnement -> getNbConfiguredObjReponses())."\">
<input type=\"hidden\" name=\"id\" value=\"$id\"/>
<input type=\"hidden\" name=\"dynamique\" value=\"$dynamique\"/>
<input type=\"hidden\" name=\"nb_questions\" value=\"$nb_questions\"/>
<input type=\"hidden\" name=\"nb_choix\" value=\"$nb_choix\"/>");
if($current_positionnement->isFini())
    print("
    <input type=\"submit\" name=\"sub_questions\" value=\"$MSG_1813\"/>
    ");
else
    print("
    <input type=\"submit\" name=\"sub_questions\" value=\"$MSG_1815\" disabled />
    ");
print("
<td>
</table></tr>

</td>
</tr>\n
");

print ("
</table>
</form>
");
//define("VERSION", "9.0.0");
require ("../piedpage.php3");
?>