<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Affiche les elements auxquels un positionnement est connect
 * 
 * @package positionnement
 */

/*----------------------------------------------------------------------------------*/
//            INITIALISATION
/*----------------------------------------------------------------------------------*/
//define("VERSION", "7.0.0");
require ("../dbpostgres.php3");
require ("../lib/lib_positionnement.php");
connecteDB();
$styleCSS = "../style/" . MY_STYLE . "/ressourcesPedagogiques.css";
require ('../entete_fenetre.php');
// require("functions.inc.php");

require ("../ftb/functions.inc.php");

if (!isset ($classement))
	$classement = 1;

if ($classement == 1)
	$cla1 = -1;
else
	$cla1 = 1;
if ($classement == 2)
	$cla2 = -2;
else
	$cla2 = 2;

if (!$id) {
	print ("$ERROR_13=num_positionnement");
	$id = 1;
}

// cration d'un objet positionnement
$current_positionnement = new Positionnement($id);
$titre_positionnement = $current_positionnement->toString();

// ----------------------------------
// AFFICHAGE
// ----------------------------------

print ("
<center>
<br><table class=\"tableau_message\"><tr><td><b>$MSG_1859 :</b> $titre_positionnement</td></tr></table><br>
");

print ("
<!--HAUT DU TABLEAU-->
<br>
<table class=\"tableau_espace\">
");

//sens de la fleche
if ($classement > 0) {
	$sens = 0;
} else {
	$sens = 1;
}
// Les sries alatoires sont de type C
if ($mode == "alea")
	$type = 'C';
else
	$type = 'B';
switch ($classement) {
	// -------------------------------------------------------------------------------------------------------------------------------
	// CLASSEMENT 1 > PAR POSITIONNEMENT
	// -------------------------------------------------------------------------------------------------------------------------------
	case (1) :
	case (-1) :
		// TITRE POSITIONNEMENT
		print ("
				<tr>
				    <th><a href=\"connectePositionnement.php?id=$id&classement=$cla1\">$MSG_1274 <img border=\"0\" src=\"../gestion_fichier/images/fleche" . $sens . ".gif\"></a></th>
				    <th><a href=\"connectePositionnement.php?id=$id&classement=$cla2\">$MSG_2282</a></th>
				</tr>
				");

		// Rcup des tests du positionnement
		$tests = array ();
		$tests = $current_positionnement->getTests();
		//on trie le tableau
		uasort($tests, "compare_tests");
		//on inverse l'ordre si besoin
		if ($classement == -1)
			$tests = array_reverse($tests, false);
		$nbTests = count($tests);
		if ($nbTests == 0) {
			print ("<tr class=\"couleur2\"><td colspan=\"2\" align=\"center\"><i>$MSG_1860</i></td></tr>");

		} else {
			// Parcours du tableau tests[]
			for ($i = 0; $i < $nbTests; $i++) {
				$current_test = $tests[$i];
				$parcours = array ();
				$parcours = & $current_test->getParcours();
				$nb_parcours = sizeof($parcours);

				$classcolor = ($i % 2 == 0 || $i == 0 ? "couleur1" : "couleur2");

				print ("
								                                    <tr class=\"$classcolor\" align=\"center\">
								                                        <td rowspan=\"$nb_parcours\"><b>" . $current_test->toString() . "</b></td>");

				if ($nb_parcours == 0) {
					print ("
										                                                <td><i>$MSG_2488</i></td>
										                                                </tr>");
				} else {

					// boucle sur les parcours
					for ($j = 0; $j < $nb_parcours; $j++) {
						$current_parcours = new Parcours($parcours[$j]);
						print ("
												                                                            <td><b>" . $current_parcours->toString() . "</b></td>
												                                                            </tr>");
					}
				}
			}
		}
		break;

		// -------------------------------------------------------------------------------------------------------------------------
		// CLASSEMENT 2 > PAR PARCOURS
		// -------------------------------------------------------------------------------------------------------------------------
	case (2) :
	case (-2) :
		// TITRE POSITIONNEMENT
		print ("
				<tr>
				    <th><a href=\"connectePositionnement.php?id=$id&classement=$cla1\">$MSG_1274 </a></th>
				    <th><a href=\"connectePositionnement.php?id=$id&classement=$cla2\">$MSG_2282 <img border=\"0\" src=\"../gestion_fichier/images/fleche" . $sens . ".gif\"></a></th>
				</tr>
				");
		// Rcup des tests du positionnement
		$tests = array ();
		$tests = & $current_positionnement->getTests();
		$nbTests = sizeof($tests);
		if ($nbTests == 0) {
			print ("<tr class=\"couleur2\"><td colspan=\"2\" align=\"center\"><i>$MSG_1860</i></td></tr>");

		} else {
			// Parcours du tableau tests[]
			for ($i = 0; $i < $nbTests; $i++) {
				$current_test = $tests[$i];
				$parcours = array ();
				$parcours = $current_test->getParcours();
				$nb_parcours = sizeof($parcours);

				$classcolor = ($i % 2 == 0 || $i == 0 ? "couleur1" : "couleur2");

				print ("
								                                    <tr class=\"$classcolor\" align=\"center\">
								                                        <td rowspan=\"$nb_parcours\"><b>" . $current_test->toString() . "</b></td>");

				if ($nb_parcours == 0) {
					print ("
										                                                <td><i>$MSG_2488</i></td>
										                                                </tr>");
				} else {

					// boucle sur les parcours
					for ($j = 0; $j < $nb_parcours; $j++) {
						$current_parcours = new Parcours($parcours[$j]);
						print ("
												                                                            <td><b>" . $current_parcours->toString() . "</b></td>
												                                                            </tr>");
					}
				}
			}
		}
		break;

		//                case 2 :
		//                case -2:
		//
		//                // REQUETE SUR SERIE_EXO ET ASSO_EXO_SERIE
		//                /*if($classement==-2)
		//                        $desc="DESC";*/
		//
		//                // Rcup des tests du positionnement
		//                $tests=array();
		//                $tests = &$current_positionnement->getTests();
		//                $nbTests=sizeof($tests);
		//
		//                 // recup des formations avec leurs nom
		//                /* $sql="SELECT DISTINCT num_parcours, nom_parcours, lower(nom_parcours) AS ordre
		//                                FROM gestparcours, parcours
		//                                WHERE num_c_q_e_d=$id
		//                                AND type_etape='$type'
		//                                AND g_num_parcours=num_parcours
		//                                ORDER BY ordre $desc";
		//	
		//                 $resultParcours=pg_query($sql);
		//                 $nbParc=pg_numrows($resultParcours);*/
		//				$parcours = $current_test->getParcours();
		//				$nbParc=count($parcours);	
		//                 // Parcours des parcours
		//                /*for($i=0;$i<$nbParc;$i++)
		//                {
		//                        $rowParcours=pg_fetch_row($resultParcours,$i);
		//
		//                        // REQUETE SUR FILIERE
		//                        $sql="SELECT nom
		//                                FROM gestparcours, filiere
		//                                WHERE num_c_q_e_d=id
		//                                AND g_num_parcours=$rowParcours[0]
		//                                AND num_etape='1'
		//                                AND id=num_c_q_e_d";
		//
		//                        $resultFil=pg_query($sql);
		//                        $rowFil=pg_fetch_row($resultFil,0);
		//
		//                       print("
		//                        <tr>
		//                        <td height=50 valign=middle align=center>
		//                        <font face=\"Arial,Helvetica\" size=3>
		//                        $rowFil[0]</font>
		//                        </td>
		//                       <td align=center>
		//                       <font face=\"Arial,Helvetica\" size=3><b>$rowParcours[1]</b></font>
		//                       </td>
		//                       </tr>");
		//
		//
		//                } // FIN FOR $i<$nbCal
		//                */
		//                break ;

} // FIN SWITCH CLASSEMENT

print ("
<!--BAS DU TABLEAU-->
</table><br>");

// POUR FERMER LA FENETRE
print ("<br><a class=\"action\" href=\"#\" Onclick=\"window.close()\">$MSG_956</a>
</center>");
?>