<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Associer les evaluations aux QuestionsPositionnement et aux Choix
 * d'un positionnement .
 * Le nombre d'evaluations disponibles (QCM et FTB) doit etre suffisant pour effectuer toutes les associations.
 * C'est a dire, pour chacun des types d'evaluation, que le nombre d'evaluations du theme doit etre au moins egal
 * au nombre d'evaluation demand par reponses multipli par le nombre de rponses et par le nombre de questions.
 * 
 * @package positionnement
 */ 
//--------------------------------------------------
// 			INITIALISATION
//--------------------------------------------------
require("../dbpostgres.php3");
$db=pg_connect("$server","","","","$nombase") ;
require("$chemin_bo/lib/lib_positionnement.php");

//--------------------------------------------------
// 			FONCTIONS
//--------------------------------------------------
function assocSelector($cur_quest, $cur_rep, $nb_questions, $nb_reponses){

	global $id;
	
	print("	<table>
					<tr>
							<td>
								&nbsp;
							</td>
							<td>");
							
	if($cur_quest>=1){
		print("<a href=\"#\"  OnClick=\"javascript:document.location='./edtAssoc.php?id=$id&question=".($cur_quest-1)."&reponse=$cur_rep&nb_questions=$nb_questions&nb_reponses=$nb_reponses'; \"><img src=\"../images/flechup.gif\" border=\"0\"  align=\"absmiddle\"></a>");
	}
	else print("<img src=\"../images/flechupgr.gif\" border=\"0\"  align=\"absmiddle\">");
							
	print("				</td>
							<td>
								&nbsp;
							</td>
					</tr>
					<tr>
							<td>");
							
	if($cur_rep>=1){
		print("<a href=\"#\"  OnClick=\"javascript:document.location='./edtAssoc.php?id=$id&question=$cur_quest&reponse=".($cur_rep-1)."&nb_questions=$nb_questions&nb_reponses=$nb_reponses'; \"><img src=\"../images/flechga.gif\" border=\"0\"  align=\"absmiddle\"></a>");
	}
	else print("<img src=\"../images/flechgagr.gif\" border=\"0\"  align=\"absmiddle\">");
							
	print("				</td>
							<td>");
							
	if($cur_quest!=$nb_questions-1){
		print("<a href=\"#\" OnClick=\"javascript:document.location='./edtAssoc.php?id=$id&question=".($cur_quest+1)."&reponse=$cur_rep&nb_questions=$nb_questions&nb_reponses=$nb_reponses'; \"><img src=\"../images/flechdwn.gif\" border=\"0\"  align=\"absmiddle\"></a>");
	}
	else print("<img src=\"../images/flechdwngr.gif\" border=\"0\"  align=\"absmiddle\">");
							
	print("					</td>
								<td>");
							
	if($cur_rep!=$nb_reponses-1){
		print("<a href=\"./edtAssoc.php?id=$id&question=$cur_quest&reponse=".($cur_rep+1)."&nb_questions=$nb_questions&nb_reponses=$nb_reponses\"><img src=\"../images/flechdr.gif\" border=\"0\"  align=\"absmiddle\"></a>");
	}
	else print("<img src=\"../images/flechdrgr.gif\" border=\"0\"  align=\"absmiddle\">");
							
	print("					</td>
					</tr>
				</table>");
}
$current_positionnement=new Positionnement($id);
$current_positionnement->initQuestions();
$current_positionnement->initChoix();
//--------------------------------------------------
// 			VALIDATION DU FORMULAIRE
//--------------------------------------------------

//CREATION ASSOCIATION
if(isset($posted)){

	//suppression de l'association
	$current_question=&$current_positionnement->getQuestion($question);
	$current_reponse=&$current_positionnement->getChoix($reponse);

	del_positionnement_evaluations_a_generer($current_positionnement->getId(), $current_question->getId(), $current_reponse->getId());
	//validation des qcms
	for($i=0;$i<$current_nb_qcms;$i++){
        
		$var = "qcms_".$i ;
        $qcm = $$var ;
        $current_positionnement->setEvaluationAGenerer($qcm,get_evaluation_type_old_new("q"), $current_question->getId(), $current_reponse->getId(), $i+1);
		
	}
	

	//validation des blancs
	for($j=0;$j<$current_nb_blancs;$j++){

		$var = "blancs_".$j ;
        $blanc = $$var ;
		$current_positionnement->setEvaluationAGenerer($blanc,get_evaluation_type_old_new("f"), $current_question->getId(), $current_reponse->getId(), $i+1);
		$i++;
	}

	//header("location:./edtAssoc.php?id=$id&dynamique=$dynamique&question=$question&reponse=$reponse&nb_reponses=$nb_reponses&nb_questions=$nb_questions");	
	//exit();
}

//SUPRESSION ASSOCIATION
if(isset($del_assos)){
	$current_question=&$current_positionnement->getQuestion($question);
	$current_reponse=&$current_positionnement->getChoix($reponse);

	del_positionnement_evaluations_a_generer($current_positionnement->getId(), $current_question->getId(), $current_reponse->getId());
}
//--------------------------------------------------
// 			RECUPERATION DONNEES
//--------------------------------------------------
//recuperation de la question
$current_question=&$current_positionnement->getQuestion($question);

//recuperation des reponses pour les libelles	
$current_reponse=&$current_positionnement->getChoix($reponse);

//rcupration des exos a gnrer pour l'association
$tab_qcms_gen = $current_positionnement -> getEvaluationsAGenerer($current_question -> getId(), $current_reponse -> getId(),get_evaluation_type_old_new("q"));
$nb_qcms_gen = count($tab_qcms_gen);

//on remplie un tableau ne contenant que les index des exos de l'assossiation
$tabid_qcms_gen=array();

for($i=0;$i<$nb_qcms_gen;$i++){
	$tabid_qcms_gen[]=$tab_qcms_gen[$i] -> id;
}

$tab_blancs_gen = $current_positionnement -> getEvaluationsAGenerer($current_question -> getId(), $current_reponse -> getId(), get_evaluation_type_old_new("f"));
$nb_blancs_gen = count($tab_blancs_gen);

//on remplie un tableau ne contenant que les index des exos de l'assossiation
$tabid_blancs_gen=array();

for($i=0;$i<$nb_blancs_gen;$i++){
	$tabid_blancs_gen[]=$tab_blancs_gen[$i] -> id;
	//echo $tab_blancs_gen[$i] -> id_exercice."<br>";
}



//le nombre de select est la taille du chapeau 
// sinon c'est le nombre d'exercices a generer
if($current_reponse->chapQcms!=0)$current_nb_qcms=$current_reponse->chapQcms;
else $current_nb_qcms=$current_reponse->nbQcms;

//le nombre de select est la taille du chapeau 
// sinon c'est le nombre d'exercices a generer
if($current_reponse->chapBlancs!=0)$current_nb_blancs=$current_reponse->chapBlancs;
else $current_nb_blancs=$current_reponse->nbBlancs;

//les exercices du theme
$theme=$current_positionnement->getTheme();
$qcms=get_theme_qcms($theme);
$max_qcms=pg_num_rows($qcms);
$qcms=pg_super_fetch_array($qcms);
//echo "il y a $max_qcms dans le theme<br>";

$blancs=get_theme_ftbs($theme);
$max_blancs=pg_num_rows($blancs);
$blancs=pg_super_fetch_array($blancs);

//on recupere les exos affiliables 
$current_qcms_aff=$current_positionnement-> getEvaluationsAffiliables(get_evaluation_type_old_new("q"));
$current_blancs_aff=$current_positionnement-> getEvaluationsAffiliables(get_evaluation_type_old_new("f"));
//on tri les tableaux
sort($current_qcms_aff);
sort($current_blancs_aff);

//echo "qcms dispos:".count($current_qcms_aff);
//echo "qcm deja associs:".count($tabid_qcms_gen)."<br>";
//echo "<pre>";
//print_r($current_qcms_aff);
//echo "</pre>";

//on ne garde que les exos affiliables
for( $b=0;$b<$max_qcms;$b++){

	if(!in_array($qcms[$b][0], $current_qcms_aff)&&!in_array($qcms[$b][0],$tabid_qcms_gen)){
		//print ("q-supprime ". $qcms[$b][0]);
		$qcms[$b][0]=null;
		$qcms[$b][1]=null;
		$qcms[$b][2]=null;

	}else{
		$qcms[$b][2]=pg_fetch_result(get_qcm_question($qcms[$b][0]),0,1)	;
	}
}

for( $b=0;$b<$max_blancs;$b++){

	if(!in_array($blancs[$b][0], $current_blancs_aff)&&!in_array($blancs[$b][0],$tabid_blancs_gen)){
		//print ("f-supprime ". $blancs[$b][0]);
		$blancs[$b][0]=null;
		$blancs[$b][1]=null;
		$blancs[$b][2]=null;
	}
	else{
		$blancs[$b][2]=pg_fetch_result(get_ftb($blancs[$b][0]),0,2)	;
	}
}
//--------------------------------------------------
// 			AFFICHAGE
//--------------------------------------------------

$titre=$MSG_1825;
$nom_page="edtAssoc.php";
$javascriptFILE="./commun/javascript_test.php";
$styleCSS="../style/".MY_STYLE."/ressourcesPedagogiques.css";
$fonctionONUNLOAD="javascript:window.opener.location.reload()";
require ('../entete_fenetre.php') ;
//debug
//echo "qst=$question et rep=$reponse<br>";

print("
<center>
<table class=\"tableau_espace\">
        <tr class=\"couleur1\">
            <td colspan=\"2\"><b>$MSG_1826 :</b></td>
        </tr>
        <tr class=\"couleur2\">
            <td><b>$MSG_292 ".($question+1)." :</b></td>
            <td>".$current_question->toString()."</td>
        </tr>
        <tr class=\"couleur2\">
            <td><b>$MSG_303 ".($reponse+1)." :</b></td>
            <td>".$current_reponse->toString()."	</td>
        </tr>
</table>
<br><br>
<table class=\"tableau_espace\">
<form name=\"questions\" method=\"POST\" action=\"edtAssoc.php\">
        ");


//LIBELLES COLONNES
print("<tr class=\"couleur1\" align=\"center\">");


if($current_nb_qcms){
	print("
			<td>
				<b>$MSG_1827</b>
			</td>
	");
}

if($current_nb_blancs){
	print("
			<td><b>$MSG_1828</b></td>
	");
}

print("</tr>");

	$current_exercice=& $current_positionnement->getQuestion($exercice);

	print("<tr class=\"couleur2\">\n");

	//COLONNE DE REPONSE
		
		//QCMs
		if($current_nb_qcms){
               
			
			print("<td valign=\"top\">");
			
//			echo"<pre>";
//			//print_r($tabid_qcms_gen);
//			print_r($qcms);
//			echo"</pre>";
			
			for($e=0;$e<$current_nb_qcms;$e++){
				print("\n<br><select name=\"qcms_".$e."\" >\n");
				
				for($q=0;$q<$max_qcms;$q++){
				
					if($qcms[$q][0]!=null){
					
						print("<option value=\"".$qcms[$q][0]."\" ");
						if($tabid_qcms_gen[$e]==$qcms[$q][0])print(" selected ");
						print(">".$qcms[$q][0]."- ".substr($qcms[$q][2],0, 25)."</option>");
					
					}
				}
				//si pas de qcms
				if($q==0)print("<option value=\"null\" >$MSG_1829 </option>");
				
				print("</select>\n<br>");
			}
						
			print("<input type=\"hidden\" name=\"current_nb_qcms\" value=\"$current_nb_qcms\"/>
			</td>");
		}
		
		//BLANCs
		if($current_nb_blancs){
			
			print("<td valign=\"top\">");
			
			for($e=0;$e<$current_nb_blancs;$e++){
				
				print("\n<br><select name=\"blancs_".$e."\" >\n");

				//affiche tous les blancs du theme
				for($b=0;$b<$max_blancs;$b++){

					if($blancs[$b][0]!=null){
						print("<option value=\"".$blancs[$b][0]."\" ");
						if($tabid_blancs_gen[$e]==$blancs[$b][0])print(" selected ");
						print(">".$blancs[$b][0]."- ".substr($blancs[$b][2],0, 25)."...</option>");
					}
				}
				//si pas de blancs
				if($b==0)print("<option value=\"null\" >$MSG_1830</option>");

				print("</select>\n<br>");
			}
						
			print("<input type=\"hidden\" name=\"current_nb_blancs\" value=\"$current_nb_blancs\"/>
			</td>");
		}	

			
	print("</tr>\n\n");



	
	
	
print("	<tr class=\"couleur1\" align=\"center\">
				<td colspan=\"".($current_positionnement->getNbChoix())."\">
					<table>
						<tr>
							<td align=\"center\">");

			if( ($nb_qcms_gen || $nb_blancs_gen) || ($current_nb_qcms==0 &&$current_nb_blancs==0)) {

				print ("<img src=\"../images/link.gif\" border=\"0\"  align=\"absmiddle\">");
				$texte_submit=$MSG_1831;
				$button_suppression="<br><br><input type=\"submit\" name=\"del_assos\" value=\"Supprimer l'association\" />";
			}
			else{

				print ("<img src=\"../images/unlink.gif\" border=\"0\"  align=\"absmiddle\">");
				$texte_submit=$MSG_1832;
			}
			print ("
					<input type=\"hidden\" name=\"id\" value=\"$id\"/>
					<input type=\"hidden\" name=\"dynamique\" value=\"$dynamique\"/>
					<input type=\"hidden\" name=\"nb_questions\" value=\"$nb_questions\"/>
					<input type=\"hidden\" name=\"nb_reponses\" value=\"$nb_reponses\"/>
					<input type=\"hidden\" name=\"question\" value=\"$question\"/>
					<input type=\"hidden\" name=\"posted\" value=\"1\"/>
					<input type=\"hidden\" name=\"reponse\" value=\"$reponse\"/>");
			
			if($current_nb_qcms!=0||$current_nb_blancs!=0){
				
				print("<input type=\"button\" name=\"sub_assos\" value=\"$texte_submit\" onclick=\"javascript:verifSelectionExoGen($current_nb_blancs, $current_nb_qcms);\"/>");
				print("$button_suppression");
			}
			else{
				print("<br>$MSG_1833.<br>");
			}	

			print("</td>
							<td align=center>");
							 assocSelector($question, $reponse, $nb_questions, $nb_reponses);
							print("</td>
						</tr>
				</td>
			</tr>
                </table>
                </form>
            </td>
        </tr>
    </table>
<br><br><a class=\"retour\" href=\"#\" onClick=\"javascript:window.close();\">$MSG_956</a>
");
require("../piedpage.php3");
?>