<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Affiche les positionnements d'un theme
 * 
 * @package positionnement
 */
//----------------------------------------------------------------------------------
//            INITIALISATION
//----------------------------------------------------------------------------------
require("../dbpostgres.php3");
require("../lib/lib_positionnement.php");
$db = pg_Connect("$server", "", "", "", $nombase);
if(!$db) {
  die($ERROR_2);
}

//----------------------------------------------------------------------------------
//             VALIDATION SUPPRESSION
//----------------------------------------------------------------------------------
// Suppression de sries avec le systeme de checkboxes
if($suppression)
{
        while(($serie = each($_POST)) && $serie[0] != "suppression")
        {
                $id=substr($serie[0],4,strlen($serie[0])) ;
				del_positionnement($id);
        }
        
}

//----------------------------------------------------------------------------------
//              AFFICHAGE ENTETE
//----------------------------------------------------------------------------------
$nompage="listePositionnements.php";
$titre=$MSG_1834;
$javascriptFILE="./commun/javascript_test.php";
$styleCSS="../style/".MY_STYLE."/ressourcesPedagogiques.css";
require('../entete.php3') ;

//----------------------------------------------------------------------------------
//                  LIENS VERS NOUVEAU POSITIONNEMENT
//----------------------------------------------------------------------------------

print("<br><table class=\"tableau_message\"><tr><td>");

// Rcupration des thmes
$result=get_plateforme_themes_positionnement();
// Formulaire de saisie du theme
print("
<form method=\"post\">

            <b>$MSG_550 :</b>
            <select name=\"theme\" onChange=\"submit();\">
            <option value=\"\">$MSG_215</option>
            ");
            // Parcours des thmes
            while($row=pg_fetch_array($result))
            {
                        print("<option value=\"$row[0]\"");
                        if($theme==$row[0]) print(" selected");
                        print(" >$row[1]</option>");
            }
            print("
            </select>
            </font>
</form>
</center>
</td></tr></table><br>");



// Le thme est connu
if(!empty($theme))
{
        // La variable classement determine le mode d'affichage : par type, ou par nom (par dfaut : par type)
            if(!isset($classement))
                        $classement = "type" ;

            $result=get_theme_positionnements($theme);
            $nb=$nbLigne=pg_num_rows($result);

            if($nbLigne==0)
                        $nbLigne++ ;

            // LEGENDE DES ICONES
            print("
            <br>
                <table class=\"tableau_message\">
                    <tr align=\"left\">
                        <td>
                            <img src=\"../images/lock.gif\" align=\"absmiddle\">
                            <b>:  $MSG_1835</b>&nbsp;&nbsp;<br><br>
                            <img src=\"../images/link.gif\" align=\"absmiddle\">
                            <b>: $MSG_1836</b>&nbsp;&nbsp;<br><br>
                            <img src=\"../images/dyn.gif\" align=\"absmiddle\">
                            <b>: $MSG_1837</b>
                        </td>
                        <td>
                            <img src=\"../images/icoqcm.gif\" align=\"absmiddle\" width=\"25\" height=\"25\">
                            <b> &nbsp; $MSG_547</b><br><br>
                            <img src=\"../images/icosonde.gif\" align=\"absmiddle\" width=\"25\" height=\"25\">
                            <b> &nbsp; $MSG_1483</b>
                        </td>
                    </tr>
					<tr>
						<td>
						<a href=\"./addPositionnement.php?mode=2\">$MSG_1789</a>
						</td>
					</tr>
                </table>
                <br>

                <br>
            <table class=\"tableau_espace\">
                        <tr>
                                    <th>
                                        ");
                                                print("<a href=\"listePositionnements.php?theme=$theme&classement=type\">$MSG_608");
                                                if($classement=="type")
                                                            print("<img src=\"../images/fleche0.gif\"  border=\"0\">");
                                                print("</a>
                                    </th>
                                    <th>");
                                                print("<a href=\"listePositionnements.php?theme=$theme&classement=nom\">$MSG_1838");
                                                if($classement=="nom")
                                                            print("<img src=\"../images/fleche0.gif\"  border=0>");
                                                print("</a>
                                    </th>
                                    <th>$FORM_1</th>
                        </tr>

                        <form name=\"suppPositionnement\" method=\"post\">") ;
                        // Cette variable compte le nombre de srie supprimable : utilise dans la fonction javascript qui parcours tout les checkboxes
                        $nbSuppPossible=0;

                        // Les tableaux suivant sont passs pas reference
                        $tabSondage = array() ;
                        $tabQCM = array() ;
                        $tabVide = array() ;

                        // Fonction qui repartit les positionnements dans des tableaux pour chaque type
                        dispatch_positionnements($result,$nb,&$tabSondage, &$tabQCM, &$tabVide) ;

                        if($classement=="type")
                        {
                                    // on stock les nombres de positionnements de chaque type
                                    $tabCpt = array(sizeof($tabQCM), sizeof($tabSondage)) ;
                                    // Ce tableau contient tous les id des positionnements
                                    $tabRes = array_merge($tabQCM, $tabSondage);
                                    // La variable etat permet de connaitre dans quelle partie du tableau tabRes on se trouve (partie Multi, partie QCM, etc.)
                                    $etat = 0 ;
                                    // cpt est un compteur qui est utilis pour savoir quand on passe d'une partie  une autre
                                    $cpt = 0 ;
                                    // Le libelle de la premire partie est QCM
                                    $libelle_type = "QCM" ;
                                    $img_type = "icoqcm.gif" ;
                                    $continue = list($id,$tab) = each($tabRes) ;
                        }
                        else
                        {
                                    $continue = pg_fetch_array($result) ;
                        }

                        $cpt_color=0;
                        // Selon le type de classement (par nom ou par type), la condition d'arrt est diffrente
                        while($continue)
                        {
                                    $cpt_color++;
                                    if($classement=="type")
                                    {
                                                // On change de type
                                                if($cpt >= $tabCpt[$etat])
                                                {

                                                            // On passe  l'tat suivant (il se peut qu'il n'y ait aucune srie de QCM, donc on passe de l'tat 0  l'etat 2 par exemple)
                                                            do
                                                            {
                                                                        $etat++ ;
                                                            }
                                                            while($tabCpt[$etat]==0 && $etat<2) ;

                                                            // On n'affiche aucune srie pourtant il en existe qui sont vides
                                                            if($etat==2 && $cpt==0)
                                                                        $nb=0 ;

                                                            // Actualisation du compteur
                                                            $cpt = 1 ;

                                                            $etat++ ;
                                                            switch($etat)
                                                            {
                                                                        case 1 :
                                                                                    $libelle_type = "QCM" ;
                                                                                    $img_type = "icoqcm.gif" ;
                                                                                    break ;

                                                                        case 2 :
                                                                                    $libelle_type = "Sondage" ;
                                                                                    $img_type = "icosonde.gif" ;
                                                                                    break ;

                                                            } // fin swich

                                                } // fin if
                                                 else
                                                            $cpt++ ;

                                                // Affectations
                                                $titre_positionnement = $tab->toString() ;
                                                $num = $tab->getId() ;

                                                // Condition d'arret
                                                $continue = (list($id,$tab) = each($tabRes)) ;

                                    } // fin if classement par type
                                    else
                                    {
                                                // Affectations
                                                $titre_positionnement=$continue[1];
                                                $num=$continue[0];

                                                $positionnement = new Positionnement($num);

                                                if($positionnement->getType() == get_evaluation_type_old_new("q"))
                                                {
                                                            $img_type = "icoqcm.gif" ;
                                                            $libelle_type = "QCM" ;
                                                }
                                                else
                                                {

                                                            if($positionnement->getType() == get_evaluation_type_old_new("s"))
                                                            {
                                                                        $img_type = "icosonde.gif" ;
                                                                        $libelle_type = "Sondage" ;
                                                            }
                                                            else
                                                            {
                                                                        $img_type = "" ;
                                                                        $libelle_type = "Vide" ;
                                                            }

                                                }
                                                unset($positionnement);
                                                // Condition d'arret
                                                $continue = pg_fetch_array($result) ;
                                    }

                                    $classcolor=($cpt_color%2==0||$cpt_color==0?"couleur2":"couleur1");

                                    print("
                                    <tr class=\"$classcolor\">
                                    <td align=\"center\">
                                                <img src=\"../images/$img_type\" border=\"0\" alt=\"$libelle_type\">
                                    </td>
                                    <td><b>$titre_positionnement</b>
                                    ");
                                    // on verifie si le positionnement est dynamique. Si vrai, affiche le symbole "D" aprs le titre du positionnement
                                    $positionnement = new Positionnement($num);
                                    $positionnement->initQuestions();
                                    $positionnement->initChoix();
                                     if($positionnement->isDynamique()){
                                     	
                                     		if(!$positionnement->isFini())print("<a href=\"./assocEvaluations.php?id=".$positionnement->getId()."&dynamique=true&nb_choix=".$positionnement->getNbChoix()."&nb_questions=".$positionnement->getNbQuestions().")\" >(Incomplet)</a>");
                                            print("<img src=\"../images/dyn.gif\" border=\"0\" alt=\"D\" align=\"absmiddle\">");
                                     }
                                     print("

                                    </td>
                                    <td>
                                                <table width=\"100%\">
                                                <tr>
                                    ");

                                    // Quelles sont les actions permises sur le positionnement courant
                                    // Rgles :
                                    //              - le test n'est pas dans un parcours
                                    //                  $action_positionnement=0 => Paramtrage gnral / Edition des evaluations- Loupe (lister) - Supprimer
                                    //              - le test est dans un parcours mais pas en formation
                                    //                  $action_positionnement=1 => Paramtrage gnral  / Edition des evaluations- Loupe (lister) - Verrou parcours
                                    //              - le test est dans un parcours et en formation
                                    //                  $action_positionnement=2 => Loupe (lister) - Verrou 
                                    $action_positionnement=get_positionnement_actions($num);
                                    switch($action_positionnement)
                                    {
                                                // cas o suppression possible
                                                case 0 : print("
                                                              <td width=\"35%\">
                                                                    <a href=\"#\" OnClick=\"javascript:apercu($num);return(false);\"><img src=\"../images/view.gif\" border=\"0\"  align=\"absmiddle\"></a>
                                                              </td>
                                                              <td width=\"30%\" align=\"center\">
                                                                    <a class=\"action\" href=\"addPositionnement.php?num_positionnement=$num&mode=1\">$MSG_713</a>
                                                              </td>
                                                              <td width=\"35%\" align=\"center\">
                                                                <a class=\"action\" OnClick=\"if(document.suppPositionnement.supp$num.checked==true) document.suppPositionnement.supp$num.checked = false ; else document.suppPositionnement.supp$num.checked = true ;\">
                                                                $FORM_4</a>
                                                                <input type=\"checkbox\" name=\"supp$num\">
                                                              </td>
                                                              </tr>
                                                              ");
                                                              $nbSuppPossible++ ;
                                                break ;

                                                // cas ou suppression impossible
                                                case 1 :
                                                print("
                                                            <td width=\"35%\">

                                                                        <a href=\"#\" OnClick=\"javascript:apercu($num);return(false);\"><img src=\"../images/view.gif\" border=\"0\"  align=\"absmiddle\"></a>
                                                            </td>
                                                             <td width=\"30%\" align=\"center\">
                                                                <a class=\"action\" href=\"addPositionnement.php?num_positionnement=$num&mode=1\">$MSG_713</a>
                                                              </td>
                                                            <td width=\"35%\" align=\"center\">
                                                                        <a href=\"#\" OnClick=\"window.open('./connectePositionnement.php?id=$num','demo','status=no,scrollbars=yes,resizable=yes,width=650,height=450');return(false);\">
                                                                        <img src=\"../images/link.gif\" border=\"0\">
                                                                        </a>
                                                            </td>
                                                </tr>
                                                ");
                                                break ;

                                                case 2 :
                                                print("
                                                            <td width=\"35%\">
                                                                        <a href=\"#\" OnClick=\"javascript:apercu($num);return(false);\"><img src=\"../images/view.gif\" border=\"0\"  align=\"absmiddle\"></a>
                                                            </td>
                                                             <td width=\"30%\" align=\"center\">
                                                              &nbsp;
                                                              </td>
                                                            <td width=\"35%\" align=\"center\">
                                                                        <a href=\"#\" OnClick=\"window.open('./verrouPositionnement.php?id=$num','demo','status=no,scrollbars=yes,resizable=yes,width=650,height=450');return(false);\">
                                                                        <img src=\"../images/lock.gif\" border=\"0\">
                                                                        </a>
                                                            </td>
                                                </tr>
                                                ");

                                                break ;
                                                
                                                default:
                                                	print("Erreur: valeur inatendue");

                                    }

                print("
                </td>
                </tr>
                </table>
                </td>
                </tr>
                ");


        } // fin while




        if($nb==0)
                print("<tr class=\"couleur2\"><td colspan=\"3\" align=\"center\"><i>$MSG_916</i></td></tr>");

        print("</table><br>");

        // Formulaire de suppression des sries par checkboxes seulement apparent s'il y a des sries  supprimer
        if($nbSuppPossible>0)
                print("
                <table class=\"tableau_message\"><tr><td>
                <input type=\"button\" name=\"cocher\" value=\"$FORM_24\" onClick=\"toutselect($nbSuppPossible)\">
                <input type=\"button\" name=\"decocher\" value=\"$FORM_25\" onClick=\"toutselect(-$nbSuppPossible)\"><br><br>
                <input type=\"submit\" value=\"$FORM_28\" name=\"suppression\">
                <input type=\"hidden\" value=\"$theme\" name=\"theme\">
                </td></tr></table><br>");

        // On n'oublie pas de fermer le formulaire
        print("</form>");

}

print("
    <br><a class=\"retour\" href=\"index.php?menu=s\">$MSG_37</a>
");
require("../piedpage.php3");
?>
