<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Affiche les listes de tests d'un theme
 * 
 * @package positionnement
 */
require("../dbpostgres.php3");
require("../lib/lib_positionnement.php");
$db = pg_Connect("$server", "", "", "","$nombase");
if(!$db) {
  die($ERROR_2);
}

/*----------------------------------------------------------------------------------*/
//              SUPPRESSION
/*----------------------------------------------------------------------------------*/

// Suppression des listes avec le systeme de checkboxes
if($suppression){
	// Rcupration dans le buffer des affichages
    ob_start() ;	

    while(($serie = each($_POST)) && $serie[0] != "suppression"){
        $ids[]=substr($serie[0],4,strlen($serie[0])) ;
    }
    $nb_deleted=del_tests($ids);
    // Rcupration des messages d'erreur dans une variable
    $message_erreur = ob_get_contents() ;
    ob_end_clean() ;
    //echo $message_erreur;
    unset($message_erreur);
    
    //affiche le nombre de positionnements supprims
    $msg="$MSG_2191 $nb_deleted"; 
}


/*----------------------------------------------------------------------------------*/
//              AFFICHAGE ENTETE
/*----------------------------------------------------------------------------------*/
$nompage="listeTests.php";
$titre=$MSG_1851;
$styleCSS="../style/".MY_STYLE."/ressourcesPedagogiques.css";
require('../entete.php3') ;


/*-------------------------------------------------------------------------------------------------*/
//                  LEGENDE DES ICONES & LIENS VERS NOUVEAU TEST
/*-------------------------------------------------------------------------------------------------*/
print("
				<table class=\"tableau_message\"> 
					<tr>
                        <td>
                            <img src=\"../images/lock.gif\" align=\"absmiddle\">
                            <b>:  $MSG_1852</b>&nbsp;&nbsp;<br><br>
                            <img src=\"../images/link.gif\" align=\"absmiddle\">
                            <b>: $MSG_1853</b>
                        </td>
                    </tr>
					<tr><td><a href=\"./addTest.php\">$MSG_1790</a></td></tr>
				</table><br>
");
/*-------------------------------------------------------------------------------------------------*/
//                  FONCTION JAVASCRIPT
/*-------------------------------------------------------------------------------------------------*/
?>
<script language="Javascript" type="text/javascript">
            function pop_etape(num)
            {
                        window.open('liste_etape.php?serie='+num,'help','height=500,width=700,resizable=yes,scrollbars=yes');
            }

            // Fonction qui demande confirmation avant suppression
            function confirmDelete()
            {
                        return(confirm('<?php print("$MSG_1412");?>'));
            }

            function toutselect(nbchck)
            {
                        // Si le paramtre est ngatif, on dcoche tout, autrement on coche.
                        if(nbchck<=0)
                        {
                                    val=false;
                                    nbchck*=-1;
                        }
                        else
                                    val=true;
                        for(i=0 ; i < nbchck ; i++)
                        {
                                    document.suppSerie.elements[i].checked=val;
                        }

            }
</script>

<?php
$result=get_plateforme_tests();
$nb=$nbLigne=pg_num_rows($result);
if($nbLigne==0)
    $nbLigne++ ;
    
//message 
if($suppression){
	
	print("
           	<br>
           	<table class=\"tableau_message\">
             	<th>$msg</th>
           	</table>
    		<br><br>");
}
print("<table class=\"tableau_espace\">
<tr>
<th>
");
print("<a href=\"listeTests.php?classement=type\">$MSG_608");
if($classement=="type")
    print("<img src=\"../images/fleche0.gif\"  border=\"0\">");
print("
</a>
</th>
<th><a href=\"listeTests.php?classement=nom\">$MSG_1274");
if($classement=="nom")
    print("<img src=\"../images/fleche0.gif\"  border=\"0\">");
print("
</a>
</th>
<th>
$FORM_1
</th>
</tr>
<form name=\"suppSerie\" method=\"post\">
") ;
// Cette variable compte le nombre de srie supprimable : utilise dans la fonction javascript qui parcours tout les checkboxes
$nbSuppPossible=0;
// Les tableaux suivant sont passs pas reference
$tabDyn = array() ;
$tabContinue = array() ;
$tabDynContinue = array() ;
$tabRien = array();
// Fonction qui repartit les tests dans des tableaux pour chaque type
dispatch_tests($result,$nb,&$tabContinue, &$tabDyn,&$tabDynContinue,&$tabRien) ;
if($classement=="type"){
    // on stock les nombres de listes de chaque type
    $tabCpt = array(sizeof($tabContinue), sizeof($tabDyn), sizeof($tabDynContinue),sizeof($tabRien)) ;
    // Ce tableau contient tous les id des listes
    $tabRes = array_merge($tabContinue, $tabDyn,$tabDynContinue,$tabRien);
    // La variable etat permet de connaitre dans quelle partie du tableau tabRes on se trouve
    $etat = 0 ;
    // cpt est un compteur qui est utilis pour savoir quand on passe d'une partie  une autre
    $cpt = 0 ;
    // Le libelle de la premire partie est continue
    $libelle_type = $MSG_2487 ;
    $img_type = "icoqcm.gif" ;
    $continue = list($id,$tab) = each($tabRes) ;
}
else{
    $continue = pg_fetch_array($result) ;
}

$cpt_color=0;

// Selon le type de classement (par nom ou par type), la condition d'arrt est diffrente
while($continue){

    $classcolor=($cpt_color==0||$cpt_color%2==0?"couleur1":"couleur2");
    $cpt_color++ ;

    if($classement=="type"){
        // On change de type
        if($cpt >= $tabCpt[$etat]){
            // On passe  l'tat suivant (il se peut qu'il n'y ait aucune srie de QCM, donc on passe de l'tat 0  l'etat 2 par exemple)
            do{
                $etat++ ;
            }
            while($tabCpt[$etat]==0 && $etat<3) ;
            // On n'affiche aucune srie pourtant il en existe qui sont vides
            if($etat==3 && $cpt==0)
                $nb=0 ;
            // Actualisation du compteur
            $cpt = 1 ;
            //$etat++ ;
            switch($etat){
                case 1 : $libelle_type = $MSG_1854 ;
                              $img_type = "icosonde.gif" ;
                break ;
                case 2 : $libelle_type = $MSG_1855;
                              $img_type="";
                break;
                case 3 : $libelle_type=$MSG_2465;
                              $img_type="";
                break;
            } // fin swich
        } // fin if
        else
            $cpt++ ;
        // Affectations
        $titre_liste = $tab->toString() ;
        $num = $tab->getId() ;
        // nb test de la liste
        $nb_test=$tab->getNbPositionnements();
        // Condition d'arret
        $continue = (list($id,$tab) = each($tabRes)) ;
    } // fin if classement par type
    else {
        // Affectations
        $titre_liste=$continue[1];
        $num=$continue[0];
        $liste = new Test($num);
        $nb_test=$liste->getNbPositionnements();
        if(($liste->isDynamique() == "t") && ($liste->isContinue()=="t")){
            $img_type = "icoqcm.gif" ;
            $libelle_type = $MSG_1855 ;
        }
        else {
            if($liste->isDynamique() == "t"){
                $img_type = "icosonde.gif" ;
                $libelle_type = $MSG_1854 ;
            }
            else{
                if($liste->isContinue()=="t"){
                    $img_type = "icosonde.gif" ;
                    $libelle_type = $MSG_2487 ;
                }
                else{
                    $img_type = "" ;
                    $libelle_type = $MSG_2465 ;
                }
            }
        }
        unset($liste);
        // Condition d'arret
        $continue = pg_fetch_array($result) ;
    }
    print("
    <tr class=\"$classcolor\">
    <td align=\"center\">$libelle_type</td>
    <td><b>$titre_liste</b> ($nb_test $MSG_2486)</font>
    </td>
    <td>
    <table width=\"100%\">
    <tr>
    ");
    // Quelles sonr les actions permises sur la srie courante
    // Rgles :
    //              - La srie n'est pas dans un parcours
    //                  $action_serie=0 => Paramtrage gnral / Edition des tapes- Loupe (lister) - Supprimer
    //              - La srie est dans un parcours mais pas en formation
    //                  $action_serie=1 => Paramtrage gnral  / Edition des tapes- Loupe (lister) - Verrou parcours
    //              - La srie est dans un parcours et en formation
    //                  $action_serie=2 => Loupe (lister) - Verrou srie
    $action_liste=get_test_actions($num);
    switch($action_liste){
        // cas o suppression possible
        case 0 : print("
                      <td width=\"25%\">
                            <a href=\"#\" OnClick=\"window.open('./apercuTest.php?id=$num','demo','status=yes,scrollbars=yes,resizable=yes,width=600,height=450');return(false);\">
                            <img src=\"../images/view.gif\" border=\"0\">
                            </a>
                      </td>
                      <td width=\"30%\" align=\"center\">
                            <a class=\"action\" href=\"addPositionnementsTest.php?num_test=$num\">$FORM_2</a>
                      </td>
                      <td width=\"45%\" align=\"center\">
                            <a class=\"action\" OnClick=\"if(document.suppSerie.supp$num.checked==true) document.suppSerie.supp$num.checked = false ; else document.suppSerie.supp$num.checked = true ;\">
                            $FORM_4</a>
                            <input type=\"checkbox\" name=\"supp$num\">
                      </td>
                      </tr>
                      ");
                      $nbSuppPossible++ ;
        break ;
        // cas ou suppression impossible
        case 1 : print("
                      <td width=\"25%\">
                            <a href=\"#\" OnClick=\"window.open('./apercuTest.php?id=$num','demo','status=yes,scrollbars=yes,resizable=yes,width=600,height=450');return(false);\">
                            <img src=\"../images/view.gif\" border=\"0\">
                            </a>
                      </td>
                      <td width=\"30%\" align=\"center\">
                            <a class=\"action\" href=\"addPositionnementsTest.php?num_test=$num\">$FORM_2</a>
                      </td>
                     <td width=\"45%\" align=\"center\">
                            <a href=\"#\" OnClick=\"window.open('./verrouTest.php?id=$num','demo','status=yes,scrollbars=yes,resizable=yes,width=600,height=450');return(false);\">
                            <img src=\"../images/link.gif\" border=\"0\">
                            </a>
                     </td>
                     </tr>
                     ");
        break ;
        case 2 :  print("
                      <td width=\"25%\">
                            <a href=\"#\" OnClick=\"window.open('./apercuTest.php?id=$num','demo','status=yes,scrollbars=yes,resizable=yes,width=600,height=450');return(false);\">
                            <img src=\"../images/view.gif\" border=\"0\">
                            </a>
                      </td>
                      <td width=\"30%\" align=\"center\">
                            &nbsp;
                      </td>
                     <td width=\"45%\" align=\"center\">
                            <a href=\"#\" OnClick=\"window.open('./verrouTest.php?id=$num','demo','status=yes,scrollbars=yes,resizable=yes,width=600,height=450');return(false);\">
                            <img src=\"../images/lock.gif\" border=\"0\">
                     </a>
                     </td>
                     </tr>
                     ");
        break ;
    }
    print("
    </td>
    </tr>
    </table>
    </td>
    </tr>
    ");
} // fin while

if($nb==0)
    print("<tr class=\"couleur2\"><td colspan=\"3\"><i>$MSG_916</i></td></tr>");
print("</table><br>");
// Formulaire de suppression des sries par checkboxes seulement apparent s'il y a des sries  supprimer
if($nbSuppPossible>0)
    print("
    <br>
    <table class=\"tableau_message\"><tr><td>
    <input type=\"button\" name=\"cocher\" value=\"$FORM_24\" onClick=\"toutselect($nbSuppPossible)\">
    <input type=\"button\" name=\"decocher\" value=\"$FORM_25\" onClick=\"toutselect(-$nbSuppPossible)\"><br><br>
    <input type=\"submit\" value=\"$FORM_28\" name=\"suppression\">
    </td></tr></table><br>
    ");
    // On n'oublie pas de fermer le formulaire
print("
</form>
");

//}
print("
<br><a class=\"retour\" href=\"index.php?menu=s\">$MSG_37</a><br>
");

require("../piedpage.php3");
?>
