<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Affichage des liens d'un postionnement.
 * Ce script est appel par le liens 'verrou' de la liste de Positionnements.
 * 
 * @package positionnement
 */
require("../dbpostgres.php3");
require("../lib/lib_positionnement.php");
$db = pg_Connect("$server", "", "", "", $nombase);
if(!$db) {
  die($ERROR_2);
}
$styleCSS="../style/".MY_STYLE."/ressourcesPedagogiques.css";
require ('../entete_fenetre.php') ;
// require("functions.inc.php");

require("../ftb/functions.inc.php");

// PARAMETRES
// id=num_test
// classement => determine l'affichage
// 1 > test
// 2 > calendrier
// 3 > groupe

// pour les sries alatoires : mode=alea

if(!isset($classement))
        $classement=1;

if($classement==1)$cla1=-1;else $cla1=1;
if($classement==2)$cla2=-2;else $cla2=2;



if(!$id)
{
        print("$ERROR_13=num_test");
        $id=1;
}

// cration d'un objet test
$current_test = new Test($id);
$titre_test = $current_test->toString();

// ----------------------------------
// AFFICHAGE
// ----------------------------------

print("
<center>
<br><table class=\"tableau_message\"><tr><td><b>$MSG_1859 :</b> $titre_test</td></tr></table><br>
");

print("
<!--HAUT DU TABLEAU-->
<br>
<table class=\"tableau_espace\">
<tr>
    <th>$MSG_1274 <a href=\"verroutest.php?id=$id&classement=$cla1\"><img border=\"0\" src=\"../gestion_fichier/images/fleche1.gif\"></a></th>
    <th>$MSG_2410 <a href=\"verroutest.php?id=$id&classement=$cla2\"><img border=\"0\" src=\"../gestion_fichier/images/fleche1.gif\"></a></th>
</tr>
");

// Les sries alatoires sont de type C
if($mode == "alea")
        $type='C';
else
        $type='B' ;
switch ($classement)
{
        // -------------------------------------------------------------------------------------------------------------------------------
        // CLASSEMENT 1 > PAR LISTES
        // -------------------------------------------------------------------------------------------------------------------------------
        case(1) :
        case(-1) :

            // Rcup des listes du test
            $Listes=array();
            $Listes = &$current_test->getListe();
            $nbListes=sizeof($Listes);
            if($nbListes == 0)
            {
                        print("<tr class=\"couleur2\"><td colspan=\"2\" align=\"center\"><i>$MSG_1860</i></td></tr>");


            }
            else
            {
                        // Parcours du tableau Listes[]
                        for($i=0;$i<$nbListes;$i++)
                        {
                                    $current_liste = $Listes[$i];
                                    $formations = array();
                                    $formations = $current_liste->getFormations();
                                    $nb_formations = sizeof($formations);

                                    $classcolor=($i%2==0||$i==0?"couleur1":"couleur2");

                                    print("
                                    <tr class=\"$classcolor\"  align=\"center\">
                                    <td rowspan=\"$nb_formations\"><b>".$current_liste->toString()."</b></td>");

                                    if($nb_formations == 0)
                                    {
                                                print("
                                                <td><i>$MSG_1031</i></td>
                                                </tr>");
                                    }
                                    else
                                    {
                                                // boucle sur la formations
                                                for($j=0;$j<$nb_formations;$j++)
                                                {
                                                            $current_formation=$formations[$j];
                                                            print("
                                                            <td><b>".$current_formation->toString()."</b></td>
                                                            </tr>");
                                                }
                                    }
                        }
            }
            break;

                // -------------------------------------------------------------------------------------------------------------------------
                // CLASSEMENT 2 > PAR FORMATIONS
                // -------------------------------------------------------------------------------------------------------------------------
                case 2 :
                case -2:

                // REQUETE SUR SERIE_EXO ET ASSO_EXO_SERIE
                if($classement==-2)
                        $desc="DESC";

                // Rcup des listes du test
                $Listes=array();
                $Listes = &$current_test->getListe();
                $nbListes=sizeof($Listes);

                 // recup des formations avec leurs nom
                 $sql="SELECT DISTINCT num_parcours, nom_parcours, lower(nom_parcours) AS ordre
                                FROM gestparcours, parcours
                                WHERE num_c_q_e_d=$id
                                AND type_etape='$type'
                                AND g_num_parcours=num_parcours
                                ORDER BY ordre $desc";

                 $resultParcours=pg_query($sql);
                 $nbParc=pg_numrows($resultParcours);

                 // Parcours des parcours
                /*for($i=0;$i<$nbParc;$i++)
                {
                        $rowParcours=pg_fetch_row($resultParcours,$i);

                        // REQUETE SUR FILIERE
                        $sql="SELECT nom
                                FROM gestparcours, filiere
                                WHERE num_c_q_e_d=id
                                AND g_num_parcours=$rowParcours[0]
                                AND num_etape='1'
                                AND id=num_c_q_e_d";

                        $resultFil=pg_query($sql);
                        $rowFil=pg_fetch_row($resultFil,0);

                       print("
                        <tr>
                        <td height=50 valign=middle align=center>
                        <font face=\"Arial,Helvetica\" size=3>
                        $rowFil[0]</font>
                        </td>
                       <td align=center>
                       <font face=\"Arial,Helvetica\" size=3><b>$rowParcours[1]</b></font>
                       </td>
                       </tr>");


                } // FIN FOR $i<$nbCal
                */
                break ;

} // FIN SWITCH CLASSEMENT


print("
<!--BAS DU TABLEAU-->
</table>");

// POUR FERMER LA FENETRE
print("<br><br>
<a class=\"action\" href=\"#\" Onclick=\"window.close()\">$MSG_956</a>
</center>");
?>