<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
    Creation / Modification d'un QRC
    @param integer $mode 1 pour modification, 2 pour ajout
    @param integer $id numero du qsrc  diter
    @param integer $type_qsrc type du qsrc (4 -> qrc, 5->src)
	@param string $action_qsrc action en cours
    @param string $retour script cible pour le bouton retour
    @param string $retour_action_qsrc action a effectuer a la fin de l'action courante
    
    @package qsrc
*/

//--------------------------------------------------
// 			VALIDATION DU FORMULAIRE
//--------------------------------------------------

if($posted == 1){
	 ob_end_clean() ;
    // On rcupre les message d'erreur dans une variable
    ob_start() ;
    pg_query("begin");
    $message_erreur="";

    //EDITION
    if($mode==1){
    	if(!$id)die("Erreur: perte de l'identifiant du qsrc.");
    	
    	if(get_evaluation_type_new_old_r($type_qsrc)==TYPE_EVALUATION_QRC){
        	$current_qsrc = new Qrc($id);
		
    	}else{
    		
    		$current_qsrc = new Src($id);
    	}
    	$current_qsrc->loadObjects();
    	$current_qsrc->setLibelle($libelle);
    	$current_qsrc->setQuestionCommune($question_commune);
    	$current_qsrc->setRadio($type_rep);
		$updte=$current_qsrc->updateToDB($message_erreur, true);
		if(!$updte){
        	$message_erreur.="La mise  jour a choue.";
        }
    }
    //CREATION
    else{
    	
//    	echo " ".get_evaluation_type_old_new_r($type_qsrc)."==".TYPE_EVALUATION_QRC."<br>";
//echo "type_qsrc=$type_qsrc<br>";
    	if(get_evaluation_type_old_new_r($type_qsrc)==TYPE_EVALUATION_QRC){
        	$current_qsrc =& new Qrc(0, $libelle, get_evaluation_type_new_old_r($type_qsrc), null, $type_rep , $question_commune,$bareme,$chrono,$new_media,$chrono_genere );
    	}else{
    		$current_qsrc =& new Src(0, $libelle, get_evaluation_type_new_old_r($type_qsrc), null, $type_rep , $question_commune,$bareme,$chrono,null,$chrono_genere );
    	}
    }
    //print_rr($current_qsrc);
    $message_erreur .= ob_get_contents() ;
    ob_end_clean() ;
	//print_rr($message_erreur);
    
    // Soit on passe  la suite
    
    if(empty($message_erreur)){
        pg_query("commit");
//        print_rr($current_qsrc);
// en commentaire pour le moment

     header("location:qsrc.php?type_qsrc=$type_qsrc&action_qsrc=creation_modification_reponses_qsrc&nb_reponses=$nb_reponses&nb_questions=$nb_questions&mode=$mode&theme=$theme&retour=$retour&retour_action_qsrc=$retour_action_qsrc&obj_qsrc=".urlencode(exportObject($current_qsrc))) ;
     exit();

    }
    // Soit on recharge la page en affichant l'erreur
    else{
    	echo $message_erreur;
        pg_query("rollback");
        echo "<br>operation annulee";
    }
}
//--------------------------------------------------
//   INITIALISATION OU  RECUPERATION DONNEES
//--------------------------------------------------
else{
	//construction du QRC  diter
	if(isset($id)){
		if(get_evaluation_type_new_old_r($type_qsrc)==4){
        	$current_qsrc = new Qrc($id) ;
    	}else{
    		$current_qsrc = new Src($id) ;
    	}
	
		$v_nb_questions=$current_qsrc->getNbQuestions();
		$v_nb_choix=$current_qsrc->getNbReponses();
//print_rr($current_qsrc);
		//recup du libelle
		$v_libelle=$current_qsrc->getLibelle();
		
		//echo "v_lib=$v_libelle<br> et id =$id";
		// recup du type de reponse (radio ou checkbox)
		$v_reponse_type=$current_qsrc->isRadio();
		// recup de la question commune
		$v_question_commune=$current_qsrc->getQuestionCommune();
	}
	// On construit un nouveau QSRC
	else{
		if(get_evaluation_type_new_old_r($type_qsrc)==4){
        	$current_qsrc = new Qrc() ;
    	}else{
    		$current_qsrc = new Src() ;
    	}
	}
}

//print_rr($current_qsrc);
//--------------------------------------------------
// 			AFFICHAGE
//--------------------------------------------------
/*
$javascriptFILE = "./javascript_qsrc.php";
$styleCSS = "../style/".MY_STYLE."/ressourcesPedagogiques.css";
include ('../entete.php3');
*/
print("
<br><br>
<form name=\"editor\" method=\"post\">
<table class=\"tableau_normal\">
	<tr class=\"couleur1\">
		<td class=\"titre\">
			$MSG_117 :
		</td>
		<td>");

if($mode==1){
	$disable =" disabled";
	print("
			<input type=\"hidden\" name=\"theme\" value=\"$v_theme\">");
}else{
	$disable=""; 
}

print("
			<select name=\"theme\" $disable>
				<option value=\"-1\">$MSG_215</option>");

$result=get_plateforme_themes();
while($row=pg_fetch_array($result)){
	$tmp_theme=get_ams_libelles($row[1]);
        $row[1]=get_ams_libelle($tmp_theme,50);
    print("
				<option value=\"$row[0]\"");
    if($v_theme==$row[2])
         print(" selected");
    print(">$row[1]</option>");
}

print("
			</select>
		</td>
	</tr>
		<tr class=\"couleur2\">
		<td class=titre>
			$MSG_606 :
		</td>
		<td >
			<!--<input type=\"text\" name=\"libelle\" value=\"$v_libelle\"/>-->
			".get_gui_libelle_input('libelle',$v_libelle)."
		</td>
	</tr>");

print("
	<tr class=\"couleur1\">
		<td  class=\"titre\">
			$MSG_492 :
		</td>
		<td>
			<select name=\"nb_questions\" >");
if($v_nb_questions==0){
	for($i=1;$i<=100;$i++){
		print("
				<option value=\"$i\">$i</option>\n");
	}
}
else{
	print("
				<option selected value=\"$v_nb_questions\">$v_nb_questions</option>");
}
print("
			</select>
		</td>
	</tr>
	<tr class=\"couleur2\">
		<td class=\"titre\">
			$MSG_497 :
		</td>
		<td>
			<select name=\"nb_reponses\" >");
if($v_nb_choix==0){
      
	// nombre de rponse ... max ?
	for($i=2;$i<=8;$i++){
		print("
				<option value=\"$i\"");
		if($nb_choix==$i)
        	echo ' selected';
		
		print(">$i</option>\n");
	}
}
else{
	print("<option  selected  value=\"$v_nb_choix\">$v_nb_choix</option>");
}

print("
			</select>
		</td>
	</tr>
	<tr class=\"couleur1\">
		<td class=\"titre\">
			$MSG_2217:
		</td>
		<td>
			<br>
			<input");
if($v_reponse_type){
	$checked="checked";
}
else $checked="";

print(" type=\"radio\" name=\"type_rep\" value=\"1\" $checked> (Radio)<br>
			<input");

if(!$v_reponse_type){
	$checked="checked";
}
else $checked="";

print(" type=\"radio\" name=\"type_rep\" value=\"0\" $checked> (Check box)<br>
		</td>
	</tr>");

// question commune pour le test
print("
	<tr class=\"couleur2\">
		<td class=\"titre\">$MSG_1842</td>
		<td><!--<textarea name=\"question_commune\" cols=\"40\" rows=\"4\">$v_question_commune</textarea>-->
		".get_gui_libelle_textearea('question_commune',$v_question_commune)."
	</tr>");

if($mode == 1){
	print("
	<input type=\"hidden\" name=\"id\" value=\"$id\">
	<input type=\"hidden\" name=\"theme\" value=\"$v_theme\">");
	
}

print("
	<input type=hidden name=\"action_qcm\" value=\"$action_qcm\">");

print("
	<tr class=\"couleur1\">
		<td colspan=\"2\" align=\"center\">
			<input type =\"hidden\" name=\"type_qsrc\" value=\"$type_qsrc\">
			<input type=\"hidden\" name=\"posted\" value=\"1\">
			<input type=\"hidden\" name=\"id\" value=\"$id\">
			<input type=\"hidden\" name=\"mode\" value=\"$mode\">
			<input type=\"hidden\" name=\"v_theme\" value=\"$v_theme\">
			<input type=\"hidden\" name=\"retour\" value=\"$retour\">
			<input type=\"hidden\" name=\"retour_action_qsrc\" value=\"$retour_action_qsrc\">
			<input type=\"submit\" name=\"valider\" value=\"$FORM_6\"  onClick=\"return VerifForm();\"/><br><br>
		</td>
	</tr>
</table>
</form>
<br>
<!--<a class=\"retour\" href=\"$retour?retour=$retour&action_qsrc=$retour_action_qsrc&theme=$v_theme&retour_action_qsrc=$retour_action_qsrc&type_qsrc=$type_qsrc\">$MSG_37</a>-->");
?>