<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
    Creation / modification des reponses d'un QSRC.
    
    @param integer $id identifiant du qsrc
    @param string  $action_qsrc chaine decrivant l'action a effectuer
    @param integer $nb_reponses nombre de reponses du qsrc
    @param integer $nb_questions nombre de questions du qsrc
    @param integer $mode 1 pour modification, 2 pour creation
    @param integer $type_qsrc type de qsrc a creer : 4-> qrc, 5 -> src
    @param string $retour script cible pour le bouton retour

    @package qsrc
*/

//--------------------------------------------------
// 			INITIALISATION
//--------------------------------------------------


//--------------------------------------------------
// PASSAGE A LA SUITE
//--------------------------------------------------
/*
if(isset($suite)){
	

	//construit l'objet qsrc
	if(empty($obj_qsrc)){
		die("Erreur lors de la rcupration du Qsrc.(\$obj_qsrc manquant)");
	}
    $current_qsrc=importObjet($obj_qsrc);
    if(!is_object($current_qsrc)){
		die("Erreur lors de la rcupration du Qsrc.(\$obj_qsrc n'est pas un objet valide)");
	}

    header("location:qsrc.php?theme=$theme&action_qsrc=creation_modification_questions_qsrc&type_qsrc=$type_qsrc&nb_reponses=$nb_reponses&nb_questions=$nb_questions&mode=$mode&retour=$retour&retour_action_qsrc=$retour_action_qsrc&obj_qsrc=".urlencode(exportObjet($current_qsrc)));
	exit();
}
*/

//--------------------------------------------------
//                      VALIDATION DU FORMULAIRE
//--------------------------------------------------
if(isset($sub_reponses)){
	//print_rr($_POST);
    // Bloque l'envoi d'affichage
    ob_start() ;

	//construit l'objet qsrc
	if(empty($obj_qsrc)){
		die("Erreur lors de la rcupration du Qsrc.(\$obj_qsrc manquant)");
	}
    $mon_qsrc=importObject($obj_qsrc);
    if(!is_object($mon_qsrc)){
		die("Erreur lors de la rcupration du Qsrc.(\$obj_qsrc n'est pas un objet valide)");
	}
    $probleme = false ;
    $type = $mon_qsrc->getType() ;
    pg_query("begin") ;
    $i = 1 ;
    // Parcours des rponses
    while($i <= $nb_reponses && !$probleme){
        // Rcupration des variables du formulaire
        $var = "lib_reponse_".$i ;
        $lib_reponse = $$var ;
        $var = "media".$i ;
        $media = $$var ;
        $var = "largeur".$i ;
        $largeur = $$var ;
        $var = "hauteur".$i ;
        $hauteur = $$var ;
        $var = "modif".$i ;
        $id_reponse = $$var ;
		//echo "id_rep=$id_reponse<br>";

        // Modification d'une rponse
        if($id_reponse){
        	
//        	echo "MODIF<br>";
        	$rep = $mon_qsrc->getObjReponses($i);//new Reponse($id_reponse) ;
        	
        	//MAJ REPONSE
            $rep->setLibelle($lib_reponse) ;
            $res_rep=$rep->updateToDB($message_erreur) ;
            if(!$res_rep){
            	$message_erreur.="Mise  jour de la rponse : echec<br>param : $id_reponse,$lib_reponse<br>" ;
                $probleme = true ;
            }
            
            //MAJ MEDIA REPONSE
            if(!empty($media)){
            	$mon_media = new MediaQuestionReponseElement($id,$rep->getId(),$media, $hauteur, $largeur) ;
	            if(!is_object($mon_media)){
	            	$message_erreur.="Cration du mdia de la rponse : echec<br>(params : $id_rep, ".$rep->getId().", $media, $hauteur, $largeur)<br>";
	                $probleme = true ;
	            }
	            else{
	            	$rep->setMedia($mon_media);
	            }
            }
            else{
            	$rep->setMedia(null);
            	unset($mon_media);
            }

            //ajoute l'objet rponse au qsrc
            $ajout_rep=$mon_qsrc->setObjReponse($rep);
            if(!$ajout_rep){
            	$message_erreur.="Mise  jour de la rponse : echec<br>";print_rr($rep);
                $probleme = true ;
            }
        }
        // Insertion d'une nouvelle rponse
        else{
//        	echo "NEW<br>";
        
        	$rep = new Reponse(0,$lib_reponse,$type);
        	
        	//INSERTION REPONSE
            $id_rep = $rep->insertToDB($theme,$message_erreur) ;
            if(!$id_rep){
            	$message_erreur.="Insertion de la rponse : echec<br>param : $theme, $message_erreur<br>" ;
                $probleme = true ;
            }
            
            //INSERTION MEDIA REPONSE
            if(!empty($media)){
                $mon_media = new  MediaQuestionReponseElement($id,$rep->getId(),$media, $hauteur, $largeur) ;
               // $res_media=$mon_media->insertToDb() ;
	            if(!is_object($mon_media)){
	            	$message_erreur.="Insertion du mdia de la rponse : echec<br>(params : $id_rep, ".$rep->getId().", $media, $hauteur, $largeur)<br>";
	                $probleme = true ;
	            }else{
	            	$rep->setMedia($mon_media);
	            }
            }
            
            //ajoute l'objet rponse au qsrc
            $ajout_rep=$mon_qsrc->setObjReponse($rep);
            if(!$ajout_rep){
            	$message_erreur.="Affectation de la rponse cre: echec<br>";print_rr($rep);
                $probleme = true ;
            }
        }
        $i++ ;
    }
    $message_erreur .= ob_get_contents() ;
    ob_end_clean() ;
    // On annule toutes les requtes s'il y a eu un problme
    //echo "msg_err=$message_erreur et prob=$robleme<br>";
    if($probleme || $message_erreur){
        $message_erreur .= "Oprations sur base de donnes annules<br>" ;
        pg_query("rollback") ;
        echo $message_erreur;
    }
    else{
        pg_query("commit") ;
    }
}
else{
	//construit l'objet qsrc
	if(empty($obj_qsrc)){
		die("Erreur lors de la rcupration du Qsrc.(\$obj_qsrc manquant)");
	}
    $mon_qsrc=importObject($obj_qsrc);
    if(!is_object($mon_qsrc)){
		die("Erreur lors de la rcupration du Qsrc.(\$obj_qsrc n'est pas un objet valide)");
	}
}

//-----------------------------------------------------------------
//      SUPPRESSION D'UNE REPONSE DU QSRC
//-----------------------------------------------------------------
if(!empty($to_del)){

	// Rcupration dans le buffer des affichages
    ob_start() ;
    $mon_qsrc->delObjReponse($to_del) ;
    // Rcupration des messages d'erreur dans une variable
    $message_erreur = ob_get_contents() ;
    ob_end_clean() ;
    if(!empty($message_erreur)){
    	echo $message_erreur;
    	pg_query("rollback");
    	print("Operation de bases de donnees annulees");
    }else{
    	pg_query("commit");
    }
    unset($to_del);
}

//--------------------------------------------------
// 			RECUPERATION DONNEES
//--------------------------------------------------

$obj_nb_choix=count($mon_qsrc->getObjReponses());
//print_rr($mon_qsrc);
//--------------------------------------------------
// 			AFFICHAGE
//--------------------------------------------------
$javascriptFILE = "./javascript_qsrc.php";
$styleCSS = "../style/".MY_STYLE."/ressourcesPedagogiques.css";
$fonctionONLOAD="initFormCreationModification('reponses')";
//include ('../entete.php3');
//echo "id=$id<br>";
if(!empty($message_erreur)){
    print("<span class=\"erreur\">$message_erreur</span>");
}
print("
<form name=\"reponses\" method=\"post\">
<table class=\"tableau_espace2\">
");
//LIBELLES COLONNES
print("
	<tr>
		<th>$MSG_606</th>
		<th>$MSG_577</th>
		<th>$FORM_1</th>
	</tr>");

if($obj_nb_choix>$nb_reponses)
    $nb_reponses = $obj_nb_choix ;

$obj_reponses=$mon_qsrc->getObjReponses();

// LIGNES DE REPONSES
for($i=1; $i<=$nb_reponses; $i++){
	
    //couleurs des lignes
    $classcolor=($i%2==0||$i==0?"couleur1":"couleur2");
    if(count($obj_reponses)>0){
    	$current_rep=$obj_reponses[$i-1];	
    }
    if(is_object($current_rep)){
        $current_media = $current_rep->getMedia();
        if(is_object($current_media)){
        	$id_current_media=$current_media->getId();
        	$largeur_current_media=$current_media->getLargeur();
        	$hauteur_current_media=$current_media->getHauteur();
        }
        else{
        	unset($id_current_media);
        	unset($largeur_current_media);
        	unset($hauteur_current_media);
        }
       // $id_rep=$current_rep->getId();
       // Un input type hidden pour modifier et non pas insrer  la soumission du formulaire
        print("<input type=\"hidden\" name=\"modif$i\" value=\"".$current_rep->getId()."\">");
    }
    else {
        $current_rep = new Reponse(0, "Reponse $i", $mon_qsrc->getType()) ;
		unset($id_current_media);
        unset($largeur_current_media);
        unset($hauteur_current_media);
    }

    //LIBELLE    
    print("
    <tr class=\"$classcolor\">
    	<td class=\"$classcolor\">
    		$MSG_303 $i :
    		<!--<input type=\"text\" name=\"lib_reponse_$i\" value=\"".$current_rep->getLibelle()."\"/>-->
			".get_gui_libelle_input('lib_reponse_'.$i,$current_rep->getLibelle(),'',50)."
		</td>");

    //MEDIA
    print("
		<td  class=\"$classcolor\">
    		<table>
    			<tr>
    				<td colspan=\"2\" nowrap>
    					<select name=\"media$i\" onchange=\"javascript:charger_tailleSWF($i,'reponses');\" $disamedia>
    						<option value=\"0\">$MSG_1458</option>");

    $resmedia=get_theme_medias_evaluations($theme);
	$nbmedia=pg_numrows($resmedia);
    for($j=1;$j<=$nbmedia;$j++){
        $rowmedia=pg_fetch_row($resmedia);
        print("
        					<option value=\"".$rowmedia[0]."\"");
        if($id_current_media==$rowmedia[0])
            echo ' selected';
        print(">".$rowmedia[1]."</option>");
    }
    print ("
						</select><br>
					</td>
				</tr>");
				
    //TAILLE .swf
    print("
				<tr>
					<td nowrap><br>
						$MSG_1222 : <input type=text name=\"largeur$i\" size=4 value=\"$largeur_current_media\">&nbsp;&nbsp;
					</td>
					<td nowrap>
						<br>
						$MSG_1223 : <input type=text name=\"hauteur$i\" size=4 value=\"$hauteur_current_media\">
					</td>
				</tr>
			</table>
		</td>");
  
  //SUPPRESSION
   if($obj_nb_choix){
       	print("
		<td  class=\"$classcolor\">");
		if(count($obj_reponses)>2){
			print("
			<a class=\"action\" href=\"./qsrc.php?to_del=$i&action_qsrc=creation_modification_reponses_qsrc&nb_reponses=".($nb_reponses-1)."&nb_questions=$nb_questions&mode=$mode&type_qsrc=$type_qsrc&retour=$retour&retour_action_qsrc=$retour_action_qsrc&theme=$theme&obj_qsrc=".exportObject($mon_qsrc)."\" >$FORM_4</a>");
		}else{
			print ("
			<img src=\"../images/lock.gif\" onMouseOver=\"AffBulle('$BULLE_84')\" onMouseOut=\"HideBulle()\" border=\"0\">");
		}
		print("</td>");
	}else{
		print("
		<td class=\"$classcolor\">
	        &nbsp;
		</td>");
        }
    print("
	</tr>");
}

// Mode modification
if($obj_nb_choix){
    //ajout d'une rponse
    print("
	<tr>
		<td class=\"$classcolor\" colspan=\"3\">
			<a class=\"action\" href=\"./qsrc.php?action_qsrc=creation_modification_reponses_qsrc&nb_reponses=".($nb_reponses+1)."&nb_questions=$nb_questions&mode=$mode&type_qsrc=$type_qsrc&retour=$retour&retour_action_qsrc=$retour_action_qsrc&theme=$theme&obj_qsrc=".exportObject($mon_qsrc)."\">$MSG_496</a>
		<td>
	</tr>");
}
else{
    print("
	<tr>
		<td class=\"$classcolor\" colspan=\"3\">
			&nbsp;
		<td>
	</tr>");	
}
print("
	<tr>
		<td colspan=\"3\" class=\"couleur1\" align=\"center\">
			<input type=\"hidden\" name=\"id\" value=\"$id\"/>
			<input type=\"hidden\" name=\"obj_qsrc\" value=\"".exportObject($mon_qsrc)."\"/>
			<input type=\"hidden\" name=\"theme\" value=\"$theme\"/>
			<input type=\"hidden\" name=\"nb_questions\" value=\"$nb_questions\"/>
			<input type=\"hidden\" name=\"type_qsrc\" value=\"$type_qsrc\"/>
			<input type=\"hidden\" name=\"nb_reponses\" value=\"$nb_reponses\"/>
			<input type=\"hidden\" name=\"mode\" value=\"$mode\"/>
			<input type=\"hidden\" name=\"to_del\" value=\"\"/>
			<input type=\"hidden\" name=\"retour\" value=\"$retour\">
			<input type=\"hidden\" name=\"retour_action_qsrc\" value=\"$retour_action_qsrc\">
			<input type=\"submit\" name=\"sub_reponses\" value=\"$MSG_1808\" onclick=\"return verifFormCreationModification('reponses')\"/>");

// Bouton pour passer  la suite de la cration du test
if($obj_nb_choix == 0 || $obj_nb_choix!=$nb_reponses)
    $disa = "disabled" ;
else {
    $disa = "" ;
}			
print("
			<input type=\"submit\" name=\"suite\" value=\"$MSG_1809\" $disa />
		</td>
	</tr>");
print("
</table>
</form>
");
// retour  la page prcdente
print("
<center><a class=\"retour\" href=\"./$retour?retour=$retour&retour_action_qsrc=$retour_action_qsrc&id=".$mon_qsrc->getId()."&type_qsrc=$type_qsrc&action_qsrc=creation_modification_qsrc&mode=$mode&theme=$theme&v_theme=$theme&obj_qsrc=".exportObject($mon_qsrc)."\">$MSG_37</a>");
?>