<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Affiche la dmo d'un qsrc.
 * 
 * @param integer $type type de qsrc.
 * @param integer $qsrc identifiant du qsrc.
 * 
 * @package qsrc
 */
//require("../dbpostgres.php3");
//connecteDB();
require("$root/lib/lib_qsrc.php");

// cette fonction permet de vrifier si la rponse $rep pour une question $qst est vrai ou fausse
function juste($qst,$rep)
{
    //$sql="select juste from quest_rep where qr_num_question=$qst and qr_num_rep=$rep";
    //$res=@pg_query($sql);
	$res=get_qcm_reponse_infos($qst,$rep);
    if(pg_numrows($res)==1)
        $row=pg_fetch_row($res,0);
    else
        $row[2]=false;

    return $row[2];
}


$titre=$MSG_1380;
$styleCSS="../style/".MY_STYLE."/ressourcesPedagogiques.css";
require('../entete_fenetre.php');

// on cre un objet le numero du qrc pass en paramtre.

if(get_evaluation_type_new_old_r($type_qsrc)==4){
	$obj_qsrc = new Qrc($qsrc) ;
}else{
	$obj_qsrc = new Src($qsrc) ;
}
$obj_qsrc->loadObjects();
//$obj_qsrc = new Qsrc($qsrc);
//initialisaions
//$obj_qsrc->initQuestions();
//$obj_qsrc->initChoix();

// on rcupere la question commune
$quest_commune = $obj_qsrc->getQuestionCommune();
// on rcupere le nombre d'exercices
$nb_exo=$obj_qsrc->getNbQuestions();
// on vrifie le type de rponse (type "r" : radio, type "c" : checkbox)
$type_reponse=$obj_qsrc->isRadio();

// on rcupere le nombre de rponses
$nb_rep=$obj_qsrc->getNbReponses();


// affichage du formulaire
if(!isset($submit)){
	$affichage="<center>
                        <form name=\"demo\" action=\"\" method=\"post\">
						<input type=hidden name=\"type_qsrc\" value=\"$type_qsrc\">
						<input type=hidden name=\"type\" value=\"$type\">
						<input type=hidden name=\"qsrc\" value=\"$qsrc\">
						<input type=hidden name=\"evaluation\" value=\"$evaluation\">

                        <!--<table border=\"3\" cellpadding=\"10\" bordercolor=\"#000000\" width=\"90%\">-->
						<table class=\"tableau_normal\">
                        <tr class=\"couleur1\">
                        <td bgcolor=\"#000000\"><font face=\"Arial, Helvetica\" size=\"3\" color=\"#FFFFFF\"><b>".get_gui_libelle($quest_commune)."</b></font></td>";

    // on affiche chacune des rponses
    for($i=0;$i<$nb_rep;$i++){
        $obj_rep=&$obj_qsrc->getReponses($i+1);
        //print_rr($obj_rep);
        $tmp_rep=get_ams_libelles($obj_rep[1]);
        $libelle_rep=get_ams_libelle($tmp_rep);
        $affichage.="<td align=\"center\" bgcolor=\"#E4E4E4\">".$libelle_rep."</td>";
        
    }
    $affichage.="</tr>";

    for($i=0;$i<$nb_exo;$i++){
		$classcolor=($i%2==0 || $i==0 ? "couleur2" : "couleur3");
        // on affiche chacune des questions
        $obj_quest=&$obj_qsrc->getQuestions($i);
        
        $affichage.="<tr class=\"$classcolor\">
                            <td bgcolor=\"#E4E4E4\">".get_gui_libelle($obj_quest[1])."</td>\n";

        // on affiche selon le type de rponse un radio ou un checkbox pour chacune des rponses
        for($j=0;$j<$nb_rep;$j++){
			
            $obj_rep=&$obj_qsrc->getReponses($j+1);
            //print_rr($obj_rep);
            if($type_reponse)
                $affichage.="<td align=\"center\"><input type=radio name=\"rep$i\" value=".$obj_rep[0]."></td>\n";
            else
                $affichage.="<td align=\"center\"><input type=checkbox name=\"rep$i-$j\" value=".$obj_rep[0]."></td>\n";
        }
        $affichage.="</tr>";
    }
    $affichage.="</table>
                        <input type=\"submit\" value=\"valider\" name=\"submit\">
                        </center>";

    // affichage du formulaire
    echo "$affichage<br>";

}
else{
    // lorsque le formulaire est valid
    $affichage="<center>
                        <table border=\"3\" cellpadding=\"10\" bordercolor=\"#000000\" width=\"90%\">
                        <tr>
                        <td bgcolor=\"#000000\"><font face=\"Arial, Helvetica\" size=\"3\" color=\"#FFFFFF\"><b>".get_gui_libelle($quest_commune)."</b></font></td>";

    // on raffiche chacune des rponses en colonne
    for($i=0;$i<$nb_rep;$i++)
    {
        $obj_rep=&$obj_qsrc->getReponses($i+1);
        //print_rr($obj_rep);
        $tmp_rep=get_ams_libelles($obj_rep[1]);
        $libelle_rep=get_ams_libelle($tmp_rep);
        $affichage.="<td align=\"center\"  bgcolor=\"#E4E4E4\">".get_gui_libelle($obj_rep[1])."gg</td>";
    }

    $affichage.="</tr>";

    // initialisation du score  0
    $score=0;

    for($i=0;$i<$nb_exo;$i++){
    	
        // on affiche chacune des questions en lignes
        //$obj_quest=&$obj_qsrc->getObjQuestions($i);
        $obj_quest=&$obj_qsrc->getQuestions($i);
       //print_rr($obj_quest);
       $tmp_quest=get_ams_libelles($obj_quest[1]);
       $libelle_question=get_ams_libelle($tmp_quest);
        $affichage.="<tr><td bgcolor=\"#E4E4E4\"> ".$libelle_question."</td>\n";
        //$affichage.="<tr><td bgcolor=\"#E4E4E4\"> ".get_gui_libelle($obj_quest[1])."</td>\n";

        for($j=0;$j<$nb_rep;$j++){
        	
        	//on recupere le choix courrant
        	//$obj_rep=&$obj_qsrc->getChoix($j+1);
			$obj_rep=&$obj_qsrc->getReponses($j+1);
			
        	//on recupere la solution du couple question reponse
			//$res_j=get_positionnement_question_positionnement_reponse_solution($obj_qsrc->getId(), $obj_quest[0],$obj_rep[0]); 
            if(get_evaluation_type_new_old_r($type_qsrc)==4){
            	if($type_reponse){
            		// on affiche pour chacunes des rponses le type de radio
                	$affichage.="<td align=\"center\" bgcolor=\"#CECFCE\">";

                	// on vrifie si c t la rponse coche par l'utilisateur
                	$reponse="rep$i";
                	// si la rponse tait coche par l'utilisateur on le raffiche dans la correction, autrement on ne fait rien
                	if($$reponse==$obj_rep[0])
                    	$checked="checked";
                	else
                    	$checked="";

                	// dans le cas ou la rponse est coche par l'utilisateur et que la rponse est juste
                	// debug
               		if ($obj_qsrc->isJuste($obj_quest[0],$obj_rep[0]) &&($$reponse==$obj_rep[0]) ) {
                		//if($res_j&&(pg_num_rows($res_j)>0&&pg_fetch_result($res_j, 0, 3)=="t") && ($$reponse==$obj_rep[0])){
                
                    	// on affiche l'image verte pour dire que c'est juste et on incrmente de 1 le score
                    	$affichage.="<img src=\"../images/icovalid.gif\"><br>";
                    	$score++;
                	}

                	// dans le cas ou la rponse n'est pas coche par l'utilisateur et que la rponse est fausse
                	//elseif($res_j&&(pg_num_rows($res_j)>0&&pg_fetch_result($res_j, 0, 3)=="t") && ($reponse!=$obj_rep[0])){
                	elseif (!$obj_qsrc->isJuste($obj_quest[0],$obj_rep[0]) &&($$reponse!=$obj_rep[0]) ) {
                    	// on affiche galeemnt l'image verte pour dire que c'est juste et on incrmente aussi de 1 le score
                    	$affichage.="<img src=\"../images/icovalid.gif\"><br>";
                    	$score++;
                	}

                // dans tout les autres cas, l'utilisateur n'a pas rpondu juste, donc on affiche l'image rouge pour dire
                // que ce n'est pas juste et on incrmente pas le score
                else $affichage.="<img src=\"../images/iconontraite.gif\"><br>";

                // on affiche le type de rponse avec la valeur coche ou non selon ce que l'utilisateur avait rpondu
                $affichage.="<input type=radio name=\"rep$i\" $checked ></td>\n";
            }
            else{
            	
                // traitement similaire dans le cas des checkbox
                $affichage.="<td align=\"center\" bgcolor=\"#CECFCE\">";
                $reponse="rep$i-$j";
                
                if($$reponse==$obj_rep[0])
                    $checked="checked";
                else
                    $checked= "" ;
                
				if ($obj_qsrc->isJuste($obj_quest[0],$obj_rep[0]) &&($$reponse==$obj_rep[0]) ) {
                //if($res_j&&(pg_num_rows($res_j)>0&&pg_fetch_result($res_j, 0, 3)=="t") && ($$reponse==$obj_rep[0])){
                
                    $affichage.="<img src=\"../images/icovalid.gif\"><br>";
                    $score++;
                }
                //elseif($res_j&&(pg_num_rows($res_j)>0&&pg_fetch_result($res_j, 0, 3)=="t") && ($$reponse!=$obj_rep[0])){
                elseif (!$obj_qsrc->isJuste($obj_quest[0],$obj_rep[0]) &&($$reponse!=$obj_rep[0]) ) {
                    $affichage.="<img src=\"../images/icovalid.gif\"><br>";
                    $score++;
                }
                else  $affichage.="<img src=\"../images/iconontraite.gif\"><br>";


                $affichage.="<input type=checkbox name=\"rep$i-$j\" $checked ></td>\n";
            }
        }
        //$affichage.="</tr>";
        }
        $affichage.="</tr>";
    }

    // calcul du dnominateur,  savoir le nombre maximum de points possible que l'on peut obtenir  l'exercice
    $score_max=$nb_rep*$nb_exo ;

    // on affiche la dernire ligne du tableau : le score de l'utilisateur sur le score maximum possible
    $colspan=$nb_rep+1;
    $affichage.="<tr>
                        <td colspan=\"$colspan\" align=\"center\" bgcolor=\"#000000\">
                        <font face=\"Arial, Helvetica\" size=\"3\" color=\"#FFFFFF\"><b>Score : $score / $score_max</b></font>
                        </td>
                        </tr>
                        </table>
                        </center>";

    echo "$affichage<br>";
}

// Lien pour fermer la popup.
print("<center><b>[ <a href=\"#\" Onclick=\"window.close()\"><font face=\"Arial\" color=\"#000000\">$MSG_956</font></a> ] </b></center>");
//include('../piedpage.php3');
print ("
</BODY>
</HTML>
");
//require("../piedpage.php3");
include('../../pied_page.php');
?>