<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
	Afficher la liste des qsrc de la plate-forme
	
	@package qsrc
*/

// Suppression de sries avec le systeme de checkboxes
if(isset($suppression)){
	if(!empty($supp))$del=del_qsrc($supp);
}

//-------------------------------------------------------
//              INITIALISATIONS
//-------------------------------------------------------
//echo "type=$type_qsrc<br>";
if($type_qsrc==4){
	$lib_type_qsrc=$MSG_1863;	
	$titre=$MSG_2303;
	$nompage=$MSG_2303;
	$aide1=$MSG_2213;
	$aide2=$MSG_2214;
	$msg_creation=$MSG_2185;
}
else{
	$lib_type_qsrc=$MSG_1864;
	$titre=$MSG_1881;
	$nompage=$MSG_1881;
	$aide1=$MSG_2215;
	$aide2=$MSG_2216;
	$msg_creation=$MSG_1896;
}

$nbSuppPossible=0;
/*
$javascriptFILE="./javascript_qsrc.php";
$styleCSS = "../style/".MY_STYLE."/ressourcesPedagogiques.css";
require('../entete.php3') ;
*/

//--------------------------------------------------
//                 CHOIX DU THEME
//--------------------------------------------------
print("
<table class=\"tableau_message\">
	<tr>
		<td><a href=\"./qsrc.php?action_qsrc=creation_modification_qsrc&type_qsrc=$type_qsrc&mode=2&retour=$retour&retour_action_qsrc=lister_qsrc&v_theme=$theme\">$msg_creation</a></br>
");

// Formulaire de choix du theme
$page="./qsrc.php";
$form_name="select_qsrc_theme";
$message=$MSG_117;
$fonction_selection="get_plateforme_themes_qsrc()";
$hiddens["action_qsrc"]="lister_qsrc";
$hiddens["type_qsrc"]=$type_qsrc;
$hiddens["retour"]=$retour;
$select_value_name="theme";
include("../../lib_graphique/forms/formSelectEntiteAuto.php");

print("
		</td>
	</tr>
</table>");

//--------------------------------------------------
//              AFFICHAGE
//--------------------------------------------------
// Le thme est connu
if(!empty($theme)){
	// La variable classement determine le mode d'affichage : par type, ou par nom (par dfaut : par type)
	if(!isset($classement))
		$classement = "type" ;

	if($type_qsrc==4){
		$result=get_theme_qrcs($theme, $classement, $desc);
		$retour_page="../qcm/qcm.php";
	}else{
		$result=get_theme_srcs($theme, $classement, $desc);
		$retour_page="../sondages/sondage.php";
	}
	$nb=pg_num_rows($result);
	if($nbLigne==0)
		$nbLigne++ ;
		
	// LEGENDE DES ICONES
	print("
<br>
<table class=\"tableau_message\">
	<tr>
		<td align=\"left\" nowrap=\"nowrap\">
			<img src=\"../images/lock.gif\" align=\"absmiddle\">
			<b>: $aide1</b>&nbsp;&nbsp;<br><br>
			<img src=\"../images/link.gif\" align=\"absmiddle\">
			<b>: $aide2</b>
		</td>
	</tr>
</table>");
	
	//TITRES TABLEAU
    print("
<br>
<form name=\"suppSerie\" method=\"post\">
<table class=\"tableau_espace\">
	<tr class=\"couleur1\">
		<th>");
if($classement=="nom"){
	if($desc=="ASC"){
		print("
			<a href=\"qsrc.php?action_qsrc=lister_qsrc&theme=$theme&classement=nom&desc=DESC\">$lib_type_qsrc
				<img src=\"../images/fleche0.gif\"  border=\"0\">
			</a>");
	}else{
		print("
		<a href=\"qsrc.php?action_qsrc=lister_qsrc&theme=$theme&classement=nom&desc=ASC\">$lib_type_qsrc
			<img src=\"../images/fleche1.gif\"  border=\"0\">
		</a>");
	}
}
print("
		</th>
		<th align=\"center\" width=\"45%\">
			$FORM_1
		</th>
	</tr>");

	for($i=0;$i<$nb;$i++){
		
		//couleurs des lignes
		$classcolor=($i%2==0 || $i==0 ? "couleur1" : "couleur2");
		
		//recup du qsrc
		$row=pg_fetch_row($result,$i);
		$tmp_texte=get_ams_libelles($row[1]);
		//print_rr($tmp_texte);
        $row[1]=get_ams_libelle($tmp_texte,80);
		print("
	<tr class=\"$classcolor\">
		<td>
			".get_gui_libelle($row[1])."
		</td>
		<td>
			<table width=\"100%\">
				<tr class=\"action\">");
						
		// Quelles sont les actions permises sur le qsrc courant
		$action=get_evaluation_actions($row[0],get_evaluation_type_new_old_r($type_qsrc));
		//echo "action=$action<br>";
		switch($action){
			// suppression et edition possible
			case 2 : 
				print("
					<td width=\"25%\">
						<a href=\"#\" OnClick=\"javascript:apercu($row[0],$type_qsrc);return(false);\">
							<img src=\"../images/view.gif\" border=\"0\" align=\"absmiddle\">
						</a>
					</td>	
					<td width=\"25%\">
						<a href=\"#\" OnClick=\"window.open('../evaluation/demo_evaluation.php?type=".get_evaluation_type_new_old_r($type_qsrc)."&theme=$theme&evaluation=$row[0]','demo','status=yes,scrollbars=yes,resizable=yes,width=800,height=600');return(false);\">
							$MSG_1380
						</a>
					</td>				
					<td width=\"25%\">
						<a href=\"qsrc.php?action_qsrc=creation_modification_qsrc&id=$row[0]&v_theme=$theme&type_qsrc=$type_qsrc&mode=1&retour=$retour&retour_action_qsrc=$action_qsrc\">
							$FORM_2
						</a>
					</td>				
					<td width=\"25%\">
							$FORM_4
						<input type=\"checkbox\" name=\"supp[]\" value=\"$row[0]\">
					</td>");
			$nbSuppPossible++ ;
			break ;
			
			// suppression impossible et edition possible
			case 1 :
				print("
					<td width=\"25%\">
						<a href=\"#\" OnClick=\"javascript:apercu($row[0],$type_qsrc);return(false);\">
							<img src=\"../images/view.gif\" border=\"0\"  align=\"absmiddle\">
						</a>
					</td>	
					<td width=\"25%\">
						<a href=\"#\" OnClick=\"window.open('../evaluation/demo_evaluation.php?type=".get_evaluation_type_new_old_r($type_qsrc)."&theme=$theme&evaluation=$row[0]','demo','status=yes,scrollbars=yes,resizable=yes,width=800,height=600');return(false);\">
							$MSG_1380
						</a>
					</td>				
					<td width=\"25%\">
						<a href=\"qsrc.php?action_qsrc=creation_modification_qsrc&id=$row[0]&v_theme=$theme&type_qsrc=$type_qsrc&mode=1&retour=$retour&retour_action_qsrc=$action_qsrc\">
							$FORM_2
						</a>
					</td>
					<td width=\"25%\">
						<a href=\"#\" OnClick=\"window.open('../evaluation/verrou.php?id=$row[0]&type_evaluation=$type_qsrc','connecte','status=no,scrollbars=yes,resizable=yes,width=800,height=560');return(false);\">
							<img src=\"../images/link.gif\" border=\"0\">
						</a>
					</td>");
			break ;
			
			// dition et suppression impossible
			case 0 :
				print("
					<td width=\"25%\">
						<a href=\"#\" OnClick=\"javascript:apercu($row[0],$type_qsrc);return(false);\">
							<img src=\"../images/view.gif\" border=\"0\"  align=\"absmiddle\">
						</a>
					</td>	
					<td width=\"25%\">
						<a href=\"#\" OnClick=\"window.open('../evaluation/demo_evaluation.php?type=".get_evaluation_type_new_old_r($type_qsrc)."&theme=$theme&evaluation=$row[0]','demo','status=no,scrollbars=yes,resizable=yes,width=600,height=800');return(false);\">
							$MSG_1380
						</a>
					</td>
					<td width=\"25%\">
						&nbsp;
					</td>
					<td width=\"25%\">
						<a href=\"#\" OnClick=\"window.open('../evaluation/verrou.php?id=$row[0]&type_evaluation=$type_qsrc&list_stag=true','verrou','status=yes,scrollbars=yes,resizable=yes,width=800,height=560');return(false);\">
							<img src=\"../images/lock.gif\" border=\"0\">
						</a>
					</td>");
			break ;
		}
		print("
				</tr>
			</table>
		</td>
	</tr>");
	} 
	
	//PAS DE QSRC
	if($nb==0)
		print("
	<tr class=\"couleur2\">
		<td colspan=\"2\">
			<i>$MSG_916</i>
		</td>
	</tr>");
		
	print("
</table>");

	// Formulaire de suppression des sries par checkboxes
	print("
<br/>
<br/>
<table class=\"tableau_message\">
	<tr>
		<td colspan=\"2\">
			<input type=\"button\" name=\"cocher\" value=\"$FORM_24\" onClick=\"toutselect($nbSuppPossible)\">
			<input type=\"button\" name=\"decocher\" value=\"$FORM_25\" onClick=\"toutselect(-$nbSuppPossible)\"><br><br>
			<input type=\"submit\" value=\"$FORM_28\" name=\"suppression\">
			<input type=\"hidden\" value=\"$action_qsrc\" name=\"action_qsrc\">
			<input type=\"hidden\" value=\"$type_qsrc\" name=\"type_qsrc\">
			<input type=\"hidden\" value=\"$theme\" name=\"theme\">
		</td>
	</tr>");
	
	print("
	<input type=hidden name=\"retour\" value=\"$retour\">
</table>
</form>");
}
/*
print("
<br>
<a class=\"retour\" href=\"$retour_page\">$MSG_37</a>
");
*/
?>