<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
	Creation/modification d'une tape ressource
	@param integer $ressource identifiant de l'tape ressource (pour modification uniquement)
	@package ressource
*/
$perm->check('ADD,MOD');
//-----------------------------------------------------------------------------//
//							INITIALISATIONS
//-----------------------------------------------------------------------------//
if(!empty($ressource)){
	$res=get_etape_ressource($ressource);
	$row=pg_fetch_row($res,0);
	
}

//-----------------------------------------------------------------------------//
//                         SOUMISSION FORMULAIRE
//-----------------------------------------------------------------------------//
if(isset($subcreationressource)){
	//etape ressource
	if(!empty($ressource)&&$ressource!='NULL'){
		//maj_etape_ressource($ressource,set_ams_libelle(string2Sql($title)),int2Sql((int)$fichier), int2Sql((int)$numespace), int2Sql((int)$numsection));
		maj_etape_ressource($ressource,set_ams_libelle($title),int2Sql((int)$fichier), int2Sql((int)$numespace), int2Sql((int)$numsection));
		
	}else{
		$ressource=set_etape_ressource(set_ams_libelle($title),int2Sql((int)$fichier), int2Sql($numespace), int2Sql($numsection),$theme);
		
	}
	if($fichier){
		//$res=set_fichier_metadata($fichier, set_ams_libelle(string2Sql($motcle)),int2Sql($auth->getUserId()));
		$res=set_fichier_metadata($fichier, set_ams_libelle($motcle),int2Sql($auth->getUserId()));
	}
	$res=get_etape_ressource($ressource);
	$row=pg_fetch_row($res,0);
}

//-----------------------------------------------------------------------------//
//                          FONCTION PHP
//-----------------------------------------------------------------------------//
// javascript pour la gnration automatique des menus droulant
function gestion_fichier_javascript(){
    global $num_theme;
    print("<script language=\"javascript\">
    <!--\n");
    //$tabtype=array('f','fa','t','ta','s','sa', 'a');
    
    $tabtype=array('fa','ta','sa','da','a');
    $nb_type=sizeof($tabtype);
    print("var tabfich=new Array();\n");
    for($i=0;$i<$nb_type;$i++){
        print("tabfich[$i]=new Array();\n");
     	$res=0;
        if($tabtype[$i]=='fa'||$tabtype[$i]=='f')
            $res=get_theme_ressources_fichier($num_theme);
         if($tabtype[$i]=='t'||$tabtype[$i]=='ta')
            $res=get_theme_ressources_texte($num_theme);
         if($tabtype[$i]=='s'||$tabtype[$i]=='sa')
         	$res=get_theme_ressources_scenario($num_theme);
         if($tabtype[$i]=='d' || $tabtype[$i]=='da')
         	$res=get_theme_ressources_scenario_dynamique($num_theme);
         if($res){
        $nb_res=pg_num_rows($res);
        for($j=0;$j<$nb_res;$j++){
            print("tabfich[$i][$j]=new Array(");
            $row=pg_fetch_row($res,$j);
            $tmp_fichier=get_ams_libelles($row[1]);
            $row[1]=get_ams_libelle($tmp_fichier);
            print("\"$row[0]\",\"".addslashes($row[1])."\");\n");
        }
         }

    }
    print("//-->\n
    </script>");
}


//-----------------------------------------------------------------//
//    Initialisation
//-----------------------------------------------------------------//
// recup des themes des fichiers ressources (fichier + texte + scnario + scenario dynamique)

$restheme=get_plateforme_themes_ressource_fichier_texte();//
$nb_theme=pg_num_rows($restheme);
// si mode edition

if(isset($ressource) && !empty($ressource)){
	
	$libelle_ressource=$row[1];
	$mot_cle=$row[6];
	// recup info fichier
	$fic=$row[4];
	unset($type);
	if(!empty($fic)){
		$resfic=get_fichier($fic);
		$rowfic=pg_fetch_row($resfic,0);
		$libelle_fichier=$rowfic[1];
		switch($row[5]){
			case 1 : 
				$type='t';
				$resth=get_fichier_ressource_texte_themes($fic);
			break;
			
			case 5:
				$type='s';
				$resth=get_fichier_scenario_themes($fic);
			break;
			
			case 7 : 
				$type='f';
				$resth=get_fichier_ressource_fichier_themes($fic);
			break;
			
			case 15 :
				$type='d';
				$resth=get_fichier_scenario_dynamique_themes($fic);
			break;
		}
		// theme fichier
		$num_theme=pg_fetch_result($resth,0,0);
	}
	else{
		$type='a';
	}
	$id_espace=$row[2];
	$id_section=$row[3];
	if(!empty($fic)&&(!empty($id_espace)||!empty($id_section))){
		$type.='a';
	}
	// theme etape ressource
	$resth=get_etape_ressource_themes($ressource);
	$theme=pg_fetch_result($resth,0,0);
}
if(isset($num_theme) && !empty($num_theme)){
	gestion_fichier_javascript();
	$resthem=get_theme($num_theme);
	$libelle_theme=pg_fetch_result($resthem,0,1);
	$tmp_theme=get_ams_libelles($libelle_theme);
	$libelle_theme=get_ams_libelle($tmp_theme);
}
//-----------------------------------------------------------------//
//    Formulaire
//-----------------------------------------------------------------//
print("
<br/>
<table class=\"tableau_normal\">");

print("
<tr>
	<th colspan=\"2\">$MSG_2229</th>
</tr>");
//-------------------------//
//  TYPE D'ETAPE RESSOURCE
//-------------------------//
print("
<form name=\"Add1\" OnSubmit=\"return checkForm();\" method=\"post\">
");
// choix du type de ressource (fichier ou texte)
print("
<tr class=\"couleur1\">
	<td><b>$MSG_608 :</b></td>
	<td>
	<select name=\"type\" onChange=\"document.formtheme.type.value=this.value;chargefichier();\">
		<option value=\"\">$MSG_217</option>");
	
//$tabtype=array('f'=>"$MSG_125 (uniquement)",'fa'=>"$MSG_125 (espace/section)",'t'=>"$MSG_946(uniquement)",'ta'=>"$MSG_946(espace/section)",'s'=>"$MSG_922(uniquement)",'sa'=>"$MSG_922(espace/section)", 'a'=> "Espace/section (uniquement)");
$tabtype=array('fa'=>"$MSG_125 (".MSG_2067."/".MSG_2068.")",'ta'=>"$MSG_946(".MSG_2067."/".MSG_2068.")",'sa'=>"$MSG_922(".MSG_2067."/".MSG_2068.")",'da'=>"$MSG_2551(".MSG_2067."/".MSG_2068.")", 'a'=> MSG_2067."/".MSG_2068." (".MSG_2659.")");
$nb_type=sizeof($tabtype);

for($i=0;$i<$nb_type;$i++){
	list($ind,$texte)=each($tabtype);
	/*
	$tmp_texte=get_ams_libelles($texte);
    
    $texte=get_ams_libelle($tmp_texte,80);
    */
	if($ind==$type)
		$texte_selected="selected";
	else
		$texte_selected="";
	print("
		<option value=\"$ind\" $texte_selected>$texte</option>");
}
print("
	</select>
	</td>
</tr>
</form>");

//-------------------------//
//      DONNEES FICHIER
//-------------------------//
print("
<form name=\"formtheme\" method=get>
<tr class=\"couleur1\">
	<td><b>$MSG_214: </b></td>
	<td><select name=\"num_theme\" onchange=\"validetheme()\">
	<option value=\"\">$MSG_217</option>
	");
	for($t=0;$t<$nb_theme;$t++){
		$rowtheme=pg_fetch_row($restheme,$t);
		$tmp_theme=get_ams_libelles($rowtheme[1]);
        $rowtheme[1]=get_ams_libelle($tmp_theme,50);
		//print_r($rowtheme);
		if($num_theme==$rowtheme[0])
			print("
			<option value=\"$rowtheme[0]\" selected>$rowtheme[1]</option>
			");
		else
			 print("
			<option value=\"$rowtheme[0]\">$rowtheme[1]</option>
			");
	}
	print("
	</select></td>
</tr>
<input type=\"hidden\" name=\"action_ressource\" value=\"creation_ressource\">
<input type=\"hidden\" name=\"ressource\" value=\"$ressource\">
<input type=\"hidden\" name=\"type\" value=\"$type\">
</form>
");

// choix fichier
print("
<form name=\"Add\" OnSubmit=\"return checkForm();\" method=\"post\">
<tr class=\"couleur1\">
	<td><b>$MSG_2491 :</b></td>
	<td>
	<select name=\"fichier\">
		<option value=\"\">$MSG_217</option>
	</select>
	</td>
</tr>");

// les mots cles
/*
print("
<tr class=\"couleur1\">
	<td><b>$MSG_143 :</b></td>
	<td>
	<textarea name=\"motcle\" wrap=\"physical\" cols=\"40\" rows=\"2\">");
	if(!empty($ressource))
		print("$mot_cle");
	else
		print("mot1;mot2");
	print("</textarea><br>$MSG_2400
	</td>
	
</tr>
");
*/
// les mots cles
if(!empty($ressource))
	$mots_cles=$mot_cle;
else
	$mots_cles=MSG_143;
print("
<tr class=\"couleur1\">
<td><b>$MSG_143 :</b></td>
<td>".get_gui_libelle_textearea('motcle',$mots_cles)."</td></tr>
");



//-------------------------//
//      ESPACE/SECTION
//-------------------------//
print ("
 <tr class=\"couleur2\">
    <td><b>$MSG_139 : </b></td>
    <td><select name=\"numespace\">
        ");

        print "
			<option value=\"\"$texte_selected>$MSG_217</option>";
        //On recupre les espaces
        //$resesp=pg_query($database,"select * from ressource_esp;");
        //$numresesp=pg_numrows($resesp);
        $resesp=get_plateforme_espaces();
        $nb_espace=pg_numrows($resesp);
        for($i=0;$i<$nb_espace;$i++) {
            $rowesp=pg_fetch_row($resesp,$i);
            $tmp_espace=get_ams_libelles($rowesp[1]);
        	$rowesp[1]=get_ams_libelle($tmp_espace,50);
            if ($id_espace==$rowesp[0]){
                $texte_selected=" selected";
            }
            else{
                $texte_selected="";
            }
            print "
				<option value=\"$rowesp[0]\"$texte_selected>$rowesp[1]</option>";
        }
        print ("
        </select>
    </td>
</tr>
<tr class=\"couleur2\">
    <td><b>$MSG_141 : </b></td>
    <td><select name=\"numsection\">
        ");
        print "
			<option value=\"\"$texte_selected>$MSG_217</option>";        
        //On recupre les sections
        //$ressec=pg_exec($database,"select * from ressource_sec;");
        //$numressec=pg_numrows($ressec);
        $ressec=get_plateforme_sections();
        $nb_sec=pg_numrows($ressec);
        for($i=0;$i<$nb_sec;$i++) {
            $rowsec=pg_fetch_row($ressec,$i);
            $tmp_section=get_ams_libelles($rowsec[1]);
        	$rowsec[1]=get_ams_libelle($tmp_section,50);
            if ($id_section==$rowsec[0]){
                $texte_selected=" selected";
            }
            else{
                $texte_selected="";
            }
            print "<option value=\"$rowsec[0]\"$texte_selected>$rowsec[1]</option>";
        }
        print ("
        </select>
    </td>
</tr>
<tr class=\"couleur2\"><td></td><td>$MSG_2230</td></tr>
");

//ligne blanche de sparation
print ("
	<tr class=\"#ffffff\">
		<td align=\"center\" colspan=\"4\" style=\"height:10%\">
		</td>
	</tr>");
	
//-------------------------//
//DONNEES RESSOURCE A CREER
//-------------------------//
print("
<tr>
	<th colspan=\"2\">$MSG_2606</th>
</tr>
");

// theme pour la ressource
// recup des theme de la plateforme
$restheme=get_plateforme_themes();
$nb_theme=pg_num_rows($restheme);
print("
<tr class=\"couleur2\">
<td><b>$MSG_214: </b></td>
<td><select name=\"theme\">
");
if(isset($num_theme) && !empty($num_theme))
	print("
	<option value=\"$num_theme\">$libelle_theme</option>
	");
else
	print("
	<option value=\"\">$MSG_217</option>
	");
for($t=0;$t<$nb_theme;$t++){
	$rowtheme=pg_fetch_row($restheme,$t);
	$tmp_theme=get_ams_libelles($rowtheme[1]);
     $rowtheme[1]=get_ams_libelle($tmp_theme,50);
	//print_r($rowtheme);
	if($theme==$rowtheme[0])
		print("
		<option value=\"$rowtheme[0]\" selected>$rowtheme[1]</option>
		");
	else
		 print("
		<option value=\"$rowtheme[0]\">$rowtheme[1]</option>
		");
}
print("
</select></td></tr>

");

// choix libelle
/*
print("
<tr class=\"couleur2\">
<td><b>$MSG_2074 : </b></td>
<td><input type=\"text\" name=\"title\" size=\"40\" value=\"".htmlentities($libelle_ressource,ENT_QUOTES,CHARSET)."\"></td>
</tr>
");
*/
// libelle etape ressource
print("
<tr class=\"couleur2\">
<td colspan=\"2\" align=\"center\"><b>$MSG_2074 : </b>".get_gui_libelle_input('title',$libelle_ressource)."</td>
</tr>
");
// submit
print("
 <tr class=\"couleur1\">
 <td colspan=\"2\" align=\"center\">
 <input type=\"submit\" name=\"subcreationressource\" value=\"$FORM_6\">
 </td>
 </tr>
");
// les hidden
print("
<input type=\"hidden\" name=\"action_ressource\" value=\"$action_ressource\">
");
if(isset($ressource))
	print("
    <input type=\"hidden\" name=\"ressource\" value=\"$ressource\">
    <input type=\"hidden\" name=\"nom_fichier_ressource\" value=\"$nom_fichier_ressource\">
    ");
else
	print("
	<input type=\"hidden\" name=\"nom_fichier_ressource\" value=\"\">
	");
print("
<input type=\"hidden\" name=\"id_fichier\" value=\"$fic\">
</form>
</table>
");

?>