<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
	Lister les ressources
	@package ressource
*/
$perm->check('LST');
/*-----------------------------------------------------------------*/
//    Initialisation
/*-----------------------------------------------------------------*/
// recup des themes des ressource
$restheme=get_plateforme_themes_etape_ressource();
$nb_theme=pg_num_rows($restheme);


/*-----------------------------------------------------------------*/
//    Formulaire
/*-----------------------------------------------------------------*/
print("
<br/>
<table class=\"tableau_message\">
<form name=\"formtheme\" method=get>
");
// le theme des fichiers (fichier ou texte)
print("
<tr>
<td><b>$MSG_117 : </b></td>
<td><select name=\"num_theme\" onchange=\"validetheme()\">
<option value=\"\">$MSG_217</option>
");
for($t=0;$t<$nb_theme;$t++){
	$rowtheme=pg_fetch_row($restheme,$t);
	$tmp_theme=get_ams_libelles($rowtheme[1]);
    
    $rowtheme[1]=get_ams_libelle($tmp_theme,80);
	//print_r($rowtheme);
	if($num_theme==$rowtheme[0])
		print("
		<option value=\"$rowtheme[0]\" selected>$rowtheme[1]</option>
		");
	else
		 print("
		<option value=\"$rowtheme[0]\">$rowtheme[1]</option>
		");
}
print("
</select></td></tr>
<input type=hidden name=\"action_ressource\" value=\"lister_ressource\">

</form>
</table>
<br>
");

if(isset($num_theme) && !empty($num_theme)){
	//$res=get_theme_ressources($num_theme);
	$res=get_theme_etapes_ressource($num_theme);
	$nb=pg_num_rows($res);
	//echo "nb=$nb<br>";
	print("
	<table class=\"tableau_espace\">
	<tr>
	<th>$MSG_606</th>
	<th>$MSG_2067</th>
	<th>$MSG_2068</th>
	<th>$MSG_125</th>
	<th>$MSG_608</th>
	<th>$MSG_2506</th>
	<th>$FORM_36</th>
	</tr>
	");
	// boucle sur les ressources
	for($i=0;$i<$nb;$i++){
		$row=pg_fetch_row($res,$i);
		
		// recup infos fichier si existe
		if($row[5]){
			$resfichier=get_fichier($row[5]);
			$rowfichier=pg_fetch_row($resfichier,0);
			// type de fichier
			switch($rowfichier[2]){
				case 1 : $type=$MSG_955;break;
				case 7 : $type=$MSG_125;break;
				case 5 : $type=$MSG_922;break;
				case 15 : $type=$MSG_2551;break;
			}
		}
		else{
			$rowfichier[1]='-';
			$type='';
		}
		$classcolor='couleur'.(($i%2)+1);
		$ressource_action=get_etape_ressource_actions($row[0]);
		// recup espace et section si existe
		$libelle_espace='';
		$libelle_section='';
		if(!empty($row[2])){
			$res_espace=get_espace($row[2]);
			$libelle_espace=pg_fetch_result($res_espace,0,1);
			if(!empty($row[3])){
				$res_section=get_section($row[3]);
				$libelle_section=pg_fetch_result($res_section,0,1);
			}
		}
		print("
		<tr class=\"$classcolor\">
		<td>".get_gui_libelle($row[1],false)."</td>
		<td><!--$row[2]--> ".get_gui_libelle($libelle_espace,false)."</td>
		<td><!--$row[3]--> ".get_gui_libelle($libelle_section,false)."</td>
		<td>".get_gui_libelle($rowfichier[1],false)."</td>
		<td>$type</td>
		<td>".get_gui_libelle($row[6],false)."</td>
		");
		print("
		<td>
		");
		if($ressource_action!=0){
			
			if($perm->have_perm('MOD')){
			print("
			<a href=\"./ressource.php?action_ressource=editer_ressource&ressource=$row[0]&num_theme=$num_theme\">$FORM_2</a>
			");
			}
			
			if($ressource_action==2)
				if($perm->have_perm('DEL')){
				print("
				<br><a href=\"./ressource.php?action_ressource=supprimer_etape_ressource&ressource=$row[0]&num_theme=$num_theme\">$FORM_4</a>
				");
				}
		}
		else
			print("&nbsp;");
		print("
		</td></tr>
		");
		
	}
	print("
	</table>
	");
}
print("
<br>
<a class=\"retour\" href=\"../module_menu/module_menu.php?action_ressource=gestion_ressource\">$MSG_37</a>
");
?>