<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

class guiBoScenarioEditorAssociation extends PageComponent{
	function guiBoScenarioEditorAssociation($block_target,$obj_scenario,$selected_bloc_ordre,$selected_bloc_id,$renderer_factories,$module_root=null,$templates=null,$theme=0,$style_theme=0){
		messageDebug("guiBoScenarioEditorAssociation($block_target,\$obj_scenario,$selected_bloc_ordre,$selected_bloc_id,\$renderer_factories,$module_root=null,$templates=null,$theme=0)");
	
		global $root;
		
		parent::PageComponent($module_root,$templates);

		$this->set_var('SCENARIO_BLOC_ADD_LIBELLE',MSG_2618);
		$this->set_var('SCENARIO_ID',$obj_scenario->getId());
		$obj_component_factory=$obj_scenario->getComponentsFactory();
		$this->set_var('SCENARIO_RENDERER',$obj_component_factory->getType());

		
		$val['SCENARIO_EDITOR_TITRE_EXPLICATIONS']=MSG_2664;
		$val['SCENARIO_EDITOR_EXPLICATIONS']=MSG_2665;
		$this->set_var($val);
		$theme_scenario=$obj_scenario->getThemes(0);
		$component=new guiBoScenarioEditorCreation('scenario_creation',$obj_scenario,$renderer_factories,$module_root,array('scenario_creation' => 'gui_bo_scenario_editor_creation.tpl'),$theme_scenario[0],$obj_scenario->getLibelle(),$style_theme);
		$this->setComponent('scenario_creation', $component);
		
		//cr�ation du bloc 
		if(!empty($selected_bloc_ordre)||$selected_bloc_ordre==0){
			$obj_bloc=$obj_scenario->getObjBloc($selected_bloc_ordre);
			$tmp=$obj_bloc->getId();
		}
		
		// insertion 
		if($selected_bloc_id!=$tmp){
			$obj_bloc=new FichierScenarioDynamiqueBloc($obj_scenario->getId(),$obj_scenario->getComponentsFactory());
			$obj_bloc->setOrdre($selected_bloc_ordre);
			
		}
		if(!empty($selected_bloc_id)){
			$obj_bloc->setId($selected_bloc_id);
		}
		
		if((!empty($selected_bloc_ordre)||$selected_bloc_ordre=='0')&&empty($selected_bloc_id)){
			$bloc_selection_disabled=false;
		}else{
			$bloc_selection_disabled=true;
		}
		$component=new guiBoScenarioEditorBlocSelection('bloc_selection',$obj_scenario,$obj_bloc,$module_root,array('bloc_selection' => 'gui_bo_scenario_editor_bloc_selection.tpl'),$bloc_selection_disabled,$theme);
		$this->setComponent('bloc_selection', $component);
		
		$obj_component_factory=$obj_scenario->getComponentsFactory();
		
		$render_class=$obj_component_factory->getGuiRendererClass();
		$render_tpl=$obj_component_factory->getGuiRendererTpl();
		$component=new $render_class('scenario_dynamique',$obj_scenario,$module_root,array('scenario_dynamique' => $render_tpl),$theme);
		$this->setComponent('scenario_dynamique', $component);

		if(is_object($obj_bloc)&&$obj_bloc->getId()){//
			$component=new guiBoScenarioEditorBlocEdition('bloc_edition',$obj_scenario,$obj_bloc,$module_root,array('bloc_edition' => 'gui_bo_scenario_editor_bloc_edition.tpl'));
			$this->setComponent('bloc_edition', $component);
		}
	}
	
}
?>