<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Affichage des �l�ments graphiques associ�s � l'�dition/cr�ation d'un bloc.
 * 
 */
class guiBoScenarioEditorBlocEdition extends PageComponent{
	
	/**
	 * @param string $block_target Bloc cible dans lequel on veut afficher ce PageComponent
	 * @param string $obj_scenario
	 * @param string $bloc_ordre Num�ro d'ordre dans le sc�nario dynamique pour le bloc � ajouter/�diter
	 * @param string $bloc_id Identifiant du bloc � ajouter/�diter
	 * @param string $module_root Chemin racine des fichiers de templates (TPL)
	 * @param string $templates Les fichiers de Templates
	 */
	function guiBoScenarioEditorBlocEdition($block_target,$obj_scenario,$obj_bloc,$module_root=null,$templates=null){
		messageDebug("guiBoScenarioEditorBlocEdition($block_target,\$obj_scenario,\$obj_bloc,$module_root=null,$templates=null)");
	
		global $chemin_fo;
		parent::PageComponent($module_root,$templates);
		//print_rr($obj_bloc);
	
		$scenario_id=$obj_scenario->getId();
		$bloc_ordre=$obj_bloc->getOrdre();
		$bloc_id=$obj_bloc->getId();

		$val['SCENARIO_ID']=$scenario_id;
		$val['BLOC_ORDRE']=$bloc_ordre;
		$val['BLOC_ID']=$bloc_id;
		$obj_component_factory=$obj_scenario->getComponentsFactory();
		$val['SCENARIO_RENDERER']=$obj_component_factory->getType();
		$val['SCENARIO_EDITION_BLOC_ACTION']='load_bloc';
//		$val['SCENARIO_SELECTION_BLOC_LIBELLE']='Sélectionner ce bloc';

		if($obj_bloc->isEmpty()){
			$val['SCENARIO_EDITION_BLOC_LIBELLE']=MSG_2619;
		}else{
			$val['SCENARIO_EDITION_BLOC_LIBELLE']=MSG_2620;
		}
		$val['SCENARIO_ANNULATION_BLOC_LIBELLE']=MSG_1954;
		
		//bloc s�lectionn�, on affiche le formulaire de saisie associ�
		if( (!empty($scenario_id) )&& (!empty($bloc_ordre)||$bloc_ordre==0) && (!empty($bloc_id)) ){
//			print_rr($obj_bloc);
			$component=new guiBoScenarioEditorBlocInput('bloc_input',$obj_bloc,$obj_scenario->getComponentsFactory(),$obj_bloc->getTemplatesPath(),array('bloc_input' => $bloc_id.'.tpl'));
			$this->setComponent('bloc_input', $component);
			
			//déjà affecté au dessus
			$val['SCENARIO_EDITION_BLOC_ACTION']='associate_bloc';
		}
//		else{
//			echo "pas de bloc";
//		}
		parent::set_var($val);
	}
	
	function submit($post){
//		print_rr($post);
		global $ERROR_118,$ERROR_119,$WARN_138;
		if(!empty($post['bloc_id'])&&!empty($post['scenario_id'])&&(!empty($post['bloc_ordre'])&&(!empty($post['renderer']))||$post['bloc_ordre']==0)){
			
			//on charge le scenario
			//$obj_scenario=new FichierScenarioDynamique($post['scenario_id']);
			$obj_ScenarioEditorFactoryBuilder=new  ScenarioEditorFactoryBuilder();
			$obj_scenario=new FichierScenarioDynamique($post['scenario_id'],"",null,$obj_ScenarioEditorFactoryBuilder->createFactory($post['renderer']));
			if(!is_object($obj_scenario))die("Erreur creation objet 3");
		
			//on ajoute le bloc au scenario
			$res=$obj_scenario->setBloc($post['bloc_id'],$post['bloc_ordre'],$post);
			if($res){
				$msg=$WARN_138;
				$msg_code=MSG_CONFIRM;
//				$action="associate";
				$action=array("associate",$post['id_theme'],$post['renderer']);
				
			}else{
				$old_message=AstairsTemplate::getPageMessage();
				$msg=$ERROR_118.$old_message['MSG'];
				$msg_code=MSG_ERROR;
//				$action="load_bloc";
				$action=array("load_bloc",$post['id_theme'],$post['renderer']);
			}
		}else{
			
//		echo "erreur";
//			if(!empty($post['id_theme'])){
//				$action=array("load_bloc",$post['id_theme']);
//				exit;
//			}
//			else{
//				print_rr($post);
				$msg=$ERROR_119;
				$msg_code=MSG_ERROR;
//				$action="load_bloc";
				$action=array("load_bloc",$post['id_theme'],$post['renderer']);
//			}
//			echo "erreur";
//			print_rr($_POST);
		}
//		echo  $msg;
		AstairsTemplate::setPageMessage($msg,$msg_code);
//		print_rr($action);
		return $action;
	}
}
?>