<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

class guiBoScenarioEditorCreation extends PageComponent{
	function guiBoScenarioEditorCreation($block_target,$obj_scenario,$renderer_factories,$module_root=null,$templates=null,$theme=0,$libelle="",$style_theme=null){
		global $root,$chemin_fo,$MSG_606,$MSG_394,$MSG_513,$ERROR_123;
		parent::PageComponent($module_root,$templates);
		
		if(is_object($obj_scenario)){
			$cur_style=$obj_scenario->getStyle();
			$cur_renderer=$obj_scenario->getRenderer();
			
			$component=new guiBoSelectScenarioEditorRenderer('renderer_selection',$renderer_factories,$module_root,array('renderer_selection' => 'gui_bo_select_scenario_editor_renderer.tpl'),$cur_renderer,false,'');
			$this->setComponent('renderer_selection', $component);
			
			$component= new guiAmsLibelleInput($obj_scenario->getLibelle(),'scenario_libelle',"$root/lib_graphique/objets/langue/templates/tpl",array('scenario_libelle_input'=>'gui_ams_libelle_input.tpl'),$disabled,30,$onKeyUp,MSG_606);
			$this->setComponent('scenario_libelle_input', $component);
			
			$val['SCENARIO_CREATION_LIBELLE']=$MSG_513;
			$val['SCENARIO_ID']=$obj_scenario->getId();
			$val['ACTION']='submit_modify';
			$theme_disabled=true;
		}
		else{
			$component= new guiAmsLibelleInput($libelle,'scenario_libelle',"$root/lib_graphique/objets/langue/templates/tpl",array('scenario_libelle_input'=>'gui_ams_libelle_input.tpl'),$disabled,30,$onKeyUp,MSG_606);
			$this->setComponent('scenario_libelle_input', $component);
			
				
			$val['SCENARIO_CREATION_LIBELLE']=$MSG_394;
			$val['ACTION']='submit_create';
		}	
//		$component=new guiSelectTheme('theme_selection',"$root/lib_graphique/selects/selectTheme/templates/tpl/",array('theme_selection' => 'gui_select_theme.tpl'),'id_theme',$theme,$theme_disabled,'javascript:submitForm(this)');
		$component=new guiSelectTheme('theme_selection',"$root/lib_graphique/selects/selectTheme/templates/tpl/",array('theme_selection' => 'gui_select_theme.tpl'),'id_theme',$theme,$theme_disabled);
		$this->setComponent('theme_selection', $component);
		
		$component=new guiBoSelectScenarioEditorStyle('style_selection',$style_theme,"$root/lib_graphique/selects/selectStyle/templates/tpl/",array('style_selection' => 'gui_select_style.tpl'),$cur_style,false,'');
		$this->setComponent('style_selection', $component);
		
		$component=new guiBoSelectScenarioEditorRenderer('renderer_selection',$renderer_factories,$module_root,array('renderer_selection' => 'gui_bo_select_scenario_editor_renderer.tpl'),$cur_renderer,false,'');
		$this->setComponent('renderer_selection', $component);
		
		
//		$val['SCENARIO_LIBELLE_LABEL']=$MSG_606;
		$val['SCENARIO_CREATION_ON_CLICK']='return validScenarioCreationForm(document.scenario_editor_creation,\''.$ERROR_123.'\');';
		parent::set_var($val);
	}
	
	function submit($post){

		if(!empty($post['scenario_libelle'])&&!empty($post['id_style'])&&!empty($post['id_renderer'])){

			$obj_ScenarioEditorFactoryBuilder= new ScenarioEditorFactoryBuilder();
						
			//cr�ation
			if(!empty($post['id_theme'])&&empty($post['scenario_id'])&&!empty($post['id_renderer'])){
								
				$obj_scenario=new FichierScenarioDynamique(0,$post['scenario_libelle'],int2Sql($post['id_style']),$obj_ScenarioEditorFactoryBuilder->createFactory($post['id_renderer']));
				if($obj_scenario->insertToDB(int2Sql($post['id_theme']))){
					$msg=WARN_139;
					$msg_code=MSG_CONFIRM;
					$id=$obj_scenario->getId();
					$action=array("associate",$post['id_theme'],$id,$post['id_renderer']);
					
				}else{
					$msg=ERROR_120;
					$msg_code=MSG_ERROR;
					$action="create";
				}
			}
			//�dition
			else{
				$obj_scenario=new FichierScenarioDynamique(int2Sql($post['scenario_id']),$post['scenario_libelle'],int2Sql($post['id_style']),$obj_ScenarioEditorFactoryBuilder->createFactory($post['id_renderer']));
				if($obj_scenario->updateToDB()){
					$msg=WARN_140;
					$msg_code=MSG_CONFIRM;
					$id=$obj_scenario->getId();
					$action=array("associate",$post['id_theme'],$id,$post['id_renderer'],$post['style_theme']);
				}else{
					$msg=ERROR_122;
					$msg_code=MSG_ERROR;
					$action="create";
				}
			}
		}else{
			//selection du theme
			if(!empty($post['id_theme'])){
				$action=array("create",$post['id_theme'],null,$post['scenario_libelle'],$post['id_renderer'],$post['style_theme']);
			}else{
				$msg=ERROR_121;
				$msg_code=MSG_ERROR;
				$action="create";
			}
		}
		AstairsTemplate::setPageMessage($msg,$msg_code);
		return $action;
	}
}
?>