<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Affichage d'une AstairsPage de Back-office spcifique  langue editor
 */ 
class guiBoScenarioLstPage extends AstairsPageBo{
	
	/**
	 * Constructeur.
	 * Appel du constructeur pre (AstairsPageBO) avec les valeurs ncssaires  l'affichage du lien retour  null.
	 * @param string $astairs_titre Titre  afficher 
	 * @param string $astairs_retour_libelle Libell du lien retour  afficher
	 * @param string $astairs_retour_url URL du lien retour  afficher 
	 * @param string $astairs_retour_title Message sur le title du retour ( un retour par exemple)
	 * @param object PageBuilder $pageBuilder L'objet permettant de crer une page
	 * @param Array $templates Les templates  utiliser pour la cration de la page
	 * @param Array $style_files Les feuilles de style
	 * @param Array $javascript_files Les fichiers javascript
	 * @param string $javascript_internal_code Le code javascript interne
	 */
	function guiBoScenarioLstPage($astairs_titre, $astairs_retour_libelle,$astairs_retour_url,$astairs_retour_title,$pageBuilder,$templates,$style_files,$javascript_files,$javascript_internal_code,$obj_table_model,$page_titre=""){
		parent::AstairsPageBO($pageBuilder,$templates,$style_files,$javascript_files,$javascript_internal_code,$astairs_titre, $astairs_retour_libelle,$astairs_retour_url,$astairs_retour_title,$page_titre);
		global $root,$auth;
		global $submit_editor;
		global $num_page;
		global $_POST;
		global $MSG_2501,$MSG_2502,$MSG_2615,$MSG_1085,$FORM_6,$MSG_215;
	
	
		if(is_object($obj_table_model)){
			$filter_box=$obj_table_model->getDataFilter();	
		}
		
		if(!is_object($filter_box)){
			$user_id=$auth->getUserId();
			$req="SELECT * FROM contraintes.af_get_categorie_themes(".TYPE_CATEGORIE_FICHIER_SCENARIO_DYNAMIQUE.",$user_id)AS (id integer, libelle varchar)";
			$value=null;
			$disabled="";
			$valeur=null;
			$filters[]=new DataFilterSelect($MSG_215,'theme',$value,$disabled,$req,$valeur);
		
			
			// saisie du message
			$filters[]=new DataFilterInput($MSG_2615,'message',50,null,$disabled);
			
			// max messages par page
			// la requete
			$req='select * from contraintes.af_gen_get_int_values(10,100) as (id integer,val integer)';
			$value=null;
			$disabled=false;
			$valeur=null;
			$filters[]=new DataFilterSelect("$MSG_1085",'max_par_page',$value,$disabled,$req,$valeur);
			
//			
			// Ecriture Dynamique de la fonction "fonction_page"
			$fonction_page='get_theme_scenarios_dynamiques_colonnes_libelles(';
			$tab_param_supplementaire=array("##num_champ##","##classement##","##offset##");
			$nb_param_supplementaire=sizeof($tab_param_supplementaire);
			// affecte autant d'arguments qu'il y a de filters
			$nb_filters=sizeof($filters);
			for($f=0;$f<$nb_filters;$f++){
				//$num_filter=$f+1;
				if($f==$nb_filters -1)
					$fonction_page .="##$f##";
				else
					$fonction_page .="##$f##,";
					
			}
			// Ajoute les paramtres supplmentaires s'il y en a
			for($e=0;$e<$nb_param_supplementaire;$e++){
				$fonction_page .=",$tab_param_supplementaire[$e]";	
			}
			// ferme la parenthse
			$fonction_page .=")";
			
			$query='select * from contraintes.af_get_theme_fichiers_scenarios_dynamiques(##0##, ##1##) as (id int4, libelle varchar, type int4, connecte bool, style integer,date_creation date)';
			
			$disabled=false;
			$filter_box=new DataFilterBox('form_langue_editor',$query,$fonction_page,$filters,'','submit_editor',$FORM_6,$disabled);
			$obj_table_model->setDataFilter($filter_box);
		}
		
		$component=new guiDataFilterBox('data_filter_box',$filter_box,$root."lib_graphique/tables/tableModel/templates/tpl",array('data_filter_box' => 'gui_data_filter_box.tpl'));
 		$this->setComponent('data_filter_box',$component,true);
		
		$table_model_gui_line_struct=new TableModelGuiLineStruct(array('0'=>TABLE_MODEL_LINE_ID,'1'=>TABLE_MODEL_LINE_INPUT,'2'=>TABLE_MODEL_LINE_DATE),TABLE_MODEL_LINE_LABEL);
		
		// ajoute en parametre $table_model_gui_line_struct (je suggre en 2eme)
		$component=new guiTableModel($obj_table_model,$table_model_gui_line_struct,$root."lib_graphique/tables/tableModel/templates/tpl",array('table_model' => 'gui_table_model.tpl'));
		$this->setComponent('table_model', $component,true);
	
		
 	 	$obj_data_filter=$obj_table_model->getDataFilter();
	}
}
?>
