<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/


require("../dbpostgres.php3");
$db = pg_Connect("$server", "", "", "","$nombase");
if(!$db) {
  die($ERROR_2);
}


//recupere le nom et prenom d'un utilisateur
function getUser($numuser){
    $sql="select nom,prenom from utilisateurs where num_user=$numuser";
    $res=pg_query($sql);
    $row=pg_fetch_row($res,0);
    $str=$row[1]." ".$row[0] ;
    return $str ;
}

// recupere le nom d'un paquet scorm
function getNomPaquet($numpaquet){
    $sql="select name from scorm where id=$numpaquet";
    $res=pg_query($sql);
    $row=pg_fetch_row($res,0);
    $str=$row[0] ;
    return $str ;
}

// fonction de remise  zero d'un paquet (RAZ)
function reinitPaquet($numcal,$numpaquet,$numuser){
    $sql="update scorm_sco_users set cmi_core_lesson_location='',cmi_core_lesson_status='not attempted',cmi_core_exit='',cmi_core_total_time='00:00:00',
        cmi_core_session_time='00:00:00',cmi_core_score_raw='0' where userid=$numuser and scormid=$numpaquet and num_cal=$numcal";
    $maj=pg_query($sql);
}

// fonction qui calcul le score d'un utilisateur pour un paquet prcis
function calculScore($numcal,$numpaquet,$numuser){
    $sql="select cmi_core_score_raw from scorm_sco_users where userid=$numuser and scormid=$numpaquet and num_cal=$numcal";
    $res=pg_query($sql);
    $nb=pg_num_rows($res);
    //initialisation
    $score=0;
    //addition des scores de chaque tape
    for($i=0;$i<$nb;$i++){
        $row=pg_fetch_row($res,$i);
        $score+=$row[0];
    }
    //debug
    //echo "nb=$nb<br>";
    //echo "score=$score<br>";
    return $score ;
}

// calcul le tps pass par un utilisateur sur un paquet prcis
function calculTemps($numcal,$numpaquet,$numuser){
    $sql="select cmi_core_total_time from scorm_sco_users where userid=$numuser and scormid=$numpaquet and num_cal=$numcal";
    $res=pg_query($sql);
    $nb=pg_num_rows($res);
    //initialisation
    $heure=0;
    $min=0;
    $sec=0;
    //addition des dures de chaque tape
    for($i=0;$i<$nb;$i++){
        $row=pg_fetch_row($res,$i);
        $tab=explode(":",$row[0]);
        $heure+=$tab[0];
        $min+=$tab[1];
        $sec+=$tab[2];
        //debug
        //echo "row[$i]=$row[0] : heure=$heure et min=$min et sec=$sec<br>";
    }
    //conversion du rsultat obtenu en timestamp
    $time=mktime($heure,$min,$sec);
    //formatage du timestamp en format horaire
    $time=date("H:i:s",$time);
    //debug
    //echo "nb=$nb<br>";
    //echo "time=$time<br>";
    return $time ;
}


// function qui affiche le details d'un paquet pr un utilisateur
function detailsPaquetUser($numcal,$numpaquet,$numuser) {
    $sql="select title,cmi_core_total_time,cmi_core_score_raw, cmi_core_lesson_status from scorm_sco_users,scorm_scoes where num_cal=$numcal and userid=$numuser and scormid=$numpaquet and scoid=scorm_scoes.id order by scorm_scoes.id";
    $res=pg_query($sql);
    $nb=pg_num_rows($res);
    print("
        <table border=\"1\" cellpading=\"5\">
            <tr>
                <td><b>Nom tape</b></td>
                <td><b>Temps pass</b></td>
                <td><b>Score obtenu</b></td>
                <td><b>Status</b></td>
            </tr>
    ");
    for($i=0;$i<$nb;$i++){
        $row=pg_fetch_row($res,$i);
        print("
            <tr>
                <td>$row[0]</td>
                <td align=\"center\">$row[1]</td>
                <td align=\"center\">$row[2]</td>
                <td>$row[3]</td>
            </tr>
        ");
    }
    print("
        </table>
    ");
}

//crer une liste des paquets scorm
function listerPaquetsMode() {
    $sql="select id from scorm" ;
    $res=pg_query($sql);
    $nbpaquet=pg_num_rows($res);
        print("
            <form name=\"formpaquet\" method=\"post\" action=\"actions.php?do=mode\">
            Slectionnez un paquet :
            <select name=\"paquet\">
            ");
            for($i=0;$i<$nbpaquet;$i++) {
                $row=pg_fetch_row($res,$i);
                $paquet_id=$row[0] ;
                $sql="select name from scorm where id=$paquet_id";
                $res2=pg_query($sql);
                $row=pg_fetch_row($res2,0);
                $name=$row[0] ;
                print("
                <option value=\"$paquet_id\">$name</option>
                ");
            }
            print("
            </select><br><br>
            Slectionnez un mode :
            <select name=\"mode\">
                <option value=\"popup\">Popup</option>
                <option value=\"none\">Pas de Popup</option>
            </select><br><br>
            <input type=\"submit\" value=\"Valider\">
            </form>
        ");
}

// fonction de changement de mode d'execution d'un paquet : Popup ou non ?
function chgtModeExecution($numpaquet,$modepaquet){
    /*
    if($modepaquet=="popup")
            $popup="resizable=1,scrollbars=1,status=1,height=400,width=620,location=0,menubar=0,toolbar=0";
    else $popup="";
    */
    $sql="update scorm set popup='$modepaquet' where id=$numpaquet";
    $maj=pg_query($sql);
}

//fonction qui permet d'afficher les etapes et le mode de fonctionnement d'un paquet et qui permet de l'diter
function infosPaquet($numpaquet){
    $nom=getNomPaquet($numpaquet);
    print("
        <table border=\"0\" cellpadding=\"5\">
            <tr>
                <td colspan=\"4\"><b>Nom paquet :</b> $nom</td>
            </tr>
    ");

    $sql="select title,type from scorm_scoes where scorm=$numpaquet order by id";
    $res=pg_query($sql);
    $nb=pg_num_rows($res);
    for($i=0;$i<$nb;$i++){
        $row=pg_fetch_row($res,$i);
        $type=$row[1];
        $titre=$row[0];
        if($type=="") $type="title";
        $numetape=$i+1;
        print("
            <tr>
                <td>&nbsp;&nbsp;</td>
                <td>Etape $numetape</td>
                <td><i>($type)</i></td>
                <td>$titre</td>
            </tr>
        ");
    }
    print("
        <tr>
            <td colspan=\"4\"><b>Mode d'execution :</b> <a href=\"actions.php?do=popup&scormid=$numpaquet\">Modifier</a></td>
        </tr>
        </table>
    ");
}

function editMode($numpaquet){
    /*
    $sql="select popup from scorm where id=$numpaquet";
    $res=pg_query($sql);
    $row=pg_fetch_row($res,0);
    $mode=$row[0];
    $tab=explode(",",$mode);
    print_r($tab);
    $nb=sizeof($tab) ;

    for($i=0;$i<sizeof($tab);$i++){
        $var="tab$i";
        $$var=explode("=",$tab[$i]);
        print_r($$var);
    }

    print("
        <form name=\"formmode\">
    ");
    for($i=0;$i<$nb;$i++){
        $var="tab$i";
        $$var=explode("=",$tab[$i]);
        print("
            ${$var[0]} : <input type=\"text\" name=\"$$var[0]\" value=\"$$var[1]\"><br>
        ");
    }
    */
    print("
        <table border=\"0\">
        <form name=\"formmode\" method=\"post\" action=\"actions.php?do=popup&scormid=$numpaquet&submitted\">
            <tr>
                <td>Hauteur :</td>
                <td><input type=\"text\" name=\"height\" size=\"5\"></td>
            </tr>
            <tr>
                <td>Largeur :</td>
                <td><input type=\"text\" name=\"width\" size=\"5\"></td>
            </tr>
            <tr>
                <td>Redimentionnement :</td>
                <td><select name=\"resizable\"><option value=\"1\">Oui</option><option value=\"0\">Non</option></select></td>
            </tr>
            <tr>
                <td>Barre de dfilements :</td>
                <td><select name=\"scrollbars\"><option value=\"1\">Oui</option><option value=\"0\">Non</option></select></td>
            </tr>
            <tr>
                <td colspan=\"2\" align=\"center\"><input type=\"submit\" value=\"Valider\"></td>
            </tr>
        </form>
        </table>
    ");
}


?>