<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
   Affiche, Ajoute et Modifie les evaluations  une srie
  Type d'evaluations :
      - f -> comme fill the blanc (les blancs ou texte  trous)
      - s -> comme sondage
      - q -> comme qcm
      - r -> qcm ou sondage  rponses communes (les tests)
	@param string $action_retour action a effectuer pour le retour.
	@package serie
*/

//PERMISSIONS REQUISES POUR AFFICHER LA PAGE
$perm->check('MOD');

//-----------------------------------------------------------------------
//					RECUPERATION DES DONNEES
//-----------------------------------------------------------------------
$result = get_serie($id);
$row_serie = pg_fetch_array($result);
// recup action sur serie
$serie_actions=get_serie_actions($id);
//echo "action serie=$serie_actions<br>";
//LIBELLE
$title = $row_serie[1];

//echo "chrono=$chrono<br>";
// rcupere le type de chrono (0=>pas de chrono n=>chrono individuel 1=>chrono global)
if(isset($chrono)&&!empty($chrono))
	$type_chrono=$chrono;
else{
	if($row_serie[3]>0)
		$type_chrono='1';
	else{
		$res_chrono=get_serie_somme_chronos($id);
		if(pg_fetch_result($res_chrono,0,0)>0)
			$type_chrono='n';
		else
			$type_chrono='0';	
	}
}
//echo "t_chrono=$type_chrono<br>";


//CHRONO
$chrono = $row_serie[3];

//if ($chrono == -1 || $chrono==null) //si pas de chronomtre
//echo "type_chrono=$type_chrono<br>";
if ($type_chrono == '0' || $type_chrono==null) //si pas de chronomtre
	$chrono_txt = $MSG_1386;
//elseif ($chrono == 0) //si chrono individuel
elseif ($type_chrono == 'n') //si chrono individuel

$chrono_txt = $MSG_1387;
else
	$chrono_txt = $MSG_1388 .
	': ' . sec_to_txt($chrono); //si chrono global
//echo "ch_txt=$chrono_txt<br>";
//BAREME
$bareme = $row_serie[2];
if (empty ($bareme)||$bareme==-1){ //si bareme individuel
	$bareme=0;
	$bareme_txt = $MSG_1391;
}
else {
	$bareme_txt = $MSG_1392 . ": "; //si bareme general
	$resultat = get_bareme($bareme);
	//affichage du bareme gnral
	$bareme_txt .= pg_result($resultat, 0, 1) . '&nbsp;&nbsp;[ Bon = ' . pg_result($resultat, 0, 2) . '  Faux = -' . pg_result($resultat, 0, 3) . '  Absent =';
	if (pg_result($resultat, 0, 4) > 0)
		$bareme_txt .= ' -' .
		pg_result($resultat, 0, 4) . '  ]';
	else
		$bareme_txt .= ' ' .
		pg_result($resultat, 0, 4) . '  ]';
}

//THEME
$res_th = get_serie_themes($id);
$theme = pg_fetch_result($res_th, 0, 0);
$result = get_serie_somme_points($id);
$ini_total = pg_fetch_result($result, 0);
//$ini_total = count_point($id);
$restheme = get_theme($theme);
$rowtheme = pg_fetch_row($restheme, 0);
$libelle_theme = $rowtheme[1];

//-----------------------------------------------------------------------
//					RECUPERATION DES DONNEES JAVASCRIPT
//-----------------------------------------------------------------------
function print_javascript() {
	global $db, $theme, $id;
	global $MSG_1410;
	global $MSG_1409;
	global $liste_qrc_src;
	echo "
					    <SCRIPT LANGUAGE=\"JavaScript\">
					    ";
	//Existe-t-il  des qcm pour ce theme?
	//$listeqcm = get_serie_exos_question_qcm_disponibles($id, $theme);
	$listeqcm = get_serie_exos_qcm_disponibles($id, $theme);
	if (pg_num_rows($listeqcm) > 0)
		$tabtype[] = 'q';

	//Existe-t-il  des ftb pour ce theme?
	$listeftb = get_serie_exos_ftb_disponibles($id, $theme);
	if (pg_num_rows($listeftb) > 0)
		$tabtype[] = 'f';

	// Existe-t-il des question de sondage pour ce theme
	//$listesondage = get_serie_exos_question_sondage_disponibles($id, $theme);
	$listesondage = get_serie_exos_sondage_disponibles($id, $theme);
	if (pg_num_rows($listesondage) > 0)
		$tabtype[] = 's';

	//Existe-t-il  des qrc pour ce thme (qcm  rponses communes)
	$listeqrc = get_serie_exos_qrc_disponibles($id, $theme);
	if (pg_num_rows($listeqrc) > 0)
		$tabtype[] = 'm';

	//Existe-t-il  des src pour ce thme (sondage  rponses communes)
	$listesrc = get_serie_exos_src_disponibles($id, $theme);
	if (pg_num_rows($listesrc) > 0)
		$tabtype[] = 'o';

	echo "var tabexo = new Array();\n";
	for ($i = 0; $i < count($tabtype); $i++) {
		echo "tabexo[$i] = new Array();\n";
		if ($tabtype[$i] == 'q') {
			$nbqcm = pg_num_rows($listeqcm);
			for ($j = 0; $j < $nbqcm; $j++) {
				echo "tabexo[$i][$j] = new Array(";
				$rowexo = pg_fetch_row($listeqcm, $j);
				//print_rr($rowexo);
				// traitement ams
				$tmp_exo=get_ams_libelles($rowexo[1]);
				$rowexo[1]=get_ams_libelle($tmp_exo);
				//echo "rowexo1=$rowexo[1]<br>";
				$chaine = substr($rowexo[1], 0, 40);
				$chaine = addcslashes($chaine, "\0...\31");
				
				
				echo "\"$rowexo[0]\", \"".MSG_2209." $rowexo[0] - $chaine\");\n";
				

			}
		}
		
		
		if ($tabtype[$i] == 'f') {
			$nbftb = pg_numrows($listeftb);
			for ($k = 0; $k < $nbftb; $k++) {
				echo "tabexo[$i][$k] = new Array(";
				$rowexo = pg_fetch_row($listeftb, $k);
				// traitement ams
				$tmp_exo=get_ams_libelles($rowexo[1]);
				$rowexo[1]=get_ams_libelle($tmp_exo);
				$chaine = clear_text($rowexo[1]);
				$chaine = substr($chaine, 0, 40);
				$chaine = addcslashes($chaine, "\0...\31");
				echo "\"$rowexo[0]\", \"".MSG_2209." $rowexo[0] - $chaine\");\n";
			}
		}
		// traitement sondage
		if ($tabtype[$i] == 's') {
			$nbsondage = pg_numrows($listesondage);
			for ($s = 0; $s < $nbsondage; $s++) {
				echo "tabexo[$i][$s] = new Array(";
				$rowexo = pg_fetch_row($listesondage, $s);
				// traitement ams
				$tmp_exo=get_ams_libelles($rowexo[1]);
				$rowexo[1]=get_ams_libelle($tmp_exo);
				$chaine = clear_text($rowexo[1]);
				$chaine = substr($chaine, 0, 40);
				$chaine = addcslashes($chaine, "\0...\31");
				echo "\"$rowexo[0]\",\"".MSG_2209." $rowexo[0] - $chaine\");\n";
			}
		}

		// traitement des qrc (qcm  rponses communes)
		if ($tabtype[$i] == 'm') {
			$nbqrc = pg_numrows($listeqrc);
			for ($m = 0; $m < $nbqrc; $m++) {
				echo "tabexo[$i][$m] = new Array(";
				$rowexo = pg_fetch_row($listeqrc, $m);
				// traitement ams
				$tmp_exo=get_ams_libelles($rowexo[1]);
				$rowexo[1]=get_ams_libelle($tmp_exo);
				$chaine = clear_text($rowexo[1]);
				$chaine = substr($chaine, 0, 40);
				$chaine = addcslashes($chaine, "\0...\31");
				echo "\"$rowexo[0]\",\"".MSG_2209." $rowexo[0] - $chaine\");\n";
			}
		}
		// traitement des src (sondage  rponses communes)
		if ($tabtype[$i] == 'o') {
			$nbsrc = pg_numrows($listesrc);
			for ($o = 0; $o < $nbsrc; $o++) {
				echo "tabexo[$i][$o] = new Array(";
				$rowexo = pg_fetch_row($listesrc, $o);
				// traitement ams
				$tmp_exo=get_ams_libelles($rowexo[1]);
				$rowexo[1]=get_ams_libelle($tmp_exo);
				$chaine = clear_text($rowexo[1]);
				$chaine = substr($chaine, 0, 40);
				$chaine = addcslashes($chaine, "\0...\31");
				echo "\"$rowexo[0]\",\"".MSG_2209." $rowexo[0] - $chaine\");\n";
			}
		}
		
		
		if ($tabtype[$i] != 'o' && $tabtype[$i]!= 'm' && $tabtype[$i]!= 's'&& $tabtype[$i]!= 'q' && $tabtype[$i]!='f'){
			print("type non reconnu dans make_etape.php");
		} 
	}
	echo "</script>";

}

//-----------------------------------------------------------------------
//					VALIDATION FORMULAIRE
//-----------------------------------------------------------------------
if ($posted == 1) {
	//print_rr($_POST);
	$chrono_duree = ($heure * 60 + $minute) * 60 + $seconde;
	// diffrentes actions  effectuer sur un exo
	switch ($action) {
		// suppression
		case "del" :
			del_serie_evaluation($id, $num_eval);
			break;
			
		//si un changement de place est demand 			
		case "mov":
			if ($position != $num_eval) {
				//echo "bouge $num_eval (".get_evaluation_type_old_new_r($typ).") a la place de $position (".get_evaluation_type_new_old($type_dest).")<br>";
				
				//selon qu'on avance ou qu'on recule une evaluation, on insert avant ou apres
				if($indice<$indice_dest)$insere_avant='FALSE';
				else $insere_avant='TRUE';
				maj_serie_evaluation_ordre_evaluation($id, $num_eval, $position, $insere_avant, get_evaluation_type_old_new($typ), get_evaluation_type_old_new($type_dest));
			}
			break;
		
		// modifications : questions, points, etc..
		case "mod" :
		
			//LES VERIFICATION SONT FAITES EN JAVASCRIPT, ET EN PHP AUSSI 
			if ($typ != 's' && $typ != 'o') {
				if (!empty ($bareme)) {
					//$choix_bareme = 'NULL';
					$choix_bareme=0;
				}

				if ($choix_bareme == 'NULL'){
					//$tab_err_new[] = $MSG_1398;
					$choix_bareme=0;
				}
				
				$point = (float) $point;

				if ($point == ''){
					$tab_err_new[] = $MSG_1400;
				}elseif (!($point > 0 && floor($point) == $point)) {
					$tab_err_new[] = $MSG_1401;
					unset ($point);
				}
			}
			
			if ($chrono != 0){
				$chrono_duree = 0;
			}
			elseif ($chrono_duree <= 0){
				//$tab_err_new[] = $MSG_1399;
				$chrono_duree = 0;
			} 
			
			if (count($tab_err_new) == 0) { 
				//$com_etape = htmlspecialchars($com_etape);
				if ($typ == 's' || $typ == 'o') {
					$choix_bareme = 'NULL';
					$point = 0;
				}
				//$com_etape = addslashes($com_etape);
				if (empty ($choix_bareme)) {
					$choix_bareme = "NULL";
				}
				if (empty ($num_eval)) {
					$num_eval = "NULL";
				}
				if (empty ($p_eval)) {
					$p_eval = "NULL";
				}
				maj_serie_evaluation($id, $num_eval, $p_eval, set_ams_libelle($com_etape), $choix_bareme, $chrono_duree, $point, get_evaluation_type_new_old($typ));
			} else {
				print ("
				<center><p class=\"errorbloc\">;
				<br><font size=\"2\" face=\"Arial\" color=\"red\"><b>Modification d\'une tape :</b><br><br>
				");
				for ($i = 0; $i < count($tab_err_new); $i++)
					print ("&nbsp;$tab_err_new[$i]<br>");
				print ("<br></font></p></center><br>");
			}

			break;

			//  ajout d'un exercice
		case 'new' :
		//echo "ajout";
			//LES VERIFICATION SONT FAITES EN JAVASCRIPT, ET EN PHP AUSSI 
			//echo "evaluation=$evaluation<br>";
			$choix_exo = $evaluation;
			$typ = $type_etape;
			if ((!is_numeric($choix_exo)) || (empty ($choix_exo))) {
				$tab_err_new[] = $MSG_1403;
			}

			if ($chrono != 0)
				$chrono_duree = 0;
			elseif (!$chrono_duree > 0) {
				//$tab_err_new[] = $MSG_1399;
				$chrono_duree = 0;
			}

			if ($typ != 's' && $typ != 'o') {

				if (empty ($bareme)) {
					if ($choix_bareme == 'NULL'){
						//$tab_err_new[] = $MSG_1398;
						$choix_bareme=0;
					}
				} 
				else
					$choix_bareme = 'NULL';

				$point = (float) $point;

				if ($point == '')
					$tab_err_new[] = $MSG_1400;
				elseif (!($point > 0 && floor($point) == $point)) {
					$tab_err_new[] = $MSG_1401;
					unset ($point);
				}

			}

			if (count($tab_err_new) == 0) {

				//test pour viter le raffichage d'une tape lors d'un reload de la page
				$resultat = get_serie_evaluation($id, $choix_exo, get_evaluation_type_new_old($typ));
				if (pg_num_rows($resultat) != 0)
					$resultat_id = pg_fetch_result($resultat, 0, 0);
					
					
				if (empty ($resultat_id)) {
					$nb_etape = pg_num_rows(get_serie_evaluations($id));
					$nb_etape++;
					$eval_pere = get_serie_last_evaluation($id);
					//$com_etape = htmlspecialchars($com_etape);
					if ($typ == 's' || $typ == 'o') {
						$choix_bareme = 'NULL';
						//$chrono_duree = 'NULL';
						$point = 'NULL';
					}
					//$com_etape = addslashes($com_etape);
					if (empty ($eval_pere))
						$eval_pere = "NULL";
					if (empty ($choix_bareme)){
						$choix_bareme = "NULL";
					}
					$id_result = set_serie_evaluation($evaluation, $id, $eval_pere, set_ams_libelle($com_etape), $choix_bareme, $chrono_duree, $point, get_evaluation_type_old_new($typ));
					if ($position != "NULL") { // si la nouvelle tape n'a pas t insrer  la fin
						maj_serie_evaluation_ordre_evaluation($id, $id_result, $position, 'TRUE', get_evaluation_type_old_new($typ), get_evaluation_type_old_new($type_dest));
					}
					unset ($choix_ftb);
					unset ($position);
					unset ($com_etape);
					unset ($choix_bareme);
					unset ($chrono_duree);
					unset ($point);
					unset ($time);
					unset ($heure);
					unset ($minute);
					unset ($seconde);
				}
			} else {
				print ("
<center>
	<p class=\"errorbloc\">
		<font size=\"2\" face=\"Arial\" color=\"red\">
			<b>$MSG_285 :</b><br><br>");
				for ($i = 0; $i < count($tab_err_new); $i++)
					print ("&nbsp;$tab_err_new[$i]<br>");
				print ("
			<br>
		</font>
	</p>
</center>
<br>");
			}
			break;
	}
	unset($action);
} 

//-----------------------------------------------------------------------
//					AFFICHAGE EVALUATIONS EXISTANTES
//-----------------------------------------------------------------------
//raccourcis
print ("
<br>
<a name=\"haut\"></a>
<table width=\"93%\">
	<tr align=\"center\">
    	<td width=\"15%\">&nbsp;</td>
    	<td width=\"70%\"><a href=\"#serie\">$MSG_1404</a> | <a href=\"#etape\">$MSG_1406</a> | <a href=\"#new\">$MSG_1407</a></td>
    	<td width=\"15%\" align=\"right\"><a href=\"#bas\"><img src=\"../images/fleche0.gif\" border=\"0\">$MSG_1305</a></td>
	</tr>
</table>
<br><br>");

if($perm->have_perm('PARAM'))
print ("
<table class=\"tableau_message\">
<tr><td><a class=\"action\" href=\"serie.php?action_serie=ajout_modification_serie&id=$id&action_retour=$action_retour\">$MSG_1405</a></td></tr>
</table>
<br>
");

//Affichage des informations gnrales de la srie
print ("
<table class=\"tableau_normal2\">
	<tr class=\"couleur1\">
		<th colspan=\"4\" align=\"center\"><a name=\"serie\"></a><b>$MSG_1404</b></th>
	</tr>
	<tr class=\"couleur3\">
		<td><b>$MSG_116 :</b></td>
		<td>" .get_gui_libelle($title,false) . "</td>
		<td><b>$MSG_117 :</b></td>
		<td>".get_gui_libelle($libelle_theme,false)."</td>
	</tr>
	<tr class=\"couleur3\">
		<td><b>$MSG_300 :</b></td>
		<td>$bareme_txt</td>
		<td><b>$MSG_257 :</b></td>
		<td>$chrono_txt</td>
	</tr>
</table>
<br><br>");

//Affichage des evaluations
$listeserieexo = get_serie_evaluations($id);
$nb_etape = pg_num_rows($listeserieexo);
if ($nb_etape > 0) {
	print ("
<table class=\"tableau_normal2\">
	<tr>
		<th align=\"center\" style=\"border: 1px solid;border-color: #FFCC00;\">
			<a name=\"etape\"></a><b>$MSG_1406</b>
		</th>
	</tr>
	<tr>
		<td align=\"center\"  style=\"border: 1px solid;border-color: #FFCC00;\">");

	//on liste les etapes dj cres de la srie en cours de cration
	$cur_etape = 0;
	while ($row = pg_fetch_array($listeserieexo)) {
		//print_rr($row);
		$cur_etape++;
		if (get_evaluation_type_new_old($row[8]) == 'f') {
			$num = $row[0];
			$result = get_ftb($num);
			$val = pg_fetch_row($result, 0);
			$tabmot = getBlanks($val[3]);
			$affichage = $val[2];
		}
		elseif (get_evaluation_type_new_old($row[8]) == 'q') {
			$num = $row[0];
			// $result=get_qcm_infos_question_reponses($num);
			$result = get_qcm_reponses_infos($num);
			$result_question = get_qcm_question($num);
			$val_question = pg_fetch_row($result_question, 0);
			$val = pg_fetch_row($result, 0);

			//interpretation html
			if ($val_question[2] == "t")
				$affichage = $val_question[1];
			else{
				//$affichage = htmlentities($val_question[1]);
				$affichage = ($val_question[1]);
			}

			$affichage_rep_qcm = array ();
			for ($i = 0; $i < pg_numrows($result); $i++)
				if (pg_result($result, $i, 2) == "t")
					$affichage_rep_qcm[$i] =pg_fetch_result($result, $i, 1);
				else{
					//$affichage_rep_qcm[$i] = htmlentities(pg_result($result, $i, 1));
					$affichage_rep_qcm[$i] = pg_fetch_result($result, $i, 1);
				}
		}

		//traitement pour les sondages (affichage dans la loupe)
		elseif (get_evaluation_type_new_old($row[8]) == 's') {
			$num = $row[0];
			$result = get_sondage_propositions_infos($num);
			$result_question=get_sondage_question($num);
			//$val = pg_fetch_row($result, 0);
			$affichage = pg_fetch_result($result_question,0,1);//$val[1];
			$affichage_rep_sondage = array ();
			for ($i = 0; $i < pg_numrows($result); $i++)
				$affichage_rep_sondage[$i] = pg_result($result, $i, 1);
		}

		// traitement pour qsrc
		elseif (get_evaluation_type_new_old($row[8]) == 'm' || get_evaluation_type_new_old($row[8]) == 'o') {
			$num = $row[0];
			if(get_evaluation_type_new_old($row[8]) == 'm' ){
				$obj_qsrc = & new Qrc($num);	
			}else{
				$obj_qsrc = & new Src($num);	
			}
//			echo"<pre>";
//			print_r($obj_qsrc);
//			echo"</pre>";
			$affichage = $obj_qsrc->getLibelle();
			$type_qsrc = $obj_qsrc->getType();
//			$obj_qsrc->initChoix();
//			$obj_qsrc->initQuestions();
		}
			
		//traitement pour les series (affichage dans la loupe)
		$time = get_hms($row[6]);
		
		//image du type
		$type_qsrc_img=get_evaluation_type_icone(get_evaluation_type_new_old($row[8]));
		
		// action sur evaluation
		$evaluation_action=get_serie_evaluation_actions($id,$row[0]);
		//echo "eval action=$evaluation_action<br>";
		$disabled="";
		$disabled_commentaire="";
		//$evaluation_action=2;
		if($evaluation_action==0)
			$disabled="disabled";
		if($evaluation_action==1)
			$disabled_commentaire="disabled";
		
		print ("
			<form method=\"post\" name=ev_" . $row[0] . " action=" . $_SERVER["REQUEST_URI"] . " >
			<table width=\"100%\" border=\"0\"  class=\"couleur2\" >
				<tr class=\"couleur1\">
					<td width=\"40px\">
							<img src=\"$type_qsrc_img\" border=\"0\"  align=\"absmiddle\">
					</td>
					<td>
						<b>$MSG_1033&nbsp;
						<select name=\"position\" onChange=\"chargeTypeSelection(this,ev_" . $row[0] . ");action.value='mov';submit();\">
							<option value=\"$row[0]\" SELECTED>$cur_etape</option >
							<option value=\"0\">---</option>");
				
		for ($i = 1; $i <= $nb_etape; $i++) {
			if ($cur_etape != $i) {
				$row_sel = pg_fetch_result($listeserieexo, $i -1, 0);
				print ("
							<option value=\"$row_sel\">$i</option>");
			}
		}
		print ("
						</select> : </b>".get_gui_libelle($affichage,false)."
					</td>");
		
		//LOUPES
		$a = get_evaluation_type_new_old($row[8]);
		$b = $row[0];
		
		print("
					<td width=\"170px\">
							<a href=\"#\" onClick=\"apercu('$a','$id','$b','$theme');return(false)\"><img src=\"../images/loupapercu.gif\" border=\"0\"  align=\"right\"></a>
							<a href=\"#\" onClick=\"ShowLoupe('$row[0]');return(false);\"><img id=\"loupe_$row[0]\" src=\"../images/louplus.gif\" border=\"0\"  align=\"right\"></a>");
		print ("
					</td>
				</tr>
				<tr>
					<td colspan=\"3\" style=\"height:0px;\">
						<div id=\"divPrev_$row[0]\">
						</div>
						<div id=\"divAll_$row[0]\" style=\"display:none\">
						<table width=\"100%\">
							<tr>
								<td colspan=\"2\"  style=\"padding:0px; border-spacing:0px; margin: 0px;\">");
	        
		//CHRONO	
		//echo "chrono=$chrono<br>";							        
		//if (empty ($chrono)) {
		if (empty ($chrono)&&$type_chrono!=1) {
			$chrono=0;
			print ("<b>$MSG_257 :</b>
					<blockquote><select name=\"heure\">");
			for ($i = 0; $i < 12; $i++) {
				print ("<option value=\"$i\"");
				if ($i == $time["heure"])
					print (" selected");
				print (">");
				if ($i < 10)
					print ("0");
				print ("$i</option>\n");
			}
			print ("</select>h<select name=\"minute\">");
			for ($i = 0; $i < 60; $i++) {
				print ("<option value=\"$i\"");
				if ($i == $time["minute"])
					print (" selected");
				print (">");
				if ($i < 10)
					print ("0");
				print ("$i</option>\n");
			}
			print ("</select>m<select name=\"seconde\">");
			for ($i = 0; $i < 60; $i++) {
				print ("<option value=\"$i\"");
				if ($i == $time["seconde"])
					print (" selected");
				print (">");
				if ($i < 10)
					print ("0");
				print ("$i</option>\n");
			}
			print ("</select>s</blockquote>");
		}
		
		print ("
								</td>");
		
		//DETAILS
		print("
								<td rowspan=\"4\" align=\"left\" style=\"padding:0px; border-spacing:0px; margin: 0px; background-color:#ffffff;\">");
						
		if (get_evaluation_type_new_old($row[8]) == 'q') {
			print ("
									<u>$MSG_1870 :</u>
									<ol>");
			for ($i = 0; $i < count($affichage_rep_qcm); $i++)
				print ("
										<li>".get_gui_libelle($affichage_rep_qcm[$i],false)."</li>");
			print ("
									</ol>");
		}

		if (get_evaluation_type_new_old($row[8]) == 'c') {
			print ("
									<u>$MSG_1870 :</u>
									<ol>");
			for ($i = 0; $i < count($affichage_serie); $i++)
				print ("
										<li> $affichage_serie[$i]"."</li>");
			print ("
									</ol>");
		}

		if (get_evaluation_type_new_old($row[8]) == 's') {
			print ("
									<u>$MSG_1871 :</u>
									<ol>");
			for ($j = 0; $j < count($affichage_rep_sondage); $j++)
				print ("
										<li>".get_gui_libelle($affichage_rep_sondage[$j],false)."</li>");
			print ("
									</ol>");
		}
//print_rr($row);
//echo get_evaluation_type_new_old($row[8]);
		if (get_evaluation_type_new_old($row[8]) == 'm' || get_evaluation_type_new_old($row[8]) == 'o') {
			print ("
									<u>$MSG_1872 :</u>
									<br><br>");
//			print (
//									$obj_qsrc->details() . "<br>");
		}
		print("					</td>
							</tr>
							<tr>
								<td width=\"20%\" style=\"padding:0px; border-spacing:0px; margin: 0px;text-align: left ;\">");
		//POINTS
		if (get_evaluation_type_new_old($row[8]) != 's' && get_evaluation_type_new_old($row[8]) != 'o')
			print ("
									<b>$MSG_617 :</b><blockquote><input type=\"text\" name=\"point\" value=\"$row[7]\" size=\"4\" $disabled></blockquote>");
		$a = get_evaluation_type_new_old($row[8]);
		$b = $row[0];
		print ("
									<input type=\"hidden\" name=\"posted\" value=\"1\">
									<input type=\"hidden\" name=\"type_chrono\" value=\"$type_chrono\">
									<input type=\"hidden\" name=\"num_eval\" value=\"$row[0]\">
									<input type=\"hidden\" name=\"indice\" value=\"$cur_etape\">
									<input type=\"hidden\" name=\"type_dest\" value=\"\">
									<input type=\"hidden\" name=\"indice_dest\" value=\"\">
									<input type=\"hidden\" name=\"p_eval\" value=\"$row[3]\">
									<input type=\"hidden\" name=\"nb_etape\" value=\"$nb_etape\">
									<input type=\"hidden\" name=\"id\" value=\"$id\">
									<input type=\"hidden\" name=\"typ\" value=\"" . get_evaluation_type_new_old($row[8]) . "\">");
		print ("
								</td>
								<td style=\"padding:0px; border-spacing:0px; margin: 0px;text-align: left ;\">");
		//BAREME
		if (empty ($bareme) && get_evaluation_type_new_old($row[8]) != 's' && get_evaluation_type_new_old($row[8]) != 'o') {
			print ("
									<b>$MSG_1021 :</b>
									<blockquote>
									<select name=\"choix_bareme\" $disabled>");
					$res_bar = get_plateforme_baremes();
					while ($row_bar = pg_fetch_array($res_bar)) {
						print ("
									<option value=\"$row_bar[0]\"");
						if ($row[5] == $row_bar[0])
							print (" selected");
						print (" >$row_bar[1]</option>");
					}
					print ("
									</select>
									</blockquote>");
		}	
		print("						</td>
							</tr>");
		
		//Commentaire pour la correction
		print ("
							<tr>
								<td colspan=\"2\" style=\"padding:0px; border-spacing:0px; margin: 0px;\">
									<b>$MSG_1408 :</b>
									<blockquote>
									<!--<textarea cols=\"50\" rows=\"6\" name=\"com_etape\" $disabled_commentaire>" . $row[4] . "</textarea>-->
									".get_gui_libelle_textearea('com_etape',$row[4])."
									</blockquote>
									
								</td>
							</tr>
							<tr>
								<td align=\"center\" colspan=\"2\" style=\"padding:0px; border-spacing:0px; margin: 0px;\">
									<input type=\"button\" name=\"supprimer\" value=\"$FORM_4\" OnClick=\"if(confirmDelete()){action.value='del';submit()}\" $disabled>
									<input type=\"button\" name=\"modifier\" value=\"$MSG_513\" OnClick=\"action.value='mod';submit();\" $disabled>
									<input type=\"hidden\" name=\"action\" value=\"null\">
								</td>
							</tr>
						</td>
						");
		print("
						</tr>
					</table>
					</div>
				</td>
			</tr>
		</table>
		</form>");
	}
	print ("
		</td>
	</tr>
</table>
<br><br>");
}


//-----------------------------------------------------------------------
//		RECUPERATION DES DONNEES NOUVELLE EVALUATION
//-----------------------------------------------------------------------
//Existe t il des qcm pour ce theme?
//$listeqcm = get_serie_exos_qcm_disponibles($id, $theme);
$listeqcm = get_serie_exos_question_qcm_disponibles($id, $theme);
if (pg_numrows($listeqcm) > 0)
	$tabtype[] = 'q';

//Existe t il des ftb pour ce theme?
$listeftb = get_serie_exos_ftb_disponibles($id, $theme);
if (pg_numrows($listeftb) > 0)
	$tabtype[] = 'f';

// existe t'il des question de sondage pour ce theme
$listesondage = get_serie_exos_sondage_disponibles($id, $theme);
if (pg_numrows($listesondage) > 0)
	$tabtype[] = 's';

// Existe t'il des qrc pour ce thme (qcm  rponses communes)
$listeqrc = get_serie_exos_qrc_disponibles($id, $theme);
if (pg_numrows($listeqrc) > 0)
	$tabtype[] = 'm';

// Existe t'il des src pour ce thme (sondage  rponses communes)
$listesrc = get_serie_exos_src_disponibles($id, $theme);
if (pg_numrows($listesrc) > 0)
	$tabtype[] = 'o';
//print_rr($tabtype);	
//-----------------------------------------------------------------------
//					AFFICHAGE NOUVELLE EVALUATION
//-----------------------------------------------------------------------
//Raccouris
print ("
<a name=\"bas\"></a>
<table class=\"tableau_normal\">
	<tr class=\"couleur1\">
		<th align=\"center\"><b><a name=\"new\"></a>$MSG_1407</b></th>
	</tr>");

if ($action != 'new') {
	unset ($choix_exo);
	unset ($num_eval);
	unset ($action);
	unset ($position);
	unset ($com_etape);
	unset ($choix_bareme);
	unset ($chrono_duree);
	unset ($point);
	unset ($time);
	unset ($heure);
	unset ($minute);
	unset ($seconde);
	unset ($typ);
}

print ("
	<tr class=\"couleur2\">
		<td>");
		
print_javascript();
print ("
			<table class=\"couleur2\" width=\"100%\">
				<tr>
					<form method=\"post\" name=\"nouvelle\">
						<td width=\"50%\">
							<b>$MSG_1033</b>
							<select name=\"position\"  onChange=\"chargeTypeSelection(this,nouvelle);\">");
echo '<option value="NULL" SELECTED>' . ($nb_etape +1) . '</option >';

for ($i = ($nb_etape); $i > 0; $i--) {
	$row_sel = pg_fetch_result($listeserieexo, $i -1, 0);

	if ($row[3] < $i)
		$new_place = $i;
	else
		$new_place = $i +1;
	if ($row[3] != $i && $row[3] != ($i +1)) {
		if ($i == 0)
			echo '<option value="NULL">1</option>';
		else
			echo '<option value="' . $row_sel . '">' . $new_place . '</option>';
	}
}
print ("
				</select><b>:</b>
				<br><br>");

//Chrono				
//if ($chrono == 0) {
if ($type_chrono == 'n') {
	echo '<li><b>' . $MSG_257 . '</b> : <select name="heure">';
	for ($i = 0; $i < 12; $i++) {
		echo '<option value="' . $i . '"';
		if ($i == $time["heure"])
			echo ' selected';
		echo ">";
		if ($i < 10)
			echo '0';
		echo $i . "</option>\n";
	}
	echo '</select>h<select name="minute">';
	for ($i = 0; $i < 60; $i++) {
		echo '<option value="' . $i . '"';
		if ($i == $time["minute"])
			echo ' selected';
		echo ">";
		if ($i < 10)
			echo '0';
		echo $i . "</option>\n";
	}
	echo '</select>m<select name="seconde">';
	for ($i = 0; $i < 60; $i++) {
		echo '<option value="' . $i . '"';
		if ($i == $time["seconde"])
			echo ' selected';
		echo ">";
		if ($i < 10)
			echo '0';
		echo $i . "</option>\n";
	}
	echo '</select>s<br><br>'; //"
}
//Bareme
if (empty($bareme)||$bareme == 'NULL') {
	echo '<li><b>' . $MSG_1021 . '</b> : <select name="choix_bareme"><option value="">' . $MSG_217 . '</option>';
	$res_bar = get_plateforme_baremes();
	while ($row_bar = pg_fetch_array($res_bar)) {
		echo '<option value="' . $row_bar[0] . '"';
		if ($row[5] == $row_bar[0])
			echo ' selected';
		echo '>' . $row_bar[1] . '</option>';
	}
	echo '</select><br><br>';
}
if (empty ($bareme))
	$js_bareme = 0;
else
	$js_bareme = $bareme;
//print_rr($row);
//Nombre de points
print ("
							<li> <b>$MSG_617 :</b> <input type=\"text\" name=\"point\" size=\"4\" value=\"" . $row[7] . "\"><br>
							<input type=\"hidden\" name=\"posted\" value=\"1\">
							<input type=\"hidden\" name=\"num_etape\" value=\"" . $row[3] . "\">
							<input type=\"hidden\" name=\"type_dest\" value=\"\">
							<input type=\"hidden\" name=\"nb_etape\" value=\"$nb_etape\">
							<input type=\"hidden\" name=\"id\" value=\"$id\">
							<input type=\"hidden\" name=\"type_chrono\" value=\"$type_chrono\">
						</td>");

//Type d'etape
if(empty($chrono))
	$chrono=0;
print ("
						<td valign=\"top\" width=\"50%\">
							<br>
							<b><u>$MSG_1409</u> :</b>
							<br>
							<select name=\"type_etape\" onChange=\"chargeExo($chrono,$js_bareme)\">
								<option value=\"\">$MSG_1409</option>");

//print_r($tabtype);
for ($i = 0; $i < count($tabtype); $i++) {
	switch ($tabtype[$i]) {
		case 'q' :
			$msg = $MSG_1867;
			break;

		case 'f' :
			$msg = $MSG_1201;
			break;

		case 's' :
			$msg = $MSG_1868;
			break;

		case 'r' :
			$msg = $MSG_1873;
			break;

		case 'm' :
			$msg = $MSG_1863;
			break;

		case 'o' :
			$msg = $MSG_1864;
			break;
	}
	//n'est pas encore activ car il faut gerer le rechargement pour les exos en plus du type d'exo
	//if ($tabtype[$i] == $type_etape)
	//$_selected = " selected ";
	print ("
							<option value=\"$tabtype[$i]\" $_selected>$msg</option>");
}
print ("
						</select>
						<br>
						<b><u>$MSG_1410</u> :</b>
						<br>
						<select name=\"evaluation\">
							<option value=\"\">$MSG_1410</option>
						</select>
						&nbsp;<a href=\"#\" OnClick=\"open_choix($id,$theme);return(false)\"><img src=\"../images/loupapercu.gif\" border=\"0\"  align=\"absmiddle\"></a>
					</td>
				</tr>
				<tr>
					<td colspan=\"2\" align=\"center\">
						<b>$MSG_1408 :</b><br><br>
						<!--<textarea  cols=\"45\" rows =\"6\" name=\"com_etape\">" . $row[4] . "</textarea>-->
						".get_gui_libelle_textearea('com_etape',$row[4])."
						<br>&nbsp;
					</td>
				</tr>
			</table>
		</td>
	</tr>
	<tr class=\"couleur1\">
		<td align=\"center\">
			<input type=\"button\" name=\"modifier\" value=\"$MSG_1375\" OnClick=\"return verifFormNew(document.forms['nouvelle']);\">
			<input type=\"hidden\" name=\"action\" value=\"null\">
		</td>
	</tr>
</form>
</table>
<br>");

//Raccouris
print ("
<br>
	<table width=\"93%\">
		<tr align=\"center\">
			<td width=\"15%\">&nbsp;</td>
			<td width=\"70%\"><a href=\"#serie\">$MSG_1404</a> | <a href=\"#etape\">$MSG_1406</a> | <a href=\"#new\">$MSG_1407</a></td>
			<td width=\"15%\" align=\"right\"><a href=\"#haut\"><img src=\"../images/fleche1.gif\" border=\"0\">$MSG_1304</a></td>
		</tr>
	</table>
<br><br>
<a class=\"retour\" href=\"serie.php?action_serie=$action_retour&theme=$theme\">$MSG_37</a>");
?>