<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
 * Affiche toutes les informations concernant les liens d'une s�rie avec des �l�ments de la plate-forme
 * @param integer: $id numero de la serie
 * @param integer :$classement Determine l'ordre de l'affichage :1/-1 -> filiere  2/-2 -> parcours 3/-3 ->filiere 4/-4->parcours
 * @param bool : $list_stag liste l'avancement des stagiaires. (ce que l'on fait quand il ya a un verrou)
 * @param bool : $no_piedpage bloque l'affichage du pied de page et du lien retour
 * 
 * @package serie
 */
//--------------------------------------------------------------------
//						INITIALISATIONS
//-------------------------------------------------------------------- 
//inclusions
$dbpath="../..";  //le dbpath sert � maintenir les inclusions � partir du $chemin_bo
include("$dbpath/en_tete.php"); //contient les traitements communs � l'ensemble du FrameWork Astairs
$no_path_verify=true;
include("../en_tete_back.php"); //contient les traitements communs � l'ensemble du BackOffice Astairs

//PERMISSIONS REQUISES POUR AFFICHER LA PAGE
$perm->check('GEST');

//connecteDB();
require ("$root/lib/lib_serie.php");
$styleCSS = "../style/" . MY_STYLE . "/ressourcesPedagogiques.css";

if (empty($classementA)){
	$classementA = 1;
}
if(empty ($classementB)){
	$classementB=3;
}

if (!$id) {
	print ("$ERROR_13=num_serie");
}

// pour les s�ries al�atoires : mode=alea
// Les s�ries al�atoires sont de type C
if ($mode == "alea")
	$type = 'C';
else
	$type = 'B';

//recup de la serie
$nomserie = pg_fetch_result(get_serie($id), 0, 1);
//ICONES ET LIENS POUR LE TITRE DES COLONNES
switch ($classement) {
	case -1 :
		$descA = "DESC";
		$cla1 = 1;
		$cla2=2;
		$cla3 = 3;
		$cla4=4;	
		$classementA=$classement;		
		$ico_fleche1 = "<img border=\"0\" src=\"../images/fleche1.gif\">";
		$ico_fleche2 = "";
		break;
	case 1 :
		$cla1 = -1;
		$cla2=-2;
		$cla3 = 3;
		$cla4=4;		
		$classementA=$classement;	
		$ico_fleche1 = "<img border=\"0\" src=\"../images/fleche0.gif\">";
		$ico_fleche2 = "";
		break;
	case -2 :
		$descA = "DESC";
		$cla2 = 2;
		$cla1 = 1;
		$cla3 = 3;
		$cla4=4;	
		$classementA=$classement;		
		$ico_fleche2 = "<img border=\"0\" src=\"../images/fleche1.gif\">";
		$ico_fleche1 = "";
		break;
	case 2 :
		$cla2 = -2;
		$cla1 = -1;
		$cla3 = 3;
		$cla4=4;
		$classementA=$classement;		
		$ico_fleche2 = "<img border=\"0\" src=\"../images/fleche0.gif\">";
		$ico_fleche1 = "";
		break;
	case -3 :
		$descB = "DESC";
		$cla1 = 1;
		$cla2=2;		
		$cla3 = 3;
		$cla4=4;
		$classementB=$classement;	
		$ico_fleche3 = "<img border=\"0\" src=\"../images/fleche1.gif\">";
		$ico_fleche4 = "";
		break;
	case 3 :
		$cla1 = 1;
		$cla2=2;	
		$cla3 = -3;
		$cla4=-4;
		$classementB=$classement;
		$ico_fleche3 = "<img border=\"0\" src=\"../images/fleche0.gif\">";
		$ico_fleche4 = "";
		break;
	case -4 :
		$descB = "DESC";
		$cla1 = 1;
		$cla2=2;		
		$cla4 = 4;
		$cla3 = 3;
		$ico_fleche4 = "<img border=\"0\" src=\"../images/fleche1.gif\">";
		$ico_fleche3 = "";
		$classementB=$classement;	
		break;
	case 4 :
		$cla1 = 1;
		$cla2=2;	
		$cla4 = -4;
		$cla3 = -3;
		$ico_fleche4 = "<img border=\"0\" src=\"../images/fleche0.gif\">";
		$ico_fleche3 = "";
		$classementB=$classement;		
		break;	
	default:
		$cla1 = 1;
		$cla2 = 2;	
		$cla3 = 3;
		$cla4 = 4;
	
}
//--------------------------------------------------------------------
//						AFFICHAGE
//--------------------------------------------------------------------
require ('../entete_fenetre.php');

print ("
<center>
	<br/>
	<table class=\"tableau_espace\">
		<tr class=\"couleur1\">
			<td><b>$MSG_1473 :</b> ".get_gui_libelle($nomserie,false)."</td>
		</tr>
	</table>
	<br/>");

//---------------------------------------------------------------------------------------------------------------------------
// 				AFFICHAGE DES GROUPES ET DES FORMATIONS
//---------------------------------------------------------------------------------------------------------------------------	
print("
	<table class=\"tableau_espace\">
		<tr>
			<th><a href=\"verrou.php?id=$id&classement=$cla1&classementB=$classementB&list_stag=$list_stag&no_piedpage=$no_piedpage\">$MSG_1470 $ico_fleche1 1</a></th>
			<th><a href=\"verrou.php?id=$id&classement=$cla2&classementB=$classementB&list_stag=$list_stag&no_piedpage=$no_piedpage\">$MSG_1469  $ico_fleche2 2</a></th>
		</tr>");

// --------------------------------------
// CLASSEMENT 2 ou -2 -> PAR FORMATIONS (FORMATEUR)
// --------------------------------------
if ($classementA % 2 == 0) {
	//recup des formations de la serie    
	$resultFormations = get_serie_formations($id, $descA);
	$nbForm = pg_numrows($resultFormations);

	// affichage des parcours
	for ($i = 0; $i < $nbForm; $i++) {
		$rowFormation = pg_fetch_row($resultFormations, $i);
		$classcolor = ($i % 2 == 0 || $i == 0 ? "couleur1" : "couleur2");

		//recup de la classe de la formation coutante
		$resultCla = get_formation_classes($rowFormation[0]);
		$nbcla=pg_num_rows($resultCla);
		for($j=0;$j<$nbcla;$j++){
			$rowCla = pg_fetch_row($resultCla, $j);
			//$classcolor = ($j % 2 == 0 || $j == 0 ? "couleur1" : "couleur2");
			
			//recup du formateur de la formation
			$resultForm = get_formation_formateur($rowFormation[0]);
			$rowFrom = pg_fetch_row($resultForm, 0);
			
			print ("
			<tr class=\"$classcolor\" align=\"center\">
				<td rowspan=\"$nbcla\">".get_gui_libelle($rowCla[1],false)." </td>
				<td>".get_gui_libelle($rowFormation[1],false)."($rowFrom[1])</td>
			</tr>");
		}
	}
}
// --------------------------------------
// CLASSEMENT 1 ou -1 -> PAR CLASSE
// --------------------------------------
else {
	//recup des classes de la s�rie
	$resultCla = get_serie_classes($id, $descA, $type);
	$nb1 = pg_numrows($resultCla);

	//Affichage des classes
	for ($i = 0; $i < $nb1; $i++) {
		$row = pg_fetch_row($resultCla, $i);

		//recup des formations de la classe courante
		$result2 = get_serie_formations_classe($id, $row[0], $descA);
		$nbParc = pg_numrows($result2);
		$classcolor = ($i % 2 == 0 || $i == 0 ? "couleur1" : "couleur2");
		print ("
		<tr class=\"$classcolor\" align=\"center\">
			<td rowspan=\"$nbParc\">$row[1]</td>");
		for ($j = 0; $j < $nbParc; $j++) {
			$row2 = pg_fetch_row($result2, $j);
			$classcolor = ($j % 2 == 0 || $j == 0 ? "couleur1" : "couleur2");			
			//recup du formateur de la formation
			$resultForm = get_formation_formateur($row2[0]);
			$rowFrom = pg_fetch_row($resultForm, 0);
			
			print ("
			<td align=\"center\" class=\"$classcolor\">".get_gui_libelle($row2[1],false)." ($rowFrom[1])</td>
		</tr>");
		}
	}
}
if($i==0){
	print ("
	<tr class=\"couleur1\" align=\"center\">
		<td>$MSG_2211</td>
		<td>$MSG_2488</td>
	</tr>");
}	
print ("
		</table>
		<br/>");	
//---------------------------------------------------------------------------------------------------------------------------
// 				AFFICHAGE DES FILIERES ET DES PARCOURS
//---------------------------------------------------------------------------------------------------------------------------	
print("
	<table class=\"tableau_espace\">
		<tr>
			<th><a href=\"verrou.php?id=$id&classement=$cla3&classementA=$classementA&list_stag=$list_stag&no_piedpage=$no_piedpage\"> $MSG_1519 $ico_fleche3 </a></th>
			<th><a href=\"verrou.php?id=$id&classement=$cla4&classementA=$classementA&list_stag=$list_stag&no_piedpage=$no_piedpage\"> $MSG_1520 $ico_fleche4 </a></th>
		</tr>");

// --------------------------------------
// CLASSEMENT 4 ou -4 -> PAR PARCOURS
// --------------------------------------
if ($classementB % 2 == 0) {
		
	//recup des parours de la serie    
	$resultParcours = get_serie_parcourss($id, $descB, $type);
	$nbParc = pg_numrows($resultParcours);

	// affichage des parcours
	for ($i = 0; $i < $nbParc; $i++) {
		$rowParcours = pg_fetch_row($resultParcours, $i);
		$classcolor = ($i % 2 == 0 || $i == 0 ? "couleur1" : "couleur2");

		//recup des filieres du parcours coutant
		$resultFil = get_filiere($rowParcours[2]);
		$rowFil = pg_fetch_row($resultFil, 0);

		print ("
		<tr class=\"$classcolor\" align=\"center\">
			<td>".get_gui_libelle($rowFil[1],false)."</td>
			<td>".get_gui_libelle($rowParcours[1],false)."</td>
		</tr>");
	}
}
// --------------------------------------
// CLASSEMENT 3 ou -3 -> PAR FILIERES
// --------------------------------------
else {
	//recup des filieres de la s�rie
	$result1 = get_serie_filieres($id, $descB, $type);
	$nb1 = pg_numrows($result1);

	//Affichage des filieres
	for ($i = 0; $i < $nb1; $i++) {
		$row = pg_fetch_row($result1, $i);

		//recup des parcours de la filiere courante
		$result2 = get_parcours($row[3]);
		$nbParc = pg_numrows($result2);
		$classcolor = ($i % 2 == 0 || $i == 0 ? "couleur1" : "couleur2");
		print ("
		<tr class=\"$classcolor\" align=\"center\">
			<td rowspan=\"$nbParc\">".get_gui_libelle($row[1],false)."</td>");
		for ($j = 0; $j < $nbParc; $j++) {
			$row2 = pg_fetch_row($result2, $j);
			print ("
			<td align=\"center\" class=\"$classcolor\">".get_gui_libelle($row2[1],false)."</td>
		</tr>");
		}
	}
}
if($i==0){
	print ("
	<tr class=\"couleur1\" align=\"center\">
		<td>$MSG_2211</td>
		<td>$MSG_2488</td>
	</tr>");
}	
print ("
		</table>");

//---------------------------------------------------------------------------------------------------------------------------
// 										AFFICHAGE DES SERIES ALEATOIRES MULTISERIES
//---------------------------------------------------------------------------------------------------------------------------
print("
	<br/><br/>
	<table class=\"tableau_espace\">
		<tr>
			<th>$MSG_2212</th>
		</tr>");

$res_series_aleatoires=get_serie_series_aleatoires($id);
$nb_series_aleatoires=pg_num_rows($res_series_aleatoires);
$classcolor = ($j % 2 == 0 || $j == 0 ? "couleur1" : "couleur2");
for ($j = 0; $j < $nb_series_aleatoires; $j++) {
	$row = pg_fetch_row($res_series_aleatoires, $j);
	$classcolor = ($j % 2 == 0 || $j == 0 ? "couleur1" : "couleur2");
	print ("
		<tr class=\"$classcolor\" align=\"center\">
			<td>$row[1]</td>
		</tr>");		
}	
if($j==0){
	print("
		<tr class=\"$classcolor\" align=\"center\">
			<td colspan=\"2\">$MSG_1606</td>
		</tr>");
}
print ("
		</table>");

//---------------------------------------------------------------------------------------------------------------------------
// 										AFFICHAGE DE L'AVANCEMENT DES STAGIAIRES
//---------------------------------------------------------------------------------------------------------------------------		
if($list_stag==true){
	print("
		<br/><br/>
		<table class=\"tableau_espace\">
			<tr>
				<th colspan=\"3\">$MSG_973</th>
			</tr>
			<tr>
				<th>$MSG_2324</th>
				<th>$MSG_635</th>
				<th>$MSG_2282</th>
			</tr>");
	
	$res_avancement=get_serie_individus($id);
	$nb_avancement=pg_num_rows($res_avancement);
	for ($j = 0; $j < $nb_avancement; $j++) {
		$row = pg_fetch_row($res_avancement, $j);
		$classcolor = ($j % 2 == 0 || $j == 0 ? "couleur1" : "couleur2");
		print ("
			<tr class=\"$classcolor\" align=\"center\">
				<td>$row[3] $row[4]</td><td>".get_gui_libelle($row[1],false)."</td><td>".get_gui_libelle($row[6],false)."</td>
			</tr>");		
	}	
	if($j==0){
		print("
			<tr class=\"$classcolor\" align=\"center\">
				<td colspan=\"2\">$MSG_1606</td>
			</tr>");
	}
	print ("
		</table>");
}

if(!$no_piedpage){
	print("		
<br><br><a class=\"action\" href=\"#\" Onclick=\"window.close()\">$MSG_956</a>
</center>");

//	require ('../piedpage.php3');

}else{
	print("
</center>");
}
	include("$dbpath/pied_page.php");
?>