<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
	Liste des series aleatoires
	@package serie_aleatoire
*/

/*--------------------------------------------------------------*/
//      Fichier : lstserie_aleatoire.php3
//      Auteur : S. Ladjani
//      Action : Liste les series aleatoires
//      Donnes reues : $mode
//                              - 0 : serie existante
//                              -1 : serie monotheme
//                              -2 : serie multitheme
/*--------------------------------------------------------------*/


/*---------------------------------------------------------------------------------------------------------------------------------------------------*/
//              FONCTION PHP
/*----------------------------------------------------------------------------------*/

// A CHANGER >>

// fonction qui retourne les actions permises sur la srie < version pour sries alatoires (trois sous-types)
function test_action_serie($num)
{
        // Valeur de retour
        $action_serie=0;

        // test si la srie est dans un parcours
		/*
        $sql="select distinct g_num_parcours from gestparcours
        where num_c_q_e_d=$num
        and ( type_etape='B' or type_etape='C') ";
        $res=pg_query($sql);
		*/
		$res=get_serie_parcourss($num);
        if(pg_numrows($res)>0)
        {
                $action_serie=1;
                // test si parcours en formation
                $nbparc=pg_numrows($res);
                for($i=0;$i<$nbparc;$i++)
                {
                        $row=pg_fetch_row($res,$i);
                        $tabform=array();

                        parcours_en_formation($row[0],$tabform);

                        $sz=sizeof($tabform);
                        if($sz>0)
                        {
                                $action_serie=2;
                                break;
                        }
                }
        }
        return $action_serie;
}

/*----------------------------------------------------------------------------------*/
//              FIN FONCTION
/*---------------------------------------------------------------------------------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------------*/
//              AFFICHAGE ENTETE
/*----------------------------------------------------------------------------------*/



/*
// Nouvelle srie
print("<br><center>[ <a href=\"editor_serie.php?theme=$theme\">$MSG_1364</a> ] </center><br>");
*/

/*-------------------------------------------------------------------------------------------------*/
//                  FONCTION JAVASCRIPT
/*-------------------------------------------------------------------------------------------------*/

print("
<script language=\"javascript\">

// changer ici c'est fait =)
function pop_etape(num)
{
    window.open('../liste_etape.php?serie='+num,'help','height=500,width=700,resizable=yes,scrollbars=yes');
}

// Fonction qui demande confirmation avant suppression
function confirmDelete()
{
        return(confirm('$MSG_1412'));
}
</script>");


// SELECTION DU THEME
// On ne demande le theme que si le mode est diffrent de 2 (pas multithemes)
if($mode!=2){
	// Rcupration des thmes
	// Il faut chercher les themes qui possedent des sries alatoires :
	// * dans gestserie > mode==0
	/*
	if($mode==0)
		$sql="SELECT DISTINCT num_themedir, nom_theme, lower(nom_theme) AS ordre FROM themedir T, Serie_exo S, gestserie G
                WHERE T.num_themedir=S.theme
                AND S.id=G.num_serie
                ORDER BY ordre" ;
	else
		$sql="SELECT DISTINCT num_themedir, nom_theme, lower(nom_theme) AS ordre FROM themedir T, Serie_exo S, serie_aleatoire SA
                WHERE T.num_themedir=S.theme
                AND S.id=SA.num_serie
                ORDER BY ordre" ;

	$result=pg_query($sql);
	*/
	
	if($mode==0)
		$result=get_plateforme_serie_aleatoire_configuree_themes();
	else
		$result=get_plateforme_serie_aleatoire_multiserie_themes();
	/*
	if($result)
		echo "ok<br>";
	else
		echo "not ok<br>";
	*/
	$nb_theme=pg_num_rows($result);
	//echo "nb_theme=$nb_theme<br>";
	// Formulaire de saisie du theme
	print("
	<table class=\"tableau_message\">
	<tr><td>
	<center><form method=post><font size=2 face=\"Arial\"><b>$MSG_117 </b>
	<select name=\"theme\" onChange=\"submit();\">
	<option value=\"\">$MSG_215</option>
	");
	// Parcours des thmes
	while($row=pg_fetch_row($result)){
		$tmp_theme=get_ams_libelles($row[1]);
        $row[1]=get_ams_libelle($tmp_theme,50);
		echo '<option value="'.$row[0].'"';
		if($theme==$row[0])
			echo ' selected';
		echo '>'.$row[1].'</option>';
	}
	echo '</select></form><br></font></center></td></tr></table><br>';

}

/*
// A CHANGER
// Suppression d'une srie
if($act=='del')
{
    // Remarque : s'il existe une contrainte d'intgrit vers serie_exo, cette requete devient inutile
    $sql="DELETE FROM asso_exo_serie WHERE id_serie=$id";
    $result=pg_query($sql);
    $sql="DELETE FROM serie_exo WHERE id=$id";
    $result=pg_query($sql);
}
*/


// Le thme est connu ou mode multitheme
if($theme!='' || $mode==2){
	//echo "theme=$theme<br>";
	// La variable classement determine le mode d'affichage : par type, ou par nom (par dfaut : par type)
	if(!isset($classement))
		$classement = "type" ;


        // oooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo
        // SELECTIONS DES SERIES
        // oooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo

        /*
        // Les sries normales
        $sql="SELECT DISTINCT id,titre, lower(titre) AS ordre
                FROM serie_exo, asso_exo_serie
                WHERE theme=$theme
                AND id=id_serie
                AND id NOT IN
                        (select num_serie from serie_aleatoire)
                ORDER BY ordre";
        */

        /*
        // Sries existantes
        if($mode==0)
                // inserer le theme
                $sql="SELECT id,titre, lower(titre) AS ordre
                        FROM serie_exo S
                        WHERE id IN (select num_serie from gestserie)
                        AND theme=$theme
                        ORDER BY ordre ; ";
        // Sries monotheme ou multitheme
        else
        {
                $conditionTheme="";

                // Cas monotheme : on n'affiche les series alatoires du theme connu
                if(isset($theme) && $mode!=2)
                        $conditionTheme="AND theme=$theme" ;

                $sql="SELECT id,titre, lower(titre) AS ordre
                FROM serie_exo
                WHERE id IN (select distinct num_serie from serie_aleatoire where mode=$mode)
                $conditionTheme
                ORDER by ordre ;";

                // DEBUGecho "<table width=85% align=center><tr><td><b>sql :<br><br>$sql</b></td></tr></table>";
        }

        $result=pg_query($sql);
		*/
		//echo "theme=$theme<br>";
		$mode_aleatoire=get_serie_aleatoire_type_old_new($mode); // pour compatibilit script / schemas
		//echo "mode_aleatoire=$mode_aleatoire et mode=$mode<br>";
		if($mode==1|| $mode==0)
			$result=get_theme_series_aleatoires($theme,$mode_aleatoire);
		else
			if($mode==2)
				$result=get_series_aleatoires_type($mode_aleatoire);
        $nb=$nbLigne=pg_num_rows($result);

        //DEBUG 
        //echo "nb=$nb";

        // oooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo
        // FIN SELECTIONS
        // oooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooo

        if($nbLigne==0)
                $nbLigne++ ;

        // ---------------------------------------------------------------------------
        // LEGENDE DES ICONES
        // ---------------------------------------------------------------------------
        print("<br>
        <center>

        <div class=\"adv\">
        <br><center>
        <table class=\"tableau_message\">
        <tr><td valign=middle>
        <img src=\"../images/lock.gif\" align=\"absmiddle\">
        <b>: $MSG_1413</b><br><br>
        <img src=\"../images/link.gif\" align=\"absmiddle\">
        <b>: $MSG_1518</b>
        </td><td>

        <table cellspacing=0 cellpadding=2>
        <tr>
                <td><img src=\"../images/icoserie.gif\" align=\"absmiddle\" width=25 height=25></td>
                <td><b> &nbsp; $MSG_1862 <!--Multi-type--></b></td>
        </tr>
        <tr>
                <td><img src=\"../images/icoqcm.gif\" align=\"absmiddle\" width=25 height=25>
                <td><b> &nbsp;  $MSG_547 <!--QCM--></b></td>
        </tr>
        <tr>
                <td><img src=\"../images/icoremplir.gif\" align=\"absmiddle\" width=25 height=25>
                <td><b> &nbsp; $MSG_1201 <!--Remplir les blancs--></b></td>
        </tr>
        <tr>
                <td><img src=\"../images/icosonde.gif\" align=\"absmiddle\" width=25 height=25></td>
                <td><b> &nbsp; $MSG_1483 <!--Sondage--></b></td>
        </tr>
        </table>
        </td></tr></table>
        <br>
        </div>
        </center><br>
                ");

        // ---------------------------------------------------------------------------
        // PREMIERE LIGNE : noms des colonnes
        // ---------------------------------------------------------------------------
        print("
		<table cellspacing=\"0\" cellpadding=\"10\" border=\"1\" bordercolor=\"#000000\" width=\"80%\" align=\"center\">
		<tr bgcolor=\"#FFCC00\">
		<td align=\"center\" width=\"2%\" nowrap>
		<font size=\"3\" face=\"Arial\"><b>$MSG_608</b></font>
		");
		if($classement=="nom")
			print("
			<!--&nbsp;&nbsp;<a href=\"lstserie_aleatoire.php3?theme=$theme&classement=type&mode=$mode\">-->
			&nbsp;&nbsp;<a href=\"serie_aleatoire.php?action_serie=lister&theme=$theme&classement=type&mode=$mode\">
			<img src=\"../images/fleche0.gif\"  border=0></a>
			");
		print("
		</td>
		<td align=\"center\">
		<font size=\"3\" face=\"Arial\"><b>$MSG_1274</b></font>
		");
		if($classement=="type")
			print("
			&nbsp;&nbsp;<a href=\"serie_aleatoire.php?action_serie=lister&theme=$theme&classement=nom&mode=$mode\">
			<img src=\"../images/fleche0.gif\"  border=0></a>
			");
		print("
		</td>
		");

		// Si le mode est gale  0, on affiche en plus une colonne formation
		if($mode==0)
			print("<td align=\"center\"><font size=\"3\" face=\"Arial\"><b>$MSG_635</b></font></td>");

		// Si le mode est gale  2, on affiche en plus une colonne themes
		if($mode==2)
			print("<td align=\"center\"><font size=\"3\" face=\"Arial\"><b>$MSG_628</b></font></td>");

		print("
		<td align=\"center\"><font size=\"3\" face=\"Arial\"><b>$FORM_1</b></font></td>
		<td rowspan=\"".($nbLigne+1)."\" width=5%>
		&nbsp;&nbsp;
		</td>
		</tr>
		") ;

        // Pour les sries existantes, on peut utiliser la fonction dispatchserie(...)
        // Pour les sries monotheme et multitheme, le fonctionnement est bien diffrent > on a recours  une autre fonction

        $nb=pg_num_rows($result);

        // Les tableaux suivant sont passs pas reference aux fonctions
        $tabMulti = array() ;
        $tabBlanc = array() ;
        $tabSondage = array() ;
        $tabQCM = array() ;
        $tabVide = array() ;
         //echo "mode=$mode<br>";
        // Selon le mode, ce n'est pas la mme fonction de dispatchment qui est utilise
		
        if($mode==0){
			// Fonction qui repartit les resultats dans des tableaux pour chaque type d'exo
			//dispatchSerie($result,$nb,&$tabMulti,&$tabBlanc,&$tabSondage,&$tabQCM,$tabVide) ;
			dispatchSerie($result, $nb, $tabMulti, $tabBlanc, $tabSondage, $tabQCM, $tabTest,$tabQRC,$tabSRC,$tabVide,$tabSerieGenere) ;
		}
        else
		
		
			// Fonction qui repartit les resultats dans des tableaux pour chaque type d'exo
			// mais pour des sries alatoires monotheme et multitheme
			dispatchSerieAleatoire($result,$nb,&$tabMulti,&$tabBlanc,&$tabSondage,&$tabQCM,&$tabQRC,&$tabSRC) ;

        /*

        DEBUG
        echo "<tr><td colspan=3>
        debug taille tableau :<br>
        multi :".sizeof($tabMulti)." <br>qcm : ".sizeof($tabQCM)."<br>remplir : ".sizeof($tabBlanc)."<br>sonde : ".sizeof($tabSondage). "
        </td></tr>" ;

        */


        // Affichage des sries par type
        if($classement=="type"){
			// on stock les nombres de sries de chaque type
			$tabCpt = array(sizeof($tabMulti), sizeof($tabQCM), sizeof($tabBlanc), sizeof($tabSondage), sizeof($tabVide) ) ;
			// Ce tableau contient tous les id des sries
			/*
			echo "<pre>";
			print_r($tabQCM);
			echo "</pre>";
			*/
			$tabRes = array_merge($tabMulti, $tabQCM, $tabBlanc, $tabSondage, $tabVide);
			// La variable etat permet de connaitre dans quelle partie du tableau tabRes on se trouve (partie Multi, partie QCM, etc.)
			$etat = 0 ;
			// cpt est un compteur qui est utilis pour savoir quand on passe d'une partie  une autre
			$cpt = 0 ;
			// Le libelle de la premire partie est multi-type
			$libelle_type = "Multi-type" ;
			$img_type = "icoserie.gif" ;
			$continue = list($id,$tab) = each($tabRes) ;
        }
        // Affichage des sries par nom
        else {
			$continue = pg_fetch_array($result) ;
        }
		

        // ************************************************************************************************

        // DEBUT PARCOURS DES SERIES

        // ************************************************************************************************

        // Selon le type de classement (par nom ou par type), la condition d'arrt est diffrente
        while($continue){
			// Si on classe par type, il y a quatre tats : multi, qcm, ftb puis sondage
			if($classement=="type"){
				// On change de type
				if($cpt >= $tabCpt[$etat]){
					// Actualisation du compteur
					$cpt = 1 ;
					// On passe  l'tat suivant (il se peut qu'il n'y ait aucune srie de QCM, donc on passe de l'tat 0  l'etat 2 par exemple)
					do{
						$etat++ ;
					}
					while($tabCpt[$etat]==0 && $etat<4) ;
					switch($etat){
						case 1 :
							$libelle_type = "QCM" ;
							$img_type = "icoqcm.gif" ;
						break ;
						case 2 :
							$libelle_type = "Remplir les blancs" ;
							$img_type = "icoremplir.gif" ;
						break ;
						case 3 :
							$libelle_type = "Sondage" ;
							$img_type = "icosonde.gif" ;
						break ;
						case 4 :
							$libelle_type = "Vide" ;
							$img_type = "icovide.gif" ;
						break ;
					} // fin swich
				} // fin if
				else
					$cpt++ ;
				// Affectations
				/*
				echo "<pre>";
				print_r($tab);
				echo "</pre>";
				*/
				$titre_serie = $tab[1] ;
				$num = $tab[0] ;
				// Condition d'arret
				$continue = (list($id,$tab) = each($tabRes)) ;
			} // fin if classement par type
			else{
				// Affectations
				$titre_serie=$continue["titre"];
				$num=$continue["id"];
				// Il faut chercher le couple {$num,$titre_serie} dans les tableaux pour savoir quel est le type de la srie
				if(in_array( array($num,$titre_serie), $tabMulti)){
					$img_type = "icoserie.gif" ;
					$libelle_type = "Multi-type" ;
				}
				else{
					if(in_array( array($num,$titre_serie), $tabQCM)){
						$img_type = "icoqcm.gif" ;
						$libelle_type = "QCM" ;
					}
					else{
						if(in_array( array($num,$titre_serie), $tabBlanc)){
							$img_type = "icoremplir.gif" ;
							$libelle_type = "Remplir les blancs" ;
						}
						else{
							if(in_array( array($num,$titre_serie), $tabSondage)){
								$img_type = "icosonde.gif" ;
								$libelle_type = "Sondage" ;
							}
							else{
								$img_type = "" ;
								$libelle_type = "Vide" ;
							}
						}
					}
				}
				// Condition d'arret
				$continue = pg_fetch_array($result) ;
			}
			// $row=pg_fetch_array($result,)
			// $titre_serie=$row["titre"];
			// $num=$row["id"];
			print("
			<tr class=\"couleur2\">
			<td align=\"center\"><font size=2 face=\"Arial\"><img src=\"../images/$img_type\" border=0 alt=\"$libelle_type\"></td>
			<td><font size=2 face=\"Arial\"><b>".get_gui_libelle($titre_serie,false)."</b></td>
			");
			// MODE==0 on affiche le nom de la formation
			if($mode==0){
				/*
				$rescal=pg_query("select nom_cal, num_cal from calendrier where num_cal in
                        (select num_cal from gestserie where num_serie='$num');");
				*/
				$rescal=get_etape_formations($num);
				// $nb_cal=pg_num_rows($rescal) ;
				print("<td align=center><font face=\"Arial, Helvetica\" size=2><b>");
				$tab_num_cal=array() ;
				while($row_cal=pg_fetch_row($rescal)){
					$nom_cal = $row_cal[1] ;
					$tab_num_cal[] = $row_cal[0] ;
					//print_r($row_cal);
					// print($row_cal['num_cal'] ." - $nom_cal<br>");
					print("$nom_cal<br>");
				}
				print("</b></font></td>") ;
				/*
                        $nom_cal=pg_result($rescal,0,0);
                        $num_cal=pg_result($rescal,0,1);
                        print("
                        <td align=center><font face=\"Arial,Helvetica\" size=2><b>$nom_cal</b></font></td>
                        ");
                        */
			}

			// MODE==2 on affiche les themes utiliss
			if($mode==2){
				/*
				$restheme=pg_query("select nom_theme, lower(nom_theme) AS ordre FROM themedir WHERE num_themedir IN
                        (select theme from serie_aleatoire where num_serie='$num') ORDER BY ordre;");
				*/
				$restheme=get_serie_aleatoire_multitheme_themes($num);
				$nbTheme=pg_num_rows($restheme) ;
				// Initialisation de la chaine de caractres
				$listeTheme="" ;
				for($cptTheme=0 ; $cptTheme < $nbTheme ; $cptTheme++){
					$listeTheme.= "<li>".get_gui_libelle(pg_result($restheme,$cptTheme,1));
				}
				// Pour retirer le dernier <br>
				// $listeTheme=substr($listeTheme,0,-4) ; // inutile si on utilise des puces car saut  la ligne automatique
				// Aucun theme trouv > normalement impossible
				if($cptTheme==0)
					$listeTheme="Aucun thme > trange" ;
				print("
				<td align=left><font face=\"Verdana, Arial,Helvetica\" size=1>$listeTheme</font></td>
				");
			}

			/*----------------------------------------------------------------------------------------------------------------------------------- */
			//                                                                                      ACTIONS
			/*----------------------------------------------------------------------------------------------------------------------------------- */
			print("
			<td align=\"center\" width=30%>
			<table border=\"0\" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\">
			<tr>
			");
			// Les sries existantes sont forcment en formation
			if($mode==0){
				// Lien pour voir etape... utile ?
				// print("<td width=35%><a href=\"../voir_etape.php?id=$num\">$MSG_1517</a> </td>");
				// L'utilisateur doit pouvoir configurer la srie pour chacune des formations o elle est utilise en alatoire
				print("<td width=\"35%\"><!--<font face=\"Arial\" size=\"2\">-->");
				$i=0;
				$nb_cal=count($tab_num_cal) ;
				while($i<$nb_cal)
					print("
					<a class=\"action\" href=\"serie_aleatoire.php?action_serie=configuration&theme=$theme&numserie=$num&numform=".$tab_num_cal[$i++]."\">$MSG_2294</a><br>");
				print("
				<!--</font>--></td>
				<!--<td width=30% align=center><a href=\"#\" onMouseOver=\"pop_etape($num)\">-->
				<td width=30% align=center><a href=\"#\" onclick=\"pop_etape($num)\">
				<img src=\"../images/view.gif\" border=0></a></td>
				<td width=35% align=center>
				<a href=\"#\" OnClick=\"window.open('../verrouserie.php?id=$num','demo','status=yes,scrollbars=yes,resizable=yes,width=1000,height=650');
				return(false);\"><img src=\"../images/lock.gif\" border=0></a></td>
				</tr>
				");
			}
			else{
				// Quelles sont les actions permises sur la srie courante ?
				// Rgles :
				//              - La srie n'est pas dans un parcours
				//                  $action_serie=0 => Modification - Supprimer
				//              - La srie est dans un parcours mais pas en formation
				//                  $action_serie=1 => Modification - Verrou parcours
				//              - La srie est dans un parcours et en formation
				//                  $action_serie=2 => Verrou srie
				//$test_action_serie=test_action_serie($num);
				$test_action_serie=get_serie_actions($num);
				//echo "test_action=$test_action_serie<br>";
				switch($test_action_serie){
					// John 27/10/2003 Modification de l'affichage
					case 2 : 
						print("
						<td width=33% align=center>
						<a class=\"action\" href=\"serie_aleatoire.php?action_serie=creation&serie=$num&theme=$theme&mode=$mode\">$FORM_8</a></td>
						<td width=\"33%\" align=center>
						<a class=\"action\" href=\"serie_aleatoire.php?action_serie=detail&serie=$num&mode=$mode&theme=$theme\">
						<img src=\"../images/view.gif\" border=0></a></td>
						<td width=33% align=center>
						<a class=\"action\" href=\"serie_aleatoire.php?action_serie=suppression&serie=$num&theme=$theme&mode=$mode\" onClick=\"return(confirmDelete())\">$FORM_4</a></td>
						</tr>
						");
					break;
					case 1 : 
						print("
						<td width=33% align=center>
						<a class=\"action\" href=\"serie_aleatoire.php?action_serie=creation&serie=$num&theme=$theme&mode=$mode\">$FORM_8</a></td>
						<td width=\"33%\" align=center>
						<a class=\"action\" href=\"serie_aleatoire.php?action_serie=detail&serie=$num&mode=$mode&theme=$theme\">
						<img src=\"../images/view.gif\" border=0></a></td>
						<!--
						<td width=33% align=center>
						<a href=\"#\" OnClick=\"window.open('../verrouparcours.php?id=$num&mode=alea','demo','status=yes,scrollbars=yes,resizable=yes,width=1000,height=650');
						return(false);\"><img src=\"../images/link.gif\" border=0></a></td>
						-->
						<td width=\"35%\" align=\"center\">
    							<a href=\"#\" onclick=\"javascript:window.open('verrou.php?id=$num','','status=yes,scrollbars=yes,resizable=yes,width=650,height=450');\">                                
								<img src=\"../images/link.gif\" border=0></a>
                            </td> 
						</tr>
						");
					break;
					case 0 :  
						print("
						<td width=34% align=center>
						<a  class=\"action\" href=\"serie_aleatoire.php?action_serie=edit_nom_serie&serie=$num&mode=$mode&theme=$theme&retour=serie_aleatoire/lstserie_aleatoire.php3\">
						<!--$MSG_590-->".MSG_713."</a></td>
						<td width=\"33%\" align=center>
						<a class=\"action\" href=\"serie_aleatoire.php?action_serie=detail&serie=$num&mode=$mode&theme=$theme\">
						<img src=\"../images/view.gif\" border=0></a></td>
						<td width=33% align=center>
						<a href=\"#\" OnClick=\"window.open('verrou.php?id=$num&mode=alea','demo','status=yes,scrollbars=yes,resizable=yes,width=1000,height=650');
						return(false);\"><img src=\"../images/lock.gif\" border=0></a></td>
						</tr>
						");
					break;
				}
			}
			// print("<td>A FAIRE");
			print("
			</td></tr></table></td></tr>
			");
			/*
                $sql="SELECT count(*)
                                        FROM gestparcours
                                        WHERE num_c_q_e_d=".$row["id"]."
                                        AND type_etape='B'";
                $res=pg_query($sql);
                echo '<a href="editor_serie.php?id='.$row["id"].'">'.$MSG_1414.'</a> - <a href="make_etape.php?id='.$row["id"].'">'.$MSG_1415.'</a> - ';
                if(pg_result($res,0)==0)
                echo '<a href="liste_serie.php?id='.$row["id"].'&act=del&theme='.$theme.'" OnClick="return(confirmDelete())">'.$FORM_4.'</a>';
                else
                echo '<a href="#" OnClick="window.open(\'verrouserie.php?id='.$row["id"].'\',\'demo\',\'status=yes,scrollbars=yes,resizable=yes,width=1000,height=650\');
                                                                return(false);"><img src="../gestion_fichier/images/lock.gif" border=0></a>';
                                echo '
                                </td>
                                </tr>';
                */

		} // fin while

        // ************************************************************************************************
        // FIN PARCOURS
        // ************************************************************************************************

        // Aucune srie trouves
        // if(pg_num_rows($result)==0)
        if($nb==0)
                echo '<tr><td colspan="3" width="95%"><center><i><font size="2" face="Arial">'. $MSG_916.'<font></i></center></td></tr>';
        echo '</table><br>';
}


//print("<br><center>[ <a href=\"serie_aleatoire.php\">$MSG_54</a> ]");
//<!-- Consultation des anciennes versions de listes
//<br><br><a href="lstserie_aleatoire_old.php3?mode=0">OLD 1</a> - <a href="lstserie_aleatoire_old.php3?mode=1">OLD 2</a> - <a href="lstserie_aleatoire_old.php3?mode=2">OLD 3</a>
//-->
//
//</center>
//<?php
//
?>