<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
   Affiche les evaluations d'une srie
   reoit un numero de srie.
   
    @author  S. Ladjani
    @package serie
*/
//inclusions
$dbpath="../..";  //le dbpath sert  maintenir les inclusions  partir du $chemin_bo
include("$dbpath/en_tete.php"); //contient les traitements communs  l'ensemble du FrameWork Astairs
include("../en_tete_back.php"); //contient les traitements communs  l'ensemble du BackOffice Astairs

//PERMISSIONS REQUISES POUR AFFICHER LA PAGE
$perm->check('LST');

require ("$root/lib/lib_serie.php");

$styleCSS = "../style/" . MY_STYLE . "/ressourcesPedagogiques.css";
require ('../entete_fenetre.php');

$res_serie = get_serie($serie);
$nom_serie = pg_fetch_result($res_serie, 0, 1);

// recup des tape de la srie
$resserie = get_serie_evaluations($serie);
$nb = pg_numrows($resserie);
print ("
<center>
<br>
<table class=\"tableau_message\" border=1>
	<tr class=\"couleur1\">
		<td>
			<b>$MSG_1267 :</b> ".get_gui_libelle($nom_serie,false)."
		</td>
	</tr>
</table>
<br><br>
<table class=\"tableau_espace\">
    <tr>
        <th>$MSG_2209</th>
        <th>$MSG_608</th>
        <th>$MSG_606</th>
	</tr>");

for ($i = 0; $i < $nb; $i++) {
	
	$row = pg_fetch_row($resserie, $i);
	$classcolor = ($i % 2 == 0 || $i == 0 ? "couleur1" : "couleur2");
	
	$type=get_evaluation_type_libelle(get_evaluation_type_new_old($row[8]));
	$ico=get_evaluation_type_icone(get_evaluation_type_new_old($row[8]));
	$libel=$row[1];
	$libelle = substr($libel, 0, 60);
	if (strlen($libelle) == 60)
		$libelle .= "...";
		
	print ("
	    <tr class=\"$classcolor\" align=\"center\">
	        <td><b>".($i+1)."</b></td>
	        <td><img src=\"$ico\" alt=\"$type\" title=\"$type\" border=\"0\"></td>
	        <td>".get_gui_libelle($libelle,false)."</td>
	    </tr>");
	    
} 
if ($nb == 0)
	print ("
			<tr class=\"couleur2\">
				<td colspan=\"3\" align=\"center\">
					<b>$MSG_1869</b>
				</td>
			</tr>");
print ("
</table>
<br><br>
<a class=\"action\" href=\"#\" Onclick=\"window.close()\">$MSG_956</a>
</center>");

//include ('../piedpage.php3');
include("$dbpath/pied_page.php");
print("
</body></html>
");
?>