<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
    pdf pour le bilan general du test de positionnement

    Bilan pour un utilisateur

    @param integer : $formation numero de la formation
    @param integer : $liste numero de la liste de test de positionnement
    @param integer : $user numero du user
    @param integer : $parcours numero du parcours de la formation

*/
require('../dbpostgres.php3');
$db=pg_connect($server,"","","","$nombase");
require("$chemin_bo/lib/obj_liste_test.php");
require("$chemin_bo/lib/obj_individu.php");
require("$chemin_bo/lib/lib_parcours.php");
require('./analyse_fonctions.php');
define('FPDF_FONTPATH',"$chemin_bo/classement/pdf/fpdf/font/");
include("$chemin_bo/classement/pdf/fpdf/fpdf.php");
include("$chemin_bo/classement/pdf/fpdf/pdf_Afide.php");



/*---------------------------------------------------------------------*/
//                  INITIALISATION
/*---------------------------------------------------------------------*/
$obj_liste=new Liste_test($liste);
$nb_test=$obj_liste->getNbTests();
$obj_user=new Individu($user);
// nom du test
$nom_liste=$obj_liste->toString();
// nom du user
$nom_user=$obj_user->toString();
$nom=$obj_user->nom;
$prenom=$obj_user->prenom;
// tableau pour les couleurs de tests
$tab_couleur_test=array("#ffcc00"=>array("#ffe374","#ffed4a","#ffffc6"),
                                        "#0054ff"=>array("#4c94ff","#95c0ff","#b7e3ff"),
                                        "#009900"=>array("#02bf02","#5aed5a","#7bff7b"),
                                        "#990099"=>array("#d040d0","#e48ee4","#ffb0ff"));
// Les autre couleur (texte, cellule)
$couleur_gris="#cccccc";
$couleur_rouge="#ff0000";
// titre de la page pdf + taille
$titre_page="1 - BILAN DETAILLE DES INCOHERENCES ENTRE L'AUTO-POSITIONNEMENT ET LES QCM";
//Dimension d'une page A4
$largeur_page=210;
$hauteur_page=297;

//Marges horizontale et verticale
$marge=10;
$margey=25;



/*---------------------------------------------------------------------*/
//              CREATION DU PDF
/*---------------------------------------------------------------------*/
$pdf=new pdf_Afide();
$pdf->setMargins($marge,$marge);
$pdf->Open();
$pdf->AddPage();
$pdf->setAuthor("AFIDE");
$pdf->setCreator("FPDF");
$pdf->SetFont('Helvetica','B',10);
$pdf->setY($margey);
$pdf->setFillColor(255);
// affichage du titre de la page
$pdf->Cell(0,16,$titre_page,1,2,'C',1);
// nom du test et du user
$pdf->SetFont('Helvetica','B',8);
$pdf->Cell(0,10,"Test : $nom_liste",0,0,'L',0);
$pdf->ln();
$pdf->Cell(0,10,"Identifiant : $nom_user",0,0,'L',0);
$pdf->ln();
// date des rsultats
$tab=dates_test_auto_positionnement($liste);
$datetest=gmdate("d-m-Y  G:i:s",$tab[0]);

$pdf->Cell(0,10,"Date des rsultats : $datetest",0,2,'L',0);

/*---------------------------------------------------------------------*/
//                          1er TABLEAU
/*---------------------------------------------------------------------*/
$pdf->SetFont('Helvetica','BU',10);
$pdf->Cell(0,14,"Bilan des connaissances dclares au test d'auto-positionnement",0,2,'L',0);
// Boucle sur les tests
$pdf->SetFont('Helvetica','B',8);
// taille des cellules
$taille_cellule_gauche=80;
$taille_cellule_centre=60;
$taille_cellule_droite=30;
$hauteur_cellule=12;
$pdf->SetFont('Helvetica','B',8);
couleur_hexdec($couleur_gris,&$r,&$v,&$b);
$pdf->setFillColor($r,$v,$b);
/*--------------------------------------------- Ligne 1 ---------------------------*/
$pdf->Cell($taille_cellule_gauche,$hauteur_cellule,"THEME",1,'','L',1);
$pdf->Cell($taille_cellule_centre,$hauteur_cellule,"Rponses au test ",1,'','C',1);

$pdf->Cell($taille_cellule_droite,$hauteur_cellule,"Rponses QCM",1,'','C',1);
$pdf->ln();
$pdf->setX($marge);
/*--------------------------------------------- Ligne 2 ---------------------------*/
// boucle sur les tests
for($i=0;$i<$nb_test;$i++){
    $obj_test=&$obj_liste->getTest($i);
    $nom_test=$obj_test->toString();
    $num_theme=$obj_test->getNumTheme();
    // debug
    //echo "theme=$num_theme<br>";
     list($couleur_titre)=each($tab_couleur_test);
    // numero du test
    $num_test=$obj_test->getId();
    // numero de la serie correspondante au test
    $num_serie=numero_serie($num_test,$parcours,$liste);
    // pour le stockage des exercices dont le score est gal  0
    $tab_numqst=array();
    $tab_numrep=array();
    $tab_ordreqst=array();
    // les reponses du test (saul la dernire)
    $nb_reponse=$obj_test->getNbReponses() -1;
    $tab_rep=array();
    // stockage des n de reponses
    for($j=0;$j<$nb_reponse;$j++){
        $obj_reponse=&$obj_test->getReponse($j);
        // numer de reponse
        $num_reponse=$obj_reponse->getId();
        $tab_rep[]=$num_reponse;
    }
    //debug
    /*
    $taille=sizeof($tab_rep);
    for($t=0;$t<$taille;$t++){
        echo "tab_rep[$t]=$tab_rep[$t]<br>";
    }
    */
    // recup des exo avec echec
    recup_exo_echec($num_serie,$num_test,'q',&$tab_numqst,&$tab_numrep,&$tab_ordreqst);
    // debug

    $sz=sizeof($tab_numqst);
    /*
    for($s=0;$s<$sz;$s++){
        echo "tab_numsqt[$s]=$tab_numqst[$s] et tab_numrep[$s]=$tab_numrep[$s] <br>";
    }
    */
    if($sz>0){
        if($nb_reponse==1)
            $colsp=$max_rep;
        else
            $colsp=1;
        couleur_hexdec($couleur_titre,&$r,&$v,&$b);
        $pdf->setFillColor($r,$v,$b);
        $pdf->Cell($taille_cellule_gauche,$hauteur_cellule,$nom_test,1,'','L',1);
        $taille_cellule_reponse=$taille_cellule_centre/$nb_reponse;
        for($j=0;$j<$nb_reponse;$j++){
            $obj_reponse=&$obj_test->getReponse($j);
            $nom_reponse=$obj_reponse->toString();
             if($j%4==0)
                reset($tab_couleur_test);
             list($cle,$couleur_reponse)=each($tab_couleur_test["$couleur_titre"]);
             couleur_hexdec($couleur_reponse,&$r,&$v,&$b);
             $pdf->setFillColor($r,$v,$b);
             $pdf->Cell($taille_cellule_reponse,$hauteur_cellule,$nom_reponse,1,'','C',1);

        }
        couleur_hexdec($couleur_gris,&$r,&$v,&$b);
        $pdf->setFillColor($r,$v,$b);
        $pdf->Cell($taille_cellule_droite,$hauteur_cellule,"Score QCM",1,'','C',1);
        $pdf->ln();
        $pdf->setX($marge);

    }
    /*--------------------------------------------- Ligne 3 ---------------------------*/

    for($e=0;$e<$sz;$e++){
        //debug
        //echo "tab_numqst[$e]=$tab_numqst[$e]<br>";
        $id=$tab_numqst[$e];
        $obj_question=new Sondage($id);
        //$obj_question=&$obj_test->getExercice($tab_ordreqst[$e]);
        //$num_question=$obj_question->getId();
        $libelle_question=$obj_question->toString();

        // on tronque le libelle
        if(strlen($libelle_question)>45){
            $libelle_question=substr($libelle_question,0,45);
            $libelle_question .="...";
        }
        
        $num_question=$obj_question->getId();
        //debug
        //echo "num_question=$num_question $tab_numqst[$e]<br>";
        //print_r($obj_question);
        $pdf->setFillColor(255);
        $pdf->Cell($taille_cellule_gauche,$hauteur_cellule,"$num_question $libelle_question",1,'','L',1);
        for($j=0;$j<$nb_reponse;$j++){
            $obj_reponse=&$obj_test->getReponse($j);
            $bareme=$obj_reponse->bareme;
            $num_rep=$obj_reponse->getId();
            $taille_cellule_reponse=$taille_cellule_centre/$nb_reponse;

            if($num_rep==$tab_numrep[$e]){
                //debug
                //echo "num_rep=$num_rep<br>";
                $num_reponse=$num_rep;

                $pdf->Cell($taille_cellule_reponse,$hauteur_cellule,"X",1,'','C',1);
            }
            else
                $pdf->Cell($taille_cellule_reponse,$hauteur_cellule,"",1,'','C',1);

         }
         //debug
         //echo "qst=$num_question<br>test=$num_test<br>serie=$num_serie<br>";
         $lien="detailqcm.php?theme=$theme&test=$num_test&serie=$num_serie&formation=$formation&user=$user&question=$num_question&reponse=$num_reponse";
         //debug
         //echo "lien=$lien<br>";
         $tabexo=array();
        $tabexo=stock_exo_rep_test($num_test,$num_reponse,$num_question,'q');
        // recup moyenne pour cette reponse et type
         $str_moy=moyenne_rep($tabexo,$num_serie,$bareme,$type='q');
         couleur_hexdec($couleur_gris,&$r,&$v,&$b);
         $pdf->setFillColor($r,$v,$b);
         couleur_hexdec($couleur_rouge,&$r,&$v,&$b);
         $pdf->setTextColor($r,$v,$b);
         $pdf->Cell($taille_cellule_droite,$hauteur_cellule,"$str_moy",1,'','C',1);
         $pdf->Ln(); // saut de ligne
         $pdf->setTextColor(0);
    }

}
/*---------------------------------------------------------------------*/
//                          2ieme TABLEAU
/*---------------------------------------------------------------------*/
$pdf->Ln(); // saut de ligne
$pdf->setTextColor(0);
$pdf->SetFont('Helvetica','BU',10);
$pdf->Cell(0,14,"Bilan des connaissances dclares non matrises au test d'auto-positionnement",0,2,'L',0);
$pdf->SetFont('Helvetica','B',8);
couleur_hexdec($couleur_gris,&$r,&$v,&$b);
$pdf->setFillColor($r,$v,$b);
$longueur_cellule_gauche=80;
$longueur_cellule_droite=40;
$hauteur_cellule=12;
$pdf->Cell($longueur_cellule_gauche,$hauteur_cellule,"THEME",1,'','L',1);
$pdf->Cell($longueur_cellule_droite,$hauteur_cellule,"Rponses au test",1,'','C',1);
// boucle sur les tests
$pdf->Ln(); // saut de ligne
$pdf->setX($marge);
reset($tab_couleur_test);
for($i=0;$i<$nb_test;$i++){
     if($i%4==0)
                reset($tab_couleur_test);
    list($couleur_titre)=each($tab_couleur_test);
    $ordre=$i+1;
    $obj_test=&$obj_liste->getTest($i);
    // nom du test
    $libelle_test=$obj_test->toString();
    // numero du test
    $num_test=$obj_test->getId();
    // debug
    //echo "num_test=$num_test<br>";
    // recup de la derniere reponse
    $nb_reponse=$obj_test->getNbReponses();
    $obj_reponse=$obj_test->getReponse($nb_reponse -1);
    $num_reponse=$obj_reponse->getId();
    $libelle_reponse=$obj_reponse->toString();
    $couleur_reponse=$tab_couleur_test["$couleur_titre"][$nb_reponse -1];
    // debug
    //echo "num_reponse=$num_reponse<br>";
    // test si cette reponse a t coche
    $sql="select question from res_liste_test where id_stag=$user and id_formation=$formation and id_liste=$liste and ordre_etape=$ordre and reponse=$num_reponse ";
    $res=pg_query($sql);
    $nb=pg_numrows($res);
    if($nb>0){
        couleur_hexdec($couleur_titre,&$r,&$v,&$b);
        $pdf->setFillColor($r,$v,$b);
        $pdf->Cell($longueur_cellule_gauche,$hauteur_cellule,"$libelle_test",1,'','L',1);
        couleur_hexdec($couleur_reponse,&$r,&$v,&$b);
        $pdf->setFillColor($r,$v,$b);
        $pdf->Cell($longueur_cellule_droite,$hauteur_cellule,"$libelle_reponse",1,'','C',1);
        $pdf->setFillColor(255);
        $pdf->Ln(); // saut de ligne
        // methode multicell (texte sur plusieurs ligne ds une cellule)

        $pdf->SetWidths(array($longueur_cellule_gauche,$longueur_cellule_droite));
        for($j=0;$j<$nb;$j++){

            $row=pg_fetch_row($res,$j);
            $obj_question=new Sondage($row[0]);
            $libelle_question=$obj_question->toString();
            $pdf->Row(array($libelle_question,"x"));
            // saut de ligne

        }
        //$pdf->Ln(); // saut de ligne

    }


}

// fichier user
$file=$nom."_".$prenom."_detaille.pdf";

$pdf->Output($file,1);
?>