<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
    Dresse le bilan gnral  un test de positionnement

    Bilan pour un utilisateur

    @param integer : $formation numero de la formation
    @param integer : $liste numero de la liste de test de positionnement
    @param integer : $user numero du user
    @param integer : $parcours numero du parcours de la formation

*/
require('../dbpostgres.php3');
$db=pg_connect($server,"","","","$nombase");
require("$chemin_bo/lib/obj_liste_test.php");
require("$chemin_bo/lib/obj_individu.php");
require("$chemin_bo/lib/lib_parcours.php");
require('./analyse_fonctions.php');

/*---------------------------------------------------------------------*/
//          FONCTIONS PHP
/*---------------------------------------------------------------------*/

/*---------------------------------------------------------------------*/
//                  INITIALISATION
/*---------------------------------------------------------------------*/
$obj_liste=new Liste_test($liste);
// nombre de test pour la liste
$nb_test=$obj_liste->getNbTests();

$obj_user=new Individu($user);

// tableau pour les couleurs de tests
$tab_couleur_test=array("#ffcc00"=>array("#ffe374","#ffed4a","#ffffc6"),
                                        "#0054ff"=>array("#4c94ff","#95c0ff","#b7e3ff"),
                                        "#009900"=>array("#02bf02","#5aed5a","#7bff7b"),
                                        "#990099"=>array("#d040d0","#e48ee4","#ffb0ff"));

/*---------------------------------------------------------------------*/
//                  AFFICHAGE ENTETE
/*---------------------------------------------------------------------*/
$nompage="bilan_general.php";
$titre="";
$path='..';
$styleCSS="../style/ressourcesAdministratives.css";
//$styleCSS="./style_analyse.css";
include('../entete.php3');

// affichage du titre de la page
print("
<br>
<table class=\"tableau_message\"><tr>
<td><b>1 - BILAN GENERAL<BR>DES INCOHERENCES ENTRE L'AUTO-POSITIONNEMENT ET LES QCM</b></td>
</tr></table>
<br>
");
print("
<br>
<table class=\"tableau_normal2\"><tr class=\"couleur2\"><td>
<b>Test :</b> ".$obj_liste->toString()."<br>
<b>Identifiant :</b> ".$obj_user->toString()."<br>
<b>Date des rsultats :</b> <br>
");
$tab=dates_test_auto_positionnement($liste);

print("
<b>- Test :</b> ".gmdate("d-m-Y  G:i:s",$tab[0])."<br>
");
for($i=0;$i<$nb_test;$i++){
    $ind=$i+1;
    print("<b>- Srie n$ind :</b> ");
    if($tab[$ind]=="X")
        print("Pas fait");
    else
        print gmdate("d-m-Y  G:i:s",$tab[$ind]);
    print("<br>");
}

print("
</td></tr></table>
<br><br>
");

/*---------------------------------------------------------------------*/
//  TABLEAU BILAN DU TEST D'AUTO-POSITIONNEMENT
/*---------------------------------------------------------------------*/
print("
<table class=\"tableau_normal2\"><tr class=\"couleur1\"><td>
<b><u>Bilan du test d'auto-positionnement</u> :</b>
</td></tr>
<tr class=\"couleur2\"><td align=\"center\">

");
// le tableau
print("
<table border=\"0\" width=\"90%\">
");
// BOUCLE SUR LES TEST
for($i=0;$i<$nb_test;$i++){
    $obj_test=&$obj_liste->getTest($i);
    // nb de reponses pour ce test
    $nb_reponse=$obj_test->getNbReponses();
    // couleur pout le titre du test
     if($i%4==0)
            reset($tab_couleur_test);
    list($couleur_titre)=each($tab_couleur_test);
    print("
    <tr>
    <td>

    <table border=1>
    <tr>
    <td height=60 width=200 bgcolor=$couleur_titre>
    <b><font face=\"Arial,Helvetica\" size=2>".$obj_test->toString()."</font></b>
    </td>
    </tr>
    
    </table>


    </td>
    <!--<td>&nbsp;</td>-->
    <td>
    <table border=1>
    <tr>
    <td colspan=$nb_reponse bgcolor=$couleur_titre align=center width=600>
    <b><font face=\"Arial,Helvetica\" size=2>Nombre de CASES COCHEES pour le test d'auto-positionnement</font></b>
    </td>
    </tr>
    <tr>
    ");
    // BOUCLE SUR LES REPONSES DU TEST
    reset($tab_couleur_test["$couleur_titre"]);
    for($j=0;$j<$nb_reponse;$j++){
        $obj_reponse=&$obj_test->getReponse($j);
        // couleur pour les rponses

        list($cle,$couleur_reponse)=each($tab_couleur_test["$couleur_titre"]);
        print("
        <td bgcolor=$couleur_reponse align=center>
        <b><font face=\"Arial,Helvetica\" size=2>".$obj_reponse->toString()."</font></b>
        </td>
        ");
    }
    print("
    </tr>
    <tr>
    ");
    for($j=0;$j<$nb_reponse;$j++){
        $obj_reponse=&$obj_test->getReponse($j);
        // numero de la reponse
        $num_reponse=$obj_reponse->getId();
        // recup du nb de cette reponse
        // NOTE : Prevoir des methodes ....
        $sql="select count(1) from res_liste_test where id_formation=$formation and id_stag=$user and ordre_etape=$i+1 and reponse=$num_reponse";
        $res=pg_query($sql);
        $row=pg_fetch_row($res,0);
        print("
        <td align=center><b><b><font face=\"Arial,Helvetica\" size=2>$row[0]</font></b></td>
        ");
    }
    print("
    </tr>
    </table>
    </td>
    </tr>
    ");
}
print("
</table>
</td></tr></table>
");
/*---------------------------------------------------------------------*/
//  TABLEAU BILAN DES EVALUATIONS
/*---------------------------------------------------------------------*/
print("
<br>
<font face=\"Arial,Helvetica\" size=2>
<b><u>Bilan des valuations (QCM)</u><br><br>
</font>
");
// le tableau
reset($tab_couleur_test);
print("
<table border=1 cellspacing=0 cellpadding=0 width=80%>
");
/*-------------------------------- Premiere ligne ------------------*/
print("
<tr>
<td rowspan=2 align=center>
<font face=\"Arial,Helvetica\" size=2><b>EVALUATION <br>par THEME</b></font></td>

");
for($i=0;$i<$nb_test;$i++){
    $obj_test=&$obj_liste->getTest($i);
    // nb de reponses pour ce test (sauf la derniere)
    $nb_reponse=$obj_test->getNbReponses() -1;
    // couleur pout le titre du test
    if($i%4==0)
            reset($tab_couleur_test);
    list($couleur_titre)=each($tab_couleur_test);
    print("
    <td colspan=$nb_reponse bgcolor=$couleur_titre align=center>
    <b><font face=\"Arial,Helvetica\" size=2>".$obj_test->toString()."</font></b>
    </td>
    ");
}
print("
<td rowspan=2 align=center bgcolor=\"#cccccc\">
<font face=\"Arial,Helvetica\" size=2><b>TOTAL</b></font>
</td>
</tr>
<tr>
");
//reset($tab_couleur_test);
for($i=0;$i<$nb_test;$i++){
    if($i%4==0){
        reset($tab_couleur_test);
    }
    list($couleur_titre)=each($tab_couleur_test);
    reset($tab_couleur_test["$couleur_titre"]);
    $obj_test=&$obj_liste->getTest($i);
    // nb de reponses pour ce test (sauf la derniere)
    $nb_reponse=$obj_test->getNbReponses() -1;
    for($j=0;$j<$nb_reponse;$j++){

        $obj_reponse=&$obj_test->getReponse($j);
        // bareme pour cette reponse
        $bareme=$obj_reponse->bareme;
        if($bareme>0){

            // point pour juste
            $sql="select repok from bareme where num_bareme=$bareme";
            $resbareme=pg_query($sql);
            $rowbareme=pg_fetch_row($resbareme,0);
        }
        else
            $rowbareme[0]=1;
        // couleur pour les rponses
        list($cle,$couleur_reponse)=each($tab_couleur_test["$couleur_titre"]);
        //debug
        //echo "coul_tit=$couleur_titre et coul_rep=$couleur_reponse<br>";
        if($rowbareme[0]>1)
            $pt="points";
        else
            $pt="point";
        print("
        <td bgcolor=$couleur_reponse align=center>
        <b><font face=\"Arial,Helvetica\" size=2>".$obj_reponse->toString()."<br>$rowbareme[0] $pt</font></b>
        </td>
        ");
    }
}
print("
</tr>
");
/*-------------------------------- Deuxieme ligne ------------------*/
print("
<tr>
<td align=center>
<b><font face=\"Arial,Helvetica\" size=2><b>RESULTATS<br>obtenus par<br>l'apprenant pour les<br>QCM</b></font>
</td>
");
$point=0;
$total=0;
$tabecart=array();
$tab_coeff_test=array();
$tabmoyenne_test=array();
for($i=0;$i<$nb_test;$i++){
    $obj_test=&$obj_liste->getTest($i);
    // recup du n du test
    $num_test=$obj_test->getId();
    // debug
    //echo "num_test=$num_test<br>";
    // recup de la serie correspondante au n de test
    $num_serie=numero_serie($num_test,$parcours,$liste);
    // debug
    //echo "num_serie=$num_serie<br>";

    $point_test=0;
    $total_test=0;
    $coeff_rep=0;
    $bareme=0;
    // nb de reponses pour ce test (sauf la derniere)
    $nb_reponse=$obj_test->getNbReponses() -1;
    for($j=0;$j<$nb_reponse;$j++){
        $obj_reponse=&$obj_test->getReponse($j);
        // le bareme pour cette reponse
        $bareme=$obj_reponse->bareme;
        // numer de reponse
        $num_reponse=$obj_reponse->getId();
        // recup ds un tableau des numero d'exo pour cette reponse ,ce test et le type 'q'
        // NOTE : Prvoir un mthode
        $tabexo=array();
        $tabexo=stock_exo_rep_test($num_test,$num_reponse,'','q');
        //debug
        //print_r($tabexo);
        // recup moyenne pour cette reponse et type
        $str_moy=moyenne_rep($tabexo,$num_serie,$bareme,$type='q');
        //echo "str_moy=$str_moy<br>";
        $msgx="";
        if($str_moy!="X"){
             // recup coeff_rep


            $tab=explode("/",$str_moy);
            $tabecart[]=$tab[1] - $tab[0];
            $point +=$tab[0];
            $total +=$tab[1];
             // recup coeff_rep
             $coeff_rep +=$tab[1];
            $point_test +=$tab[0];
            $total_test +=$tab[1];
            if($tab[0]==$tab[1])
                $couleur="#00ff00";
            else
                $couleur="#ff0000";
        }
        else{


            $tabecart[]=0;
            $couleur="#000000";
            //debug
            //echo "str_moy=$str_moy<br>";
            // la srie est-elle faite ?
            $sql="select * from res_serie where id_serie=$num_serie and id_stag=$user and id_formation=$formation";
            $resserie=pg_query($sql);
            if(pg_numrows($resserie)==1)
                $msgx="(pas d'exo)";
            else
                $msgx="(pas fait)";

        }
        // debug
        //echo "tab[0]=$tab[0] et tab[1]=$tab[1]<br>";
        print("
        <td align=center>
        <font face=\"Arial,Helvetica\" size=2 color=$couleur><b>$str_moy</b><br>$msgx</font>
        </td>
        ");
    }
    // stockage des coefficient de test
    // debug
    //echo "coeff_rep=$coeff_rep<br>";
    $tab_coeff_test[]=$coeff_rep;
    // stockage des moyenne de test
    if($total_test!=0){
        $moyenne_test=$point_test * (20/$total_test);
        $moyenne_test *=100;
        $moyenne_test = round($moyenne_test);
        $moyenne_test /=100;
        $tabmoyenne_test[]=$moyenne_test;
    }
    else
        $tabmoyenne_test[]=-1;
}
if($total!=0)
    if($point==$total)
        $couleur="#00ff00";
    else
        $couleur="#ff0000";
else
    $couleur="#000000";
print("
<td bgcolor=\"#cccccc\" align=center>
<b><font face=\"Arial,Helvetica\" size=2 color=$couleur>$point / $total</font></b>
</td>
</tr>
");
/*-------------------------------- Troisieme ligne ------------------*/
print("
<tr>
<td align=center>
<b><font face=\"Arial,Helvetica\" size=2><b>ECART<br>sur les resultats de<br>QCM</b></font>
</td>
");
$ind=0;
for($i=0;$i<$nb_test;$i++){
$obj_test=&$obj_liste->getTest($i);
    // nb de reponses pour ce test (sauf la derniere)
    $nb_reponse=$obj_test->getNbReponses() -1;
    for($j=0;$j<$nb_reponse;$j++){
        $obj_reponse=&$obj_test->getReponse($j);
        $nb_reponse=$obj_test->getNbReponses() -1;
        for($j=0;$j<$nb_reponse;$j++){
            if($tabecart[$ind]>1)
                $pt="points";
            else
                $pt="point";
            print("
            <td align=center>
            <b><font face=\"Arial,Helvetica\" size=2>$tabecart[$ind] $pt</font></b>
            </td>
            ");
            $ind++;
        }
    }
}
$somme_ecart=array_sum($tabecart);
if($somme_ecart>1)
    $pt="points";
else
    $pt="point";
print("
<td bgcolor=\"#cccccc\" align=center>
<b><font face=\"Arial,Helvetica\" size=2>$somme_ecart $pt</font></b>
</td>
</tr>
");
/*-------------------------------- Quatrieme ligne ------------------*/
print("
<tr bgcolor=\"#cccccc\">
<td align=center>
<b><font face=\"Arial,Helvetica\" size=2><b>MOYENNE QCM<br> - par THEME et<br>- TOTALE</b></font>
</td>
");
for($i=0;$i<$nb_test;$i++){
    $obj_test=&$obj_liste->getTest($i);
    $nb_reponse=$obj_test->getNbReponses() -1;
    print("
        <td align=center colspan=$nb_reponse>
        <b><font face=\"Arial,Helvetica\" size=2 color=\"#ff0000\">
        ");
        if($tabmoyenne_test[$i]>=0)
            print("
            $tabmoyenne_test[$i]
            ");
        else
            print("
            X
            ");
        print("
        / 20 </b><br><font color=\"#000000\" size=1><i>(coeff=$tab_coeff_test[$i])</i></font></font>
        </td>
        ");
}
$somme_totale=array_sum($tabmoyenne_test);
$moyenne_totale=$somme_totale / $nb_test;
$moyenne_totale *=100;
$moyenne_totale=round($moyenne_totale);
$moyenne_totale /=100;
$sz=sizeof($tabmoyenne_test);
// debug
//echo "sz=$sz<br>";
$tabmoy=array();
for($i=0;$i<$sz;$i++){
    //debug
    //echo "tabmoyenne_test[$i]=$tabmoyenne_test[$i]<br>";
    if($tabmoyenne_test[$i]>=0){
        // debug
        //echo "tabmoyenne_test[$i]=$tabmoyenne_test[$i]<br>";
        $tabmoy[]=$tabmoyenne_test[$i];
    }
    else
        $tabmoy[]='X';
}
$nb=sizeof($tabmoy);
//debug
//echo "nb=$nb<br>";
if($nb>0){
    /*
    $somme_totale=array_sum($tabmoy);

    $moyenne_totale=$somme_totale / $nb;
    $moyenne_totale *=100;
    $moyenne_totale=round($moyenne_totale);
    $moyenne_totale /=100;
    */
    // calcul avec prise en compte des coefficients
    $somme_totale=0;
    //print_r($tabmoy);
    //print_r($tab_coeff_test);
    for($i=0;$i<$nb;$i++){
        if($tabmoy[$i]!="X")
            $somme_totale +=($tabmoy[$i]*$tab_coeff_test[$i]);

    }
    $moyenne_totale=$somme_totale/(array_sum($tab_coeff_test));
    $moyenne_totale *=100;
    $moyenne_totale=round($moyenne_totale);
    $moyenne_totale /=100;
}
else
    $moyenne_totale="X";
if($moyenne_totale==20)
    $couleur="#00ff00";
else
    $couleur="#ff0000";
print("
<td align=center>
<b><font face=\"Arial,Helvetica\" size=2 color=\"#ff0000\">$moyenne_totale / 20 </font></b>
</td>
</tr>
");
print("
</table>
");




// ajout Elyes Mars 2005 : affichage du bouton retour dans le cas o on vient de la page de stats par utilisateur
if(isset($stats_user))
    print("<br>\n<center><form><input type=\"button\" value=\"$MSG_37\" onClick=\"history.back()\"></form>\n</center>\n");


include('../piedpage.php3');



?>