<?php
/*
	This file is part of Astairs.

    Astairs is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    any later version.

    Astairs is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Astairs.  If not, see <http://www.gnu.org/licenses/>.

	Copyright (C) 2006, 2007, 2008, 2009 AFIDE
    
	Auteurs:

	Said Ladjani <sladjani@yahoo.fr>
	Remi Cocquet <remi.cocquet@gmail.com>

*/

/**
    pdf pour le bilan general et dtaill du test de positionnement

    Bilan pour un utilisateur

    @param integer : $formation numero de la formation
    @param integer : $liste numero de la liste de test de positionnement
    @param integer : $user numero du user
    @param integer : $parcours numero du parcours de la formation

*/
require('../dbpostgres.php3');
$db=pg_connect($server,"","","","$nombase");
require("$chemin_bo/lib/obj_liste_test.php");
require("$chemin_bo/lib/obj_individu.php");
require("$chemin_bo/lib/lib_parcours.php");
require('./analyse_fonctions.php');
define('FPDF_FONTPATH',"$chemin_bo/classement/pdf/fpdf/font/");
include("$chemin_bo/classement/pdf/fpdf/fpdf.php");
include("$chemin_bo/classement/pdf/fpdf/pdf_Afide.php");


/*---------------------------------------------------------------------*/
//                  INITIALISATION
/*---------------------------------------------------------------------*/
$obj_liste=new Liste_test($liste);
$nb_test=$obj_liste->getNbTests();
$obj_user=new Individu($user);
// nom du test
$nom_liste=$obj_liste->toString();
// nom du user
$nom_user=$obj_user->toString();
$nom=$obj_user->nom;
$prenom=$obj_user->prenom;
// tableau pour les couleurs de tests
$tab_couleur_test=array("#ffcc00"=>array("#ffe374","#ffed4a","#ffffc6"),
                                        "#0054ff"=>array("#4c94ff","#95c0ff","#b7e3ff"),
                                        "#009900"=>array("#02bf02","#5aed5a","#7bff7b"),
                                        "#990099"=>array("#d040d0","#e48ee4","#ffb0ff"));
// Les autre couleur (texte, cellule)
$couleur_gris="#cccccc";
$couleur_rouge="#ff0000";
// titre de la page pdf + taille
$titre_page="1 - BILAN GENERAL DES INCOHERENCES ENTRE L'AUTO-POSITIONNEMENT ET LES EVALUATIONS";
//Dimension d'une page A4
$largeur_page=210;
$hauteur_page=297;

//Marges horizontale et verticale
$marge=10;
$margey=25;



/*---------------------------------------------------------------------*/
//              CREATION DU PDF
/*---------------------------------------------------------------------*/
$pdf=new pdf_Afide();
$pdf->setMargins($marge,$marge);
$pdf->Open();
$pdf->AddPage();
$pdf->setAuthor("AFIDE");
$pdf->setCreator("FPDF");
$pdf->SetFont('Helvetica','B',10);
$pdf->setY($margey);
$pdf->setFillColor(255);
// affichage du titre de la page
$pdf->Cell(0,16,$titre_page,1,2,'C',1);
// nom du test et du user
$pdf->SetFont('Helvetica','B',8);
$pdf->Cell(0,10,"Test : $nom_liste",0,0,'L',0);
$pdf->ln();
$pdf->Cell(0,10,"Identifiant : $nom_user",0,0,'L',0);
$pdf->ln();
// date des rsultats
$tab=dates_test_auto_positionnement($liste);
$datetest=gmdate("d-m-Y  G:i:s",$tab[0]);

$pdf->Cell(0,10,"Date des rsultats : $datetest",0,2,'L',0);

/*---------------------------------------------------------------------*/
//                          1er TABLEAU
/*---------------------------------------------------------------------*/
$pdf->SetFont('Helvetica','BU',10);
$pdf->Cell(0,14,"Bilan du test d'auto-positionnement",0,2,'L',0);
// Boucle sur les tests
$pdf->SetFont('Helvetica','B',8);
for($i=0;$i<$nb_test;$i++){
    $obj_test=&$obj_liste->getTest($i);
    // nom du test
    $nom_test=$obj_test->toString();
    // nb de reponses pour ce test
    $nb_reponse=$obj_test->getNbReponses();
    // couleur pout le titre du test
    if($i%4==0)
            reset($tab_couleur_test);
    list($couleur_titre)=each($tab_couleur_test);
    reset($tab_couleur_test["$couleur_titre"]);
    // couleur en R V B
    couleur_hexdec($couleur_titre,&$r,&$v,&$b);
    $pdf->setFillColor($r,$v,$b);
    $pdf->setX($marge);
    $pdf->Cell(50,24,$nom_test,1,0,'L',1);
    $y=$pdf->getY();
    $pdf->setX(70);
    $pdf->Cell(120,8,"Nombre de CASES COCHEES pour le test d'auto-positionnement",1,1,'C',1);
    // boucle sur les reponses
    // taille de la cellule pour une reponse
    $taille_cellule=120/$nb_reponse;
    $pdf->setX(70+$x);
    for($j=0;$j<$nb_reponse;$j++){
        $obj_reponse=&$obj_test->getReponse($j);
        $nom_reponse=$obj_reponse->toString();

        list($cle,$couleur_reponse)=each($tab_couleur_test["$couleur_titre"]);
        couleur_hexdec($couleur_reponse,&$r,&$v,&$b);
        $pdf->setFillColor($r,$v,$b);
        $pdf->Cell($taille_cellule,8,$nom_reponse,1,'','C',1);
    }
    // boucle sur les nb de coches
    $pdf->Ln(); // saut de ligne
    $pdf->setX(70+$x);  // repositionnement en abcisse
    for($j=0;$j<$nb_reponse;$j++){
        $obj_reponse=&$obj_test->getReponse($j);
        // numero de la reponse
        $num_reponse=$obj_reponse->getId();
        $sql="select count(1) from res_liste_test where id_formation=$formation and id_stag=$user and ordre_etape=$i+1 and reponse=$num_reponse";
        $res=pg_query($sql);
        $row=pg_fetch_row($res,0);
        $pdf->Cell($taille_cellule,8,$row[0],1,'','C');
    }
    $pdf->Ln(); // saut de ligne
}

/*---------------------------------------------------------------------*/
//                          2ieme TABLEAU
/*---------------------------------------------------------------------*/
$pdf->SetFont('Helvetica','BU',10);
$pdf->Cell(0,14,"Bilan des QCM",0,2,'L',0);
reset($tab_couleur_test);
/*--------------------------------------------- Ligne 1 ---------------------------*/
$pdf->setX($marge);
$pdf->SetFont('Helvetica','B',8);
$pdf->setFillColor(255);
$pdf->Cell(72,16,"EVALUATION",1,0,'C',1);
$pdf->Cell(24,16,"RESULTATS",1,0,'C',1);
$pdf->Cell(24,16,"ECART (point)",1,0,'C',1);
$pdf->Cell(24,16,"MOYENNE",1,0,'C',1);

$pdf->Ln(); // saut de ligne
 $tabecart=array();
  $tab_coeff_test=array();
    $tabmoyenne_test=array();

//$taille_cellule_test=150/$nb_test;
// boucle sur les test (affiche les noms de test)
//$pdf->setX(34);
for($i=0;$i<$nb_test;$i++){

    $obj_test=&$obj_liste->getTest($i);
    $nom_test=$obj_test->toString();
    //$obj_test=&$obj_liste->getTest($i);
    // recup du n du test
    $num_test=$obj_test->getId();
    $num_serie=numero_serie($num_test,$parcours,$liste);
    $point=0;
    $total=0;
    $coeff_rep=0;
    //$moyenne_test=0;

    // nb de reponses pour ce test (sauf la derniere)
    $nb_reponse=$obj_test->getNbReponses() -1;
    // couleur pout le titre du test
    if($i%4==0)
        reset($tab_couleur_test);
    list($couleur_titre)=each($tab_couleur_test);
    reset($tab_couleur_test["$couleur_titre"]);
    // couleur en R V B
    couleur_hexdec($couleur_titre,&$r,&$v,&$b);
    $pdf->setFillColor($r,$v,$b);
    $pdf->setTextColor(255);
    $pdf->SetFont('Helvetica','B',10);
    $pdf->Cell(144,8,$nom_test,1,0,'L',1);
    $pdf->SetFont('Helvetica','B',8);
    /*
    $pdf->Cell(24,8,"",1,0,'C',1);
    $pdf->Cell(24,8,"",1,0,'C',1);
    $pdf->Cell(24,8,"",1,0,'C',1);
    */
    $pdf->Ln(); // saut de ligne
    //BOUCLE SUR LES RPONSES

    for($j=0;$j<$nb_reponse;$j++){
        $obj_reponse=&$obj_test->getReponse($j);
        $nom_reponse=$obj_reponse->toString();
        list($cle,$couleur_reponse)=each($tab_couleur_test["$couleur_titre"]);
        couleur_hexdec($couleur_reponse,&$r,&$v,&$b);
        $pdf->setFillColor($r,$v,$b);
        $pdf->setTextColor(0);
        $pdf->Cell(72,8,$nom_reponse,1,'','C',1);
        $pdf->setFillColor(255);
        // resultat ------------------------------------------------------------------------------------------------------------------------------
         // le bareme pour cette reponse
        $bareme=$obj_reponse->bareme;
        // numer de reponse
        $num_reponse=$obj_reponse->getId();
        // recup ds un tableau des numero d'exo pour cette reponse ,ce test et le type 'q'
        // NOTE : Prvoir un mthode
        $tabexo=array();
        $tabexo=stock_exo_rep_test($num_test,$num_reponse,'','q');
        // recup moyenne pour cette reponse et type
        $str_moy=moyenne_rep($tabexo,$num_serie,$bareme,$type='q');
        if($str_moy!="X"){
            $tab=explode("/",$str_moy);
            $ecart_courant=$tab[1] - $tab[0];
            //$tabecart[]=$tab[1] - $tab[0];
            $tabecart[]=$ecart_courant;
            $point +=$tab[0];
            $total +=$tab[1];
             // recup coeff_rep
             $coeff_rep +=$tab[1];
            $point_test +=$tab[0];
            $total_test +=$tab[1];
            if($tab[0]==$tab[1])
                $couleur="#008040";
            else
                $couleur="#ff0000";
        }
        else{
            $ecart_courant="0";
            $tabecart[]=0;
            $couleur="#000000";

        }
        couleur_hexdec($couleur,&$r,&$v,&$b);
        //$pdf->setFillColor($r,$v,$b);
        $pdf->setTextColor($r,$v,$b);
        $pdf->Cell(24,8,$str_moy,1,'','C',1);
        //ecart ---------------------------------------------------------------------------------------------------------------------
        $pdf->setTextColor(0);
        $pdf->Cell(24,8,"$ecart_courant",1,'','C',1);
    //$pdf->Ln(); // saut de ligne




        //moyenne -----------------------------------------------------------------------------------------------------------------
         // stockage des coefficient de test
    //$tab_coeff_test[]=$coeff_rep;
    // stockage des moyenne de test
    if($total!=0){
        //$moyenne_test=$point_test * (20/$total_test);
        $moyenne_test=$point * (20/$total);
        $moyenne_test *=100;
        $moyenne_test = round($moyenne_test);
        $moyenne_test /=100;
        //$tabmoyenne_test[]=$moyenne_test;
        $mt=$moyenne_test;
    }
    else {
        //$tabmoyenne_test[]=-1;
        $moyenne_test="X";
        $mt=- 1;
    }


//}
if($total!=0)
    if($point==$total)
        $couleur="#008040";
    else
        $couleur="#ff0000";
else
    $couleur="#000000";
couleur_hexdec($couleur,&$r,&$v,&$b);
$pdf->setTextColor($r,$v,$b);
couleur_hexdec($couleur_gris,&$r,&$v,&$b);
$pdf->setFillColor($r,$v,$b);
$haut_cell=8*$nb_reponse;
// svg coordonnes
if($j==0){
    $oldx=$pdf->getX();
    $oldy=$pdf->getY();
    //print("x=$oldx et y=$oldy<br>");
}
if($j==$nb_reponse -1){
    $ajust= 8;
    if($nb_reponse>1){
        $ajust= ($nb_reponse)*8;
         $pdf->setY($oldy);
         $pdf->setX($oldx);
    }

    $pdf->Cell(24,$ajust,"$moyenne_test/20",1,0,'C',1);
}
else{
   $pdf->setX($pdf->getX() + 24);
   
}
$pdf->Ln(); // saut de ligne
}
$tab_coeff_test[]=$coeff_rep;
$tabmoyenne_test[]=$mt;
}
// total ----------------------------------------------------------------------------------------------------------------------
$pdf->setTextColor(0);
$pdf->Cell(72,16,"TOTAL",1,0,'C',1);
//-------------------------------------------
if($total!=0)
    if($point==$total)
        $couleur="#008040";
    else
        $couleur="#ff0000";
else
    $couleur="#000000";
couleur_hexdec($couleur,&$r,&$v,&$b);
$pdf->setTextColor($r,$v,$b);
couleur_hexdec($couleur_gris,&$r,&$v,&$b);
$pdf->setFillColor($r,$v,$b);
$pdf->Cell(24,16,"$point_test / $total_test",1,0,'C',1);
//------------------------------------------
$somme_ecart=array_sum($tabecart);
if($somme_ecart>1)
    $pt="points";
else
    $pt="point";
couleur_hexdec($couleur_gris,&$r,&$v,&$b);
$pdf->setFillColor($r,$v,$b);
$pdf->setTextColor(0);
$pdf->Cell(24,16,"$somme_ecart $pt",1,0,'C',1);
//------------------------------------------
$somme_totale=array_sum($tabmoyenne_test);
$moyenne_totale=$somme_totale / $nb_test;
$moyenne_totale *=100;
$moyenne_totale=round($moyenne_totale);
$moyenne_totale /=100;
$sz=sizeof($tabmoyenne_test);
// debug
//echo "sz=$sz<br>";
$tabmoy=array();
for($i=0;$i<$sz;$i++){
    //debug
    //echo "tabmoyenne_test[$i]=$tabmoyenne_test[$i]<br>";
    if($tabmoyenne_test[$i]>=0){
        // debug
        //echo "tabmoyenne_test[$i]=$tabmoyenne_test[$i]<br>";
        $tabmoy[]=$tabmoyenne_test[$i];
    }
    //else
        //echo "t=$tabmoyenne_test[$i]<br>";
}
$nb=sizeof($tabmoy);
//debug
//echo "nb=$nb<br>";
if($nb>0){
/*
    $somme_totale=array_sum($tabmoy);
    $moyenne_totale=$somme_totale / $nb;
    $moyenne_totale *=100;
    $moyenne_totale=round($moyenne_totale);
    $moyenne_totale /=100;
    */
     // calcul avec prise en compte des coefficients
    $somme_totale=0;
    for($i=0;$i<$nb;$i++){
        if($tabmoy[$i]!="X")
            $somme_totale +=($tabmoy[$i]*$tab_coeff_test[$i]);

    }
    $moyenne_totale=$somme_totale/(array_sum($tab_coeff_test));
    $moyenne_totale *=100;
    $moyenne_totale=round($moyenne_totale);
    $moyenne_totale /=100;
}
else
    $moyenne_totale="X";
if($moyenne_totale==20)
    $couleur="#008040";
else
    $couleur="#ff0000";
couleur_hexdec($couleur,&$r,&$v,&$b);
$pdf->setTextColor($r,$v,$b);
couleur_hexdec($couleur_gris,&$r,&$v,&$b);
$pdf->setFillColor($r,$v,$b);

$pdf->Cell(24,16,"$moyenne_totale / 20",1,0,'C',1);



$pdf->setTextColor(0);


$pdf->AddPage();

$titre_page="1 - BILAN DETAILLE DES INCOHERENCES ENTRE L'AUTO-POSITIONNEMENT ET LES EVALUATIONS";
$pdf->SetFont('Helvetica','B',10);
$pdf->setFillColor(255);
// affichage du titre de la page
$pdf->Cell(0,16,$titre_page,1,2,'C',1);
// nom du test et du user
$pdf->SetFont('Helvetica','B',8);
$pdf->Cell(0,10,"Test : $nom_liste",0,0,'L',0);
$pdf->ln();
$pdf->Cell(0,10,"Identifiant : $nom_user",0,2,'L',0);
/*---------------------------------------------------------------------*/
//                          1er TABLEAU
/*---------------------------------------------------------------------*/
$pdf->SetFont('Helvetica','BU',10);
$pdf->Cell(0,14,"Bilan des connaissances dclares au test d'auto-positionnement",0,2,'L',0);
// Boucle sur les tests
$pdf->SetFont('Helvetica','B',8);
// taille des cellules
$taille_cellule_gauche=80;
$taille_cellule_centre=60;
$taille_cellule_droite=30;
$hauteur_cellule=12;
$pdf->SetFont('Helvetica','B',8);
couleur_hexdec($couleur_gris,&$r,&$v,&$b);
$pdf->setFillColor($r,$v,$b);
/*--------------------------------------------- Ligne 1 ---------------------------*/
$pdf->Cell($taille_cellule_gauche,$hauteur_cellule,"THEME",1,'','L',1);
$pdf->Cell($taille_cellule_centre,$hauteur_cellule,"Rponses au test",1,'','C',1);
$pdf->Cell($taille_cellule_droite,$hauteur_cellule,"Rponses QCM",1,'','C',1);
$pdf->ln();
$pdf->setX($marge);
reset($tab_couleur_test);
/*--------------------------------------------- Ligne 2 ---------------------------*/
// boucle sur les tests
for($i=0;$i<$nb_test;$i++){
    $obj_test=&$obj_liste->getTest($i);
    $nom_test=$obj_test->toString();
    $num_theme=$obj_test->getNumTheme();
    // debug
    //echo "theme=$num_theme<br>";
    if($i%4==0)
                reset($tab_couleur_test);
     list($couleur_titre)=each($tab_couleur_test);
      reset($tab_couleur_test["$couleur_titre"]);
    // numero du test
    $num_test=$obj_test->getId();
    // numero de la serie correspondante au test
    $num_serie=numero_serie($num_test,$parcours,$liste);
    // pour le stockage des exercices dont le score est gal  0
    $tab_numqst=array();
    $tab_numrep=array();
    $tab_ordreqst=array();
    // les reponses du test (saul la dernire)
    $nb_reponse=$obj_test->getNbReponses() -1;
    $tab_rep=array();
    // stockage des n de reponses
    for($j=0;$j<$nb_reponse;$j++){
        $obj_reponse=&$obj_test->getReponse($j);
        // numer de reponse
        $num_reponse=$obj_reponse->getId();
        $tab_rep[]=$num_reponse;
    }
    //debug
    /*
    $taille=sizeof($tab_rep);
    for($t=0;$t<$taille;$t++){
        echo "tab_rep[$t]=$tab_rep[$t]<br>";
    }
    */
    // recup des exo avec echec
    recup_exo_echec($num_serie,$num_test,'q',&$tab_numqst,&$tab_numrep,&$tab_ordreqst);
    // debug

    $sz=sizeof($tab_numqst);
    /*
    for($s=0;$s<$sz;$s++){
        echo "tab_numsqt[$s]=$tab_numqst[$s] et tab_numrep[$s]=$tab_numrep[$s] <br>";
    }
    */
    if($sz>0){
        if($nb_reponse==1)
            $colsp=$max_rep;
        else
            $colsp=1;
        couleur_hexdec($couleur_titre,&$r,&$v,&$b);
        $pdf->setFillColor($r,$v,$b);
        $pdf->Cell($taille_cellule_gauche,$hauteur_cellule,$nom_test,1,'','L',1);
        $taille_cellule_reponse=$taille_cellule_centre/$nb_reponse;
         reset($tab_couleur_test["$couleur_titre"]);
        for($j=0;$j<$nb_reponse;$j++){
            $obj_reponse=&$obj_test->getReponse($j);
            $nom_reponse=$obj_reponse->toString();
             list($cle,$couleur_reponse)=each($tab_couleur_test["$couleur_titre"]);
             couleur_hexdec($couleur_reponse,&$r,&$v,&$b);
             $pdf->setFillColor($r,$v,$b);
             $pdf->Cell($taille_cellule_reponse,$hauteur_cellule,$nom_reponse,1,'','C',1);

        }
        couleur_hexdec($couleur_gris,&$r,&$v,&$b);
        $pdf->setFillColor($r,$v,$b);
        $pdf->Cell($taille_cellule_droite,$hauteur_cellule,"Score QCM",1,'','C',1);
        $pdf->ln();
        $pdf->setX($marge);

    }
    /*--------------------------------------------- Ligne 3 ---------------------------*/

    for($e=0;$e<$sz;$e++){
        //debug
        //echo "tab_numqst[$e]=$tab_numqst[$e]<br>";
        $id=$tab_numqst[$e];
        $obj_question=new Sondage($id);
        //$obj_question=&$obj_test->getExercice($tab_ordreqst[$e]);
        //$num_question=$obj_question->getId();
        $libelle_question=$obj_question->toString();

         // on tronque le libelle
        if(strlen($libelle_question)>45){
            $libelle_question=substr($libelle_question,0,45);
            $libelle_question .="...";
        }


        $num_question=$obj_question->getId();
        //debug
        //echo "num_question=$num_question $tab_numqst[$e]<br>";
        //print_r($obj_question);
        $pdf->setFillColor(255);
        $pdf->Cell($taille_cellule_gauche,$hauteur_cellule,"$num_question $libelle_question",1,'','L',1);
        for($j=0;$j<$nb_reponse;$j++){
            $obj_reponse=&$obj_test->getReponse($j);
            $bareme=$obj_reponse->bareme;
            $num_rep=$obj_reponse->getId();
            $taille_cellule_reponse=$taille_cellule_centre/$nb_reponse;

            if($num_rep==$tab_numrep[$e]){
                //debug
                //echo "num_rep=$num_rep<br>";
                $num_reponse=$num_rep;

                $pdf->Cell($taille_cellule_reponse,$hauteur_cellule,"X",1,'','C',1);
            }
            else
                $pdf->Cell($taille_cellule_reponse,$hauteur_cellule,"",1,'','C',1);

         }
         //debug
         //echo "qst=$num_question<br>test=$num_test<br>serie=$num_serie<br>";
         $lien="detailqcm.php?theme=$theme&test=$num_test&serie=$num_serie&formation=$formation&user=$user&question=$num_question&reponse=$num_reponse";
         //debug
         //echo "lien=$lien<br>";
         $tabexo=array();
        $tabexo=stock_exo_rep_test($num_test,$num_reponse,$num_question,'q');
        // recup moyenne pour cette reponse et type
         $str_moy=moyenne_rep($tabexo,$num_serie,$bareme,$type='q');
         couleur_hexdec($couleur_gris,&$r,&$v,&$b);
         $pdf->setFillColor($r,$v,$b);
         couleur_hexdec($couleur_rouge,&$r,&$v,&$b);
         $pdf->setTextColor($r,$v,$b);
         $pdf->Cell($taille_cellule_droite,$hauteur_cellule,"$str_moy",1,'','C',1);
          $pdf->Ln(); // saut de ligne
         $pdf->setTextColor(0);
    }

}
/*---------------------------------------------------------------------*/
//                          2ieme TABLEAU
/*---------------------------------------------------------------------*/
$pdf->Ln(); // saut de ligne
$pdf->setTextColor(0);
$pdf->SetFont('Helvetica','BU',10);
$pdf->Cell(0,14,"Bilan des connaissances dclares non matrises au test d'auto-positionnement",0,2,'L',0);
$pdf->SetFont('Helvetica','B',8);
couleur_hexdec($couleur_gris,&$r,&$v,&$b);
$pdf->setFillColor($r,$v,$b);
$longueur_cellule_gauche=80;
$longueur_cellule_droite=40;
$hauteur_cellule=12;
$pdf->Cell($longueur_cellule_gauche,$hauteur_cellule,"THEME",1,'','L',1);
$pdf->Cell($longueur_cellule_droite,$hauteur_cellule,"Rponses au test",1,'','C',1);
// boucle sur les tests
$pdf->Ln(); // saut de ligne
$pdf->setX($marge);
reset($tab_couleur_test);
for($i=0;$i<$nb_test;$i++){
    if($i%4==0)
            reset($tab_couleur_test);
    list($couleur_titre)=each($tab_couleur_test);
     reset($tab_couleur_test["$couleur_titre"]);
    $ordre=$i+1;
    $obj_test=&$obj_liste->getTest($i);
    // nom du test
    $libelle_test=$obj_test->toString();
    // numero du test
    $num_test=$obj_test->getId();
    // debug
    //echo "num_test=$num_test<br>";
    // recup de la derniere reponse
    $nb_reponse=$obj_test->getNbReponses();
    $obj_reponse=$obj_test->getReponse($nb_reponse -1);
    $num_reponse=$obj_reponse->getId();
    $libelle_reponse=$obj_reponse->toString();
    $couleur_reponse=$tab_couleur_test["$couleur_titre"][$nb_reponse -1];
    // debug
    //echo "num_reponse=$num_reponse<br>";
    // test si cette reponse a t coche
    $sql="select question from res_liste_test where id_stag=$user and id_formation=$formation and id_liste=$liste and ordre_etape=$ordre and reponse=$num_reponse ";
    $res=pg_query($sql);
    $nb=pg_numrows($res);
    if($nb>0){
        couleur_hexdec($couleur_titre,&$r,&$v,&$b);
        $pdf->setFillColor($r,$v,$b);
        $pdf->Cell($longueur_cellule_gauche,$hauteur_cellule,"$libelle_test",1,'','L',1);
        couleur_hexdec($couleur_reponse,&$r,&$v,&$b);
        $pdf->setFillColor($r,$v,$b);
        $pdf->Cell($longueur_cellule_droite,$hauteur_cellule,"$libelle_reponse",1,'','C',1);
        $pdf->setFillColor(255);
        $pdf->Ln(); // saut de ligne
         // methode multicell (texte sur plusieurs ligne ds une cellule)

        $pdf->SetWidths(array($longueur_cellule_gauche,$longueur_cellule_droite));
        for($j=0;$j<$nb;$j++){
            $row=pg_fetch_row($res,$j);
            $obj_question=new Sondage($row[0]);
            $libelle_question=$obj_question->toString();
             $pdf->Row(array($libelle_question,"x"));


        }
        //$pdf->Ln(); // saut de ligne

    }


}
// fichier user
$file=$nom."_".$prenom."_total.pdf";
$pdf->Output($file,1);
?>